package Venus::Scalar;

use 5.018;

use strict;
use warnings;

use Moo;

extends 'Venus::Kind::Value';

use overload (
  '${}' => sub{$_[0]->value},
  '*{}' => sub{$_[0]->value},
);

# METHODS

sub default {
  return \'';
}

1;



=head1 NAME

Venus::Scalar - Scalar Class

=cut

=head1 ABSTRACT

Scalar Class for Perl 5

=cut

=head1 SYNOPSIS

  package main;

  use Venus::Scalar;

  my $scalar = Venus::Scalar->new;

  # ${$scalar}

=cut

=head1 DESCRIPTION

This package provides methods for manipulating scalar data.

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Venus::Kind::Value>

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 default

  default() (Ref)

The default method returns the default value, i.e. C<\''>.

I<Since C<0.01>>

=over 4

=item default example 1

  # given: synopsis;

  my $default = $scalar->default;

  # \""

=back

=cut

=head1 OPERATORS

This package overloads the following operators:

=cut

=over 4

=item operation: C<(${})>

This package overloads the C<${}> operator.

B<example 1>

  package main;

  use Venus::Scalar;

  my $scalar = Venus::Scalar->new(\*STDOUT);

  my $value = $$scalar;

  # *::STDOUT

=back

=over 4

=item operation: C<(*{})>

This package overloads the C<*{}> operator.

B<example 1>

  package main;

  use Venus::Scalar;

  my $scalar = Venus::Scalar->new(\*STDOUT);

  my $value = *$scalar;

  # *::STDOUT

=back

=head1 AUTHORS

Cpanery, C<cpanery@cpan.org>

=cut

=head1 LICENSE

Copyright (C) 2021, Cpanery

Read the L<"license"|https://github.com/cpanery/venus/blob/master/LICENSE> file.

=cut