#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Audio::Signal::Effect::Echo;

    use Moose;
    use Moose::Util::TypeConstraints;

    extends 'Audio::Signal::Effect';
    
    has 'gain_in' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'gain_out' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'decay' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'delay' => (
        is => 'rw',
        isa => 'Num',
    );
   
    sub gencmd {
        my $self = shift;
        my $ret = sprintf("%s %s %s %s %s",$self->fx,$self->gain_in,$self->gain_out,$self->delay,$self->decay);
        return($ret);
    }
}

1;
