package App::Manoc::Controller::Mac;
#ABSTRACT: Mac controller
use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'Catalyst::Controller'; }


sub view : Chained('/') : PathPart('mac') : Args(1) {
    my ( $self, $c, $macaddr ) = @_;

    $c->stash(
        macaddr => $macaddr,

        mat_results => [
            $c->model('ManocDB::Mat')->search(
                {
                    macaddr => $macaddr
                },
                {
                    prefetch => { 'device' => ['mng_url_format'] }
                }
            )->all
        ],

        arp_results => [
            $c->model('ManocDB::Arp')->search(
                {
                    macaddr => $macaddr,
                },
                {
                    order_by => { -desc => [ 'lastseen', 'firstseen' ] }
                }
            )->all
        ],

        dot11_results => [
            $c->model('ManocDB::Dot11Assoc')->search(
                {
                    macaddr => $macaddr
                },
                {
                    order_by => { -desc => [ 'lastseen', 'firstseen' ] }
                }
            )->all,
        ],

        serverhw => [
            $c->model('ManocDB::ServerHW')
                ->search( { 'nics.macaddr' => $macaddr }, { join => 'nics' } )
        ],

        reservations =>
            [ $c->model('ManocDB::DHCPReservation')->search( { macaddr => $macaddr } ) ],

        leases => [ $c->model('ManocDB::DHCPLease')->search( { macaddr => $macaddr } ) ],

    );

    #vendor info
    my $oui = $c->model('ManocDB::Oui')->find( substr( $macaddr, 0, 8 ) );
    $c->stash( vendor => $oui ? $oui->vendor : 'UNKNOWN' );
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=head1 NAME

App::Manoc::Controller::Mac - Mac controller

=head1 VERSION

version 2.99.4

=head1 ACTIONS

=head2 view

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
