# Generated by default/object.tt
package Paws::SSMIncidents::Filter;
  use Moose;
  has Condition => (is => 'ro', isa => 'Paws::SSMIncidents::Condition', request_name => 'condition', traits => ['NameInRequest'], required => 1);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::Filter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::Filter object:

  $service_obj->Method(Att1 => { Condition => $value, ..., Key => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::Filter object:

  $result = $service_obj->Method(...);
  $result->Att1->Condition

=head1 DESCRIPTION

Filter the selection by using a condition.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Condition => L<Paws::SSMIncidents::Condition>

The condition accepts before or after a specified time, equal to a
string, or equal to an integer.


=head2 B<REQUIRED> Key => Str

The key that you're filtering on.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

