# Generated by default/object.tt
package Paws::WAFV2::NotStatement;
  use Moose;
  has Statement => (is => 'ro', isa => 'Paws::WAFV2::Statement', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::NotStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::NotStatement object:

  $service_obj->Method(Att1 => { Statement => $value, ..., Statement => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::NotStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->Statement

=head1 DESCRIPTION

A logical rule statement used to negate the results of another rule
statement. You provide one Statement within the C<NotStatement>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Statement => L<Paws::WAFV2::Statement>

The statement to negate. You can use any statement that can be nested.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

