# Generated by default/object.tt
package Paws::LexModelsV2::MessageGroup;
  use Moose;
  has Message => (is => 'ro', isa => 'Paws::LexModelsV2::Message', request_name => 'message', traits => ['NameInRequest'], required => 1);
  has Variations => (is => 'ro', isa => 'ArrayRef[Paws::LexModelsV2::Message]', request_name => 'variations', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::MessageGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::MessageGroup object:

  $service_obj->Method(Att1 => { Message => $value, ..., Variations => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::MessageGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->Message

=head1 DESCRIPTION

Provides one or more messages that Amazon Lex should send to the user.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Message => L<Paws::LexModelsV2::Message>

The primary message that Amazon Lex should send to the user.


=head2 Variations => ArrayRef[L<Paws::LexModelsV2::Message>]

Message variations to send to the user. When variations are defined,
Amazon Lex chooses the primary message or one of the variations to send
to the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

