# Generated by default/object.tt
package Paws::MediaConvert::QueueTransition;
  use Moose;
  has DestinationQueue => (is => 'ro', isa => 'Str', request_name => 'destinationQueue', traits => ['NameInRequest']);
  has SourceQueue => (is => 'ro', isa => 'Str', request_name => 'sourceQueue', traits => ['NameInRequest']);
  has Timestamp => (is => 'ro', isa => 'Str', request_name => 'timestamp', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::QueueTransition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::QueueTransition object:

  $service_obj->Method(Att1 => { DestinationQueue => $value, ..., Timestamp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::QueueTransition object:

  $result = $service_obj->Method(...);
  $result->Att1->DestinationQueue

=head1 DESCRIPTION

Description of the source and destination queues between which the job
has moved, along with the timestamp of the move

=head1 ATTRIBUTES


=head2 DestinationQueue => Str

The queue that the job was on after the transition.


=head2 SourceQueue => Str

The queue that the job was on before the transition.


=head2 Timestamp => Str

The time, in Unix epoch format, that the job moved from the source
queue to the destination queue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

