package Monitoring::GLPlugin::SNMP::MibsAndOids::STULZWIB8000;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'STULZ-WIB8000'} = {
  url => '',
  name => 'STULZ-WIB8000',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'STULZ-WIB8000'} =
  '1.3.6.1.4.1.29462.10';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'STULZ-WIB8000'} = {
  stulz => '1.3.6.1.4.1.29462',
  stulzWib => '1.3.6.1.4.1.29462.10',
  wibIntern => '1.3.6.1.4.1.29462.10.1',
  settings => '1.3.6.1.4.1.29462.10.1.1',
  wib => '1.3.6.1.4.1.29462.10.1.1.1',
  wibUnitname => '1.3.6.1.4.1.29462.10.1.1.1.65536',
  wibTempUnit => '1.3.6.1.4.1.29462.10.1.1.1.65538',
  wibFirmware => '1.3.6.1.4.1.29462.10.1.1.1.65540',
  wibsettingAuxInLow => '1.3.6.1.4.1.29462.10.1.1.1.65551',
  wibsettingAuxInHigh => '1.3.6.1.4.1.29462.10.1.1.1.65552',
  wibsettingAuxInMailaddress => '1.3.6.1.4.1.29462.10.1.1.1.65553',
  wibsettingAuxInSubject => '1.3.6.1.4.1.29462.10.1.1.1.65554',
  wibsettingAuxInState => '1.3.6.1.4.1.29462.10.1.1.1.65555',
  networkSettings => '1.3.6.1.4.1.29462.10.1.1.2',
  networksettingUseDhcp => '1.3.6.1.4.1.29462.10.1.1.2.6',
  mailSettings => '1.3.6.1.4.1.29462.10.1.1.3',
  mailsettingSenderAddress => '1.3.6.1.4.1.29462.10.1.1.3.262144',
  mailsettingSmtpServer => '1.3.6.1.4.1.29462.10.1.1.3.262145',
  mailsettingSmtpPort => '1.3.6.1.4.1.29462.10.1.1.3.262146',
  mailsettingSmtpUser => '1.3.6.1.4.1.29462.10.1.1.3.262147',
  mailsettingSmtpPassword => '1.3.6.1.4.1.29462.10.1.1.3.262148',
  mailsettingSmtpAuthentication => '1.3.6.1.4.1.29462.10.1.1.3.262149',
  busSettings => '1.3.6.1.4.1.29462.10.1.1.4',
  bussettingPackettimeoutMsBus0 => '1.3.6.1.4.1.29462.10.1.1.4.196608',
  bussettingPackettimeoutMsBus1 => '1.3.6.1.4.1.29462.10.1.1.4.196609',
  bussettingCachetimeoutSBus0 => '1.3.6.1.4.1.29462.10.1.1.4.196610',
  bussettingCachetimeoutSBus1 => '1.3.6.1.4.1.29462.10.1.1.4.196611',
  bussettingLogintervalSBus0 => '1.3.6.1.4.1.29462.10.1.1.4.196612',
  bussettingLogintervalSBus1 => '1.3.6.1.4.1.29462.10.1.1.4.196613',
  alarmSettings => '1.3.6.1.4.1.29462.10.1.1.5',
  alarmMailTable => '1.3.6.1.4.1.29462.10.1.1.5.1',
  alarmMailEntry => '1.3.6.1.4.1.29462.10.1.1.5.1.1',
  wibAlarmEntryNumber => '1.3.6.1.4.1.29462.10.1.1.5.1.1.1',
  alarmsettingMailaddress1 => '1.3.6.1.4.1.29462.10.1.1.5.1.1.131073',
  alarmsettingMailsubject1 => '1.3.6.1.4.1.29462.10.1.1.5.1.1.131078',
  alarmsettingStarttime1 => '1.3.6.1.4.1.29462.10.1.1.5.1.1.131083',
  alarmsettingStoptime1 => '1.3.6.1.4.1.29462.10.1.1.5.1.1.131088',
  alarmsettingWeekday1 => '1.3.6.1.4.1.29462.10.1.1.5.1.1.131093',
  alarmsettingMaxalarmdelayS => '1.3.6.1.4.1.29462.10.1.1.5.131072',
  unitSettings => '1.3.6.1.4.1.29462.10.1.1.6',
  unitTable => '1.3.6.1.4.1.29462.10.1.1.6.1',
  unitEntry => '1.3.6.1.4.1.29462.10.1.1.6.1.1',
  unitsettingName => '1.3.6.1.4.1.29462.10.1.1.6.1.1.393221',
  unitsettingHwType => '1.3.6.1.4.1.29462.10.1.1.6.1.1.393222',
  unitsettingType => '1.3.6.1.4.1.29462.10.1.1.6.1.1.393223',
  unitsettingReachability => '1.3.6.1.4.1.29462.10.1.1.6.1.1.393224',
  unitsettingHasFailure => '1.3.6.1.4.1.29462.10.1.1.6.1.1.393243',
  unitsettingFamily => '1.3.6.1.4.1.29462.10.1.1.6.1.1.393251',
  loggingSettings => '1.3.6.1.4.1.29462.10.1.1.7',
  logUnitTable => '1.3.6.1.4.1.29462.10.1.1.7.1',
  logUnitEntry => '1.3.6.1.4.1.29462.10.1.1.7.1.1',
  unitsettingLoggedDp1 => '1.3.6.1.4.1.29462.10.1.1.7.1.1.393216',
  unitsettingLoggedDp2 => '1.3.6.1.4.1.29462.10.1.1.7.1.1.393217',
  unitsettingLoggedDp3 => '1.3.6.1.4.1.29462.10.1.1.7.1.1.393218',
  unitsettingLoggedDp4 => '1.3.6.1.4.1.29462.10.1.1.7.1.1.393219',
  unitsettingLoggedDp5 => '1.3.6.1.4.1.29462.10.1.1.7.1.1.393220',
  wibsettingLogmailAddress => '1.3.6.1.4.1.29462.10.1.1.7.65543',
  wibsettingLogmailIntervalS => '1.3.6.1.4.1.29462.10.1.1.7.65544',
  eventSettings => '1.3.6.1.4.1.29462.10.1.1.8',
  wibsettingEventmailAddress => '1.3.6.1.4.1.29462.10.1.1.8.65545',
  wibsettingEventmailIntervalS => '1.3.6.1.4.1.29462.10.1.1.8.65546',
  snmpSettings => '1.3.6.1.4.1.29462.10.1.1.9',
  snmpsettingReadcomm => '1.3.6.1.4.1.29462.10.1.1.9.327680',
  snmpsettingWritecomm => '1.3.6.1.4.1.29462.10.1.1.9.327681',
  snmpsettingtrpComm => '1.3.6.1.4.1.29462.10.1.1.9.327682',
  snmpsettingtrpReceiver => '1.3.6.1.4.1.29462.10.1.1.9.327683',
  snmpsettingtrpPort => '1.3.6.1.4.1.29462.10.1.1.9.327684',
  wibGroups => '1.3.6.1.4.1.29462.10.1.11',
  wibAlarms => '1.3.6.1.4.1.29462.10.1.12',
  wibAlarmPrefix => '1.3.6.1.4.1.29462.10.1.12.0',
  wibAlarmText => '1.3.6.1.4.1.29462.10.1.12.10',
  wibIndexTable => '1.3.6.1.4.1.29462.10.1.13',
  wibIndexEntry => '1.3.6.1.4.1.29462.10.1.13.1',
  wibBusNumber => '1.3.6.1.4.1.29462.10.1.13.1.11',
  wibDeviceAddress => '1.3.6.1.4.1.29462.10.1.13.1.12',
  wibModuleNumber => '1.3.6.1.4.1.29462.10.1.13.1.13',
  wibUnits => '1.3.6.1.4.1.29462.10.2',
  unitTypeAC => '1.3.6.1.4.1.29462.10.2.1',
  info => '1.3.6.1.4.1.29462.10.2.1.1',
  infoValuesControl => '1.3.6.1.4.1.29462.10.2.1.1.1',
  infoValAir => '1.3.6.1.4.1.29462.10.2.1.1.1.1',
  infoValTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1',
  infoValTemperatureTable => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1',
  infoValTemperatureEntry => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1',
  unitAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1170',
  unitEmergencyTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1172',
  unitSetpointAirTratureCorrected => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1175',
  unitReturnAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1192',
  unitSupplyAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1193',
  unitOutsideAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1196',
  unitOutsideAirHumidity => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1197',
  unitSupplyAirTemperature3 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1243',
  unitReturnAirTemperature2 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1244',
  unitReturnAirTemperature3 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1245',
  unitReturnAirTemrnAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1246',
  unitSupplyAirTemlyAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1247',
  unitSupplyAirTemperature2 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.1248',
  condensorTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.10210',
  supplyTemperature1 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.10211',
  supplyTemperature2 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.10212',
  fCBRoomAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.10264',
  supplyAirTemperatureComfortUnit1 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.10266',
  supplyAirTemperatureComfortUnit2 => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.10267',
  fCBOutsideAirTemperature => '1.3.6.1.4.1.29462.10.2.1.1.1.1.1.1.1.10268',
  infoValHumidity => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2',
  infoValHumidityTable => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1',
  infoValHumidityEntry => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1.1',
  unitHumidity => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1.1.1171',
  unitSetpointHumidityCorrected => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1.1.1178',
  unitReturnAirHumidity => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1.1.1194',
  unitSupplyAirHumidity => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1.1.1195',
  fCBRoomAirHumidity => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1.1.10265',
  fCBOutsideAirHumidity => '1.3.6.1.4.1.29462.10.2.1.1.1.1.2.1.1.10269',
  infoValPressure => '1.3.6.1.4.1.29462.10.2.1.1.1.1.3',
  infoValPressureTable => '1.3.6.1.4.1.29462.10.2.1.1.1.1.3.1',
  infoValPressureEntry => '1.3.6.1.4.1.29462.10.2.1.1.1.1.3.1.1',
  currentRaisedFloorPressure => '1.3.6.1.4.1.29462.10.2.1.1.1.1.3.1.1.1208',
  infoValWater => '1.3.6.1.4.1.29462.10.2.1.1.1.2',
  infoValWaterTable => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1',
  infoValWaterEntry => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1',
  waterInTemperatu1ChillersPrimary => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1191',
  waterInTemperatuhillersSecondary => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1202',
  waterOutTemperatChillersPrimary => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1206',
  waterOutTemperatillersSecondary => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1207',
  unitSetpointWaterPressure => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1211',
  unitCurrentWaterPressure => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1212',
  waterTemperaturetpointCorrected => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1240',
  waterFlowVolume => '1.3.6.1.4.1.29462.10.2.1.1.1.2.1.1.1249',
  infoValRefrigerant => '1.3.6.1.4.1.29462.10.2.1.1.1.3',
  infoValRefrigerantTable => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1',
  infoValRefrigerantEntry => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1',
  unitSuctionGasTemperature1 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2232',
  unitEvaporationPressure1 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2233',
  unitHotGasTemperature1 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2234',
  unitCondensationPressure1 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2235',
  unitCondensationPressure2 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2250',
  unitHotGasTemperature2 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2272',
  unitEvaporationPressure2 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2273',
  unitSuctionGasTemperature2 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2274',
  unitSuctionPressure1 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2278',
  unitSuctionPressure2 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2279',
  saturatedSuctionGasTemperature1 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2281',
  saturatedSuctionGasTemperature2 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.2282',
  cyclesFreecoolingK3 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.10289',
  cyclesFreecoolingK4 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.10290',
  runningHoursFliter => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.10291',
  runningHoursController => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.10292',
  runningHoursAirco1 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.10293',
  runningHoursAirco2 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.10294',
  runningHoursAirco3 => '1.3.6.1.4.1.29462.10.2.1.1.1.3.1.1.10295',
  infoValAEcontrol => '1.3.6.1.4.1.29462.10.2.1.1.1.4',
  infoValAEcontrolTable => '1.3.6.1.4.1.29462.10.2.1.1.1.4.1',
  infoValAEcontrolEntry => '1.3.6.1.4.1.29462.10.2.1.1.1.4.1.1',
  operationMode => '1.3.6.1.4.1.29462.10.2.1.1.1.4.1.1.10315',
  reasonForSummerMode => '1.3.6.1.4.1.29462.10.2.1.1.1.4.1.1.10316',
  infoValMiscellaneous => '1.3.6.1.4.1.29462.10.2.1.1.1.5',
  infoValMiscellaneousTable => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1',
  infoValMiscellaneousEntry => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1',
  universalTemperature1 => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1.1210',
  unitSetpointCondPressureDynamic1 => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1.1280',
  unitSetpointCondPressureDynamic2 => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1.1281',
  electricCabinetTemp => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1.1283',
  intermediateTempMixTemp => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1.1284',
  freezeCirculationRunning => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1.1780',
  fans => '1.3.6.1.4.1.29462.10.2.1.1.1.5.1.1.1782',
  infoModulefunctionsComponents => '1.3.6.1.4.1.29462.10.2.1.1.2',
  infoCooling => '1.3.6.1.4.1.29462.10.2.1.1.2.1',
  infoCompressor => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1',
  infoCompressorTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1',
  infoCompressorEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1',
  compressorCabinetTemp => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.1282',
  numberOfCompressors => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.1761',
  compr1Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.4403',
  compr2Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.4503',
  compr3Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.9503',
  compr4Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.9603',
  compr5Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.9703',
  compr6Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.9803',
  speedRequestToInverter => '1.3.6.1.4.1.29462.10.2.1.1.2.1.1.1.1.11526',
  infoValves => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2',
  infoSuctionvalves => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.1',
  infoSuctionvalvesTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.1.1',
  infoSuctionvalvesEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.1.1.1',
  numberOfSuctionValve => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.1.1.1.1762',
  suctionvalve1CurrentValue => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.1.1.1.4611',
  suctionvalve2CurrentValue => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.1.1.1.4711',
  infoGECWValves => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2',
  infoGECWValvesTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2.1',
  infoGECWValvesEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2.1.1',
  numberOfGeCwValves => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2.1.1.1771',
  gECWValveOpen => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2.1.1.5207',
  gECWValveOpeningGrade1 => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2.1.1.5214',
  gECWValveOpeningGrade2 => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2.1.1.5224',
  gECWValveChillerSaverSignal => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.2.1.1.5242',
  infoHGBPs => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.3',
  infoHGBPsTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.3.1',
  infoHGBPsEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.3.1.1',
  hgbp1OpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.3.1.1.9318',
  hgbp2OpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.3.1.1.9418',
  infoEEV => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4',
  infoEEV1 => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1',
  infoEEV1Table => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1',
  infoEEV1Entry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1.1',
  eev1CurrentSuperheatSetpoint => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1.1.8726',
  eev1SuctionPressureAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1.1.8727',
  eev1SaturationTemperatureAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1.1.8728',
  eev1CoilOutTemperatureAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1.1.8729',
  eev1Superheat => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1.1.8730',
  eev1ValveOpening => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.1.1.1.8731',
  infoEEV2 => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2',
  infoEEV2Table => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1',
  infoEEV2Entry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1.1',
  eev2CurrentSuperheatSetpoint => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1.1.8826',
  eev2SuctionPressure => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1.1.8827',
  eev2SaturationTemperature => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1.1.8828',
  eev2CoilOutTemperature => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1.1.8829',
  eev2Superheat => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1.1.8830',
  eev2ValveOpening => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.4.2.1.1.8831',
  infoValvesTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5',
  infoValvesEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5.1',
  numberOfEEVs => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5.1.1776',
  numberOfHotgasBypass => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5.1.1786',
  unitFreecoolingValve => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5.1.2238',
  gValve1OpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5.1.5312',
  gValve2OpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5.1.5362',
  freecoolingPossible => '1.3.6.1.4.1.29462.10.2.1.1.2.1.2.5.1.10101',
  infoDrycooler => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3',
  infoDrycoolerTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1',
  infoDrycoolerEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1.1',
  numberOfDrycoolers => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1.1.1763',
  drycooler1Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1.1.5402',
  drycooler1Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1.1.5416',
  drycooler2Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1.1.5502',
  drycooler3Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1.1.5602',
  drycooler4Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.3.1.1.5702',
  infoPumps => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4',
  infoPumpsTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1',
  infoPumpsEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1',
  numberOfPumps => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.1764',
  pump1Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.5802',
  pump1Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.5821',
  pump2Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.5902',
  pump2Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.5921',
  pump3Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.6002',
  pump3Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.6021',
  pump4Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.6102',
  pump4Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.1.4.1.1.6121',
  infoLouver => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5',
  infoLouverTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1',
  infoLouverEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1.1',
  eCOLouverOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1.1.9913',
  freshAirLouverOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1.1.10408',
  antiFreezeLouverOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1.1.10508',
  circulationLouverOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1.1.10608',
  exitLouverOpeningState => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1.1.10702',
  exitLouverOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.1.5.1.1.10709',
  infoCondesorfan => '1.3.6.1.4.1.29462.10.2.1.1.2.1.6',
  infoCondesorfanTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.6.1',
  infoCondesorfanEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.6.1.1',
  condFan1Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.6.1.1.10802',
  condFan1ActualSpeed => '1.3.6.1.4.1.29462.10.2.1.1.2.1.6.1.1.10808',
  condFan2Running => '1.3.6.1.4.1.29462.10.2.1.1.2.1.6.1.1.10902',
  condFan2ActualSpeed => '1.3.6.1.4.1.29462.10.2.1.1.2.1.6.1.1.10908',
  infoIcc => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7',
  infoIccTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1',
  infoIccEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1',
  availability => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11519',
  envelopeWorkingZone => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11520',
  suctionGasTemperature => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11521',
  dischargeGasTemperature => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11522',
  dischargeGasPressure => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11523',
  suctionGasPressure => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11524',
  superheatEeValve => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11525',
  compressorRotorSpeedRps => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11527',
  compressorRotorSpeedPercent => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11528',
  compressorPowerRequest => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11529',
  inverterErrorCode => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11530',
  eeValvePosition => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11531',
  runtimeCompressor => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11532',
  iccTempHystereseRefIccStartTemp => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11533',
  compressorMinimuTempTooLowTimer => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11534',
  compressorMinimufTempTooLowTimer => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11535',
  alarmpriorityLowPressure => '1.3.6.1.4.1.29462.10.2.1.1.2.1.7.1.1.11536',
  infoMovableCoil => '1.3.6.1.4.1.29462.10.2.1.1.2.1.8',
  infoMovableCoilTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.8.1',
  infoMovableCoilEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.8.1.1',
  moveableCoilEnabled => '1.3.6.1.4.1.29462.10.2.1.1.2.1.8.1.1.10001',
  moveableCoilDirection => '1.3.6.1.4.1.29462.10.2.1.1.2.1.8.1.1.10002',
  moveableCoilPositionMotor1 => '1.3.6.1.4.1.29462.10.2.1.1.2.1.8.1.1.10008',
  moveableCoilPositionMotor2 => '1.3.6.1.4.1.29462.10.2.1.1.2.1.8.1.1.10009',
  infoCoolingTable => '1.3.6.1.4.1.29462.10.2.1.1.2.1.9',
  infoCoolingEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.1.9.1',
  coolingMode => '1.3.6.1.4.1.29462.10.2.1.1.2.1.9.1.1787',
  infoHeating => '1.3.6.1.4.1.29462.10.2.1.1.2.2',
  infoEHeating => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1',
  infoEHeatingTable => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1.1',
  infoEHeatingEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1.1.1',
  numberOfEHeatings => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1.1.1.1765',
  elecHeating1Running => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1.1.1.4803',
  elecHeating1PWMGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1.1.1.4817',
  elecHeating2Running => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1.1.1.4903',
  elecHeating3Running => '1.3.6.1.4.1.29462.10.2.1.1.2.2.1.1.1.5003',
  infoHeatingTable => '1.3.6.1.4.1.29462.10.2.1.1.2.2.2',
  infoHeatingEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.2.2.1',
  hotgasHeatingRunning => '1.3.6.1.4.1.29462.10.2.1.1.2.2.2.1.6202',
  pWWHeatingRunning => '1.3.6.1.4.1.29462.10.2.1.1.2.2.2.1.6302',
  pWWHeatingCurrentValue => '1.3.6.1.4.1.29462.10.2.1.1.2.2.2.1.6315',
  infoHumidity => '1.3.6.1.4.1.29462.10.2.1.1.2.3',
  infoHumidityTable => '1.3.6.1.4.1.29462.10.2.1.1.2.3.1',
  infoHumidityEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.3.1.1',
  humidifier1Running => '1.3.6.1.4.1.29462.10.2.1.1.2.3.1.1.6402',
  humidifier1CurrentValue => '1.3.6.1.4.1.29462.10.2.1.1.2.3.1.1.6427',
  dehumidificationRunning => '1.3.6.1.4.1.29462.10.2.1.1.2.3.1.1.6802',
  dehumidificationValveValue => '1.3.6.1.4.1.29462.10.2.1.1.2.3.1.1.6806',
  dehumidificationtgasbypassValue => '1.3.6.1.4.1.29462.10.2.1.1.2.3.1.1.6807',
  infoAir => '1.3.6.1.4.1.29462.10.2.1.1.2.4',
  infoAirTable => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1',
  infoAirEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1',
  numberOfHumidifiers => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.1766',
  numberOfFans => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.1767',
  numberOfLouvers => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.1768',
  numberOfHotgasReheat => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.1772',
  numberOfPwwHeatings => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.1773',
  numberOfDehumidifiers => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.1774',
  fan1Running => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.6902',
  fan1Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.6932',
  fan2Runtime => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.7031',
  fan2Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.7032',
  fan3Runtime => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.7131',
  fan3Speed => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.7132',
  louver1Open => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.7202',
  freecoolingLouverOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10213',
  dCPowerSupplyVoltage => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10214',
  fANFCB => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10216',
  remoteComfortUnit1 => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10217',
  remoteComfortUnit2 => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10218',
  lOUVERFCB => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10219',
  remoteComfortUnit3 => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10220',
  freecoolingLouverK3 => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10221',
  freecoolingLouverK4 => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10222',
  analogueOutFanACFan => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10270',
  analogueOutLouverFCB => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10271',
  fCBAnalogueOutHumidifier => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10272',
  fanTotalCurrentConsumption => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10296',
  fanTotalPowerConsumption => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10297',
  userPassword => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10298',
  language => '1.3.6.1.4.1.29462.10.2.1.1.2.4.1.1.10299',
  infoAirAE => '1.3.6.1.4.1.29462.10.2.1.1.2.4.6',
  infoAirAETable => '1.3.6.1.4.1.29462.10.2.1.1.2.4.6.1',
  infoAirAEEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.4.6.1.1',
  filter1CurrentPressureDrop => '1.3.6.1.4.1.29462.10.2.1.1.2.4.6.1.1.11010',
  filter2CurrentPressureDrop => '1.3.6.1.4.1.29462.10.2.1.1.2.4.6.1.1.11110',
  filter3CurrentPressureDrop => '1.3.6.1.4.1.29462.10.2.1.1.2.4.6.1.1.11210',
  infoSensorIORawdata => '1.3.6.1.4.1.29462.10.2.1.1.2.5',
  infoSensorIORawdataTable => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1',
  infoSensorIORawdataEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1',
  numberOfSensors => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1769',
  dIN1 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1800',
  dIN2 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1801',
  dIN3 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1802',
  dIN4 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1803',
  dIN5 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1804',
  dIN6 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1805',
  dIN7 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1806',
  dIN8 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1807',
  dIN9 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1808',
  dIN10 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1809',
  dIN11 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1810',
  dIN12 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1811',
  dIN13 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1812',
  dIN14 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1813',
  dIN15 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1814',
  dIN16 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1815',
  dIN17 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1816',
  dIN18 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1817',
  dIN19 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1818',
  dIN20 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1819',
  dIN21 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1820',
  dIN22 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1821',
  dIN23 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1822',
  dIN24 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1823',
  dIN25 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1824',
  dIN26 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1825',
  dIN27 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1826',
  dIN28 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1827',
  dIN29 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1828',
  dIN30 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1829',
  dIN31 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1830',
  dIN32 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1831',
  dIN33 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1832',
  dIN34 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1833',
  dIN35 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1834',
  dIN36 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1835',
  dIN37 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1836',
  dIN38 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1837',
  dIN39 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1838',
  dIN40 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1839',
  dIN41 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1840',
  dIN42 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1841',
  dIN43 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1842',
  dOUT1 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1843',
  dOUT2 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1844',
  dOUT3 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1845',
  dOUT4 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1846',
  dOUT5 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1847',
  dOUT6 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1848',
  dOUT7 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1849',
  dOUT8 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1850',
  dOUT9 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1851',
  dOUT10 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1852',
  dOUT11 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1853',
  dOUT12 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1854',
  dOUT13 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1855',
  dOUT14 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1856',
  dOUT15 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1857',
  dOUT16 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1858',
  dOUT17 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1859',
  dOUT18 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1860',
  dOUT19 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1861',
  dOUT20 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1862',
  dOUT21 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1863',
  dOUT22 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1864',
  dOUT23 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1865',
  dOUT24 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1866',
  dOUT25 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1867',
  dOUT26 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1868',
  dOUT27 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1869',
  dOUT28 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1870',
  dOUT29 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1871',
  dOUT30 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1872',
  dOUT31 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1873',
  aIN1 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1900',
  aIN2 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1901',
  aIN3 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1902',
  aIN4 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1903',
  aIN5 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1904',
  aIN6 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1905',
  aIN7 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1906',
  aIN8 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1907',
  aIN9 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1908',
  aIN10 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1909',
  aIN11 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1910',
  aIN12 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1911',
  aIN13 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1912',
  aIN14 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1913',
  aIN15 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1914',
  aIN16 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1915',
  aIN17 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1916',
  aIN18 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1917',
  aIN19 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1918',
  aIN20 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1919',
  aIN21 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1920',
  aOUT1 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1921',
  aOUT2 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1922',
  aOUT3 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1923',
  aOUT4 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1924',
  aOUT5 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1925',
  aOUT6 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1926',
  aOUT7 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1927',
  aOUT8 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1928',
  aOUT9 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1929',
  aOUT10 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1930',
  aOUT11 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1931',
  aOUT12 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1932',
  aOUT13 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1933',
  aOUT14 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1934',
  aOUT15 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1935',
  aOUT16 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1936',
  aOUT17 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1937',
  aOUT18 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1938',
  aOUT19 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1939',
  aOUT20 => '1.3.6.1.4.1.29462.10.2.1.1.2.5.1.1.1940',
  infoModulefunctionsComponenTable => '1.3.6.1.4.1.29462.10.2.1.1.2.6',
  infoModulefunctionsComponenEntry => '1.3.6.1.4.1.29462.10.2.1.1.2.6.1',
  numberOfExtAlarmIn => '1.3.6.1.4.1.29462.10.2.1.1.2.6.1.1770',
  infoZoneSequencing => '1.3.6.1.4.1.29462.10.2.1.1.3',
  infoZoneSequencingTable => '1.3.6.1.4.1.29462.10.2.1.1.3.1',
  infoZoneSequencingEntry => '1.3.6.1.4.1.29462.10.2.1.1.3.1.1',
  myZone => '1.3.6.1.4.1.29462.10.2.1.1.3.1.1.11700',
  myZoneRoomTemperature => '1.3.6.1.4.1.29462.10.2.1.1.3.1.1.11701',
  myZoneRoomHumidity => '1.3.6.1.4.1.29462.10.2.1.1.3.1.1.11702',
  myZoneSupplyTemperature => '1.3.6.1.4.1.29462.10.2.1.1.3.1.1.11703',
  myZoneSupplyHumidity => '1.3.6.1.4.1.29462.10.2.1.1.3.1.1.11704',
  myZoneSequencingTime => '1.3.6.1.4.1.29462.10.2.1.1.3.1.1.11705',
  infoDataStatistical => '1.3.6.1.4.1.29462.10.2.1.1.4',
  infoStatDatalog1 => '1.3.6.1.4.1.29462.10.2.1.1.4.1',
  infoStatDatalog2 => '1.3.6.1.4.1.29462.10.2.1.1.4.2',
  infoStatEventlog => '1.3.6.1.4.1.29462.10.2.1.1.4.3',
  infoStatRuntimes => '1.3.6.1.4.1.29462.10.2.1.1.4.4',
  infoStatFunctions => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1',
  infoStatFunctionsTable => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1',
  infoStatFunctionsEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1.1',
  unitRuntimeCooling => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1.1.1166',
  unitRuntimeHeating => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1.1.1167',
  unitRuntimeHumidification => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1.1.1168',
  unitRuntimeDehumidification => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1.1.1169',
  unitRuntimeFreecooling => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1.1.1203',
  unitRuntimeFreecoolMixmode => '1.3.6.1.4.1.29462.10.2.1.1.4.4.1.1.1.1204',
  infoStatComponents => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2',
  infoStatCompressors => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1',
  infoStatCompressorsTable => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1',
  infoStatCompressorsEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1',
  compr1Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.4428',
  compr1MinimumRuntime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.4436',
  compr2Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.4528',
  compr2MinimumRuntime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.4536',
  compr3Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.9528',
  compr4Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.9628',
  compr5Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.9728',
  compr6Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.1.1.1.9828',
  infoStatPumps => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.2',
  infoStatPumpsTable => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.2.1',
  infoStatPumpsEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.2.1.1',
  pump1Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.2.1.1.5820',
  pump2Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.2.1.1.5920',
  pump3Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.2.1.1.6020',
  pump4Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.2.1.1.6120',
  infoStatEHeatings => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.3',
  infoStatEHeatingsTable => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.3.1',
  infoStatEHeatingsEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.3.1.1',
  elecHeating1Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.3.1.1.4816',
  elecHeating2Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.3.1.1.4916',
  elecHeating3Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.3.1.1.5016',
  infoStatDrycoolers => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.4',
  infoStatDrycoolersTable => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.4.1',
  infoStatDrycoolersEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.4.1.1',
  drycooler1Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.4.1.1.5415',
  drycooler2Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.4.1.1.5515',
  drycooler3Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.4.1.1.5615',
  drycooler4Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.4.1.1.5715',
  infoStatComponentsTable => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.5',
  infoStatComponentsEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.5.1',
  humidifier1Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.5.1.6426',
  fan1Runtime => '1.3.6.1.4.1.29462.10.2.1.1.4.4.2.5.1.6931',
  infoStatRuntimesTable => '1.3.6.1.4.1.29462.10.2.1.1.4.4.3',
  infoStatRuntimesEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.4.3.1',
  unitRuntimeUnit => '1.3.6.1.4.1.29462.10.2.1.1.4.4.3.1.1164',
  unitStoptimeUnit => '1.3.6.1.4.1.29462.10.2.1.1.4.4.3.1.1165',
  infoStatMaintenance => '1.3.6.1.4.1.29462.10.2.1.1.4.5',
  infoStatMaintenanceTable => '1.3.6.1.4.1.29462.10.2.1.1.4.5.1',
  infoStatMaintenanceEntry => '1.3.6.1.4.1.29462.10.2.1.1.4.5.1.1',
  unitLastMaintenanceYear => '1.3.6.1.4.1.29462.10.2.1.1.4.5.1.1.1160',
  unitLastMaintenanceMonth => '1.3.6.1.4.1.29462.10.2.1.1.4.5.1.1.1161',
  unitLastMaintenanceDay => '1.3.6.1.4.1.29462.10.2.1.1.4.5.1.1.1162',
  unitMaintenanceIntervall => '1.3.6.1.4.1.29462.10.2.1.1.4.5.1.1.1163',
  infoSystem => '1.3.6.1.4.1.29462.10.2.1.1.5',
  infoSystemTable => '1.3.6.1.4.1.29462.10.2.1.1.5.2',
  infoSystemEntry => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1',
  unitType => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.1',
  sWVersion => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.3',
  unitFamily => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.20',
  numberOfEDIO => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.1758',
  numberOfEAIO => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.1759',
  typeOfEBUS => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.1760',
  numberOfEEIO => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.1775',
  systemName => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.14000',
  unitName => '1.3.6.1.4.1.29462.10.2.1.1.5.2.1.14100',
  operation => '1.3.6.1.4.1.29462.10.2.1.2',
  opValuesControl => '1.3.6.1.4.1.29462.10.2.1.2.1',
  opCtrlAir => '1.3.6.1.4.1.29462.10.2.1.2.1.1',
  opCtrlTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1',
  opCtrlTemperatureTable => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1',
  opCtrlTemperatureEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1',
  unitSetpointTemperatureDay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.1173',
  unitSetpointTemperatureNight => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.1174',
  limitReturnAirTempTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2239',
  limitReturnAirTempTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2240',
  limitSupplyAirTempTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2241',
  limitSupplyAirTempTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2242',
  limitReturnAirTeoHighAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2253',
  limitReturnAirTeTooLowAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2255',
  limitSupplyAirTeoHighAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2257',
  limitSupplyAirTeTooLowAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.1.1.1.2259',
  opCtrlHumidity => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2',
  opCtrlHumidityTable => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1',
  opCtrlHumidityEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1',
  unitSetpointHumidity => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.1176',
  limitReturnAirHumidTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2245',
  limitReturnAirHumidTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2246',
  limitSupplyAirHumidTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2247',
  limitSupplyAirHumidTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2248',
  limitReturnAirHuooHighAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2265',
  limitReturnAirHuooLowAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2267',
  limitSupplyAirHuooHighAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2269',
  limitSupplyAirHuooLowAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.2.1.1.2271',
  opCtrlPressure => '1.3.6.1.4.1.29462.10.2.1.2.1.1.3',
  opCtrlPressureTable => '1.3.6.1.4.1.29462.10.2.1.2.1.1.3.1',
  opCtrlPressureEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.1.3.1.1',
  setpointRaisedFloorPressure => '1.3.6.1.4.1.29462.10.2.1.2.1.1.3.1.1.1209',
  opCtrlAirTable => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4',
  opCtrlAirEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1',
  limitSupplyAirPrsureTooHighLimit => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1729',
  limitSupplyAirPrsureTooHighDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1730',
  limitSupplyAirPrTooHighDoutPrio => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1731',
  limitSupplyAirPrsureTooLowLimit => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1732',
  limitSupplyAirPrsureTooLowDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1733',
  limitSupplyAirPrreTooLowDoutPrio => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1734',
  unitCurrentSupplyAirPressure => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1735',
  unitSetpointSupplyAirPressure => '1.3.6.1.4.1.29462.10.2.1.2.1.1.4.1.1736',
  opCtrlWater => '1.3.6.1.4.1.29462.10.2.1.2.1.2',
  opCtrlWaterTable => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1',
  opCtrlWaterEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1',
  waterTemperatureSetpoint1 => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1237',
  waterTemperatureSetpoint2 => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1238',
  limitWaterInlet1MinTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1468',
  limitWaterInlet1MaxTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1469',
  limitWaterOutlet1MinTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1470',
  limitWaterOutlet1MaxTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1471',
  limitWaterInlet2MinTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1472',
  limitWaterInlet2MaxTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1473',
  limitWaterOutlet2MinTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1474',
  limitWaterOutlet2MaxTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1475',
  waterInlet1MinTeatureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1476',
  waterInlet1MaxTeatureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1477',
  waterOutlet1MinTratureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1478',
  waterOutlet1MaxTratureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1479',
  waterInlet2MinTeatureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1480',
  waterInlet2MaxTeatureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1481',
  waterOutlet2MinTratureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1482',
  waterOutlet2MaxTratureAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.1483',
  limitWaterTempInTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.2243',
  limitWaterTempInTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.2244',
  limitWaterTempTooHighAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.2261',
  limitWaterTempTooLowAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.2263',
  limitWaterTempOutTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.2276',
  limitWaterTempOutTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.2.1.2.1.1.2277',
  opCtrlRefrigerant => '1.3.6.1.4.1.29462.10.2.1.2.1.3',
  opCtrlRefrigerantTable => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1',
  opCtrlRefrigerantEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1',
  unitSetpointCondPressureMixMode => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1218',
  unitSetpointCondonPressureDXMode => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1219',
  unitSetpointCondPressure2MixMode => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1220',
  unitSetpointCondPressure2DXMode => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1221',
  circuit1LPManagementAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1509',
  circuit1HPManagementAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1539',
  circuit2LPManagementAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1609',
  circuit2HPManagementAlarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.1639',
  pump1PressureSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.1.3.1.1.5812',
  opCtrlAEoperation => '1.3.6.1.4.1.29462.10.2.1.2.1.4',
  opCtrlAEoperationTable => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1',
  opCtrlAEoperationEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1',
  summerModeTempersetFromSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10308',
  antiFreezeModeTesetFromSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10309',
  fanStartDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10314',
  transitionDelayFcAfFc => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10317',
  antiFreezeTemperatureAbsolut => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10318',
  mixedAirTemperatureSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10319',
  emergencyHysteresis => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10320',
  freeCoolingStartDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.4.1.1.10321',
  opCtrlEcocool => '1.3.6.1.4.1.29462.10.2.1.2.1.5',
  opCtrlEcocoolTable => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1',
  opCtrlEcocoolEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1.1',
  eCOCOOL2StartOutdoorTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1.1.9938',
  eCOCOOL2Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1.1.9939',
  eCOCOOL2DifferenStartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1.1.9940',
  eCOCOOL2EmergencyHysteresis => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1.1.9941',
  eCOCOOL2AntiFreezeTemperature => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1.1.9942',
  eCOCOOL2StartDelay => '1.3.6.1.4.1.29462.10.2.1.2.1.5.1.1.9943',
  opValuesControlTable => '1.3.6.1.4.1.29462.10.2.1.2.1.6',
  opValuesControlEntry => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1',
  keyLock => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10206',
  setpointTemperatureCooling => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10273',
  setpointTemperatureHeating => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10274',
  secondSetpointTemperatureHeating => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10275',
  setpointHumidity => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10276',
  colingBand => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10277',
  heatingBand => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10278',
  humidityBand => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10279',
  limitRoomTempMax => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10280',
  limitRoomTempMin => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10281',
  limitRoomHumidityTooLow => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10282',
  limitRoomHumidityTooHigh => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10283',
  errorLevel => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10284',
  coolingSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10285',
  heatingSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10286',
  highTemperatureAlarmThreshold => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10287',
  lowTemperatureAlarmThreshold => '1.3.6.1.4.1.29462.10.2.1.2.1.6.1.10288',
  opModulefunctionsComponents => '1.3.6.1.4.1.29462.10.2.1.2.2',
  opCooling => '1.3.6.1.4.1.29462.10.2.1.2.2.1',
  opCompressor => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1',
  opCompressor1 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1',
  opCompressor1Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1',
  opCompressor1Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1',
  compressor1StartTempSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1.4416',
  compressor1HysteresisSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1.4417',
  compressor1StartTempWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1.4418',
  compressor1HysteresisWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1.4419',
  compr1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1.4423',
  compr1LowPressAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1.4426',
  compr1Break => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.1.1.1.4427',
  opCompressor2 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2',
  opCompressor2Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1',
  opCompressor2Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1',
  compressor2StartTempSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1.4516',
  compressor2HysteresisSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1.4517',
  compressor2StartTempWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1.4518',
  compressor2HysteresisWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1.4519',
  compr2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1.4523',
  compr2LowPressAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1.4526',
  compr2Break => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.2.1.1.4527',
  opCompressor3 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3',
  opCompressor3Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1',
  opCompressor3Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1',
  compressor3StartTempSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9516',
  compressor3HysteresisSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9517',
  compressor3StartTempWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9518',
  compressor3HysteresisWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9519',
  compr3AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9523',
  compr3LowPressAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9526',
  compr5LowPressAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9726',
  compr6LowPressAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.3.1.1.9826',
  opCompressor4 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4',
  opCompressor4Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1',
  opCompressor4Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1',
  compr3Break => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9527',
  compressor4StartTempSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9616',
  compressor4HysteresisSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9617',
  compressor4StartTempWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9618',
  compressor4HysteresisWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9619',
  compr4AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9623',
  compr4LowPressDigitalIn => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9624',
  compr4LowPressAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9625',
  compr4LowPressAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9626',
  compr4Break => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9627',
  compr5Break => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9727',
  compr6Break => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.4.1.1.9827',
  opCompressor5 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5',
  opCompressor5Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5.1',
  opCompressor5Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5.1.1',
  compressor5StartTempSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5.1.1.9716',
  compressor5HysteresisSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5.1.1.9717',
  compressor5StartTempWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5.1.1.9718',
  compressor5HysteresisWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5.1.1.9719',
  compr5AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.5.1.1.9723',
  opCompressor6 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6',
  opCompressor6Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6.1',
  opCompressor6Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6.1.1',
  compressor6StartTempSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6.1.1.9816',
  compressor6HysteresisSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6.1.1.9817',
  compressor6StartTempWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6.1.1.9818',
  compressor6HysteresisWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6.1.1.9819',
  compr6AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.6.1.1.9823',
  opCompressorTable => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.7',
  opCompressorEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.7.1',
  lowpressureWinterdelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.1.7.1.2249',
  opValves => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2',
  opSuctionValve => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.1',
  opSuctionValveTable => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.1.1',
  opSuctionValveEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.1.1.1',
  suctionvalve1StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.1.1.1.4608',
  suctionvalve1LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.1.1.1.4609',
  suctionvalve2StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.1.1.1.4708',
  suctionvalve2LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.1.1.1.4709',
  opGECWValve => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2',
  opGECWValveTable => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1',
  opGECWValveEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1',
  gECWValveStartTemperature1 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5208',
  gECWValveLinearRange1 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5209',
  gECWValveGEOffTempAbsolute => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5211',
  gECWValveStartTemperature2 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5219',
  gECWValveLinearRange2 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5220',
  gECWValveChillerSaver100Jump => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5238',
  gECWValveChillerSaverSignalStart => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5240',
  gECWValveChillerSaverSignalEnd => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5241',
  gECWValveGEOffTempRelative => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.2.1.1.5244',
  opGValve => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.3',
  opEEV => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4',
  opEEV1 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.1',
  opEEV1Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.1.1',
  opEEV1Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.1.1.1',
  eev1SuperheatSetpointAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.1.1.1.8719',
  eev1DehumidificatSetpointAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.1.1.1.8720',
  opEEV2 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.2',
  opEEV2Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.2.1',
  opEEV2Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.2.1.1',
  eev2SuperheatSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.2.1.1.8819',
  eev2DehumidificaperheatSetpoint => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.4.2.1.1.8820',
  opChillerFreecoolingValve => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.5',
  opChillerFreecoolingValveTable => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.5.1',
  opChillerFreecoolingValveEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.5.1.1',
  freecoolingStartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.5.1.1.10108',
  freecoolingHysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.5.1.1.10109',
  freecoolingStarteratureDrycooler => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.5.1.1.10113',
  freecoolingHysteresisDrycooler => '1.3.6.1.4.1.29462.10.2.1.2.2.1.2.5.1.1.10114',
  opDrycooler => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3',
  opDrycooler1 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.1',
  opDrycooler1Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.1.1',
  opDrycooler1Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.1.1.1',
  drycooler1StartTemperatureWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.1.1.1.5408',
  drycooler1StartTemperatureSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.1.1.1.5409',
  drycooler1Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.1.1.1.5410',
  drycooler1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.1.1.1.5414',
  opDrycooler2 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.2',
  opDrycooler2Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.2.1',
  opDrycooler2Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.2.1.1',
  drycooler2StartTemperatureWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.2.1.1.5508',
  drycooler2StartTemperatureSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.2.1.1.5509',
  drycooler2Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.2.1.1.5510',
  drycooler2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.2.1.1.5514',
  opDrycooler3 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.3',
  opDrycooler3Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.3.1',
  opDrycooler3Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.3.1.1',
  drycooler3StartTemperatureWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.3.1.1.5608',
  drycooler3StartTemperatureSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.3.1.1.5609',
  drycooler3Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.3.1.1.5610',
  drycooler3AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.3.1.1.5614',
  opDrycooler4 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.4',
  opDrycooler4Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.4.1',
  opDrycooler4Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.4.1.1',
  drycooler4StartTemperatureWinter => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.4.1.1.5708',
  drycooler4StartTemperatureSummer => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.4.1.1.5709',
  drycooler4Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.4.1.1.5710',
  drycooler4AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.3.4.1.1.5714',
  opPump => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4',
  opPump1 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1',
  opPump1Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1.1',
  opPump1Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1.1.1',
  pump1StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1.1.1.5809',
  pump1Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1.1.1.5810',
  pump1LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1.1.1.5811',
  pump1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1.1.1.5817',
  pump1SetpointSpeed => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.1.1.1.5830',
  opPump2 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2',
  opPump2Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2.1',
  opPump2Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2.1.1',
  pump2StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2.1.1.5909',
  pump2Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2.1.1.5910',
  pump2LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2.1.1.5911',
  pump2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2.1.1.5917',
  pump2SetpointSpeed => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.2.1.1.5930',
  opPump3 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3',
  opPump3Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3.1',
  opPump3Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3.1.1',
  pump3StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3.1.1.6009',
  pump3Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3.1.1.6010',
  pump3LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3.1.1.6011',
  pump3AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3.1.1.6017',
  pump3SetpointSpeed => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.3.1.1.6030',
  opPump4 => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4',
  opPump4Table => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4.1',
  opPump4Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4.1.1',
  pump4StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4.1.1.6109',
  pump4Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4.1.1.6110',
  pump4LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4.1.1.6111',
  pump4AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4.1.1.6117',
  pump4SetpointSpeed => '1.3.6.1.4.1.29462.10.2.1.2.2.1.4.4.1.1.6130',
  opCoolLouver => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5',
  opEcoLouver => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5.1',
  opEcoLouverTable => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5.1.1',
  opEcoLouverEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5.1.1.1',
  eCOLouverStartOutdoorTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5.1.1.1.9908',
  eCOLouverHysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5.1.1.1.9909',
  eCOLouverStartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5.1.1.1.9910',
  eCOLouverLinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.1.5.1.1.1.9911',
  opCondensorfan => '1.3.6.1.4.1.29462.10.2.1.2.2.1.6',
  opCondensorfanTable => '1.3.6.1.4.1.29462.10.2.1.2.2.1.6.1',
  opCondensorfanEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.1.6.1.1',
  condFan1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.6.1.1.10823',
  condFan2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.1.6.1.1.10923',
  opHeating => '1.3.6.1.4.1.29462.10.2.1.2.2.2',
  opEHeat => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1',
  opEHeat1 => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.1',
  opEHeat1Table => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.1.1',
  opEHeat1Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.1.1.1',
  elecHeating1StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.1.1.1.4809',
  elecHeating1Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.1.1.1.4810',
  elecHeating1LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.1.1.1.4811',
  elecHeating1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.1.1.1.4815',
  opEHeat2 => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.2',
  opEHeat2Table => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.2.1',
  opEHeat2Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.2.1.1',
  elecHeating2StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.2.1.1.4909',
  elecHeating2Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.2.1.1.4910',
  elecHeating2LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.2.1.1.4911',
  elecHeating2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.2.1.1.4915',
  opEHeat3 => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.3',
  opEHeat3Table => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.3.1',
  opEHeat3Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.3.1.1',
  elecHeating3StartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.3.1.1.5009',
  elecHeating3Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.3.1.1.5010',
  elecHeating3LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.3.1.1.5011',
  elecHeating3AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.2.1.3.1.1.5015',
  opHotgasHeat => '1.3.6.1.4.1.29462.10.2.1.2.2.2.2',
  opHotgasHeatTable => '1.3.6.1.4.1.29462.10.2.1.2.2.2.2.1',
  opHotgasHeatEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.2.2.1.1',
  hotgasHeatingStartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.2.2.1.1.6208',
  hotgasHeatingHysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.2.2.1.1.6209',
  hotgasHeatingAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.2.2.1.1.6213',
  opHwrValve => '1.3.6.1.4.1.29462.10.2.1.2.2.2.3',
  opHwrValveTable => '1.3.6.1.4.1.29462.10.2.1.2.2.2.3.1',
  opHwrValveEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.2.3.1.1',
  pWWHeatingStartTemperature => '1.3.6.1.4.1.29462.10.2.1.2.2.2.3.1.1.6309',
  pWWHeatingHysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.2.3.1.1.6311',
  pWWHeatingLinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.2.3.1.1.6312',
  opHumidity => '1.3.6.1.4.1.29462.10.2.1.2.2.3',
  opHumidifier => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1',
  opHumidifierTable => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1',
  opHumidifierEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1',
  humidifier1StartHumidity => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1.6417',
  humidifier1StartHumidity2 => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1.6418',
  humidifier1Hysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1.6419',
  humidifier1LinearRange => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1.6420',
  humidifier1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1.6425',
  humidifier1AlarmDelay5uS => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1.6431',
  humidifier1AlarmDelay20uS => '1.3.6.1.4.1.29462.10.2.1.2.2.3.1.1.1.6432',
  opDehumidification => '1.3.6.1.4.1.29462.10.2.1.2.2.3.2',
  opDehumidificationTable => '1.3.6.1.4.1.29462.10.2.1.2.2.3.2.1',
  opDehumidificationEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.3.2.1.1',
  dehumidifierStartHumidity => '1.3.6.1.4.1.29462.10.2.1.2.2.3.2.1.1.6809',
  dehumidificationHysteresis => '1.3.6.1.4.1.29462.10.2.1.2.2.3.2.1.1.6811',
  dehumidifierMinWaterTemp => '1.3.6.1.4.1.29462.10.2.1.2.2.3.2.1.1.6817',
  dehumidifierMaxWaterTemp => '1.3.6.1.4.1.29462.10.2.1.2.2.3.2.1.1.6818',
  opAir => '1.3.6.1.4.1.29462.10.2.1.2.2.4',
  opFan => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1',
  opFanTable => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1',
  opFanEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1',
  fan1SpeedNmax => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1.6909',
  fan1StartTemp => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1.6913',
  fan1StartSpeed => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1.6914',
  fan1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1.6927',
  fan1FilterAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1.6930',
  fan1SpeedNmaxInEFCMIXModeForDFC => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1.6947',
  fan2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.4.1.1.1.7027',
  opAirLouver => '1.3.6.1.4.1.29462.10.2.1.2.2.4.2',
  opAirLouverTable => '1.3.6.1.4.1.29462.10.2.1.2.2.4.2.1',
  opAirLouverEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.4.2.1.1',
  louver1Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.4.2.1.1.7208',
  opAEfilter => '1.3.6.1.4.1.29462.10.2.1.2.2.4.6',
  opAEfilterTable => '1.3.6.1.4.1.29462.10.2.1.2.2.4.6.1',
  opAEfilterEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.4.6.1.1',
  filter1MaxPressureDrop => '1.3.6.1.4.1.29462.10.2.1.2.2.4.6.1.1.11009',
  filter1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.4.6.1.1.11012',
  filter2MaxPressureDrop => '1.3.6.1.4.1.29462.10.2.1.2.2.4.6.1.1.11109',
  filter3MaxPressureDrop => '1.3.6.1.4.1.29462.10.2.1.2.2.4.6.1.1.11209',
  opSensor => '1.3.6.1.4.1.29462.10.2.1.2.2.5',
  opSensor1 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.1',
  opSensor1Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.1.1',
  opSensor1Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.1.1.1',
  sensor1AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.1.1.1.2317',
  sensor1FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.1.1.1.2319',
  sensor1AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.1.1.1.2320',
  sensor1CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.1.1.1.2321',
  opSensor2 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.2',
  opSensor2Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.2.1',
  opSensor2Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.2.1.1',
  sensor2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.2.1.1.2417',
  sensor2FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.2.1.1.2419',
  sensor2AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.2.1.1.2420',
  sensor2CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.2.1.1.2421',
  opSensor3 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.3',
  opSensor3Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.3.1',
  opSensor3Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.3.1.1',
  sensor3AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.3.1.1.2517',
  sensor3FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.3.1.1.2519',
  sensor3AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.3.1.1.2520',
  sensor3CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.3.1.1.2521',
  opSensor4 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.4',
  opSensor4Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.4.1',
  opSensor4Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.4.1.1',
  sensor4AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.4.1.1.2617',
  sensor4FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.4.1.1.2619',
  sensor4AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.4.1.1.2620',
  sensor4CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.4.1.1.2621',
  opSensor5 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.5',
  opSensor5Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.5.1',
  opSensor5Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.5.1.1',
  sensor5AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.5.1.1.2717',
  sensor5FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.5.1.1.2719',
  sensor5AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.5.1.1.2720',
  sensor5CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.5.1.1.2721',
  opSensor6 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.6',
  opSensor6Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.6.1',
  opSensor6Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.6.1.1',
  sensor6AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.6.1.1.2817',
  sensor6FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.6.1.1.2819',
  sensor6AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.6.1.1.2820',
  sensor6CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.6.1.1.2821',
  opSensor7 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.7',
  opSensor7Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.7.1',
  opSensor7Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.7.1.1',
  sensor7AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.7.1.1.2917',
  sensor7FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.7.1.1.2919',
  sensor7AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.7.1.1.2920',
  sensor7CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.7.1.1.2921',
  opSensor8 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.8',
  opSensor8Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.8.1',
  opSensor8Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.8.1.1',
  sensor8AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.8.1.1.3017',
  sensor8FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.8.1.1.3019',
  sensor8AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.8.1.1.3020',
  sensor8CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.8.1.1.3021',
  opSensor9 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.9',
  opSensor9Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.9.1',
  opSensor9Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.9.1.1',
  sensor9AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.9.1.1.3117',
  sensor9FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.9.1.1.3119',
  sensor9AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.9.1.1.3120',
  sensor9CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.9.1.1.3121',
  opSensor10 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.10',
  opSensor10Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.10.1',
  opSensor10Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.10.1.1',
  sensor10AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.10.1.1.3217',
  sensor10FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.10.1.1.3219',
  sensor10AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.10.1.1.3220',
  sensor10CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.10.1.1.3221',
  opSensor11 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.11',
  opSensor11Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.11.1',
  opSensor11Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.11.1.1',
  sensor11AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.11.1.1.3317',
  sensor11FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.11.1.1.3319',
  sensor11AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.11.1.1.3320',
  sensor11CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.11.1.1.3321',
  opSensor12 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.12',
  opSensor12Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.12.1',
  opSensor12Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.12.1.1',
  sensor12AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.12.1.1.3417',
  sensor12FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.12.1.1.3419',
  sensor12AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.12.1.1.3420',
  sensor12CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.12.1.1.3421',
  opSensor13 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.13',
  opSensor13Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.13.1',
  opSensor13Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.13.1.1',
  sensor13AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.13.1.1.3517',
  sensor13FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.13.1.1.3519',
  sensor13AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.13.1.1.3520',
  sensor13CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.13.1.1.3521',
  opSensor14 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.14',
  opSensor14Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.14.1',
  opSensor14Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.14.1.1',
  sensor14AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.14.1.1.3617',
  sensor14FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.14.1.1.3619',
  sensor14AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.14.1.1.3620',
  sensor14CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.14.1.1.3621',
  opSensor15 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.15',
  opSensor15Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.15.1',
  opSensor15Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.15.1.1',
  sensor15AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.15.1.1.3717',
  sensor15FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.15.1.1.3719',
  sensor15AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.15.1.1.3720',
  sensor15CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.15.1.1.3721',
  opSensor16 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.16',
  opSensor16Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.16.1',
  opSensor16Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.16.1.1',
  sensor16AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.16.1.1.3817',
  sensor16FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.16.1.1.3819',
  sensor16AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.16.1.1.3820',
  sensor16CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.16.1.1.3821',
  opSensor17 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.17',
  opSensor17Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.17.1',
  opSensor17Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.17.1.1',
  sensor17AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.17.1.1.3917',
  sensor17FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.17.1.1.3919',
  sensor17AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.17.1.1.3920',
  sensor17CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.17.1.1.3921',
  opSensor18 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.18',
  opSensor18Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.18.1',
  opSensor18Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.18.1.1',
  sensor18AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.18.1.1.4017',
  sensor18FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.18.1.1.4019',
  sensor18AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.18.1.1.4020',
  sensor18CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.18.1.1.4021',
  opSensor19 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.19',
  opSensor19Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.19.1',
  opSensor19Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.19.1.1',
  sensor19AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.19.1.1.4117',
  sensor19FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.19.1.1.4119',
  sensor19AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.19.1.1.4120',
  sensor19CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.19.1.1.4121',
  opSensor20 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.20',
  opSensor20Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.20.1',
  opSensor20Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.20.1.1',
  sensor20AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.20.1.1.4217',
  sensor20FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.20.1.1.4219',
  sensor20AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.20.1.1.4220',
  sensor20CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.20.1.1.4221',
  opSensor21 => '1.3.6.1.4.1.29462.10.2.1.2.2.5.21',
  opSensor21Table => '1.3.6.1.4.1.29462.10.2.1.2.2.5.21.1',
  opSensor21Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.5.21.1.1',
  sensor21AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.21.1.1.4317',
  sensor21FailureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.5.21.1.1.4319',
  sensor21AdjustOffset => '1.3.6.1.4.1.29462.10.2.1.2.2.5.21.1.1.4320',
  sensor21CurrentPhysValue => '1.3.6.1.4.1.29462.10.2.1.2.2.5.21.1.1.4321',
  opAuxPorts => '1.3.6.1.4.1.29462.10.2.1.2.2.6',
  opExtAlarms => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1',
  opExtAlarms1 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.1',
  opExtAlarms1Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.1.1',
  opExtAlarms1Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.1.1.1',
  extAlarm1Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.1.1.1.7510',
  extAlarm1Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.1.1.1.7511',
  opExtAlarms2 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.2',
  opExtAlarms2Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.2.1',
  opExtAlarms2Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.2.1.1',
  extAlarm2Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.2.1.1.7610',
  extAlarm2Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.2.1.1.7611',
  opExtAlarms3 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.3',
  opExtAlarms3Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.3.1',
  opExtAlarms3Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.3.1.1',
  extAlarm3Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.3.1.1.7710',
  extAlarm3Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.3.1.1.7711',
  opExtAlarms4 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.4',
  opExtAlarms4Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.4.1',
  opExtAlarms4Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.4.1.1',
  extAlarm4Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.4.1.1.7810',
  extAlarm4Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.4.1.1.7811',
  opExtAlarms5 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.5',
  opExtAlarms5Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.5.1',
  opExtAlarms5Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.5.1.1',
  extAlarm5Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.5.1.1.7910',
  extAlarm5Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.5.1.1.7911',
  opExtAlarms6 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.6',
  opExtAlarms6Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.6.1',
  opExtAlarms6Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.6.1.1',
  extAlarm6Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.6.1.1.8010',
  extAlarm6Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.6.1.1.8011',
  opExtAlarms7 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.7',
  opExtAlarms7Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.7.1',
  opExtAlarms7Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.7.1.1',
  extAlarm7Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.7.1.1.8110',
  extAlarm7Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.7.1.1.8111',
  opExtAlarms8 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.8',
  opExtAlarms8Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.8.1',
  opExtAlarms8Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.8.1.1',
  extAlarm8Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.8.1.1.8210',
  extAlarm8Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.8.1.1.8211',
  opExtAlarms9 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.9',
  opExtAlarms9Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.9.1',
  opExtAlarms9Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.9.1.1',
  extAlarm9Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.9.1.1.8310',
  extAlarm9Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.9.1.1.8311',
  opExtAlarms10 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.10',
  opExtAlarms10Table => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.10.1',
  opExtAlarms10Entry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.10.1.1',
  extAlarm10Delay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.10.1.1.8410',
  extAlarm10Text0 => '1.3.6.1.4.1.29462.10.2.1.2.2.6.1.10.1.1.8411',
  opUnitalarms => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2',
  opUnitalarmsTable => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1',
  opUnitalarmsEntry => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1',
  busalarmdelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.17',
  busadrconflictdelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.19',
  fireAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.1712',
  waterAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.1714',
  phaseAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.1716',
  waterflowAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.1720',
  freezeAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.1721',
  localStopDigitalOut => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.1722',
  freecoolingDOUTAuallyCoolingByFC => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.1723',
  roomHighPressureAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.2.2.6.2.1.1.10313',
  opZoneSequencing => '1.3.6.1.4.1.29462.10.2.1.2.3',
  opSystem => '1.3.6.1.4.1.29462.10.2.1.2.4',
  opATPreferences => '1.3.6.1.4.1.29462.10.2.1.2.4.1',
  opPassword => '1.3.6.1.4.1.29462.10.2.1.2.5',
  config => '1.3.6.1.4.1.29462.10.2.1.3',
  confValuesControl => '1.3.6.1.4.1.29462.10.2.1.3.1',
  confCtrlAir => '1.3.6.1.4.1.29462.10.2.1.3.1.1',
  confCtrlTemperature => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1',
  confCtrlTemperatureTable => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1',
  confCtrlTemperatureEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1',
  limitedControlStartTemperature => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.1184',
  limitedControlLiangeTemperature => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.1185',
  unitIntegralFactor => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.1190',
  limitedControlStartTemperature2 => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.1228',
  unitTempOffsetBoostCooling => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2251',
  limitReturnAirTehAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2252',
  limitReturnAirTeAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2254',
  limitSupplyAirTehAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2256',
  limitSupplyAirTeAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2258',
  limitReturnAirTeommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2284',
  limitReturnAirTemmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2285',
  limitSupplyAirTeommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2286',
  limitSupplyAirTemmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.1.1.1.2287',
  confCtrlHumidity => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2',
  confCtrlHumidityTable => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1',
  confCtrlHumidityEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1',
  limitedControlStartHumidity => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.1186',
  limitedControlLiaryRangeHumidity => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.1187',
  limitReturnAirHuAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2264',
  limitReturnAirHuwAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2266',
  limitSupplyAirHuAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2268',
  limitSupplyAirHuwAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2270',
  unitHumidityOffsBoostHumidifying => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2275',
  unitHumidityOffsostDehumidifying => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2280',
  limitReturnAirHummonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2290',
  limitReturnAirHuommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2291',
  limitSupplyAirHummonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2292',
  limitSupplyAirHuommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.1.2.1.1.2293',
  confCtrlPressure => '1.3.6.1.4.1.29462.10.2.1.3.1.1.3',
  confCtrlAirTable => '1.3.6.1.4.1.29462.10.2.1.3.1.1.4',
  confCtrlAirEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.1.4.1',
  unitControlTypeAirAcUnits => '1.3.6.1.4.1.29462.10.2.1.3.1.1.4.1.1183',
  confCtrlWater => '1.3.6.1.4.1.29462.10.2.1.3.1.2',
  confCtrlWaterTable => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1',
  confCtrlWaterEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1',
  controlTypeWaterChiller => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1229',
  unitOverloadSwitchOnByWatertemp => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1239',
  waterInlet1MinTeeratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1484',
  waterInlet1MaxTeeratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1485',
  waterOutlet1MinTratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1486',
  waterOutlet1MaxTratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1487',
  waterInlet2MinTeeratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1488',
  waterInlet2MaxTeeratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1489',
  waterOutlet2MinTratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1490',
  waterOutlet2MaxTratureAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1491',
  waterInlet1MinTeatureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1492',
  waterInlet1MaxTeatureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1493',
  waterOutlet1MinTtureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1494',
  waterOutlet1MaxTtureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1495',
  waterInlet2MinTeatureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1496',
  waterInlet2MaxTeatureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1497',
  waterOutlet2MinTtureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1498',
  waterOutlet2MaxTtureCommonalarm => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.1499',
  limitWaterTempTohAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.2260',
  limitWaterTempToAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.2262',
  limitWaterTempToommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.2288',
  limitWaterTempTommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.2.1.1.2289',
  confCtrlRefrigerant => '1.3.6.1.4.1.29462.10.2.1.3.1.3',
  confCtrlRefrigLPmanagement => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1',
  confCtrlRefrigLPmanagementTable => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1',
  confCtrlRefrigLPmanagementEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1',
  circuit1LPManagemmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1500',
  circuit1LPManagementDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1508',
  circuit1LPManagentAlarmpriority => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1510',
  circuit1LPManagementTime => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1511',
  circuit1LPManagementMinPressure => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1512',
  circuit1LPManagementTries => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1513',
  circuit2LPManagemmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1600',
  circuit2LPManagementDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1608',
  circuit2LPManagentAlarmpriority => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1610',
  circuit2LPManagementTime => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1611',
  circuit2LPManagementMinPressure => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1612',
  circuit2LPManagementTries => '1.3.6.1.4.1.29462.10.2.1.3.1.3.1.1.1.1613',
  confCtrlRefrigHPmanagement => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2',
  confCtrlRefrigHPmanagementTable => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1',
  confCtrlRefrigHPmanagementEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1',
  circuit1HPManagemmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1530',
  circuit1HPManagementDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1538',
  circuit1HPManagentAlarmpriority => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1540',
  circuit1HPManagementTime => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1541',
  circuit1HPManagementMaxPressure => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1542',
  circuit1HPManagementTries => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1543',
  circuit1HPManagementMode => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1544',
  circuit2HPManagemmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1630',
  circuit2HPManagementDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1638',
  circuit2HPManagentAlarmpriority => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1640',
  circuit2HPManagementTime => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1641',
  circuit2HPManagementMaxPressure => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1642',
  circuit2HPManagementTries => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1643',
  circuit2HPManagementMode => '1.3.6.1.4.1.29462.10.2.1.3.1.3.2.1.1.1644',
  confCtrlMiscParameters => '1.3.6.1.4.1.29462.10.2.1.3.1.4',
  confCtrlMiscParametersTable => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1',
  confCtrlMiscParametersEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1',
  cW2ChangeOver => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1.1025',
  cW2ChangeOverState => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1.1026',
  oTEModeOff => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1.1027',
  unitStartByRemoteOnOff => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1.1028',
  unitCoolingPriority => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1.1198',
  unitStartDelay => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1.1205',
  autoRestartAfterPhaseAlarm => '1.3.6.1.4.1.29462.10.2.1.3.1.4.1.1.1746',
  confCtrlGEOperation => '1.3.6.1.4.1.29462.10.2.1.3.1.5',
  confCtrlGEOperationTable => '1.3.6.1.4.1.29462.10.2.1.3.1.5.1',
  confCtrlGEOperationEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.5.1.1',
  unitWinterModeStarttemp => '1.3.6.1.4.1.29462.10.2.1.3.1.5.1.1.1188',
  unitWinterModeHysteresis => '1.3.6.1.4.1.29462.10.2.1.3.1.5.1.1.1189',
  outsideTemperatureForPressure => '1.3.6.1.4.1.29462.10.2.1.3.1.5.1.1.1199',
  gradientForPressure => '1.3.6.1.4.1.29462.10.2.1.3.1.5.1.1.1200',
  confCtrlChillerFreecooling => '1.3.6.1.4.1.29462.10.2.1.3.1.6',
  confCtrlChillerFreecoolingTable => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1',
  confCtrlChillerFreecoolingEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1',
  freezeCirculationStarttemp => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.1231',
  freezeCirculationStopHysteresis => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.1232',
  pump12SequencingTime => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.1235',
  pump12HandoverTime => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.1236',
  freeCoolingWinterModeAnalogAout => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.1724',
  freecoolingConfig => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.10100',
  freecoolingValveOpeningStart => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.10110',
  freecoolingValveGradient => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.10111',
  freecoolingStopTemperature => '1.3.6.1.4.1.29462.10.2.1.3.1.6.1.1.10112',
  confCtrlAEoperation => '1.3.6.1.4.1.29462.10.2.1.3.1.7',
  confCtrlAEoperationTable => '1.3.6.1.4.1.29462.10.2.1.3.1.7.1',
  confCtrlAEoperationEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.7.1.1',
  aEControlActive => '1.3.6.1.4.1.29462.10.2.1.3.1.7.1.1.10300',
  forceSummerMode => '1.3.6.1.4.1.29462.10.2.1.3.1.7.1.1.10303',
  actionOnHumidityTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.3.1.7.1.1.10304',
  actionOnWaterAlarm => '1.3.6.1.4.1.29462.10.2.1.3.1.7.1.1.10305',
  confCtrlecocool => '1.3.6.1.4.1.29462.10.2.1.3.1.8',
  confCtrlecocoolTable => '1.3.6.1.4.1.29462.10.2.1.3.1.8.1',
  confCtrlecocoolEntry => '1.3.6.1.4.1.29462.10.2.1.3.1.8.1.1',
  eCOCOOL2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.1.8.1.1.9930',
  confModulefuncComponents => '1.3.6.1.4.1.29462.10.2.1.3.2',
  confCooling => '1.3.6.1.4.1.29462.10.2.1.3.2.1',
  confCompressor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1',
  confCompressor1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1',
  confCompressor1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1',
  confCompressor1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1',
  compressor1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4400',
  compr1CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4407',
  compr1LowPressCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4408',
  compr1DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4420',
  compr1AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4421',
  compr1AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4422',
  compr1LowPressDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4424',
  compr1LowPressAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4425',
  compr1LowPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4429',
  compr1LowPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4430',
  compr1LowPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4431',
  compr1HighPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4432',
  compr1HighPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4433',
  compr1HighPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4434',
  compr1HighPressManagMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4435',
  compr1ActualCurrReadBackFromComp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4437',
  compr1DesiredSpeedPower => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4438',
  compr1OilTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.1.1.1.4439',
  confCompressor2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2',
  confCompressor2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1',
  confCompressor2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1',
  compressor2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4500',
  compr2CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4507',
  compr2LowPressCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4508',
  compr2DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4520',
  compr2AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4521',
  compr2AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4522',
  compr2LowPressDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4524',
  compr2LowPressAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4525',
  compr2LowPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4529',
  compr2LowPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4530',
  compr2LowPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4531',
  compr2HighPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4532',
  compr2HighPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4533',
  compr2HighPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4534',
  compr2HighPressManagMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4535',
  compr2actualCurrReadBackFromComp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4537',
  compr2DesiredSpeedPower => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4538',
  compr2OilTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.2.1.1.4539',
  confCompressor3 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3',
  confCompressor3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1',
  confCompressor3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1',
  compressor3ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9500',
  compr3CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9507',
  compr3DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9520',
  compr3AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9521',
  compr3AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9522',
  compr3LowPressDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9524',
  compr3LowPressAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9525',
  compr3LowPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9529',
  compr3LowPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9530',
  compr3LowPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9531',
  compr3HighPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9532',
  compr3HighPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9533',
  compr3HighPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9534',
  compr3HighPressManagMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9535',
  compr3MinimumRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9536',
  compr3ActualCurrReadBackFromComp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9537',
  compr3DesiredSpeedPower => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9538',
  compr3OilTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9539',
  compr5LowPressDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9724',
  compr5LowPressAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9725',
  compr6LowPressDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9824',
  compr6LowPressAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.3.1.1.9825',
  confCompressor4 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4',
  confCompressor4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1',
  confCompressor4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1',
  compressor4ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9600',
  compr4CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9607',
  compr4DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9620',
  compr4AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9621',
  compr4AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9622',
  compr4LowPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9629',
  compr4LowPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9630',
  compr4LowPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9631',
  compr4HighPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9632',
  compr4HighPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9633',
  compr4HighPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9634',
  compr4HighPressManagMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9635',
  compr4MinimumRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9636',
  compr4ActualCurrReadBackFromComp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9637',
  compr4DesiredSpeedPower => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9638',
  compr4OilTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.4.1.1.9639',
  confCompressor5 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5',
  confCompressor5Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1',
  confCompressor5Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1',
  compressor5ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9700',
  compr5CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9707',
  compr5DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9720',
  compr5AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9721',
  compr5AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9722',
  compr5LowPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9729',
  compr5LowPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9730',
  compr5LowPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9731',
  compr5HighPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9732',
  compr5HighPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9733',
  compr5HighPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9734',
  compr5HighPressManagMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9735',
  compr5MinimumRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9736',
  compr5ActualCurrReadBackFromComp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9737',
  compr5DesiredSpeedPower => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9738',
  compr5OilTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.5.1.1.9739',
  confCompressor6 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6',
  confCompressor6Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1',
  confCompressor6Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1',
  compressor6ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9800',
  compr6CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9807',
  compr6DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9820',
  compr6AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9821',
  compr6AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9822',
  compr6LowPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9829',
  compr6LowPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9830',
  compr6LowPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9831',
  compr6HighPressManagTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9832',
  compr6HighPressManagPress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9833',
  compr6HighPressManagRestarts => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9834',
  compr6HighPressManagMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9835',
  compr6MinimumRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9836',
  compr6ActualCurrReadBackFromComp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9837',
  compr6DesiredSpeedPower => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9838',
  compr6OilTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.1.6.1.1.9839',
  confValves => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2',
  confSuctionValves => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.1',
  confSuctionValvesTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.1.1',
  confSuctionValvesEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.1.1.1',
  suctionvalve1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.1.1.1.4600',
  suctionvalve1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.1.1.1.4610',
  suctionvalve2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.1.1.1.4700',
  suctionvalve2AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.1.1.1.4710',
  confGECWValve => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2',
  confGECWValve1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1',
  confGECWValve1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1',
  confGECWValve1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1',
  gECWValve1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11400',
  gECWValve1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11401',
  gECWValve1CloseIfWTOverSP => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11403',
  gECWValve1HeatingPermitted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11404',
  gECWValve1AnalogOutputInverted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11405',
  gECWValve1StartTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11408',
  gECWValve1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11410',
  gECWValve1GEOffTempAbsolute => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11411',
  gECWValve1OpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11414',
  gECWValve1ManOpetionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11415',
  gECWValve1AnalogIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11425',
  gECWValve1OpeningGradeReturned => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11426',
  gECWValve1PFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11432',
  gECWValve1IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11433',
  gECWValve1DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11434',
  gECWValve1ControlStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11443',
  gECWValve1GEOffTempRelative => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.1.1.1.11444',
  confGECWValve2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2',
  confGECWValve2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1',
  confGECWValve2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1',
  gECWValve2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11450',
  gECWValve2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11451',
  gECWValve2CloseIfWTOverSP => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11453',
  gECWValve2HeatingPermitted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11454',
  gECWValve2AnalogOutputInverted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11455',
  gECWValve2StartTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11458',
  gECWValve2AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11460',
  gECWValve2GEOffTempAbsolute => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11461',
  gECWValve2OpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11464',
  gECWValve2ManOpetionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11465',
  gECWValve2AnalogIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11475',
  gECWValve2OpeningGradeReturned => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11476',
  gECWValve2PFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11482',
  gECWValve2IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11483',
  gECWValve2DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11484',
  gECWValve2ControlStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11493',
  gECWValve2GEOffTempRelative => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.2.1.1.11494',
  confGECWValveTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3',
  confGECWValveEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1',
  gECWValveConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5200',
  gECWValveCloseWithComprStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5202',
  gECWValveCloseIfWTOverSP => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5203',
  gECWValveHeatingPermitted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5204',
  gECWValveAnalogOut1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5210',
  gECWValveAnalogOut2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5216',
  gECWValveDinForSwitch => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5217',
  gECWValveOpeningGradeSetpoint => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5218',
  gECWValveDoutForSwitch => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5222',
  gECWValveOperationMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5223',
  gECWValveAnalogIn1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5225',
  gECWValveOpeningGradeReturned1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5226',
  gECWValveOpeningve1DuringSwitch => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5228',
  gECWValveAnalogIn2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5229',
  gECWValveOpeningGradeReturned2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5230',
  gECWValveControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5231',
  gECWValvePFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5232',
  gECWValveIFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5233',
  gECWValveDFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5234',
  gECWValveMaximumOpeningTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5235',
  gECWValveMaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5236',
  gECWValveMaxAdjustCalculated => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5237',
  gECWValveChillerverAnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5239',
  gECWValveControlStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.2.3.1.5243',
  confGValve => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3',
  confGValveTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1',
  confGValveEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1',
  gValve1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5300',
  gValve1PressureSetpoint => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5308',
  gValve1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5309',
  gValve1PreOpeningTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5310',
  gValve1PreOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5311',
  gValve1IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5314',
  gValve1DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5315',
  gValve1ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5316',
  gValve1MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5317',
  gValve1ControlFactorPFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5318',
  gValve1OpeningGradeSetpoint => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5319',
  gValve1OpeningGradeMin => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5320',
  gValve1MaximumOpeningTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5321',
  gValve1MaxAdjustCalculated => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5322',
  gValve1OpeningGreWatertempStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5323',
  gValve1OpeningGradeStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5324',
  gValve1OpeningGradeWatertempStop => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5325',
  gValve1OpeningGradeStop => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5326',
  gValve1PreOpeningGradeCalculated => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5327',
  gValve1ControlStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5328',
  gValve1StartingTmumOpeninggrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5329',
  gValve1GradientFantOpeninggrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5330',
  gValve2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5350',
  gValve2AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5359',
  gValve2PreOpeningTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5360',
  gValve2PreOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5361',
  gValve2IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5364',
  gValve2DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5365',
  gValve2MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5367',
  gValve2ControlFactorPFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5368',
  gValve2OpeningGradeSetpoint => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5369',
  gValve2OpeningGradeMin => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5370',
  gValve2ControlStart => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5378',
  gValve2StartingTmumOpeninggrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5379',
  gValve2GradientFantOpeninggrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.3.1.1.5380',
  confHGBP => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4',
  confHGBP1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1',
  confHGBP1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1',
  confHGBP1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1',
  hgbp1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9300',
  hgbp1PFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9308',
  hgbp1IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9309',
  hgbp1DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9310',
  hgbp1ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9311',
  hgbp1PreOpeningTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9312',
  hgbp1PreOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9313',
  hgbp1MinOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9314',
  hgbp1MaxOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9315',
  hgbp1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.1.1.1.9316',
  confHGBP2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2',
  confHGBP2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1',
  confHGBP2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1',
  hgbp2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9400',
  hgbp2PFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9408',
  hgbp2IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9409',
  hgbp2DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9410',
  hgbp2ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9411',
  hgbp2PreOpeningTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9412',
  hgbp2PreOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9413',
  hgbp2MinOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9414',
  hgbp2MaxOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9415',
  hgbp2AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.4.2.1.1.9416',
  confEEV => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5',
  confEEV1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1',
  confEEV1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1',
  confEEV1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1',
  eev1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8700',
  eev1BatterySupplyAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8701',
  eev1MOPControlAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8702',
  eev1SuperheatControlModeAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8703',
  eev1PressureSensommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8708',
  eev1TemperatureSmmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8709',
  eev1StepperMotorommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8710',
  eev1ReliabilityCmonAlarmCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8712',
  eev1BatteryHoldingTimeAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8716',
  eev1RefrigerantAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8717',
  eev1MOPTemperatureAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8718',
  eev1StartUpOpeniDurationAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8721',
  eev1StartUpOpening => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8722',
  eev1ValveTypeAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8723',
  eev1SensorTypeEvPressureAlcoVCM => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8724',
  eev1PressureSensorErrorAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8732',
  eev1TemperatureSrErrorAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8733',
  eev1StepperMotorErrorAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8734',
  eev1Controller => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8735',
  eev1ReliabilityCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8736',
  eev1SuperheatSetpointCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8737',
  eev1DehumidificaetpointCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8738',
  eev1MOPTemperatureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8739',
  eev1RefrigerantCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8740',
  eev1ValveTypeCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8741',
  eev1SensorTypeEvPressureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8742',
  eev1SuctionTemperatureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8743',
  eev1EvaporationTperatureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8744',
  eev1EvaporationPressureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8745',
  eev1ReliabilityAlarmprioCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.1.1.1.8746',
  confEEV2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2',
  confEEV2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1',
  confEEV2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1',
  eev2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8800',
  eev2BatterySupply => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8801',
  eev2MOPControl => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8802',
  eev2SuperheatControlMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8803',
  eev2PressureSensommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8808',
  eev2TemperatureSmmonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8809',
  eev2StepperMotorommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8810',
  eev2AvailabilityErrorCommonAlarm => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8812',
  eev2BatteryHoldingTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8816',
  eev2Refrigerant => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8817',
  eev2MOPTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8818',
  eev2StartUpOpeningDuration => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8821',
  eev2StartUpOpening => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8822',
  eev2ValveType => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8823',
  eev2SensorTypeEvorationgPressure => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8824',
  eev2PressureSensorErrorAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8832',
  eev2TemperatureSrErrorAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8833',
  eev2StepperMotorErrorAlarmprio => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8834',
  eev2Controller => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8835',
  eev2AvailabilityCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8836',
  eev2SuperheatSetpointCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8837',
  eev2DehumidificaetpointCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8838',
  eev2MOPTemperatureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8839',
  eev2RefrigerantCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8840',
  eev2ValveTypeCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8841',
  eev2SensorTypeEvPressureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8842',
  eev2SuctionTemperatureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8843',
  eev2EvaporationTperatureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8844',
  eev2EvaporationPressureCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8845',
  eev2ReliabilityAlarmprioCarelEVD => '1.3.6.1.4.1.29462.10.2.1.3.2.1.2.5.2.1.1.8846',
  confDrycooler => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3',
  confDrycooler1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1',
  confDrycooler1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1',
  confDrycooler1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1',
  drycooler1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5400',
  drycooler1CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5405',
  drycooler1DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5411',
  drycooler1AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5412',
  drycooler1AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5413',
  drycooler1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5417',
  drycooler1PreRunningSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5418',
  drycooler1ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5419',
  drycooler1MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5420',
  drycooler1ControlFactorPFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5421',
  drycooler1WaterStPrimaryInFCMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5423',
  drycooler1IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5424',
  drycooler1DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5425',
  drycooler1MaxSpeedInDXMode => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5426',
  drycooler1MinimumSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.1.1.1.5427',
  confDrycooler2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2',
  confDrycooler2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2.1',
  confDrycooler2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2.1.1',
  drycooler2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2.1.1.5500',
  drycooler2CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2.1.1.5505',
  drycooler2DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2.1.1.5511',
  drycooler2AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2.1.1.5512',
  drycooler2AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.2.1.1.5513',
  confDrycooler3 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3',
  confDrycooler3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3.1',
  confDrycooler3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3.1.1',
  drycooler3ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3.1.1.5600',
  drycooler3CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3.1.1.5605',
  drycooler3DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3.1.1.5611',
  drycooler3AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3.1.1.5612',
  drycooler3AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.3.1.1.5613',
  confDrycooler4 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4',
  confDrycooler4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4.1',
  confDrycooler4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4.1.1',
  drycooler4ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4.1.1.5700',
  drycooler4CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4.1.1.5705',
  drycooler4DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4.1.1.5711',
  drycooler4AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4.1.1.5712',
  drycooler4AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.3.4.1.1.5713',
  confPump => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4',
  confPump1 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1',
  confPump1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1',
  confPump1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1',
  pump1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5800',
  pump1CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5804',
  pump1Type => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5808',
  pump1DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5813',
  pump1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5814',
  pump1AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5815',
  pump1AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5816',
  pump1PreRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5818',
  pump1PreSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5819',
  pump1PartnerPump => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5824',
  pump1IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5825',
  pump1DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5826',
  pump1ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5827',
  pump1MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5828',
  pump1ControlFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5829',
  pump1MinSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5831',
  pump1AfterRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.1.1.1.5832',
  confPump2 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2',
  confPump2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1',
  confPump2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1',
  pump2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5900',
  pump2CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5904',
  pump2Type => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5908',
  pump2DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5913',
  pump2AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5914',
  pump2AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5915',
  pump2AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5916',
  pump2PreRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5918',
  pump2PreSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5919',
  pump2PartnerPump => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5924',
  pump2IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5925',
  pump2DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5926',
  pump2ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5927',
  pump2MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5928',
  pump2ControlFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5929',
  pump2MinSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.2.1.1.5931',
  confPump3 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3',
  confPump3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1',
  confPump3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1',
  pump3ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6000',
  pump3CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6004',
  pump3Type => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6008',
  pump3DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6013',
  pump3AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6014',
  pump3AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6015',
  pump3AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6016',
  pump3PreRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6018',
  pump3PreSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6019',
  pump3PartnerPump => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6024',
  pump3IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6025',
  pump3DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6026',
  pump3ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6027',
  pump3MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6028',
  pump3ControlFactorPFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6029',
  pump3MinSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.3.1.1.6031',
  confPump4 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4',
  confPump4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1',
  confPump4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1',
  pump4ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6100',
  pump4CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6104',
  pump4Type => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6108',
  pump4DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6113',
  pump4AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6114',
  pump4AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6115',
  pump4AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6116',
  pump4PreRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6118',
  pump4PreSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6119',
  pump4PartnerPump => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6124',
  pump4IFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6125',
  pump4DFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6126',
  pump4ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6127',
  pump4MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6128',
  pump4ControlFactorPFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6129',
  pump4MinSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.4.4.1.1.6131',
  confCoolLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5',
  confEcoLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.1',
  confEcoLouverTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.1.1',
  confEcoLouverEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.1.1.1',
  eCOLouverConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.1.1.1.9900',
  eCOLouverAnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.1.1.1.9912',
  confFreshairLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2',
  confFreshairLouverTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1',
  confFreshairLouverEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1',
  freshAirLouverConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10400',
  freshAirLouverAnogOutputInverted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10405',
  freshAirLouverAnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10410',
  freshAirLouverPronalCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10411',
  freshAirLouverIngralCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10412',
  freshAirLouverDetiveCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10413',
  freshAirLouverMamumOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10414',
  freshAirLouverAcatorBiasVoltage => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.2.1.1.10415',
  confAntifreezeLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3',
  confAntifreezeLouverTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1',
  confAntifreezeLouverEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1',
  antiFreezeLouverigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10500',
  antiFreezeLouverogOutputInverted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10505',
  antiFreezeLouverAnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10510',
  antiFreezeLouveronalCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10511',
  antiFreezeLouvergralCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10512',
  antiFreezeLouvertiveCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10513',
  antiFreezeLouvermumOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10514',
  antiFreezeLouveratorBiasVoltage => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.3.1.1.10515',
  confCirculationLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4',
  confCirculationLouverTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1',
  confCirculationLouverEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1',
  circulationLouvefigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10600',
  circulationLouvegOutputInverted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10605',
  circulationLouverAnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10610',
  circulationLouveionalCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10611',
  circulationLouveegralCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10612',
  circulationLouveativeCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10613',
  circulationLouveimumOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10614',
  circulationLouveuatorBiasVoltage => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.4.1.1.10615',
  confExitLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5',
  confExitLouverTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1',
  confExitLouverEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1',
  exitLouverConfigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10700',
  exitLouverAnalogOutputInverted => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10705',
  exitLouverDigitalOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10708',
  exitLouverAnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10711',
  exitLouverProporonalCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10712',
  exitLouverIntegralCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10713',
  exitLouverDerivativeCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10714',
  exitLouverMaximumOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10715',
  exitLouverActuatorBiasVoltage => '1.3.6.1.4.1.29462.10.2.1.3.2.1.5.5.1.1.10716',
  confCondensorfan => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6',
  confCondensorfanTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1',
  confCondensorfanEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1',
  condFan1ConfigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10800',
  condFan1CommonAlarmConfigured => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10804',
  condFan1ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10811',
  condFan1MaximumSpeedChange => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10812',
  condFan1MinimumSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10813',
  condFan1PrerunTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10814',
  condFan1PrerunSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10815',
  condFan1ProportionalCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10816',
  condFan1IntegralCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10817',
  condFan1DerivativeCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10818',
  condFan1AnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10819',
  condFan1DigitalOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10820',
  condFan1DigitalAlarmInput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10821',
  condFan1DigitalAlarmOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10822',
  condFan2ConfigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10900',
  condFan2CommonAlarmConfigured => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10904',
  condFan2ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10911',
  condFan2MaximumSpeedChange => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10912',
  condFan2MinimumSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10913',
  condFan2PrerunTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10914',
  condFan2PrerunSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10915',
  condFan2ProportionalCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10916',
  condFan2IntegralCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10917',
  condFan2DerivativeCoefficient => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10918',
  condFan2AnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10919',
  condFan2DigitalOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10920',
  condFan2DigitalAlarmInput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10921',
  condFan2DigitalAlarmOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.6.1.1.10922',
  confIcc => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7',
  confIccTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1',
  confIccEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1',
  iCCConfigured => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11500',
  manualOperation => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11501',
  commonAlarmAvailability => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11502',
  commonAlarmUpc => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11503',
  commonAlarmLowPressure => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11504',
  compressorPowerOnUPCDP42 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11505',
  enableToOperateUPCDP46 => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11506',
  iCCUPCModbusAddress => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11508',
  compressorModel => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11509',
  compressorNMinLimit => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11510',
  compressorNMaxLimit => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11511',
  iccStartTemp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11512',
  alarmpriorityAvailability => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11513',
  alarmpriorityUpc => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11514',
  pIDControllerKp => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11515',
  pIDControllerKi => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11516',
  pIDControllerKd => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11517',
  manualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.1.7.1.1.11518',
  confMovableCoil => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8',
  confMovableCoilTable => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1',
  confMovableCoilEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1',
  moveableCoilManuOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10003',
  moveableCoilManuerationDirection => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10004',
  moveableCoilCommAlarmConfigured => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10006',
  moveableCoilMaxDifference => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10010',
  moveableCoilSetupTime => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10011',
  moveableCoilEnableDigitalOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10012',
  moveableCoilDireionDigitalOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10013',
  moveableCoilMotor1AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10014',
  moveableCoilMotor2AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10015',
  moveableCoilAlarmDigitalOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10016',
  moveableCoilAlarmDelay => '1.3.6.1.4.1.29462.10.2.1.3.2.1.8.1.1.10017',
  confHeating => '1.3.6.1.4.1.29462.10.2.1.3.2.2',
  confEHeat => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1',
  confEHeat1 => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1',
  confEHeat1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1',
  confEHeat1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1.1',
  elecHeating1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1.1.4800',
  elecHeating1CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1.1.4805',
  elecHeating1Type => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1.1.4808',
  elecHeating1DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1.1.4812',
  elecHeating1AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1.1.4813',
  elecHeating1AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.1.1.1.4814',
  confEHeat2 => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2',
  confEHeat2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1',
  confEHeat2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1.1',
  elecHeating2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1.1.4900',
  elecHeating2CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1.1.4905',
  elecHeating2Type => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1.1.4908',
  elecHeating2DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1.1.4912',
  elecHeating2AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1.1.4913',
  elecHeating2AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.2.1.1.4914',
  confEHeat3 => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3',
  confEHeat3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1',
  confEHeat3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1.1',
  elecHeating3ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1.1.5000',
  elecHeating3CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1.1.5005',
  elecHeating3Type => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1.1.5008',
  elecHeating3DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1.1.5012',
  elecHeating3AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1.1.5013',
  elecHeating3AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.2.1.3.1.1.5014',
  confHotgasHeat => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2',
  confHotgasHeatTable => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2.1',
  confHotgasHeatEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2.1.1',
  hotgasHeatingConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2.1.1.6200',
  hotgasHeatingCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2.1.1.6205',
  hotgasHeatingDigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2.1.1.6210',
  hotgasHeatingAlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2.1.1.6211',
  hotgasHeatingAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.2.2.1.1.6212',
  confHwrValve => '1.3.6.1.4.1.29462.10.2.1.3.2.2.3',
  confHwrValveTable => '1.3.6.1.4.1.29462.10.2.1.3.2.2.3.1',
  confHwrValveEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.2.3.1.1',
  pWWHeatingConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.2.3.1.1.6300',
  pWWHeatingType => '1.3.6.1.4.1.29462.10.2.1.3.2.2.3.1.1.6308',
  pWWHeatingDigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.2.3.1.1.6313',
  pWWHeatingAnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.2.3.1.1.6314',
  confHumidity => '1.3.6.1.4.1.29462.10.2.1.3.2.3',
  confHumidifier => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1',
  confHumidifierTable => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1',
  confHumidifierEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1',
  humidifier1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6400',
  humidifier1CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6405',
  humidifier1ConductivityConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6406',
  humidifier15uSCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6407',
  humidifier120uSCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6408',
  humidifier1Type => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6416',
  humidifier1DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6421',
  humidifier1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6422',
  humidifier1AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6423',
  humidifier1AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6424',
  humidifier1AlarmDigitalIn5uS => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6429',
  humidifier1AlarmDigitalIn20uS => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6430',
  humidifier1AlarmPriorities5uS => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6433',
  humidifier1AlarmPriorities20uS => '1.3.6.1.4.1.29462.10.2.1.3.2.3.1.1.1.6434',
  confDehumidification => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2',
  confDehumidificationTable => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2.1',
  confDehumidificationEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2.1.1',
  dehumidificationlveConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2.1.1.6800',
  dehumidificationpassConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2.1.1.6805',
  dehumidificationDigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2.1.1.6813',
  dehumidificationStopOnRoomTemp => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2.1.1.6821',
  minFanSpeedWhenPDehumidification => '1.3.6.1.4.1.29462.10.2.1.3.2.3.2.1.1.6822',
  confAir => '1.3.6.1.4.1.29462.10.2.1.3.2.4',
  confFanGeneral => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2',
  confFanGeneralTable => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1',
  confFanGeneralEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1',
  fan1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6900',
  fan1Type => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6908',
  fan1Offset => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6919',
  fan1DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6923',
  fan1AnalogOut => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6924',
  fan1MinSpeedDXMode => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6934',
  fan1ControlCycle => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6935',
  fan1MaxAdjust => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6936',
  fan1ControlFactor => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.6937',
  fan2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.4.2.1.1.7000',
  confFanAlarm => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3',
  confFanAlarmTable => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1',
  confFanAlarmEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1.1',
  fan1CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1.1.6906',
  fan1FilterCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1.1.6907',
  fan1AlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1.1.6925',
  fan1AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1.1.6926',
  fan1FilterAlarmDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1.1.6928',
  fan1FilterAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.4.3.1.1.6929',
  confFanSpecialModes => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4',
  confFanSpecialModesTable => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1',
  confFanSpecialModesEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1',
  fan1PreRuntime => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6911',
  fan1RunAfterTime => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6912',
  fan1Start100Time => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6916',
  fan1ReduceTime => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6917',
  fan1ReduceSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6918',
  fan1DehumidificationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6920',
  fan1UpsSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6921',
  fan1OffsetFilterClogged => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6922',
  fan1EmergencyStarttemp => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6938',
  fan1EmergencyEndtemp => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6939',
  fan1Emergencyspeed => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6940',
  fan1DehumiTimeDelay => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6941',
  fan1MinSpeedCWMode => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6942',
  fan1StarttempFretdoorTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6943',
  fan1PowerConsumption => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6944',
  fan1RpmSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6945',
  fan1CurrentConsumption => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.6946',
  fan2MinSpeedCWMode => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.7042',
  fan2StarttempFretdoorTemperature => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.7043',
  fan2PowerConsumption => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.7044',
  fan2RpmSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.7045',
  fan2CurrentConsumption => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.7046',
  fan3MinSpeedCWMode => '1.3.6.1.4.1.29462.10.2.1.3.2.4.4.1.1.7142',
  confAirLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.4.5',
  confAirLouverTable => '1.3.6.1.4.1.29462.10.2.1.3.2.4.5.1',
  confAirLouverEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.4.5.1.1',
  louver1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.4.5.1.1.7200',
  louver1DigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.4.5.1.1.7209',
  confAEfilter => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6',
  confAEfilterTable => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1',
  confAEfilterEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1',
  filter1ConfigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11000',
  filter1CommonAlarmConfigured => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11002',
  filter1ActionOnAlarm => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11003',
  filter1Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11008',
  filter1DigitalAlarmOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11011',
  filter2ConfigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11100',
  filter2CommonAlarmConfigured => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11102',
  filter2ActionOnAlarm => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11103',
  filter2Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11108',
  filter2DigitalAlarmOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11111',
  filter2AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11112',
  filter3ConfigurationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11200',
  filter3CommonAlarmConfigured => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11202',
  filter3ActionOnAlarm => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11203',
  filter3Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11208',
  filter3DigitalAlarmOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11211',
  filter3AlarmDelay => '1.3.6.1.4.1.29462.10.2.1.3.2.4.6.1.1.11212',
  confSensor => '1.3.6.1.4.1.29462.10.2.1.3.2.5',
  confSensor1 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1',
  confSensor1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1',
  confSensor1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1',
  sensor1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2300',
  sensor1DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2303',
  sensor1LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2304',
  sensor1PurposeUse => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2308',
  sensor1Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2309',
  sensor1AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2310',
  sensor1MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2311',
  sensor1MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2312',
  sensor1MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2313',
  sensor1MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2314',
  sensor1Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2315',
  sensor1AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2316',
  sensor1FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.1.1.1.2318',
  confSensor2 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2',
  confSensor2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1',
  confSensor2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1',
  sensor2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2400',
  sensor2DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2403',
  sensor2LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2404',
  sensor2Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2408',
  sensor2Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2409',
  sensor2AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2410',
  sensor2MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2411',
  sensor2MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2412',
  sensor2MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2413',
  sensor2MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2414',
  sensor2Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2415',
  sensor2AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2416',
  sensor2FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.2.1.1.2418',
  confSensor3 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3',
  confSensor3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1',
  confSensor3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1',
  sensor3ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2500',
  sensor3DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2503',
  sensor3LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2504',
  sensor3Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2508',
  sensor3Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2509',
  sensor3AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2510',
  sensor3MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2511',
  sensor3MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2512',
  sensor3MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2513',
  sensor3MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2514',
  sensor3Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2515',
  sensor3AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2516',
  sensor3FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.3.1.1.2518',
  confSensor4 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4',
  confSensor4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1',
  confSensor4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1',
  sensor4ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2600',
  sensor4DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2603',
  sensor4LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2604',
  sensor4Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2608',
  sensor4Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2609',
  sensor4AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2610',
  sensor4MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2611',
  sensor4MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2612',
  sensor4MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2613',
  sensor4MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2614',
  sensor4Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2615',
  sensor4AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2616',
  sensor4FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.4.1.1.2618',
  confSensor5 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5',
  confSensor5Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1',
  confSensor5Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1',
  sensor5ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2700',
  sensor5DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2703',
  sensor5LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2704',
  sensor5Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2708',
  sensor5Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2709',
  sensor5AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2710',
  sensor5MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2711',
  sensor5MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2712',
  sensor5MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2713',
  sensor5MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2714',
  sensor5Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2715',
  sensor5AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2716',
  sensor5FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.5.1.1.2718',
  confSensor6 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6',
  confSensor6Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1',
  confSensor6Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1',
  sensor6ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2800',
  sensor6DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2803',
  sensor6LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2804',
  sensor6Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2808',
  sensor6Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2809',
  sensor6AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2810',
  sensor6MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2811',
  sensor6MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2812',
  sensor6MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2813',
  sensor6MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2814',
  sensor6Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2815',
  sensor6AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2816',
  sensor6FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.6.1.1.2818',
  confSensor7 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7',
  confSensor7Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1',
  confSensor7Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1',
  sensor7ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2900',
  sensor7DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2903',
  sensor7LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2904',
  sensor7Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2908',
  sensor7Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2909',
  sensor7AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2910',
  sensor7MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2911',
  sensor7MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2912',
  sensor7MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2913',
  sensor7MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2914',
  sensor7Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2915',
  sensor7AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2916',
  sensor7FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.7.1.1.2918',
  confSensor8 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8',
  confSensor8Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1',
  confSensor8Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1',
  sensor8ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3000',
  sensor8DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3003',
  sensor8LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3004',
  sensor8Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3008',
  sensor8Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3009',
  sensor8AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3010',
  sensor8MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3011',
  sensor8MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3012',
  sensor8MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3013',
  sensor8MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3014',
  sensor8Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3015',
  sensor8AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3016',
  sensor8FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.8.1.1.3018',
  confSensor9 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9',
  confSensor9Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1',
  confSensor9Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1',
  sensor9ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3100',
  sensor9DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3103',
  sensor9LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3104',
  sensor9Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3108',
  sensor9Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3109',
  sensor9AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3110',
  sensor9MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3111',
  sensor9MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3112',
  sensor9MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3113',
  sensor9MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3114',
  sensor9Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3115',
  sensor9AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3116',
  sensor9FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.9.1.1.3118',
  confSensor10 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10',
  confSensor10Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1',
  confSensor10Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1',
  sensor10ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3200',
  sensor10DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3203',
  sensor10LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3204',
  sensor10Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3208',
  sensor10Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3209',
  sensor10AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3210',
  sensor10MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3211',
  sensor10MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3212',
  sensor10MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3213',
  sensor10MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3214',
  sensor10Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3215',
  sensor10AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3216',
  sensor10FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.10.1.1.3218',
  confSensor11 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11',
  confSensor11Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1',
  confSensor11Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1',
  sensor11ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3300',
  sensor11DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3303',
  sensor11LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3304',
  sensor11Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3308',
  sensor11Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3309',
  sensor11AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3310',
  sensor11MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3311',
  sensor11MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3312',
  sensor11MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3313',
  sensor11MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3314',
  sensor11Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3315',
  sensor11AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3316',
  sensor11FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.11.1.1.3318',
  confSensor12 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12',
  confSensor12Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1',
  confSensor12Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1',
  sensor12ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3400',
  sensor12DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3403',
  sensor12LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3404',
  sensor12Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3408',
  sensor12Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3409',
  sensor12AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3410',
  sensor12MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3411',
  sensor12MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3412',
  sensor12MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3413',
  sensor12MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3414',
  sensor12Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3415',
  sensor12AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3416',
  sensor12FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.12.1.1.3418',
  confSensor13 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13',
  confSensor13Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1',
  confSensor13Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1',
  sensor13ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3500',
  sensor13DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3503',
  sensor13LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3504',
  sensor13Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3508',
  sensor13Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3509',
  sensor13AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3510',
  sensor13MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3511',
  sensor13MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3512',
  sensor13MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3513',
  sensor13MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3514',
  sensor13Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3515',
  sensor13AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3516',
  sensor13FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.13.1.1.3518',
  confSensor14 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14',
  confSensor14Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1',
  confSensor14Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1',
  sensor14ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3600',
  sensor14DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3603',
  sensor14LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3604',
  sensor14Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3608',
  sensor14Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3609',
  sensor14AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3610',
  sensor14MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3611',
  sensor14MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3612',
  sensor14MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3613',
  sensor14MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3614',
  sensor14Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3615',
  sensor14AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3616',
  sensor14FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.14.1.1.3618',
  confSensor15 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15',
  confSensor15Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1',
  confSensor15Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1',
  sensor15ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3700',
  sensor15DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3703',
  sensor15LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3704',
  sensor15Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3708',
  sensor15Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3709',
  sensor15AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3710',
  sensor15MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3711',
  sensor15MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3712',
  sensor15MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3713',
  sensor15MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3714',
  sensor15Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3715',
  sensor15AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3716',
  sensor15FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.15.1.1.3718',
  confSensor16 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16',
  confSensor16Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1',
  confSensor16Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1',
  sensor16ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3800',
  sensor16DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3803',
  sensor16LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3804',
  sensor16Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3808',
  sensor16Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3809',
  sensor16AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3810',
  sensor16MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3811',
  sensor16MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3812',
  sensor16MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3813',
  sensor16MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3814',
  sensor16Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3815',
  sensor16AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3816',
  sensor16FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.16.1.1.3818',
  confSensor17 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17',
  confSensor17Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1',
  confSensor17Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1',
  sensor17ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3900',
  sensor17DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3903',
  sensor17LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3904',
  sensor17Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3908',
  sensor17Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3909',
  sensor17AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3910',
  sensor17MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3911',
  sensor17MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3912',
  sensor17MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3913',
  sensor17MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3914',
  sensor17Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3915',
  sensor17AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3916',
  sensor17FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.17.1.1.3918',
  confSensor18 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18',
  confSensor18Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1',
  confSensor18Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1',
  sensor18ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4000',
  sensor18DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4003',
  sensor18LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4004',
  sensor18Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4008',
  sensor18Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4009',
  sensor18AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4010',
  sensor18MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4011',
  sensor18MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4012',
  sensor18MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4013',
  sensor18MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4014',
  sensor18Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4015',
  sensor18AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4016',
  sensor18FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.18.1.1.4018',
  confSensor19 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19',
  confSensor19Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1',
  confSensor19Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1',
  sensor19ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4100',
  sensor19DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4103',
  sensor19LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4104',
  sensor19Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4108',
  sensor19Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4109',
  sensor19AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4110',
  sensor19MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4111',
  sensor19MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4112',
  sensor19MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4113',
  sensor19MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4114',
  sensor19Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4115',
  sensor19AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4116',
  sensor19FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.19.1.1.4118',
  confSensor20 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20',
  confSensor20Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1',
  confSensor20Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1',
  sensor20ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4200',
  sensor20DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4203',
  sensor20LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4204',
  sensor20Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4208',
  sensor20Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4209',
  sensor20AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4210',
  sensor20MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4211',
  sensor20MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4212',
  sensor20MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4213',
  sensor20MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4214',
  sensor20Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4215',
  sensor20AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4216',
  sensor20FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.20.1.1.4218',
  confSensor21 => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21',
  confSensor21Table => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1',
  confSensor21Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1',
  sensor21ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4300',
  sensor21DefectCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4303',
  sensor21LimitCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4304',
  sensor21Purpose => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4308',
  sensor21Type => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4309',
  sensor21AnalogInput => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4310',
  sensor21MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4311',
  sensor21MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4312',
  sensor21MinPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4313',
  sensor21MaxPhysValue => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4314',
  sensor21Tolerance => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4315',
  sensor21AlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4316',
  sensor21FailureAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.5.21.1.1.4318',
  confAuxPorts => '1.3.6.1.4.1.29462.10.2.1.3.2.6',
  confExtAlarms => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1',
  confExtAlarms1 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.1',
  confExtAlarms1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.1.1',
  confExtAlarms1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.1.1.1',
  extAlarmConfigActive1 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.1.1.1.7500',
  extAlarm1CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.1.1.1.7504',
  extAlarm1DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.1.1.1.7508',
  extAlarm1Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.1.1.1.7509',
  confExtAlarms2 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.2',
  confExtAlarms2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.2.1',
  confExtAlarms2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.2.1.1',
  extAlarmConfigActive2 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.2.1.1.7600',
  extAlarm2CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.2.1.1.7604',
  extAlarm2DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.2.1.1.7608',
  extAlarm2Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.2.1.1.7609',
  confExtAlarms3 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.3',
  confExtAlarms3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.3.1',
  confExtAlarms3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.3.1.1',
  extAlarmConfigActive3 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.3.1.1.7700',
  extAlarm3CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.3.1.1.7704',
  extAlarm3DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.3.1.1.7708',
  extAlarm3Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.3.1.1.7709',
  confExtAlarms4 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.4',
  confExtAlarms4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.4.1',
  confExtAlarms4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.4.1.1',
  extAlarmConfigActive4 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.4.1.1.7800',
  extAlarm4CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.4.1.1.7804',
  extAlarm4DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.4.1.1.7808',
  extAlarm4Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.4.1.1.7809',
  confExtAlarms5 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.5',
  confExtAlarms5Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.5.1',
  confExtAlarms5Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.5.1.1',
  extAlarmConfigActive5 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.5.1.1.7900',
  extAlarm5CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.5.1.1.7904',
  extAlarm5DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.5.1.1.7908',
  extAlarm5Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.5.1.1.7909',
  confExtAlarms6 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.6',
  confExtAlarms6Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.6.1',
  confExtAlarms6Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.6.1.1',
  extAlarmConfigActive6 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.6.1.1.8000',
  extAlarm6CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.6.1.1.8004',
  extAlarm6DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.6.1.1.8008',
  extAlarm6Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.6.1.1.8009',
  confExtAlarms7 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.7',
  confExtAlarms7Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.7.1',
  confExtAlarms7Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.7.1.1',
  extAlarmConfigActive7 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.7.1.1.8100',
  extAlarm7CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.7.1.1.8104',
  extAlarm7DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.7.1.1.8108',
  extAlarm7Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.7.1.1.8109',
  confExtAlarms8 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.8',
  confExtAlarms8Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.8.1',
  confExtAlarms8Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.8.1.1',
  extAlarmConfigActive8 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.8.1.1.8200',
  extAlarm8CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.8.1.1.8204',
  extAlarm8DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.8.1.1.8208',
  extAlarm8Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.8.1.1.8209',
  confExtAlarms9 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.9',
  confExtAlarms9Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.9.1',
  confExtAlarms9Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.9.1.1',
  extAlarmConfigActive9 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.9.1.1.8300',
  extAlarm9CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.9.1.1.8304',
  extAlarm9DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.9.1.1.8308',
  extAlarm9Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.9.1.1.8309',
  confExtAlarms10 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.10',
  confExtAlarms10Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.10.1',
  confExtAlarms10Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.10.1.1',
  extAlarmConfigActive10 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.10.1.1.8400',
  extAlarm10CommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.10.1.1.8404',
  extAlarm10DigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.10.1.1.8408',
  extAlarm10Priorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.1.10.1.1.8409',
  confUnitalarms => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2',
  confUnitalarmsTable => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1',
  confUnitalarmsEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1',
  busalarmcommon => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.11',
  busadrconflictcommon => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.13',
  busalarmprio => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.16',
  busadrconflictprio => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.18',
  fireAlarmDIN => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1704',
  waterAlarmDIN => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1705',
  waterflowAlarmDIN => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1706',
  phaseAlarmDIN => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1707',
  fireAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1711',
  waterAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1713',
  phaseAlarmPriorities => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1715',
  waterflowAlarmPriority => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1719',
  fireAlarmCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1742',
  waterAlarmCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1743',
  phaseAlarmCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1744',
  waterflowAlarmCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.1747',
  commonAlarmConfioomHighPressure => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.10302',
  forceSummerModeEernallyDigitalIn => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.10310',
  roomHighPressurearmDigitalInput => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.10311',
  roomHighPressurearmDigitalOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.6.2.1.1.10312',
  confDigitalPorts => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3',
  confDigitalPortsTable => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1',
  confDigitalPortsEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1',
  commonAlarmDOUT => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1700',
  winterModeFCPossibleDOUT => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1701',
  remoteOnOffDIN => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1702',
  upsDIN => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1703',
  cWDisableDXEnableDIN => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1708',
  unitOnOffDOUT => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1725',
  unitFreecoolingDolerReleaseDout => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1726',
  fanRunningDOUT => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1727',
  pCStopDigitalOut => '1.3.6.1.4.1.29462.10.2.1.3.2.6.3.1.1.1728',
  confValueOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4',
  confValueOutput1 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1',
  confValueOutput1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1.1',
  confValueOutput1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1.1.1',
  valout1ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1.1.1.8900',
  valout1PurposeUse => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1.1.1.8908',
  valout1AnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1.1.1.8910',
  valout1MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1.1.1.8911',
  valout1MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.1.1.1.8912',
  confValueOutput2 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2',
  confValueOutput2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2.1',
  confValueOutput2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2.1.1',
  valout2ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2.1.1.9000',
  valout2PurposeUse => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2.1.1.9008',
  valout2AnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2.1.1.9010',
  valout2MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2.1.1.9011',
  valout2MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.2.1.1.9012',
  confValueOutput3 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3',
  confValueOutput3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3.1',
  confValueOutput3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3.1.1',
  valout3ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3.1.1.9100',
  valout3PurposeUse => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3.1.1.9108',
  valout3AnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3.1.1.9110',
  valout3MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3.1.1.9111',
  valout3MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.3.1.1.9112',
  confValueOutput4 => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4',
  confValueOutput4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4.1',
  confValueOutput4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4.1.1',
  valout4ConfigActive => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4.1.1.9200',
  valout4PurposeUse => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4.1.1.9208',
  valout4AnalogOutput => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4.1.1.9210',
  valout4MinValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4.1.1.9211',
  valout4MaxValue => '1.3.6.1.4.1.29462.10.2.1.3.2.6.4.4.1.1.9212',
  confUPSOperation => '1.3.6.1.4.1.29462.10.2.1.3.2.7',
  confUPSOperationTable => '1.3.6.1.4.1.29462.10.2.1.3.2.7.1',
  confUPSOperationEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.7.1.1',
  upsActionCooling => '1.3.6.1.4.1.29462.10.2.1.3.2.7.1.1.1750',
  upsActionHeating => '1.3.6.1.4.1.29462.10.2.1.3.2.7.1.1.1751',
  upsActionHumidification => '1.3.6.1.4.1.29462.10.2.1.3.2.7.1.1.1752',
  upsActionDehumidification => '1.3.6.1.4.1.29462.10.2.1.3.2.7.1.1.1753',
  confManualOperation => '1.3.6.1.4.1.29462.10.2.1.3.2.8',
  confManCooling => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1',
  confManCompressors => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1',
  confManCompressorsTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1',
  confManCompressorsEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1',
  compr1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.4401',
  compr1ManualOperationState => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.4402',
  compr1EconomizerActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.4406',
  compr2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.4501',
  compr2ManualOperationState => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.4502',
  compr2EconomizerActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.4506',
  compr3ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9501',
  compr3ManualOperationState => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9502',
  compr3EconomizerActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9506',
  compr4ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9601',
  compr4ManualOperationState => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9602',
  compr4EconomizerActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9606',
  compr5ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9701',
  compr5ManualOperationState => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9702',
  compr5EconomizerActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9706',
  compr6ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9801',
  compr6ManualOperationState => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9802',
  compr6EconomizerActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.1.1.1.9806',
  confManValves => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2',
  confManSuctionValve => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.1',
  confManSuctionValveTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.1.1',
  confManSuctionValveEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.1.1.1',
  suctionvalve1ManlOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.1.1.1.4601',
  suctionvalve1ManlOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.1.1.1.4612',
  confManSuctionValve2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.2',
  confManSuctionValve2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.2.1',
  confManSuctionValve2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.2.1.1',
  suctionvalve2ManlOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.2.1.1.4701',
  suctionvalve2ManlOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.2.1.1.4712',
  confManGECWValve => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.3',
  confManGECWValveTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.3.1',
  confManGECWValveEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.3.1.1',
  gECWValveManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.3.1.1.5201',
  gECWValveManOperionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.3.1.1.5215',
  confManGValve => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.4',
  confManGValveTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.4.1',
  confManGValveEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.4.1.1',
  gValve1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.4.1.1.5301',
  gValve1ManualOpetionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.4.1.1.5313',
  gValve2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.4.1.1.5351',
  gValve2ManualOpetionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.4.1.1.5363',
  confManHGBP => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5',
  confManHGBP1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.1',
  confManHGBP1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.1.1',
  confManHGBP1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.1.1.1',
  hgbp1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.1.1.1.9301',
  hgbp1ManOperationOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.1.1.1.9317',
  confManHGBP2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.2',
  confManHGBP2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.2.1',
  confManHGBP2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.2.1.1',
  hgbp2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.2.1.1.9401',
  hgbp2ManOperationOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.5.2.1.1.9417',
  confManEEV => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6',
  confManEEV1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.1',
  confManEEV1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.1.1',
  confManEEV1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.1.1.1',
  eev1ManualOperation => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.1.1.1.8704',
  eev1ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.1.1.1.8725',
  confManEEV2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.2',
  confManEEV2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.2.1',
  confManEEV2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.2.1.1',
  eev2ManualOperation => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.2.1.1.8804',
  eev2ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.2.6.2.1.1.8825',
  confManDrycooler => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3',
  confManDrycooler1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.1',
  confManDrycooler1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.1.1',
  confManDrycooler1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.1.1.1',
  drycooler1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.1.1.1.5401',
  drycooler1ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.1.1.1.5404',
  drycooler1ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.1.1.1.5422',
  confManDrycooler2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.2',
  confManDrycooler2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.2.1',
  confManDrycooler2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.2.1.1',
  drycooler2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.2.1.1.5501',
  drycooler2ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.2.1.1.5504',
  confManDrycooler3 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.3',
  confManDrycooler3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.3.1',
  confManDrycooler3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.3.1.1',
  drycooler3ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.3.1.1.5601',
  drycooler3ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.3.1.1.5604',
  confManDrycooler4 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.4',
  confManDrycooler4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.4.1',
  confManDrycooler4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.4.1.1',
  drycooler4ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.4.1.1.5701',
  drycooler4ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.3.4.1.1.5704',
  confManPump => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4',
  confManPump1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.1',
  confManPump1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.1.1',
  confManPump1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.1.1.1',
  pump1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.1.1.1.5801',
  pump1ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.1.1.1.5805',
  pump1ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.1.1.1.5822',
  confManPump2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.2',
  confManPump2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.2.1',
  confManPump2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.2.1.1',
  pump2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.2.1.1.5901',
  pump2ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.2.1.1.5905',
  pump2ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.2.1.1.5922',
  confManPump3 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.3',
  confManPump3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.3.1',
  confManPump3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.3.1.1',
  pump3ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.3.1.1.6001',
  pump3ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.3.1.1.6005',
  pump3ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.3.1.1.6022',
  confManPump4 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.4',
  confManPump4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.4.1',
  confManPump4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.4.1.1',
  pump4ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.4.1.1.6101',
  pump4ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.4.1.1.6105',
  pump4ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.4.4.1.1.6122',
  confManLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5',
  confManLouverEco => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.1',
  confManLouverEcoTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.1.1',
  confManLouverEcoEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.1.1.1',
  eCOLouverManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.1.1.1.9901',
  eCOLouverManOpOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.1.1.1.9914',
  confManLouverFreshAir => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.2',
  confManLouverFreshAirTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.2.1',
  confManLouverFreshAirEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.2.1.1',
  freshAirLouverMaOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.2.1.1.10401',
  freshAirLouverMaionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.2.1.1.10409',
  confManLouverAntiFreeze => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.3',
  confManLouverAntiFreezeTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.3.1',
  confManLouverAntiFreezeEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.3.1.1',
  antiFreezeLouverOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.3.1.1.10501',
  antiFreezeLouverionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.3.1.1.10509',
  confManLouvercirculation => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.4',
  confManLouvercirculationTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.4.1',
  confManLouvercirculationEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.4.1.1',
  circulationLouvelOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.4.1.1.10601',
  circulationLouvetionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.4.1.1.10609',
  confManLouverExit => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.5',
  confManLouverExitTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.5.1',
  confManLouverExitEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.5.1.1',
  exitLouverManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.5.1.1.10701',
  exitLouverManualionOpeningState => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.5.1.1.10703',
  exitLouverManualionOpeningGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.5.5.1.1.10710',
  confManConFan => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.6',
  confManConFanTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.6.1',
  confManConFanEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.6.1.1',
  condFan1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.6.1.1.10801',
  condFan1ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.6.1.1.10809',
  condFan2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.6.1.1.10901',
  condFan2ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.1.6.1.1.10909',
  confManHeating => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2',
  confManEHeat => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1',
  confManEHeat1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.1',
  confManEHeat1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.1.1',
  confManEHeat1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.1.1.1',
  elecHeating1ManuOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.1.1.1.4801',
  elecHeating1ManuOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.1.1.1.4804',
  elecHeating1ManuerationPWMGrade => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.1.1.1.4818',
  confManEHeat2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.2',
  confManEHeat2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.2.1',
  confManEHeat2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.2.1.1',
  elecHeating2ManuOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.2.1.1.4901',
  elecHeating2ManuOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.2.1.1.4904',
  confManEHeat3 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.3',
  confManEHeat3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.3.1',
  confManEHeat3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.3.1.1',
  elecHeating3ManuOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.3.1.1.5001',
  elecHeating3ManuOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.1.3.1.1.5004',
  confManHotgasHeat => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.2',
  confManHotgasHeatTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.2.1',
  confManHotgasHeatEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.2.1.1',
  hotgasHeatingManlOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.2.1.1.6201',
  hotgasHeatingManperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.2.1.1.6203',
  confManHwrValve => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.3',
  confManHwrValveTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.3.1',
  confManHwrValveEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.3.1.1',
  pWWHeatingManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.3.1.1.6301',
  pWWHeatingManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.3.1.1.6303',
  pWWHeatingManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.2.3.1.1.6316',
  confManHumidity => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3',
  confManHumidifier => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.1',
  confManHumidifierTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.1.1',
  confManHumidifierEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.1.1.1',
  humidifier1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.1.1.1.6401',
  humidifier1ManuaperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.1.1.1.6404',
  humidifier1ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.1.1.1.6428',
  confManDehumidification => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.2',
  confManDehumidificationTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.2.1',
  confManDehumidificationEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.2.1.1',
  dehumidificationOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.2.1.1.6801',
  dehumidificationOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.3.2.1.1.6804',
  confManAir => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4',
  confManFan => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.1',
  confManFanTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.1.1',
  confManFanEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.1.1.1',
  fan1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.1.1.1.6901',
  fan1ManualOperationRunning => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.1.1.1.6905',
  fan1ManualOperationSpeed => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.1.1.1.6933',
  confManAirLouver => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.2',
  confManAirLouverTable => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.2.1',
  confManAirLouverEntry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.2.1.1',
  louver1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.2.1.1.7201',
  louver1ManualOperationOpen => '1.3.6.1.4.1.29462.10.2.1.3.2.8.4.2.1.1.7203',
  confManSensor => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5',
  confManSensor1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.1',
  confManSensor1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.1.1',
  confManSensor1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.1.1.1',
  sensor1ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.1.1.1.2305',
  sensor1ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.1.1.1.2323',
  confManSensor2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.2',
  confManSensor2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.2.1',
  confManSensor2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.2.1.1',
  sensor2ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.2.1.1.2405',
  sensor2ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.2.1.1.2423',
  confManSensor3 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.3',
  confManSensor3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.3.1',
  confManSensor3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.3.1.1',
  sensor3ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.3.1.1.2505',
  sensor3ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.3.1.1.2523',
  confManSensor4 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.4',
  confManSensor4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.4.1',
  confManSensor4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.4.1.1',
  sensor4ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.4.1.1.2605',
  sensor4ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.4.1.1.2623',
  confManSensor5 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.5',
  confManSensor5Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.5.1',
  confManSensor5Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.5.1.1',
  sensor5ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.5.1.1.2705',
  sensor5ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.5.1.1.2723',
  confManSensor6 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.6',
  confManSensor6Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.6.1',
  confManSensor6Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.6.1.1',
  sensor6ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.6.1.1.2805',
  sensor6ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.6.1.1.2823',
  confManSensor7 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.7',
  confManSensor7Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.7.1',
  confManSensor7Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.7.1.1',
  sensor7ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.7.1.1.2905',
  sensor7ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.7.1.1.2923',
  confManSensor8 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.8',
  confManSensor8Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.8.1',
  confManSensor8Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.8.1.1',
  sensor8ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.8.1.1.3005',
  sensor8ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.8.1.1.3023',
  confManSensor9 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.9',
  confManSensor9Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.9.1',
  confManSensor9Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.9.1.1',
  sensor9ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.9.1.1.3105',
  sensor9ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.9.1.1.3123',
  confManSensor10 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.10',
  confManSensor10Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.10.1',
  confManSensor10Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.10.1.1',
  sensor10ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.10.1.1.3205',
  sensor10ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.10.1.1.3223',
  confManSensor11 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.11',
  confManSensor11Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.11.1',
  confManSensor11Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.11.1.1',
  sensor11ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.11.1.1.3305',
  sensor11ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.11.1.1.3323',
  confManSensor12 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.12',
  confManSensor12Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.12.1',
  confManSensor12Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.12.1.1',
  sensor12ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.12.1.1.3405',
  sensor12ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.12.1.1.3423',
  confManSensor13 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.13',
  confManSensor13Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.13.1',
  confManSensor13Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.13.1.1',
  sensor13ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.13.1.1.3505',
  sensor13ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.13.1.1.3523',
  confManSensor14 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.14',
  confManSensor14Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.14.1',
  confManSensor14Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.14.1.1',
  sensor14ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.14.1.1.3605',
  sensor14ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.14.1.1.3623',
  confManSensor15 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.15',
  confManSensor15Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.15.1',
  confManSensor15Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.15.1.1',
  sensor15ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.15.1.1.3705',
  sensor15ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.15.1.1.3723',
  confManSensor16 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.16',
  confManSensor16Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.16.1',
  confManSensor16Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.16.1.1',
  sensor16ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.16.1.1.3805',
  sensor16ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.16.1.1.3823',
  confManSensor17 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.17',
  confManSensor17Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.17.1',
  confManSensor17Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.17.1.1',
  sensor17ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.17.1.1.3905',
  sensor17ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.17.1.1.3923',
  confManSensor18 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.18',
  confManSensor18Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.18.1',
  confManSensor18Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.18.1.1',
  sensor18ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.18.1.1.4005',
  sensor18ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.18.1.1.4023',
  confManSensor19 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.19',
  confManSensor19Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.19.1',
  confManSensor19Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.19.1.1',
  sensor19ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.19.1.1.4105',
  sensor19ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.19.1.1.4123',
  confManSensor20 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.20',
  confManSensor20Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.20.1',
  confManSensor20Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.20.1.1',
  sensor20ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.20.1.1.4205',
  sensor20ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.20.1.1.4223',
  confManSensor21 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.21',
  confManSensor21Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.21.1',
  confManSensor21Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.21.1.1',
  sensor21ManualOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.21.1.1.4305',
  sensor21ManualOperationValue => '1.3.6.1.4.1.29462.10.2.1.3.2.8.5.21.1.1.4323',
  confManAuxPorts => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6',
  confManExtAlarms => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1',
  confManExtAlarms1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.1',
  confManExtAlarms1Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.1.1',
  confManExtAlarms1Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.1.1.1',
  extAlarmManualOperationEnable1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.1.1.1.7501',
  extAlarmManualOperationActive1 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.1.1.1.7503',
  confManExtAlarms2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.2',
  confManExtAlarms2Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.2.1',
  confManExtAlarms2Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.2.1.1',
  extAlarmManualOperationEnable2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.2.1.1.7601',
  extAlarmManualOperationActive2 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.2.1.1.7603',
  confManExtAlarms3 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.3',
  confManExtAlarms3Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.3.1',
  confManExtAlarms3Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.3.1.1',
  extAlarmManualOperationEnable3 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.3.1.1.7701',
  extAlarmManualOperationActive3 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.3.1.1.7703',
  confManExtAlarms4 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.4',
  confManExtAlarms4Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.4.1',
  confManExtAlarms4Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.4.1.1',
  extAlarmManualOperationEnable4 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.4.1.1.7801',
  extAlarmManualOperationActive4 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.4.1.1.7803',
  confManExtAlarms5 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.5',
  confManExtAlarms5Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.5.1',
  confManExtAlarms5Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.5.1.1',
  extAlarmManualOperationEnable5 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.5.1.1.7901',
  extAlarmManualOperationActive5 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.5.1.1.7903',
  confManExtAlarms6 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.6',
  confManExtAlarms6Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.6.1',
  confManExtAlarms6Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.6.1.1',
  extAlarmManualOperationEnable6 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.6.1.1.8001',
  extAlarmManualOperationActive6 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.6.1.1.8003',
  confManExtAlarms7 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.7',
  confManExtAlarms7Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.7.1',
  confManExtAlarms7Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.7.1.1',
  extAlarmManualOperationEnable7 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.7.1.1.8101',
  extAlarmManualOperationActive7 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.7.1.1.8103',
  confManExtAlarms8 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.8',
  confManExtAlarms8Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.8.1',
  confManExtAlarms8Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.8.1.1',
  extAlarmManualOperationEnable8 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.8.1.1.8201',
  extAlarmManualOperationActive8 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.8.1.1.8203',
  confManExtAlarms9 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.9',
  confManExtAlarms9Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.9.1',
  confManExtAlarms9Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.9.1.1',
  extAlarmManualOperationEnable9 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.9.1.1.8301',
  extAlarmManualOperationActive9 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.9.1.1.8303',
  confManExtAlarms10 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.10',
  confManExtAlarms10Table => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.10.1',
  confManExtAlarms10Entry => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.10.1.1',
  extAlarmManualOperationEnable10 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.10.1.1.8401',
  extAlarmManualOperationActive10 => '1.3.6.1.4.1.29462.10.2.1.3.2.8.6.1.10.1.1.8403',
  confZoneSequencing => '1.3.6.1.4.1.29462.10.2.1.3.3',
  confZoneSequencingTable => '1.3.6.1.4.1.29462.10.2.1.3.3.1',
  confZoneSequencingEntry => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1',
  myZoneNumberOfErrorUnits => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11706',
  myZoneEmergencyTemperature => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11707',
  myZoneCWEnergySaveModeActiv => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11708',
  myZoneTestsequencing => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11709',
  myZoneAverageDetonOfTempAndHumi => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11710',
  myZoneStandbyInAgeDetermination => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11711',
  myZoneEmergencyOperationActive => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11712',
  myZoneAverageDetonOfAirPressure => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11713',
  myZoneAverageDetonOfRoomPressure => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11714',
  myZoneNMax => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11780',
  gE3RelativeStartTempOfMyZone => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11781',
  gE3HysteresisOfMyZone => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11782',
  gE3AbsoluteStartTempOfMyZone => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11783',
  gEpAbsoluteStarttertempOfMyZone => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11784',
  gEpWaterHysteresisOfMyZone => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11785',
  numberOfUnitsOfMyZoneForPT => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11786',
  myZoneOutdoorTemperature => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11787',
  myZoneCurrentRaisedFloorPressure => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11788',
  gepRelativeStarttertempOfMyZone => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11789',
  myZoneCurrentRoomPressure => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11790',
  myZoneAverageDetayForTempAndHumi => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11791',
  myZoneCurrentSupplyAirPressure => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11792',
  myZoneNMaxForStayUnitDuringSAPSM => '1.3.6.1.4.1.29462.10.2.1.3.3.1.1.11793',
  confDataStatistical => '1.3.6.1.4.1.29462.10.2.1.3.4',
  confDatalog => '1.3.6.1.4.1.29462.10.2.1.3.4.1',
  confEventlog => '1.3.6.1.4.1.29462.10.2.1.3.4.2',
  confRuntimes => '1.3.6.1.4.1.29462.10.2.1.3.4.3',
  confFunctions => '1.3.6.1.4.1.29462.10.2.1.3.4.3.1',
  confComponents => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2',
  confCompressors => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.1',
  confDrycoolers => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.2',
  confPumps => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.3',
  confEHeatings => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.4',
  confCondFan => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.5',
  confCondFanTable => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.5.1',
  confCondFanEntry => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.5.1.1',
  condFan1Runtime => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.5.1.1.10810',
  condFan2Runtime => '1.3.6.1.4.1.29462.10.2.1.3.4.3.2.5.1.1.10910',
  confMaintenance => '1.3.6.1.4.1.29462.10.2.1.3.4.4',
  confMaintenanceTable => '1.3.6.1.4.1.29462.10.2.1.3.4.4.1',
  confMaintenanceEntry => '1.3.6.1.4.1.29462.10.2.1.3.4.4.1.1',
  maintenanceAlarmPrio => '1.3.6.1.4.1.29462.10.2.1.3.4.4.1.1.1717',
  maintenanceCommonAlarmConfig => '1.3.6.1.4.1.29462.10.2.1.3.4.4.1.1.1745',
  confSystem => '1.3.6.1.4.1.29462.10.2.1.3.5',
  confUnitname => '1.3.6.1.4.1.29462.10.2.1.3.5.1',
  confInterfaces => '1.3.6.1.4.1.29462.10.2.1.3.5.2',
  confInterfacesTable => '1.3.6.1.4.1.29462.10.2.1.3.5.2.1',
  confInterfacesEntry => '1.3.6.1.4.1.29462.10.2.1.3.5.2.1.1',
  globalAdress => '1.3.6.1.4.1.29462.10.2.1.3.5.2.1.1.6',
  confDefaultSettingsUnittype => '1.3.6.1.4.1.29462.10.2.1.3.5.3',
  confPassword => '1.3.6.1.4.1.29462.10.2.1.3.6',
  state => '1.3.6.1.4.1.29462.10.2.1.4',
  overview => '1.3.6.1.4.1.29462.10.2.1.4.1',
  overviewTable => '1.3.6.1.4.1.29462.10.2.1.4.1.1',
  overviewEntry => '1.3.6.1.4.1.29462.10.2.1.4.1.1.1',
  busalarm => '1.3.6.1.4.1.29462.10.2.1.4.1.1.1.10',
  busadrconflict => '1.3.6.1.4.1.29462.10.2.1.4.1.1.1.12',
  unitOnOff => '1.3.6.1.4.1.29462.10.2.1.4.1.1.1.1013',
  unitOnOffDefinition => {
    0 => 'off',
    1 => 'on',
  },
  unitstate => '1.3.6.1.4.1.29462.10.2.1.4.2',
  unitstateTable => '1.3.6.1.4.1.29462.10.2.1.4.2.1',
  unitstateEntry => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1',
  numberOfModules => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.4',
  hardwareTypeControllerType => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.7',
  generalError => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.8',
  pCSTOPMonitoringBMSStop1 => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.1000',
  rEMOTESTOPContact => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.1001',
  lOCALSTOP => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.1002',
  tIMERSTOPWeeklyOper => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.1003',
  sEQStop0No1Yes => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.1004',
  wARMUPSTOPDelayedStart => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.1005',
  fCBPCSTOP => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.10201',
  fCBREMOTESTOP => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.10202',
  fCBLOCALSTOP => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.10203',
  fCBTIMERSTOP => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.10204',
  unitStandBy => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.10205',
  timeDateFormat => '1.3.6.1.4.1.29462.10.2.1.4.2.1.1.10209',
  stateTable => '1.3.6.1.4.1.29462.10.2.1.4.3',
  stateEntry => '1.3.6.1.4.1.29462.10.2.1.4.3.1',
  resetAllAlarms => '1.3.6.1.4.1.29462.10.2.1.4.3.1.1011',
  unitview => '1.3.6.1.4.1.29462.10.2.1.4.4',
  unitAlarms => '1.3.6.1.4.1.29462.10.2.1.4.4.1',
  unitAlarmsTable => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1',
  unitAlarmsEntry => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1',
  commonAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.1010',
  airflow1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8500',
  airflow2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8501',
  airflow3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8502',
  highpressure1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8503',
  highpressure2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8504',
  waterDetector => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8505',
  phasecheck => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8506',
  fireSmoke => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8507',
  returnAirTempTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8508',
  returnAirHumidTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8509',
  supplyAirTempTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8510',
  supplyAirHumidTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8511',
  waterTempTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8512',
  returnAirTempTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8513',
  returnAirHumidTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8514',
  supplyAirTempTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8515',
  supplyAirHumidTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8516',
  waterTempTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8517',
  sensor1LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8518',
  sensor2LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8519',
  sensor3LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8520',
  sensor4LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8521',
  sensor5LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8522',
  sensor6LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8523',
  sensor7LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8524',
  sensor8LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8525',
  sensor9LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8526',
  sensor10LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8527',
  sensor11LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8528',
  sensor12LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8529',
  sensor13LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8530',
  sensor14LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8531',
  sensor15LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8532',
  sensor16LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8533',
  sensor17LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8534',
  sensor18LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8535',
  sensor19LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8536',
  sensor20LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8537',
  sensor21LimitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8538',
  sensor1DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8539',
  sensor2DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8540',
  sensor3DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8541',
  sensor4DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8542',
  sensor5DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8543',
  sensor6DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8544',
  sensor7DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8545',
  sensor8DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8546',
  sensor9DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8547',
  sensor10DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8548',
  sensor11DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8549',
  sensor12DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8550',
  sensor13DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8551',
  sensor14DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8552',
  sensor15DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8553',
  sensor16DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8554',
  sensor17DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8555',
  sensor18DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8556',
  sensor19DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8557',
  sensor20DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8558',
  sensor21DefectAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8559',
  compr1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8560',
  compr2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8561',
  lowPressAlarm1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8562',
  lowPressAlarm2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8563',
  elecHeating1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8564',
  elecHeating2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8565',
  elecHeating3Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8566',
  elecHeating4Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8567',
  drycooler1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8568',
  drycooler2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8569',
  drycooler3Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8570',
  drycooler4Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8571',
  pump1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8572',
  pump2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8573',
  pump3Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8574',
  pump4Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8575',
  humidifier1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8576',
  humidifier2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8577',
  humidifier3Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8578',
  humidifier1Alarm5uS => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8579',
  humidifier2Alarm5uS => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8580',
  humidifier3Alarm5uS => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8581',
  humidifier1Alarm20uS => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8582',
  humidifier2Alarm20uS => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8583',
  humidifier3Alarm20uS => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8584',
  fan1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8585',
  fan2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8586',
  fan3Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8587',
  fan1FilterAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8588',
  fan2FilterAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8589',
  fan3FilterAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8590',
  extAlarm1Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8591',
  extAlarm2Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8592',
  extAlarm3Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8593',
  extAlarm4Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8594',
  extAlarm5Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8595',
  extAlarm6Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8596',
  extAlarm7Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8597',
  extAlarm8Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8598',
  extAlarm9Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8599',
  extAlarm10Active => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8600',
  hotgasHeatingAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8601',
  eev1PressureSensorError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8602',
  eev1TemperatureSensorError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8603',
  eev1StepperMotorError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8604',
  eev2PressureSensorError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8605',
  eev2TemperatureSensorError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8606',
  eev2StepperMotorError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8607',
  waterflowFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8608',
  valveTestAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8609',
  compr3Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8610',
  compr4Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8611',
  compr5Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8612',
  compr6Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8613',
  condenser1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8614',
  condenser2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8615',
  outsideAirTempTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8616',
  outsideAirTempTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8617',
  ioExtensionError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8618',
  waterOutTemperatooHighFlowWater => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8619',
  waterOutTemperateTooLowFlowWater => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8620',
  freezeAlarmEqualsDP2226 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8621',
  unit1Failure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8622',
  unit2Failure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8623',
  transmissionFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8624',
  controllerFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8625',
  reheatFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8626',
  roomHighPressureAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8627',
  filter1Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8628',
  filter2Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8629',
  filter3Alarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8630',
  rC1CircuitBreakerTripped => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8631',
  rC2CircuitBreakerTripped => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8632',
  fan1Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8633',
  fan2Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8634',
  powerFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8635',
  compressor1MotorProtection => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8636',
  compressor2MotorProtection => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8637',
  intrusionAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8638',
  condensorFan1Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8639',
  condensorFan2Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8640',
  internalTemperatureProbe => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8641',
  externalTemperatureProbe => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8642',
  condensorTemperatureProbe => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8643',
  supplyTemperatureProbe1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8644',
  supplyTemperatureProbe2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8645',
  moveableCoilAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8646',
  fan1ThermalMotorectionTriggered => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8647',
  externalFilterAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8648',
  waterTempInlet1TooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8649',
  waterTempInlet1TooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8650',
  waterTempOutlet1TooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8651',
  waterTempOutlet1TooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8652',
  waterTempInlet2TooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8653',
  waterTempInlet2TooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8654',
  waterTempOutlet2TooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8655',
  waterTempOutlet2TooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8656',
  eev1ReliabilityAlarmCarelEVD => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8657',
  eev2ReliabilityAlarmCarelEVD => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8658',
  fan3Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8659',
  fan4Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8660',
  fan5Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8661',
  fan6Blocked => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8662',
  fan2ThermalMotorectionTriggered => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8663',
  fan3ThermalMotorectionTriggered => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8664',
  waterflowMaximumExceeded => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8665',
  supplyTemperatureProbe3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8666',
  returnTemperatureProbe1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8667',
  returnTemperatureProbe2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8668',
  returnTemperatureProbe3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8669',
  inverterGeneralAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8670',
  extensionBoardAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8671',
  inverterOffline => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8672',
  humidifier1ThermicFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8673',
  condensateWaterLevelAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8674',
  outdoorUnitAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8675',
  outdoorUnitCommunicationError => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8676',
  minimumTemperatureAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8677',
  maximumTemperatureAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8678',
  stateThatShutOfflopAlarmsUPCDP15 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8679',
  probeBrokenAnalogInputB3UPCDP18 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8680',
  probeBrokenAnalogInputB4UPCDP19 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8681',
  probeBrokenAnalogInputB5UPCDP20 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8682',
  probeBrokenAnalogInputB6UPCDP21 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8683',
  maximumDischargePressureUPCDP23 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8684',
  minimumSuctionPressureUPCDP24 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8685',
  dischargeTemperatureAlarmUPCDP25 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8686',
  pressureDifferennMinimumUPCDP26 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8687',
  compressorFailsToStartUPCDP27 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8688',
  compressorExceedlopLimitsUPCDP28 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8689',
  lowSuperHeatAlarmEeValveUPCDP29 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8690',
  mopAlarmEeValveUPCDP30 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8691',
  lowSuctionTemperrmEeValveUPCDP31 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8692',
  evdEvoEvotunesAlarmUPCDP32 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8693',
  evdEvoRegulationctionTempUPCDP33 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8694',
  evdEvoSystemAlarobeErrorUPCDP34 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8695',
  generalInverterAlarmUPCDP35 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8696',
  communicationLosInverterUPCDP36 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8697',
  communicationLosithIccController => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8698',
  inverterModelNotmpressorUPCDP44 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.8699',
  fCBCommonAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10224',
  alarmComfortUnit1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10225',
  alarmComfortUnit2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10226',
  reheat1Failure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10234',
  humidificationFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10235',
  aiflowFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10236',
  filterClogged => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10237',
  auxAlarm1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10238',
  fireSmokeDetectorTriggered => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10239',
  auxAlarm2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10246',
  auxAlarm3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10247',
  roomAirTemperatureTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10248',
  roomAirHumidityTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10249',
  badWorkingComfortUnit1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10250',
  badWorkingComfortUnit2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10251',
  roomAirTempTooLow => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10252',
  roomAirHumidityTooLow => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10253',
  fireSmokeDetectorAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10260',
  fCBSensorFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10261',
  fCBControllerFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10262',
  fCBIOBoardTransmissionFailure => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.10263',
  maxDeltaPExceeded => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14201',
  condensorFanTherectionTriggered => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14202',
  compressorCabinetTempTooHigh => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14203',
  electricCabinetTempTooHigh => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14204',
  protectionDeviceCompressor1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14205',
  protectionDeviceCompressor2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14206',
  protectionDeviceCompressor3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14207',
  protectionDeviceCompressor4 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14208',
  protectionDeviceCompressor5 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14209',
  protectionDeviceCompressor6 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14210',
  alarmStateThatShtIncludedUPCDP37 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14211',
  bmsOfflineHeartBitFailsUPCDP40 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14212',
  globalGeneralAlarmUPCDP45 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14213',
  deltaPLargerAlloeStartUpUPCDP47 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14214',
  dpStartDisableAlarmUPCDP49 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14215',
  minOilLevelComp1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14216',
  minOilLevelComp2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14217',
  minOilLevelComp3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14218',
  minOilLevelComp4 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14219',
  minOilLevelComp5 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14220',
  minOilLevelComp6 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14221',
  powerSwitchComp1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14222',
  powerSwitchComp2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14223',
  powerSwitchComp3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14224',
  powerSwitchComp4 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14225',
  powerSwitchComp5 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14226',
  powerSwitchComp6 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14227',
  envelopeLeftComp1 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14228',
  envelopeLeftComp2 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14229',
  envelopeLeftComp3 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14230',
  envelopeLeftComp4 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14231',
  envelopeLeftComp5 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14232',
  envelopeLeftComp6 => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14233',
  freecoolFailedInrmediateTempHigh => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14234',
  supplyAirPressureTooHighAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14235',
  supplyAirPressureTooLowAlarm => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14236',
  waterflowFailurecuitCoolingWater => '1.3.6.1.4.1.29462.10.2.1.4.4.1.1.1.14237',
  unitviewTable => '1.3.6.1.4.1.29462.10.2.1.4.4.2',
  unitviewEntry => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1',
  remoteUPS => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1006',
  localUPS => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1007',
  resetManualOperation => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1009',
  maintenanceNecessary => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1014',
  unitWinterMode => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1023',
  dayNightMode => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1024',
  unitCooling => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1754',
  unitHeating => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1755',
  unitHumidification => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1756',
  unitDehumidification => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1757',
  coolingEnable => '1.3.6.1.4.1.29462.10.2.1.4.4.2.1.1781',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'STULZ-WIB8000'} = {
};
