/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class XdmFunctionItem
extends XdmItem {
    protected XdmFunctionItem(FunctionItem fi) {
        super(fi);
    }

    public QName getName() {
        FunctionItem fi = (FunctionItem)this.getUnderlyingValue();
        StructuredQName sq = fi.getFunctionName();
        return sq == null ? null : new QName(sq);
    }

    public int getArity() {
        FunctionItem fi = (FunctionItem)this.getUnderlyingValue();
        return fi.getArity();
    }

    public boolean isAtomicValue() {
        return false;
    }

    public XdmValue call(XdmValue[] arguments, Processor processor) throws SaxonApiException {
        if (arguments.length != this.getArity()) {
            throw new SaxonApiException("Supplied " + arguments.length + " arguments, required " + this.getArity());
        }
        try {
            FunctionItem fi = (FunctionItem)this.getUnderlyingValue();
            SequenceIterator[] argIters = new SequenceIterator[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                argIters[i] = Value.asIterator(arguments[i].getUnderlyingValue());
            }
            XPathContext context = processor.getUnderlyingConfiguration().getConversionContext();
            SequenceIterator<Item> resultIter = fi.invoke(argIters, context);
            ValueRepresentation<Item> se = SequenceExtent.makeSequenceExtent(resultIter);
            return XdmValue.wrap(se);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }
}

