
######################################################################
## $Id: DataAnalysis.pm 3668 2006-03-11 20:51:13Z spadkins $
######################################################################

package App::Widget::DataAnalysis;
$VERSION = (q$Revision: 3668 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget;
@ISA = ( "App::Widget" );

use strict;

=head1 NAME

App::Widget::DataAnalysis - A set of data grids and graphs

=head1 SYNOPSIS

   $name = "label";

   # official way
   use App;
   $context = App->context();
   $w = $context->widget($name);

   # internal way
   use App::Widget::DataAnalysis;
   $w = App::Widget::DataAnalysis->new($name);

=cut

######################################################################
# CONSTANTS
######################################################################

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

A set of data grids and graphs.

=cut

######################################################################
# INITIALIZATION
######################################################################

sub _init {
    &App::sub_entry if ($App::trace);
    my $self = shift;
    $self->SUPER::_init(@_);
    my $context = $self->{context};
    my $widget = $self->{widget} || {};
    my $widget_names = $self->{widgets};
    $widget_names = [ sort keys %$widget ] if (!$widget_names);
    my ($args, $columns_widget, @columns, $columns);
    foreach my $wname (@$widget_names) {
        $args = $widget->{$wname} || {};
        $context->widget($wname, %$args);
        $columns = $args->{columns};
        if ($columns && !ref($columns)) {
            @columns = ();
            foreach $columns_widget (split(/,/, $columns)) {  # it's really a list of widget names
                $columns = $context->so_get($columns_widget);  # get list of columns (comma-sep-list)
                $columns = [ split(/,/, $columns) ] if (!ref($columns));  # split into array
                push(@columns, @$columns);
            }
            $context->so_set($wname, "columns", \@columns);
            $context->so_set($wname, "numcols", $#columns + 1);
        }
    }
    &App::sub_exit() if ($App::trace);
}

######################################################################
# EVENTS
######################################################################

# no events

######################################################################
# OUTPUT METHODS
######################################################################

sub html {
    &App::sub_entry if ($App::trace);
    my $self = shift;
    my $context = $self->{context};
    my $widget = $self->{widget} || {};
    my $widget_names = $self->{widgets};
    $widget_names = [ sort keys %$widget ] if (!$widget_names);
    my ($args, $columns, $w);
    my $html = $self->heading_html();
    $html .= "<table border=0 cellspacing=2 cellpadding=2>\n";
    foreach my $wname (@$widget_names) {
        $html .= "<tr><td>\n";
        $args = $widget->{$wname} || {};
        $w = $context->widget($wname);
        #$columns = $args->{columns};
        #if ($columns && !ref($columns)) {
        #    $columns = $context->so_get($columns);
        #    $columns = [ split(/,/, $columns) ] if (!ref($columns));
        #    $context->so_set($wname, "columns", $columns);
        #}
        $html .= $w->html();
        $html .= "</td></tr>\n";
    }
    $html .= "</table>\n";
    &App::sub_exit($html) if ($App::trace);
    $html;
}

sub html_heading {
    return("");
}

1;

