# -*- cperl -*-
# ABSTRACT: LaTeX expression object


package SpeL::Object::Expression;

use SpeL::Object::MathUnit;
use SpeL::Object::Variable;
use SpeL::Object::Function;
use SpeL::Object::Fraction;
use SpeL::Object::Expressionrest;
use SpeL::Object::Limitsexpression;
use SpeL::Object::Number;
use SpeL::Object::Unop;
use SpeL::Object::MathEnvironmentInner;
use SpeL::Object::Matrix;
use SpeL::Object::Interval;
use SpeL::Object::Command;

use parent 'Exporter';
use Carp;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  if ( exists $self->{Begintext} ) {
    return 
      $self->{Begintext}->read( $level + 1 )
      . ' ' .
      ( exists $self->{Rest} ? $self->{Rest}->read( $level + 1 ) : '' );
  }
  
  if ( exists $self->{Absval} ) {
    return $SpeL::I18n::lh
      ->maketext( 'Absval',
		  $self->{Absval}->read( $level + 1 ) );
  }

  if ( exists $self->{Interval} ) {
    return $self->{Interval}->read( $level + 1 );
  }
  
  if ( exists $self->{Ellipsis} ) {
    return $SpeL::I18n::lh->maketext( 'dotdotdot' ) . ' ' .
      $self->{Rest}->read( $level + 1 );
  }

  my $sign = '';
  if ( exists $self->{Sign} ) {
    $self->{Sign} =~ s/^\\pm$/plusminus/;
    $sign = $SpeL::I18n::lh->maketext( $self->{Sign} ) . ' ';
  }

  return
    $sign . ' ' .
    $self->{Component}->read( $level + 1 ) . ' ' .
    $self->{Rest}->read( $level + 1 )
    ;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Expression - LaTeX expression object

=head1 VERSION

version 20240619.1055

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX expression

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
