/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.TriangleBasedShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

abstract class GouraudShadingContext
extends TriangleBasedShadingContext {
    private static final Log LOG = LogFactory.getLog(GouraudShadingContext.class);
    private List<ShadedTriangle> triangleList = new ArrayList<ShadedTriangle>();

    protected GouraudShadingContext(PDShading shading, ColorModel colorModel, AffineTransform xform, Matrix matrix) throws IOException {
        super(shading, colorModel, xform, matrix);
    }

    protected Vertex readVertex(ImageInputStream input, long maxSrcCoord, long maxSrcColor, PDRange rangeX, PDRange rangeY, PDRange[] colRangeTab, Matrix matrix, AffineTransform xform) throws IOException {
        float[] colorComponentTab = new float[this.numberOfColorComponents];
        long x = input.readBits(this.bitsPerCoordinate);
        long y = input.readBits(this.bitsPerCoordinate);
        float dstX = this.interpolate(x, maxSrcCoord, rangeX.getMin(), rangeX.getMax());
        float dstY = this.interpolate(y, maxSrcCoord, rangeY.getMin(), rangeY.getMax());
        LOG.debug("coord: " + String.format("[%06X,%06X] -> [%f,%f]", x, y, Float.valueOf(dstX), Float.valueOf(dstY)));
        Point2D.Float p = matrix.transformPoint(dstX, dstY);
        xform.transform(p, p);
        for (int n = 0; n < this.numberOfColorComponents; ++n) {
            int color = (int)input.readBits(this.bitsPerColorComponent);
            colorComponentTab[n] = this.interpolate(color, maxSrcColor, colRangeTab[n].getMin(), colRangeTab[n].getMax());
            LOG.debug("color[" + n + "]: " + color + "/" + String.format("%02x", color) + "-> color[" + n + "]: " + colorComponentTab[n]);
        }
        int bitOffset = input.getBitOffset();
        if (bitOffset != 0) {
            input.readBits(8 - bitOffset);
        }
        return new Vertex(p, colorComponentTab);
    }

    final void setTriangleList(List<ShadedTriangle> triangleList) {
        this.triangleList = triangleList;
    }

    @Override
    protected Map<Point, Integer> calcPixelTable(Rectangle deviceBounds) throws IOException {
        HashMap<Point, Integer> map = new HashMap<Point, Integer>();
        super.calcPixelTable(this.triangleList, map, deviceBounds);
        return map;
    }

    @Override
    public void dispose() {
        this.triangleList = null;
        super.dispose();
    }

    private float interpolate(float src, long srcMax, float dstMin, float dstMax) {
        return dstMin + src * (dstMax - dstMin) / (float)srcMax;
    }

    @Override
    protected boolean isDataEmpty() {
        return this.triangleList.isEmpty();
    }
}

