#!perl

use strict;
use warnings;
use Test::More;
use Archive::Raw;

ok (Archive::Raw->EXTRACT_OWNER);
ok (Archive::Raw->EXTRACT_PERM);
ok (Archive::Raw->EXTRACT_TIME);
ok (Archive::Raw->EXTRACT_NO_OVERWRITE);
ok (Archive::Raw->EXTRACT_UNLINK);
ok (Archive::Raw->EXTRACT_ACL);
ok (Archive::Raw->EXTRACT_FFLAGS);
ok (Archive::Raw->EXTRACT_XATTR);
ok (Archive::Raw->EXTRACT_SECURE_SYMLINKS);
ok (Archive::Raw->EXTRACT_SECURE_NODOTDOT);
ok (Archive::Raw->EXTRACT_NO_AUTODIR);
ok (Archive::Raw->EXTRACT_NO_OVERWRITE_NEWER);
ok (Archive::Raw->EXTRACT_SPARSE);
ok (Archive::Raw->EXTRACT_MAC_METADATA);
ok (Archive::Raw->EXTRACT_NO_HFS_COMPRESSION);
ok (Archive::Raw->EXTRACT_HFS_COMPRESSION_FORCED);
ok (Archive::Raw->EXTRACT_SECURE_NOABSOLUTEPATHS);
ok (Archive::Raw->EXTRACT_CLEAR_NOCHANGE_FFLAGS);

ok (Archive::Raw->FORMAT_CPIO);
ok (Archive::Raw->FORMAT_CPIO_POSIX);
ok (Archive::Raw->FORMAT_CPIO_BIN_LE);
ok (Archive::Raw->FORMAT_CPIO_BIN_BE);
ok (Archive::Raw->FORMAT_CPIO_SVR4_NOCRC);
ok (Archive::Raw->FORMAT_CPIO_SVR4_CRC);
ok (Archive::Raw->FORMAT_CPIO_AFIO_LARGE);
ok (Archive::Raw->FORMAT_SHAR);
ok (Archive::Raw->FORMAT_SHAR_BASE);
ok (Archive::Raw->FORMAT_SHAR_DUMP);
ok (Archive::Raw->FORMAT_TAR);
ok (Archive::Raw->FORMAT_TAR_USTAR);
ok (Archive::Raw->FORMAT_TAR_PAX_INTERCHANGE);
ok (Archive::Raw->FORMAT_TAR_PAX_RESTRICTED);
ok (Archive::Raw->FORMAT_TAR_GNUTAR);
ok (Archive::Raw->FORMAT_ISO9660);
ok (Archive::Raw->FORMAT_ISO9660_ROCKRIDGE);
ok (Archive::Raw->FORMAT_ZIP);
ok (Archive::Raw->FORMAT_EMPTY);
ok (Archive::Raw->FORMAT_AR);
ok (Archive::Raw->FORMAT_AR_GNU);
ok (Archive::Raw->FORMAT_AR_BSD);
ok (Archive::Raw->FORMAT_MTREE);
ok (Archive::Raw->FORMAT_RAW);
ok (Archive::Raw->FORMAT_XAR);
ok (Archive::Raw->FORMAT_LHA);
ok (Archive::Raw->FORMAT_CAB);
ok (Archive::Raw->FORMAT_RAR);
ok (Archive::Raw->FORMAT_7ZIP);
ok (Archive::Raw->FORMAT_WARC);
ok (Archive::Raw->FORMAT_RAR_V5);

ok (Archive::Raw->READ_FORMAT_ENCRYPTION_UNSUPPORTED);
ok (Archive::Raw->READ_FORMAT_ENCRYPTION_DONT_KNOW);

#ok (Archive::Raw->READ_FORMAT_CAPS_NONE);
ok (Archive::Raw->READ_FORMAT_CAPS_ENCRYPT_DATA);
ok (Archive::Raw->READ_FORMAT_CAPS_ENCRYPT_METADATA);

ok (Archive::Raw->AE_IFMT);
ok (Archive::Raw->AE_IFREG);
ok (Archive::Raw->AE_IFLNK);
ok (Archive::Raw->AE_IFSOCK);
ok (Archive::Raw->AE_IFCHR);
ok (Archive::Raw->AE_IFBLK);
ok (Archive::Raw->AE_IFDIR);
ok (Archive::Raw->AE_IFIFO);
#ok (Archive::Raw->AE_SYMLINK_TYPE_UNDEFINED);
ok (Archive::Raw->AE_SYMLINK_TYPE_FILE);
ok (Archive::Raw->AE_SYMLINK_TYPE_DIRECTORY);

ok (Archive::Raw->ENTRY_ACL_EXECUTE);
ok (Archive::Raw->ENTRY_ACL_WRITE);
ok (Archive::Raw->ENTRY_ACL_READ);
ok (Archive::Raw->ENTRY_ACL_READ_DATA);
ok (Archive::Raw->ENTRY_ACL_LIST_DIRECTORY);
ok (Archive::Raw->ENTRY_ACL_WRITE_DATA);
ok (Archive::Raw->ENTRY_ACL_ADD_FILE);
ok (Archive::Raw->ENTRY_ACL_APPEND_DATA);
ok (Archive::Raw->ENTRY_ACL_ADD_SUBDIRECTORY);
ok (Archive::Raw->ENTRY_ACL_READ_NAMED_ATTRS);
ok (Archive::Raw->ENTRY_ACL_WRITE_NAMED_ATTRS);
ok (Archive::Raw->ENTRY_ACL_DELETE_CHILD);
ok (Archive::Raw->ENTRY_ACL_READ_ATTRIBUTES);
ok (Archive::Raw->ENTRY_ACL_WRITE_ATTRIBUTES);
ok (Archive::Raw->ENTRY_ACL_DELETE);
ok (Archive::Raw->ENTRY_ACL_READ_ACL);
ok (Archive::Raw->ENTRY_ACL_WRITE_ACL);
ok (Archive::Raw->ENTRY_ACL_WRITE_OWNER);
ok (Archive::Raw->ENTRY_ACL_SYNCHRONIZE);
ok (Archive::Raw->ENTRY_ACL_PERMS_POSIX1E);
ok (Archive::Raw->ENTRY_ACL_PERMS_NFS4);
ok (Archive::Raw->ENTRY_ACL_ENTRY_INHERITED);
ok (Archive::Raw->ENTRY_ACL_ENTRY_FILE_INHERIT);
ok (Archive::Raw->ENTRY_ACL_ENTRY_DIRECTORY_INHERIT);
ok (Archive::Raw->ENTRY_ACL_ENTRY_NO_PROPAGATE_INHERIT);
ok (Archive::Raw->ENTRY_ACL_ENTRY_INHERIT_ONLY);
ok (Archive::Raw->ENTRY_ACL_ENTRY_SUCCESSFUL_ACCESS);
ok (Archive::Raw->ENTRY_ACL_ENTRY_FAILED_ACCESS);
ok (Archive::Raw->ENTRY_ACL_INHERITANCE_NFS4);
ok (Archive::Raw->ENTRY_ACL_TYPE_ACCESS);
ok (Archive::Raw->ENTRY_ACL_TYPE_DEFAULT);
ok (Archive::Raw->ENTRY_ACL_TYPE_ALLOW);
ok (Archive::Raw->ENTRY_ACL_TYPE_DENY);
ok (Archive::Raw->ENTRY_ACL_TYPE_AUDIT);
ok (Archive::Raw->ENTRY_ACL_TYPE_ALARM);
ok (Archive::Raw->ENTRY_ACL_TYPE_POSIX1E);
ok (Archive::Raw->ENTRY_ACL_TYPE_NFS4);
ok (Archive::Raw->ENTRY_ACL_USER);
ok (Archive::Raw->ENTRY_ACL_USER_OBJ);
ok (Archive::Raw->ENTRY_ACL_GROUP);
ok (Archive::Raw->ENTRY_ACL_GROUP_OBJ);
ok (Archive::Raw->ENTRY_ACL_MASK);
ok (Archive::Raw->ENTRY_ACL_OTHER);
ok (Archive::Raw->ENTRY_ACL_EVERYONE);
ok (Archive::Raw->ENTRY_ACL_STYLE_EXTRA_ID);
ok (Archive::Raw->ENTRY_ACL_STYLE_MARK_DEFAULT);
ok (Archive::Raw->ENTRY_ACL_STYLE_SOLARIS);
ok (Archive::Raw->ENTRY_ACL_STYLE_SEPARATOR_COMMA);
ok (Archive::Raw->ENTRY_ACL_STYLE_COMPACT);

done_testing;
