# Generated by default/object.tt
package Paws::ECRPublic::Registry;
  use Moose;
  has Aliases => (is => 'ro', isa => 'ArrayRef[Paws::ECRPublic::RegistryAlias]', request_name => 'aliases', traits => ['NameInRequest'], required => 1);
  has RegistryArn => (is => 'ro', isa => 'Str', request_name => 'registryArn', traits => ['NameInRequest'], required => 1);
  has RegistryId => (is => 'ro', isa => 'Str', request_name => 'registryId', traits => ['NameInRequest'], required => 1);
  has RegistryUri => (is => 'ro', isa => 'Str', request_name => 'registryUri', traits => ['NameInRequest'], required => 1);
  has Verified => (is => 'ro', isa => 'Bool', request_name => 'verified', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECRPublic::Registry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECRPublic::Registry object:

  $service_obj->Method(Att1 => { Aliases => $value, ..., Verified => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECRPublic::Registry object:

  $result = $service_obj->Method(...);
  $result->Att1->Aliases

=head1 DESCRIPTION

The details of a public registry.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Aliases => ArrayRef[L<Paws::ECRPublic::RegistryAlias>]

An array of objects representing the aliases for a public registry.


=head2 B<REQUIRED> RegistryArn => Str

The Amazon Resource Name (ARN) of the public registry.


=head2 B<REQUIRED> RegistryId => Str

The AWS account ID associated with the registry. If you do not specify
a registry, the default public registry is assumed.


=head2 B<REQUIRED> RegistryUri => Str

The URI of a public registry. The URI contains a universal prefix and
the registry alias.


=head2 B<REQUIRED> Verified => Bool

Whether the account is verified. This indicates whether the account is
an AWS Marketplace vendor. If an account is verified, each public
repository will received a verified account badge on the Amazon ECR
Public Gallery.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECRPublic>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

