/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.User;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

public class SessionManager {
    int sessionIdCount = 1;
    private IntKeyHashMap sessionMap = new IntKeyHashMap();
    private Session sysSession;

    public SessionManager(Database database, User user) {
        this.sysSession = new Session(database, user, false, false, 0);
    }

    public Session newSession(Database database, User user, boolean bl, boolean bl2) {
        Session session = new Session(database, user, true, bl, this.sessionIdCount);
        session.isProcessingLog = bl2;
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    public Session getSysSession(String string, boolean bl) throws HsqlException {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getSchemaHsqlName(string);
        this.sysSession.isProcessingScript = bl;
        this.sysSession.isProcessingLog = false;
        return this.sysSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.defaultSchemaHsqlName;
        return this.sysSession;
    }

    public void closeAllSessions() {
        Iterator iterator = this.sessionMap.values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            iterator.remove();
            session.close();
        }
    }

    void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    void clearAll() {
        this.sessionMap.clear();
    }

    boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    Session getSession(int n) {
        return (Session)this.sessionMap.get(n);
    }

    public Session[] getAllSessions() {
        Session[] sessionArray = new Session[this.sessionMap.size()];
        Iterator iterator = this.sessionMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sessionArray[n] = (Session)iterator.next();
            ++n;
        }
        return sessionArray;
    }
}

