/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web.extension;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.web.Container;
import net.arnx.jsonic.web.ExternalContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringContainer
extends Container {
    Log log;
    ApplicationContext appContext;

    public void init(HttpServlet httpServlet) throws ServletException {
        super.init(httpServlet);
        this.log = LogFactory.getLog(httpServlet.getClass());
        this.appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.context);
    }

    public Object getComponent(String string) throws Exception {
        Object object;
        try {
            object = this.appContext.getBean(string);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("class not found: " + string, exception);
        }
        if (object instanceof ApplicationContextAware) {
            ((ApplicationContextAware)object).setApplicationContext(this.appContext);
        }
        for (Method method : object.getClass().getMethods()) {
            Class<?>[] classArray = method.getParameterTypes();
            if (!Void.TYPE.equals(method.getReturnType()) || !method.getName().startsWith("set") || classArray.length != 1) continue;
            Class<?> clazz = classArray[0];
            if (HttpServletRequest.class.equals(clazz)) {
                method.invoke(object, ExternalContext.getRequest());
                continue;
            }
            if (!HttpServletResponse.class.equals(clazz)) continue;
            method.invoke(object, ExternalContext.getResponse());
        }
        return object;
    }

    public boolean isDebugMode() {
        return this.debug != null ? this.debug.booleanValue() : this.log.isDebugEnabled();
    }

    public void debug(String string, Throwable throwable) {
        if (throwable != null) {
            this.log.debug(string, throwable);
        } else {
            this.log.debug(string);
        }
    }

    public void warn(String string, Throwable throwable) {
        if (throwable != null) {
            this.log.warn(string, throwable);
        } else {
            this.log.warn(string);
        }
    }

    public void error(String string, Throwable throwable) {
        if (throwable != null) {
            this.log.error(string, throwable);
        } else {
            this.log.error(string);
        }
    }
}

