/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.Collections;
import java.util.List;
import org.apache.james.mime4j.message.AbstractMultipart;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartImpl
extends AbstractMultipart {
    private ByteSequence preamble = null;
    private transient String preambleStrCache = null;
    private transient boolean preambleComputed = true;
    private ByteSequence epilogue = null;
    private transient String epilogueStrCache = null;
    private transient boolean epilogueComputed = true;

    public MultipartImpl(String subType) {
        this(subType, Collections.emptyList());
    }

    public MultipartImpl(String subType, List<NameValuePair> parameters) {
        super(subType, parameters);
    }

    public ByteSequence getPreambleRaw() {
        return this.preamble;
    }

    public void setPreambleRaw(ByteSequence preamble) {
        this.preamble = preamble;
        this.preambleStrCache = null;
        this.preambleComputed = false;
    }

    @Override
    public String getPreamble() {
        if (!this.preambleComputed) {
            this.preambleStrCache = this.preamble != null ? ContentUtil.decode(this.preamble) : null;
            this.preambleComputed = true;
        }
        return this.preambleStrCache;
    }

    @Override
    public void setPreamble(String preamble) {
        this.preamble = preamble != null ? ContentUtil.encode(preamble) : null;
        this.preambleStrCache = preamble;
        this.preambleComputed = true;
    }

    public ByteSequence getEpilogueRaw() {
        return this.epilogue;
    }

    public void setEpilogueRaw(ByteSequence epilogue) {
        this.epilogue = epilogue;
        this.epilogueStrCache = null;
        this.epilogueComputed = false;
    }

    @Override
    public String getEpilogue() {
        if (!this.epilogueComputed) {
            this.epilogueStrCache = this.epilogue != null ? ContentUtil.decode(this.epilogue) : null;
            this.epilogueComputed = true;
        }
        return this.epilogueStrCache;
    }

    @Override
    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue != null ? ContentUtil.encode(epilogue) : null;
        this.epilogueStrCache = epilogue;
        this.epilogueComputed = true;
    }
}

