-- Sample SQL table and data for HTML::SearchPage
-- Author: Payan Canaran <pcanaran@cpan.org>
-- Copyright (c) 2005-2007 Cold Spring Harbor Laboratory
-- Version 0.05

DROP TABLE IF EXISTS `html_searchpage_experiment`;

CREATE TABLE `html_searchpage_experiment` (
    `experiment_id`               int(11) NOT NULL auto_increment,
    `person_id`                   int(11),
    `temperature`                 int(3),
    `sample_size`                 int(3),
    `attribute`                   varchar(30),
    `result`                      varchar(30),
    `comments`                    varchar(100),
    PRIMARY KEY                 (`experiment_id`),
    KEY                         (`temperature`),
    KEY                         (`sample_size`),
    KEY                         (`attribute`),
    KEY                         (`result`)
    ) ENGINE=MyISAM;

DROP TABLE IF EXISTS `html_searchpage_person`;

CREATE TABLE `html_searchpage_person` (
    `person_id`                   int(11) NOT NULL auto_increment,
    `name`                        varchar(100),
    `organization`                varchar(100),
    `email`                       varchar(100),
    `address`                     varchar(200),
    `comments`                    varchar(100),
    PRIMARY KEY                 (`person_id`)
    ) ENGINE=MyISAM;

INSERT INTO html_searchpage_person (name, organization, email, address, comments) VALUES ("Researcher #1", "Research Lab A", "researcher at research_lab_a", "123 Main St, City, State", "comments here for first person");
INSERT INTO html_searchpage_person (name, organization, email, address, comments) VALUES ("Reseracher #2", "Research Lab B", "researcher at research_lab_b", "456 Main St, City, State", "comments here for second person");
INSERT INTO html_searchpage_person (name, organization, email, address, comments) VALUES ("Researcher #3", "Research Lab C", "researcher at research_lab_c", "789 Main St, City, State", "comments here for third person");
INSERT INTO html_searchpage_person (name, organization, email, address, comments) VALUES ("Researcher #4", "Research Lab D", "researcher at research_lab_d", "234 Main St, City, State", "comments here for fourth person");
INSERT INTO html_searchpage_person (name, organization, email, address, comments) VALUES ("Researcher #5", "Research Lab E", "researcher at research_lab_e", "567 Main St, City, State", "comments here for fifth person");

INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "143", "346", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "154", "220", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "70", "672", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "95", "997", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "74", "598", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "62", "672", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "109", "1061", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "27", "969", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "147", "756", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "154", "955", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "101", "338", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "127", "288", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "144", "1016", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "89", "295", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "97", "887", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "113", "232", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "105", "498", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "95", "653", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "71", "635", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "118", "572", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "135", "988", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "146", "1037", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "71", "646", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "58", "629", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "28", "505", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "86", "700", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "116", "1007", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "93", "927", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "58", "786", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "82", "213", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "25", "568", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "96", "986", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "69", "302", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "88", "387", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "38", "413", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "43", "650", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "99", "804", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "38", "313", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "137", "1040", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "67", "569", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "154", "1068", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "114", "863", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "89", "752", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "147", "728", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "129", "617", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "143", "965", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "111", "935", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "53", "734", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "88", "734", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "24", "1065", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "86", "867", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "130", "210", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "158", "417", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "140", "527", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "74", "591", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "158", "1075", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "97", "715", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "90", "521", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "102", "1022", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "71", "446", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "145", "668", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "137", "288", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "113", "200", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "60", "862", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "71", "891", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "35", "761", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "98", "1041", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "99", "638", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "117", "585", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "77", "852", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "65", "766", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "135", "595", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "46", "210", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "52", "889", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "133", "754", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "82", "786", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "65", "744", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "30", "337", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "71", "627", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "124", "525", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "124", "660", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "31", "1083", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "142", "805", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "74", "442", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "91", "952", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "87", "614", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "64", "561", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "129", "400", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "56", "933", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "144", "1049", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "124", "288", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "142", "803", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "52", "950", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "82", "1064", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "49", "1014", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "119", "442", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "138", "487", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "72", "425", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "103", "539", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "140", "804", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "84", "929", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "75", "938", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "107", "430", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "31", "1082", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "43", "774", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "88", "318", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "66", "297", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "94", "601", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "74", "883", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "78", "1024", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "86", "263", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "35", "982", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "125", "487", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "102", "827", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "141", "997", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "129", "831", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "78", "708", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "42", "990", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "99", "893", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "60", "334", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "74", "846", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "76", "480", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "46", "679", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "136", "719", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "114", "550", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "28", "632", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "156", "804", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "56", "421", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "78", "240", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "95", "984", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "88", "210", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "125", "952", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "135", "1051", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "137", "950", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "137", "764", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "123", "563", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "146", "962", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "76", "263", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "27", "760", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "145", "433", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "75", "726", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "41", "245", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "55", "624", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "118", "1002", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "154", "640", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "118", "1057", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "94", "478", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "74", "511", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "159", "512", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "129", "482", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "25", "852", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "31", "684", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "118", "532", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "152", "473", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "147", "358", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "50", "823", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "157", "523", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "143", "702", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "144", "428", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "120", "752", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "115", "1032", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "112", "836", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "64", "693", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "117", "805", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "99", "441", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "33", "337", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "24", "993", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "55", "452", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "115", "827", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "38", "470", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "59", "356", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "37", "466", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "87", "713", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "95", "484", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "62", "319", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "47", "313", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "58", "1085", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "155", "706", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "72", "553", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "30", "517", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "88", "216", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "159", "348", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "99", "747", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "88", "671", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "94", "962", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "133", "812", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "38", "541", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "108", "403", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "89", "654", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "136", "734", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "97", "810", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "41", "922", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "127", "671", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "147", "466", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "125", "909", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "75", "1096", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "38", "251", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "82", "570", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "121", "626", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "140", "643", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "41", "643", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "82", "835", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "20", "552", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "47", "819", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "138", "980", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "58", "590", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "125", "548", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "103", "309", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "119", "873", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "131", "941", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "57", "701", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "129", "933", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "22", "643", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "109", "598", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "104", "689", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "123", "495", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "152", "235", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "40", "598", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "123", "786", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "141", "698", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "114", "781", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "30", "391", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "82", "1073", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "32", "446", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "29", "298", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "35", "764", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "40", "830", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "85", "382", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "108", "388", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "123", "233", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "130", "566", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "140", "743", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "114", "396", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "67", "463", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "83", "1023", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "53", "898", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "71", "551", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "43", "586", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "101", "1092", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "99", "610", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "63", "619", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "41", "438", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "103", "1011", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "63", "974", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "131", "342", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "90", "1039", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "45", "454", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "62", "435", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "52", "829", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "124", "554", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "27", "803", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "141", "297", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "132", "539", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "130", "416", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "86", "488", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "151", "497", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "61", "224", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "102", "670", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "129", "874", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "79", "1083", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "49", "446", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "45", "229", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "88", "839", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "28", "629", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "146", "402", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "147", "535", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "21", "225", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "94", "761", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "88", "344", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "27", "410", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "63", "1034", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "149", "352", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "60", "696", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "86", "791", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "117", "336", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "80", "1082", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "92", "689", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "56", "752", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "36", "486", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "93", "1058", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "106", "885", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "25", "1072", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "128", "696", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "138", "678", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "20", "233", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "50", "1036", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "119", "657", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "111", "349", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "126", "494", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "48", "441", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "84", "623", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "142", "446", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "96", "855", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "87", "214", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "130", "361", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "97", "322", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "107", "353", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "86", "214", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "59", "699", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "132", "919", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "66", "1001", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "147", "683", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "136", "596", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "89", "589", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "77", "566", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "143", "443", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "91", "973", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "49", "755", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "28", "391", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "122", "485", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "82", "418", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "85", "967", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "50", "1010", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "69", "465", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "52", "523", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "113", "264", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "89", "1036", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "155", "589", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "81", "714", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "115", "350", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "142", "770", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "116", "644", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "53", "471", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "157", "635", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "118", "662", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "44", "656", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "154", "519", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "111", "995", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "138", "380", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "157", "865", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "81", "1094", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "123", "551", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "29", "951", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "65", "999", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "103", "505", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "39", "641", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "115", "1023", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "107", "542", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "89", "977", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "100", "1099", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "80", "1033", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "63", "775", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "36", "520", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "25", "1061", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "57", "510", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "75", "663", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "141", "986", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "92", "401", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "26", "904", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "90", "677", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "69", "855", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "36", "625", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "150", "448", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "52", "478", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "92", "787", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "42", "1040", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "43", "932", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "50", "624", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "74", "884", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "46", "801", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "39", "550", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "104", "608", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "139", "1019", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "122", "453", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "94", "991", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "34", "239", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "155", "690", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "25", "943", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "49", "368", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "124", "222", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "131", "1084", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "44", "404", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "151", "242", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "122", "294", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "155", "671", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "66", "938", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "100", "1042", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "23", "520", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "153", "744", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "126", "775", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "127", "628", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "153", "746", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "40", "692", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "39", "897", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "43", "787", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "51", "815", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "63", "417", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "24", "724", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "43", "274", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "138", "289", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "108", "543", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "152", "830", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "49", "581", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "107", "791", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "153", "717", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "149", "803", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "32", "997", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "50", "713", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "141", "992", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "60", "740", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "76", "713", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "26", "210", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "115", "1076", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "78", "743", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "103", "371", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "20", "725", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "142", "455", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "58", "900", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "50", "596", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "54", "1056", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "100", "251", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "39", "436", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "32", "1099", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "41", "985", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "47", "531", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "114", "531", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "158", "978", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "77", "268", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "130", "798", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "112", "1080", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "50", "492", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "112", "966", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "129", "560", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "80", "488", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "129", "688", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "102", "994", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "60", "968", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "86", "964", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "128", "454", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "149", "824", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "112", "307", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "110", "491", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "64", "999", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "56", "355", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "46", "858", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "139", "401", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "141", "322", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "113", "1053", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "55", "389", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "82", "603", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "97", "302", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "84", "1013", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "138", "418", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "34", "860", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "157", "812", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "149", "960", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "108", "1077", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "68", "617", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "95", "727", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "39", "487", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "30", "403", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "155", "624", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "148", "768", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "157", "868", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "159", "362", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "139", "297", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "107", "847", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "110", "548", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "149", "512", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "29", "397", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "110", "1018", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "51", "560", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "60", "456", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "105", "910", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "68", "1048", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "91", "986", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "24", "866", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "119", "929", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "94", "1080", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "50", "1092", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "123", "664", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "53", "623", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "74", "656", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "158", "749", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "81", "605", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "89", "231", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "88", "779", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "101", "260", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "98", "662", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "104", "858", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "80", "366", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "156", "876", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "60", "215", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "82", "807", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "26", "1057", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "82", "995", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "67", "649", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "68", "432", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "152", "291", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "47", "288", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "24", "905", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "113", "710", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "78", "295", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "87", "909", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "113", "369", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "120", "424", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "37", "437", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "157", "894", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "133", "899", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "126", "914", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "149", "679", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "143", "728", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "34", "1020", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "43", "646", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "84", "682", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "131", "946", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "53", "429", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "81", "549", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "83", "680", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "127", "282", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "105", "797", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "49", "300", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "136", "292", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "84", "739", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "138", "416", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "40", "355", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "137", "321", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "138", "439", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "142", "228", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "88", "370", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "154", "826", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "129", "928", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "124", "786", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "100", "728", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "63", "255", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "68", "800", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "61", "410", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "33", "960", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "109", "298", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "142", "935", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "72", "977", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "71", "784", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "65", "1094", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "97", "292", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "89", "847", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "93", "584", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "41", "905", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "91", "650", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "73", "905", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "85", "562", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "91", "632", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "81", "828", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "109", "255", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "138", "978", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "115", "626", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "54", "743", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "155", "907", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "140", "632", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "97", "373", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "51", "919", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "154", "275", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "159", "571", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "118", "474", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "46", "760", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "54", "287", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "114", "787", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "46", "562", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "147", "568", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "46", "611", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "55", "454", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "115", "841", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "102", "665", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "94", "622", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "139", "638", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "113", "951", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "22", "259", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "144", "403", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "52", "1023", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "84", "261", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "113", "931", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "85", "409", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "149", "624", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "69", "484", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "44", "536", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "133", "1072", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "34", "991", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "56", "203", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "68", "1018", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "91", "256", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "99", "429", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "58", "965", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "54", "743", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "134", "716", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "126", "785", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "43", "842", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "136", "782", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "42", "251", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "150", "955", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "149", "232", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "38", "243", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "152", "942", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "37", "889", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "83", "900", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "44", "593", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "152", "1064", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "26", "990", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "85", "1072", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "83", "265", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "122", "461", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "150", "283", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "45", "427", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "52", "674", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "24", "767", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "107", "578", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "46", "242", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "120", "236", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "132", "374", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "105", "396", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "151", "279", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "124", "375", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "158", "266", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "41", "880", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "157", "481", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "127", "690", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "73", "442", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "24", "379", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "105", "317", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "75", "1041", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "37", "788", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "49", "377", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "22", "420", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "86", "768", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "48", "903", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "74", "357", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "91", "415", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "158", "1063", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "62", "476", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "39", "1050", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "156", "337", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "34", "1057", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "152", "386", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "73", "715", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "80", "476", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "65", "687", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "57", "967", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "119", "564", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "93", "711", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "122", "220", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "68", "437", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "85", "1036", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "52", "374", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "48", "243", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "142", "867", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "74", "699", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "138", "468", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "114", "219", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "71", "441", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "153", "690", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "39", "976", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "117", "817", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "111", "948", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "54", "444", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "86", "225", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "135", "940", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "51", "237", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "20", "639", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "143", "423", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "117", "461", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "123", "226", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "125", "828", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "114", "774", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "61", "367", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "35", "932", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "24", "816", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "60", "754", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "54", "841", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "26", "995", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "136", "249", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "38", "767", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "141", "453", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "155", "958", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "153", "289", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "25", "625", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "62", "747", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "37", "638", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "30", "643", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "129", "488", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "23", "205", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "101", "859", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "59", "410", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "100", "439", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "136", "813", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "53", "424", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "151", "991", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "146", "824", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "110", "873", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "133", "774", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "23", "623", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "86", "586", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "75", "845", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "89", "564", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "57", "753", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "143", "274", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "108", "703", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "146", "958", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "148", "1071", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "134", "693", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "120", "1033", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "32", "504", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "93", "989", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "65", "255", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "22", "996", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "22", "566", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "75", "335", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "47", "783", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "130", "594", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "20", "250", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "99", "1005", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "60", "396", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "68", "496", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "87", "986", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "68", "1086", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "92", "1028", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "93", "1090", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "122", "572", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "141", "315", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "148", "834", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "76", "290", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "79", "397", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "108", "735", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "125", "543", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "35", "304", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "139", "1027", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "78", "631", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "126", "830", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "86", "274", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "131", "684", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "127", "1022", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "56", "432", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "74", "571", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "88", "397", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "138", "1010", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "77", "405", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "140", "862", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "149", "345", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "75", "561", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "55", "314", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "35", "796", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "31", "738", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "81", "223", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "83", "1041", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "57", "402", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "26", "362", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "68", "250", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "118", "266", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "130", "1008", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "146", "270", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "26", "821", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "123", "889", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "48", "636", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "101", "731", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "79", "402", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "105", "575", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "80", "834", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "57", "1068", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "34", "618", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "81", "804", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "113", "340", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "23", "659", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "67", "1056", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "86", "880", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "102", "489", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "80", "1042", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "59", "713", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "87", "887", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "114", "693", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "117", "392", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "51", "980", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "88", "543", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "57", "513", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "100", "1092", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "82", "922", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "64", "694", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "67", "296", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "133", "1020", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "128", "977", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "100", "493", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "128", "308", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "66", "987", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "154", "493", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "28", "354", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "120", "225", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "87", "662", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "22", "238", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "93", "716", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "92", "249", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "134", "920", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "89", "625", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "86", "913", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "91", "1075", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "125", "959", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "29", "828", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "119", "394", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "67", "682", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "42", "711", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "143", "1012", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "71", "670", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "63", "261", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "117", "1094", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "90", "484", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "46", "715", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "139", "320", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "138", "577", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "124", "877", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "73", "698", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "40", "757", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "47", "936", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "48", "959", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "39", "707", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "148", "406", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "88", "387", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "136", "786", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "44", "559", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "66", "398", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "145", "880", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "129", "852", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "154", "967", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "51", "509", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "141", "869", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "67", "840", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "94", "548", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "153", "375", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "96", "610", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "145", "597", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "89", "681", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "100", "870", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "51", "541", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "112", "986", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "148", "929", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "94", "701", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "110", "1030", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "38", "711", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "43", "577", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "69", "302", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "50", "380", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "66", "403", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "83", "549", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "111", "1024", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "31", "321", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "54", "716", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "25", "335", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "62", "522", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "36", "554", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "38", "351", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "68", "1052", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "98", "218", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "63", "538", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "151", "988", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "27", "849", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "102", "979", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "155", "768", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "100", "682", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "64", "611", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "36", "969", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "30", "837", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "78", "998", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "149", "334", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "117", "886", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "151", "724", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "53", "267", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "87", "959", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "94", "657", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "143", "504", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "85", "248", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "100", "494", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "127", "1072", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "22", "979", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "126", "969", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "115", "397", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "130", "382", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "112", "932", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "132", "320", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "147", "522", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "64", "329", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "131", "241", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "68", "675", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "81", "587", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "119", "383", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "61", "452", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "136", "382", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "82", "981", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "89", "908", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "24", "666", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "34", "677", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "127", "279", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "155", "674", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "25", "434", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "49", "330", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "29", "283", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "59", "286", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "37", "521", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "121", "743", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "108", "626", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "117", "768", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "141", "797", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "123", "754", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "141", "885", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "71", "516", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "138", "633", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "33", "433", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "143", "1071", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "65", "670", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "81", "200", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "95", "853", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "152", "254", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "89", "1026", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "137", "850", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "159", "257", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "126", "1031", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "127", "1070", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "42", "211", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "89", "1052", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "90", "372", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "107", "333", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "125", "766", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "152", "960", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "81", "297", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "65", "863", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "72", "362", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "85", "1078", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "119", "477", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "35", "887", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "35", "296", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "143", "393", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "47", "331", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "114", "264", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "155", "942", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "122", "706", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "41", "981", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "129", "660", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "42", "406", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "37", "212", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "29", "733", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "148", "917", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "111", "897", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "108", "686", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "127", "796", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "113", "341", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "71", "926", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "148", "698", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "48", "697", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "104", "897", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "134", "922", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "81", "705", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "114", "249", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "110", "318", "weight", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "57", "704", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "93", "901", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "57", "1089", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "27", "759", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "121", "473", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "138", "450", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "64", "390", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "77", "533", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "146", "1085", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "88", "848", "color", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "88", "314", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "108", "999", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "83", "1035", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "118", "1075", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "110", "519", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "66", "363", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "23", "412", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "130", "968", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "59", "757", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "92", "302", "color", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "128", "317", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "127", "982", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "85", "463", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "65", "353", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "115", "790", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "127", "424", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "106", "507", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "64", "615", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "151", "974", "color", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "119", "773", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "43", "906", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "112", "700", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "32", "862", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "52", "755", "color", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "80", "203", "weight", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "99", "965", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "34", "958", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "105", "947", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "52", "652", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "68", "578", "weight", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "124", "781", "weight", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("3", "23", "765", "height", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "129", "1071", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "131", "900", "height", "low", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "122", "357", "color", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "97", "423", "height", "high", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "89", "744", "weight", "high", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("2", "99", "841", "color", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "43", "781", "height", "normal", "comments here");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "148", "320", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("4", "110", "1028", "height", "normal", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("5", "147", "434", "weight", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "67", "390", "height", "low", "");
INSERT INTO html_searchpage_experiment (person_id, temperature, sample_size, attribute, result, comments) VALUES ("1", "68", "626", "height", "low", "");
