# Generated by default/object.tt
package Paws::Chime::SipRule;
  use Moose;
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has Disabled => (is => 'ro', isa => 'Bool');
  has Name => (is => 'ro', isa => 'Str');
  has SipRuleId => (is => 'ro', isa => 'Str');
  has TargetApplications => (is => 'ro', isa => 'ArrayRef[Paws::Chime::SipRuleTargetApplication]');
  has TriggerType => (is => 'ro', isa => 'Str');
  has TriggerValue => (is => 'ro', isa => 'Str');
  has UpdatedTimestamp => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::SipRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::SipRule object:

  $service_obj->Method(Att1 => { CreatedTimestamp => $value, ..., UpdatedTimestamp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::SipRule object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedTimestamp

=head1 DESCRIPTION

The SIP rule details, including name, triggers, and target
applications. An AWS account can have multiple SIP rules.

=head1 ATTRIBUTES


=head2 CreatedTimestamp => Str

The time at which the SIP rule was created, in ISO 8601 format.


=head2 Disabled => Bool

Indicates whether the SIP rule is enabled or disabled. You must disable
a rule before you can delete it.


=head2 Name => Str

The name of the SIP rule.


=head2 SipRuleId => Str

The SIP rule ID.


=head2 TargetApplications => ArrayRef[L<Paws::Chime::SipRuleTargetApplication>]

Target SIP media application and other details, such as priority and
AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS
Region can be provided.


=head2 TriggerType => Str

The type of trigger assigned to the SIP rule in C<TriggerValue>,
currently C<RequestUriHostname> or C<ToPhoneNumber>.


=head2 TriggerValue => Str

If C<TriggerType> is C<RequestUriHostname>, then the value can be the
outbound host name of the Amazon Chime Voice Connector. If
C<TriggerType> is C<ToPhoneNumber>, then the value can be a
customer-owned phone number in E164 format. C<SipRule> is triggered
when a SIP rule requests host name or C<ToPhoneNumber> matches in the
incoming SIP request.


=head2 UpdatedTimestamp => Str

The time at which the SIP rule was last updated, in ISO 8601 format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

