# Generated by default/object.tt
package Paws::MediaConvert::NielsenNonLinearWatermarkSettings;
  use Moose;
  has ActiveWatermarkProcess => (is => 'ro', isa => 'Str', request_name => 'activeWatermarkProcess', traits => ['NameInRequest']);
  has AdiFilename => (is => 'ro', isa => 'Str', request_name => 'adiFilename', traits => ['NameInRequest']);
  has AssetId => (is => 'ro', isa => 'Str', request_name => 'assetId', traits => ['NameInRequest']);
  has AssetName => (is => 'ro', isa => 'Str', request_name => 'assetName', traits => ['NameInRequest']);
  has CbetSourceId => (is => 'ro', isa => 'Str', request_name => 'cbetSourceId', traits => ['NameInRequest']);
  has EpisodeId => (is => 'ro', isa => 'Str', request_name => 'episodeId', traits => ['NameInRequest']);
  has MetadataDestination => (is => 'ro', isa => 'Str', request_name => 'metadataDestination', traits => ['NameInRequest']);
  has SourceId => (is => 'ro', isa => 'Int', request_name => 'sourceId', traits => ['NameInRequest']);
  has SourceWatermarkStatus => (is => 'ro', isa => 'Str', request_name => 'sourceWatermarkStatus', traits => ['NameInRequest']);
  has TicServerUrl => (is => 'ro', isa => 'Str', request_name => 'ticServerUrl', traits => ['NameInRequest']);
  has UniqueTicPerAudioTrack => (is => 'ro', isa => 'Str', request_name => 'uniqueTicPerAudioTrack', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::NielsenNonLinearWatermarkSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::NielsenNonLinearWatermarkSettings object:

  $service_obj->Method(Att1 => { ActiveWatermarkProcess => $value, ..., UniqueTicPerAudioTrack => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::NielsenNonLinearWatermarkSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveWatermarkProcess

=head1 DESCRIPTION

Ignore these settings unless you are using Nielsen non-linear
watermarking. Specify the values that MediaConvert uses to generate and
place Nielsen watermarks in your output audio. In addition to
specifying these values, you also need to set up your cloud TIC server.
These settings apply to every output in your job. The MediaConvert
implementation is currently with the following Nielsen versions:
Nielsen Watermark SDK Version 5.2.1 Nielsen NLM Watermark Engine
Version 1.2.7 Nielsen Watermark Authenticator [SID_TIC] Version [5.0.0]

=head1 ATTRIBUTES


=head2 ActiveWatermarkProcess => Str

Choose the type of Nielsen watermarks that you want in your outputs.
When you choose NAES 2 and NW (NAES2_AND_NW), you must provide a value
for the setting SID (sourceId). When you choose CBET (CBET), you must
provide a value for the setting CSID (cbetSourceId). When you choose
NAES 2, NW, and CBET (NAES2_AND_NW_AND_CBET), you must provide values
for both of these settings.


=head2 AdiFilename => Str

Optional. Use this setting when you want the service to include an ADI
file in the Nielsen metadata .zip file. To provide an ADI file, store
it in Amazon S3 and provide a URL to it here. The URL should be in the
following format: S3://bucket/path/ADI-file. For more information about
the metadata .zip file, see the setting Metadata destination
(metadataDestination).


=head2 AssetId => Str

Use the asset ID that you provide to Nielsen to uniquely identify this
asset. Required for all Nielsen non-linear watermarking.


=head2 AssetName => Str

Use the asset name that you provide to Nielsen for this asset. Required
for all Nielsen non-linear watermarking.


=head2 CbetSourceId => Str

Use the CSID that Nielsen provides to you. This CBET source ID should
be unique to your Nielsen account but common to all of your output
assets that have CBET watermarking. Required when you choose a value
for the setting Watermark types (ActiveWatermarkProcess) that includes
CBET.


=head2 EpisodeId => Str

Optional. If this asset uses an episode ID with Nielsen, provide it
here.


=head2 MetadataDestination => Str

Specify the Amazon S3 location where you want MediaConvert to save your
Nielsen non-linear metadata .zip file. This Amazon S3 bucket must be in
the same Region as the one where you do your MediaConvert transcoding.
If you want to include an ADI file in this .zip file, use the setting
ADI file (adiFilename) to specify it. MediaConvert delivers the Nielsen
metadata .zip files only to your metadata destination Amazon S3 bucket.
It doesn't deliver the .zip files to Nielsen. You are responsible for
delivering the metadata .zip files to Nielsen.


=head2 SourceId => Int

Use the SID that Nielsen provides to you. This source ID should be
unique to your Nielsen account but common to all of your output assets.
Required for all Nielsen non-linear watermarking. This ID should be
unique to your Nielsen account but common to all of your output assets.
Required for all Nielsen non-linear watermarking.


=head2 SourceWatermarkStatus => Str

Required. Specify whether your source content already contains Nielsen
non-linear watermarks. When you set this value to Watermarked
(WATERMARKED), the service fails the job. Nielsen requires that you add
non-linear watermarking to only clean content that doesn't already have
non-linear Nielsen watermarks.


=head2 TicServerUrl => Str

Specify the endpoint for the TIC server that you have deployed and
configured in the AWS Cloud. Required for all Nielsen non-linear
watermarking. MediaConvert can't connect directly to a TIC server.
Instead, you must use API Gateway to provide a RESTful interface
between MediaConvert and a TIC server that you deploy in your AWS
account. For more information on deploying a TIC server in your AWS
account and the required API Gateway, contact Nielsen support.


=head2 UniqueTicPerAudioTrack => Str

To create assets that have the same TIC values in each audio track,
keep the default value Share TICs (SAME_TICS_PER_TRACK). To create
assets that have unique TIC values for each audio track, choose Use
unique TICs (RESERVE_UNIQUE_TICS_PER_TRACK).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

