# Generated by default/object.tt
package Paws::SESv2::TopicFilter;
  use Moose;
  has TopicName => (is => 'ro', isa => 'Str');
  has UseDefaultIfPreferenceUnavailable => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::TopicFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::TopicFilter object:

  $service_obj->Method(Att1 => { TopicName => $value, ..., UseDefaultIfPreferenceUnavailable => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::TopicFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->TopicName

=head1 DESCRIPTION

Used for filtering by a specific topic preference.

=head1 ATTRIBUTES


=head2 TopicName => Str

The name of a topic on which you wish to apply the filter.


=head2 UseDefaultIfPreferenceUnavailable => Bool

Notes that the default subscription status should be applied to a
contact because the contact has not noted their preference for
subscribing to a topic.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

