package Google::Ads::AdWords::v201406::ConversionTrackingSettings;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/mcm/v201406' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %conversionOptimizerMode_of :ATTR(:get<conversionOptimizerMode>);

__PACKAGE__->_factory(
    [ qw(        conversionOptimizerMode

    ) ],
    {
        'conversionOptimizerMode' => \%conversionOptimizerMode_of,
    },
    {
        'conversionOptimizerMode' => 'Google::Ads::AdWords::v201406::ConversionDeduplicationMode',
    },
    {

        'conversionOptimizerMode' => 'conversionOptimizerMode',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201406::ConversionTrackingSettings

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ConversionTrackingSettings from the namespace https://adwords.google.com/api/adwords/mcm/v201406.

A collection of customer-wide settings related to AdWords Conversion Tracking. Settings that apply a conversion type level can be accessed and modified though {@code ConversionTrackerService} 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * conversionOptimizerMode




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

