#!/bin/false
# ABSTRACT: Object methods to create a DHCP packet
# PODNAME: Net::DHCP
use strict;
use warnings;

package Net::DHCP;
$Net::DHCP::VERSION = '0.7_009'; # TRIAL
$Net::DHCP::VERSION = '0.7009';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::DHCP - Object methods to create a DHCP packet

=head1 VERSION

version 0.7_009

=head1 SYNOPSIS

   use Net::DHCP::Packet;

   my $p = Net::DHCP::Packet->new(
        'Chaddr' => '000BCDEF',
        'Xid' => 0x9F0FD,
        'Ciaddr' => '0.0.0.0',
        'Siaddr' => '0.0.0.0',
        'Hops' => 0);

=head1 DESCRIPTION

Represents a DHCP packet as specified in RFC 1533, RFC 2132.

=head1 SEE ALSO

L<Net::DHCP::Options>, L<Net::DHCP::Constants>.

=head1 AUTHOR

Dean Hamstead <dean@fragfest.com.au>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by Dean Hamstead.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
