#!/usr/bin/perl

package eBay::API::XML::DataType::NameValueListArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. NameValueListArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::NameValueListArrayType

=head1 DESCRIPTION

A list of one or more valid names and corresponding values. Currently
only used for Item Specifics.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::NameValueListArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::NameValueListType;


my @gaProperties = ( [ 'NameValueList', 'ns:NameValueListType', '1'
	     ,'eBay::API::XML::DataType::NameValueListType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setNameValueList()

Contains the name of an Item Specific, and one or more corresponding
values, if any.<br>
<br>
In the AddItem family of calls,
this is only required when the ItemSpecifics container is specified.<br>
<br>
In GetSearchResults, GetSearchResultsExpress, GetProducts,
GetCategorySpecifics, (and soon in GetItem), this is only returned
when the ItemSpecifics (or ItemSpecific) node is returned.

  Calls: AddItem
         AddLiveAuctionItem
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: reference to an array  
                      of 'ns:NameValueListType'

=cut

sub setNameValueList {
  my $self = shift;
  $self->{'NameValueList'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getNameValueList()

  Calls: GetCategorySpecifics
         GetItemRecommendations
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetProducts
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:NameValueListType'

=cut

sub getNameValueList {
  my $self = shift;
  return $self->_getDataTypeArray('NameValueList');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
