#!/usr/bin/perl

package eBay::API::XML::DataType::OrderTransactionType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. OrderTransactionType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::OrderTransactionType

=head1 DESCRIPTION

Contains an order or a transaction. A transaction is the sale of one or
more items from a seller's listing to a buyer. An order combines two or more transactions
into a single payment.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::OrderTransactionType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::OrderType;
use eBay::API::XML::DataType::TransactionType;


my @gaProperties = ( [ 'Order', 'ns:OrderType', ''
	     ,'eBay::API::XML::DataType::OrderType', '1' ]
	, [ 'Transaction', 'ns:TransactionType', ''
	     ,'eBay::API::XML::DataType::TransactionType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setOrder()

Contains the information describing an order.

#    Argument: 'ns:OrderType'

=cut

sub setOrder {
  my $self = shift;
  $self->{'Order'} = shift
}

=head2 getOrder()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'ns:OrderType'

=cut

sub getOrder {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Order'
		,'eBay::API::XML::DataType::OrderType');
}


=head2 setTransaction()

Contains the information describing a transaction.

#    Argument: 'ns:TransactionType'

=cut

sub setTransaction {
  my $self = shift;
  $self->{'Transaction'} = shift
}

=head2 getTransaction()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'ns:TransactionType'

=cut

sub getTransaction {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Transaction'
		,'eBay::API::XML::DataType::TransactionType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
