#!/usr/bin/perl

package eBay::API::XML::Call::AddLiveAuctionItem;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AddLiveAuctionItem.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::AddLiveAuctionItem

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::AddLiveAuctionItem inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::AddLiveAuctionItem::AddLiveAuctionItemRequestType;
use eBay::API::XML::Call::AddLiveAuctionItem::AddLiveAuctionItemResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'AddLiveAuctionItem';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::AddLiveAuctionItem::AddLiveAuctionItemRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::AddLiveAuctionItem::AddLiveAuctionItemResponseType';
}

#
# input properties
#

=head2 setItem()

Specifies the values that define the new lot item.
Item is a required input.

  RequiredInput: Yes
#    Argument: 'ns:ItemType'

=cut
       
sub setItem {
   my $self   = shift;
   my $pItem = shift;
   $self->getRequestDataType()->setItem($pItem);
}



#
# output properties
#

=head2 getCategory2ID()

ID of the secondary category in which the item was listed.
Only returned if you set Item.CategoryMappingAllowed to true in the request
and the ID you passed in SecondaryCategory was mapped to a new ID by eBay.
If the secondary category has not changed or it has expired with no replacement,
Category2ID does not return a value.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getCategory2ID {
   my $self = shift;
   return $self->getResponseDataType()->getCategory2ID();
}

=head2 getCategoryID()

ID of the primary category in which the item was listed.
Only returned if you set Item.CategoryMappingAllowed to true in the request
and the ID you passed in PrimaryCategory was mapped to a new ID by eBay.
If the primary category has not changed or it has expired with no replacement,
CategoryID does not return a value.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getCategoryID {
   my $self = shift;
   return $self->getResponseDataType()->getCategoryID();
}

=head2 getFees()

Child elements contain the estimated listing fees for the new item listing.
The fees do not include the Final Value Fee (FVF), which cannot be determined
until an item is sold.
For consistency in the response, the call returns the same kinds of fees
as other listing calls, but some fees are not applicable to eBay Live Auctions listings.
See "Fees Resulting from Listing an Item" in the eBay Web Services guide
for information about fees.

  Returned: Always
#    Returns: 'ns:FeesType'

=cut
       
sub getFees {
   my $self = shift;
   return $self->getResponseDataType()->getFees();
}

=head2 getItemID()

The item ID of the lot.

  Returned: Always
#    Returns: 'ns:ItemIDType'

=cut
       
sub getItemID {
   my $self = shift;
   return $self->getResponseDataType()->getItemID();
}





1;   
