#!/usr/bin/perl

package eBay::API::XML::DataType::BidGroupItemType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BidGroupItemType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BidGroupItemType

=head1 DESCRIPTION

Contains information about items that are part of a bid group.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BidGroupItemType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ItemType;
use eBay::API::XML::DataType::Enum::BidGroupItemStatusCodeType;


my @gaProperties = ( [ 'BidGroupItemStatus', 'ns:BidGroupItemStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BidGroupItemStatusCodeType', '' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
	, [ 'MaxBidAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidGroupItemStatus()

Contains the status of the items in the bid group.

#    Argument: 'ns:BidGroupItemStatusCodeType'

=cut

sub setBidGroupItemStatus {
  my $self = shift;
  $self->{'BidGroupItemStatus'} = shift
}

=head2 getBidGroupItemStatus()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  OnlyTheseValues: Pending, CurrentBid, Skipped, Won
  Context: BidAssistantList

#    Returns: 'ns:BidGroupItemStatusCodeType'

=cut

sub getBidGroupItemStatus {
  my $self = shift;
  return $self->{'BidGroupItemStatus'};
}


=head2 setItem()

Contains a list of the items in a bid group.

#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidAssistantList

#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}


=head2 setMaxBidAmount()

Contains the maximum bid amount for the item in the bid group.

#    Argument: 'ns:AmountType'

=cut

sub setMaxBidAmount {
  my $self = shift;
  $self->{'MaxBidAmount'} = shift
}

=head2 getMaxBidAmount()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidAssistantList

#    Returns: 'ns:AmountType'

=cut

sub getMaxBidAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaxBidAmount'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
