
use strict;
use warnings;

use ExtUtils::MakeMaker;
use File::ShareDir::Install;

if ( -d 'share' ) {
  install_share 'share';
}

WriteMakefile(
  NAME           => 'Amazon::API',
  AUTHOR         => 'Rob Lauer <rlauer6@comcast.net>',
  VERSION_FROM   => 'lib/Amazon/API.pm',
  ABSTRACT       => 'AWS API base class',
  LICENSE        => 'perl',
  PL_FILES       => {},
  EXE_FILES      =>     []
,
  PREREQ_PM      => {
      'AWS::Signature4' => '1.02',
      'Amazon::Credentials' => '1.0.15',
      'Class::Accessor' => '0.31',
      'Class::Accessor::Fast' => '0.31',
      'Date::Format' => '2.24',
      'HTTP::Request' => '6.00',
      'LWP::UserAgent' => '6.36',
      'XML::LibXML::Simple' => '1.01'
    },
  BUILD_REQUIRES => {
    'ExtUtils::MakeMaker'     => 0,
    'File::ShareDir::Install' => 0,
    },
  CONFIGURE_REQUIRES => {
    'ExtUtils::MakeMaker'     => 0,
    'File::ShareDir::Install' => 0,
    },
  TEST_REQUIRES => {}
,
  META_MERGE =>    {
      'meta-spec'=>{
                       'version'=>2
                     },
      'provides'=>{
                      'Amazon::API'=>{
                                         'file'=>'lib/Amazon/API.pm',
                                         'version'=>'1.2.7'
                                       },
                      'Amazon::API::CloudWatchLogs'=>{
                                                         'file'=>'lib/Amazon/API/CloudWatchLogs.pm',
                                                         'version'=>'1.2.7'
                                                       },
                      'Amazon::API::EC2'=>{
                                              'file'=>'lib/Amazon/API/EC2.pm',
                                              'version'=>'1.2.7'
                                            },
                      'Amazon::API::ECR'=>{
                                              'file'=>'lib/Amazon/API/ECR.pm',
                                              'version'=>'1.2.7'
                                            },
                      'Amazon::API::ECS'=>{
                                              'file'=>'lib/Amazon/API/ECS.pm',
                                              'version'=>'1.2.7'
                                            },
                      'Amazon::API::Error'=>{
                                                'file'=>'lib/Amazon/API/Error.pm',
                                                'version'=>'1.2.7'
                                              },
                      'Amazon::API::SQS'=>{
                                              'file'=>'lib/Amazon/API/SQS.pm',
                                              'version'=>'1.2.7'
                                            },
                      'Amazon::API::SSM'=>{
                                              'file'=>'lib/Amazon/API/SSM.pm',
                                              'version'=>'1.2.7'
                                            },
                      'Amazon::API::STS'=>{
                                              'file'=>'lib/Amazon/API/STS.pm',
                                              'version'=>'1.2.7'
                                            },
                      'Amazon::API::SecretsManager'=>{
                                                         'file'=>'lib/Amazon/API/SecretsManager.pm',
                                                         'version'=>'1.2.7'
                                                       },
                      'Amazon::API::Signature4'=>{
                                                     'file'=>'lib/Amazon/API/Signature4.pm',
                                                     'version'=>'1.2.7'
                                                   }
                    },
      'resources'=>{
                       'bugtracker'=>{
                                         'mailto'=>'rlauer6@comcast.net',
                                         'web'=>'http://github.com/rlauer6/perl-Amazon-API/issues'
                                       },
                       'homepage'=>'http://github.com/rlauer6/perl-Amazon-API',
                       'repository'=>{
                                         'type'=>'git',
                                         'url'=>'git://github.com/rlauer6/perl-Amazon-API.git',
                                         'web'=>'http://github.com/rlauer6/perl-Amazon-API'
                                       }
                     }
    }

);

package MY;

use File::ShareDir::Install qw( postamble );

