package App::Zealc;

use 5.014000;
use strict;
use warnings;

our $VERSION = '0.000_001';

use App::Cmd::Setup '-app';
use parent qw/Class::Accessor::Fast/;
__PACKAGE__->mk_accessors(qw/path zeal config verbose/);

use Class::Method::Modifiers qw/before/;
use Config::Auto;

use File::Spec::Functions qw/catfile/;

use Zeal;

use constant DEFAULT_PATH => $ENV{HOME} ? catfile $ENV{HOME}, '.docsets' : '.docsets';

sub allow_any_unambiguous_abbrev () { 1 }
sub default_command { 'commands' } # Show usage when called without arguments

sub global_opt_spec {
	(['config|c=s' => 'Path to configuration file'],
	 ['path|p=s'   => 'Path to docset directory',],
	 ['verbose|v!' => 'Print verbose debugging output'])
}

sub parse_config {
	my ($cfg) = @_;
	return Config::Auto::parse($cfg) if $cfg;
	eval { Config::Auto::parse } or {}
}

before 'execute_command' => sub {
	my ($self) = @_;
	my %opts   = %{$self->global_options};
	my $config = parse_config $ENV{ZEALC_CONFIG} || $opts{config};
	my %config = %$config;
	my $path   = $opts{path} || $config{path} || DEFAULT_PATH;
	mkdir $path unless -d $path;

	my $zeal   = Zeal->new($path);
	$self->path($path);
	$self->zeal($zeal);
	$self->config($config);
	$self->verbose($opts{verbose} || $config{verbose})
};

1;
__END__

=encoding utf-8

=head1 NAME

App::Zealc - command-line offline documentation browser for Dash/Zeal docsets

=head1 SYNOPSIS

  use App::Zealc;
  App::Zealc->run;

=head1 DESCRIPTION

zealc is a command-line offline documentation browser inspired by
L<Dash|http://kapeli.com/dash> and L<Zeal|http://zealdocs.org>. It
uses Dash/Zeal format docsets via the L<Zeal> library.

=head1 SEE ALSO

L<zealc>, L<Zeal>

=head1 AUTHOR

Marius Gavrilescu, E<lt>marius@ieval.roE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 by Marius Gavrilescu

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.20.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
