# Generated by default/object.tt
package Paws::FMS::DnsRuleGroupLimitExceededViolation;
  use Moose;
  has NumberOfRuleGroupsAlreadyAssociated => (is => 'ro', isa => 'Int');
  has ViolationTarget => (is => 'ro', isa => 'Str');
  has ViolationTargetDescription => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::DnsRuleGroupLimitExceededViolation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::DnsRuleGroupLimitExceededViolation object:

  $service_obj->Method(Att1 => { NumberOfRuleGroupsAlreadyAssociated => $value, ..., ViolationTargetDescription => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::DnsRuleGroupLimitExceededViolation object:

  $result = $service_obj->Method(...);
  $result->Att1->NumberOfRuleGroupsAlreadyAssociated

=head1 DESCRIPTION

The VPC that Firewall Manager was applying a DNS Fireall policy to
reached the limit for associated DNS Firewall rule groups. Firewall
Manager tried to associate another rule group with the VPC and failed
due to the limit.

=head1 ATTRIBUTES


=head2 NumberOfRuleGroupsAlreadyAssociated => Int

The number of rule groups currently associated with the VPC.


=head2 ViolationTarget => Str

The ID of the VPC.


=head2 ViolationTargetDescription => Str

A description of the violation that specifies the rule group and VPC.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

