# Generated by default/object.tt
package Paws::WorkSpaces::ConnectionAliasPermission;
  use Moose;
  has AllowAssociation => (is => 'ro', isa => 'Bool', required => 1);
  has SharedAccountId => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkSpaces::ConnectionAliasPermission

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkSpaces::ConnectionAliasPermission object:

  $service_obj->Method(Att1 => { AllowAssociation => $value, ..., SharedAccountId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkSpaces::ConnectionAliasPermission object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowAssociation

=head1 DESCRIPTION

Describes the permissions for a connection alias. Connection aliases
are used for cross-Region redirection. For more information, see
Cross-Region Redirection for Amazon WorkSpaces
(https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> AllowAssociation => Bool

Indicates whether the specified AWS account is allowed to associate the
connection alias with a directory.


=head2 B<REQUIRED> SharedAccountId => Str

The identifier of the AWS account that the connection alias is shared
with.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkSpaces>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

