package Data::Password::zxcvbn::AdjacencyGraph::English;
use strict;
use warnings;
# VERSION
# ABSTRACT: adjacency graphs for English keyboards

=head1 DESCRIPTION

This is a data file used by L<<
C<Data::Password::zxcvbn::Match::Spatial> >>, and is generated by the
L<<
C<build-keyboard-adjacency-graphs>|https://bitbucket.org/broadbean/p5-data-password-zxcvbn/src/master/maint/build-keyboard-adjacency-graphs
>> program when building the distribution.


=cut

our %graphs = (
  dvorak => {
              average_degree     => 4.59574468085106,
              keys               => {
                                      "!"  => [
                                                '`~', ( undef ) x 2, '2@', '\'"', undef
                                              ],
                                      "\"" => [
                                                undef, '1!', '2@', ',<', 'aA', undef
                                              ],
                                      "#"  => [
                                                '2@', ( undef ) x 2, '4$', '.>', ',<'
                                              ],
                                      "\$" => [
                                                '3#', ( undef ) x 2, '5%', 'pP', '.>'
                                              ],
                                      "%"  => [
                                                '4$', ( undef ) x 2, '6^', 'yY', 'pP'
                                              ],
                                      "&"  => [
                                                '6^', ( undef ) x 2, '8*', 'gG', 'fF'
                                              ],
                                      "'"  => [
                                                undef, '1!', '2@', ',<', 'aA', undef
                                              ],
                                      "("  => [
                                                '8*', ( undef ) x 2, '0)', 'rR', 'cC'
                                              ],
                                      ")"  => [
                                                '9(', ( undef ) x 2, '[{', 'lL', 'rR'
                                              ],
                                      "*"  => [
                                                '7&', ( undef ) x 2, '9(', 'cC', 'gG'
                                              ],
                                      "+"  => [
                                                '/?', ']}', undef, '\\|', undef, '-_'
                                              ],
                                      ","  => [
                                                '\'"', '2@', '3#', '.>', 'oO', 'aA'
                                              ],
                                      "-"  => [
                                                'sS', '/?', '=+', ( undef ) x 2, 'zZ'
                                              ],
                                      "."  => [
                                                ',<', '3#', '4$', 'pP', 'eE', 'oO'
                                              ],
                                      "/"  => [
                                                'lL', '[{', ']}', '=+', '-_', 'sS'
                                              ],
                                      0    => [
                                                '9(', ( undef ) x 2, '[{', 'lL', 'rR'
                                              ],
                                      1    => [
                                                '`~', ( undef ) x 2, '2@', '\'"', undef
                                              ],
                                      2    => [
                                                '1!', ( undef ) x 2, '3#', ',<', '\'"'
                                              ],
                                      3    => [
                                                '2@', ( undef ) x 2, '4$', '.>', ',<'
                                              ],
                                      4    => [
                                                '3#', ( undef ) x 2, '5%', 'pP', '.>'
                                              ],
                                      5    => [
                                                '4$', ( undef ) x 2, '6^', 'yY', 'pP'
                                              ],
                                      6    => [
                                                '5%', ( undef ) x 2, '7&', 'fF', 'yY'
                                              ],
                                      7    => [
                                                '6^', ( undef ) x 2, '8*', 'gG', 'fF'
                                              ],
                                      8    => [
                                                '7&', ( undef ) x 2, '9(', 'cC', 'gG'
                                              ],
                                      9    => [
                                                '8*', ( undef ) x 2, '0)', 'rR', 'cC'
                                              ],
                                      ":"  => [
                                                undef, 'aA', 'oO', 'qQ', ( undef ) x 2
                                              ],
                                      ";"  => [
                                                undef, 'aA', 'oO', 'qQ', ( undef ) x 2
                                              ],
                                      "<"  => [
                                                '\'"', '2@', '3#', '.>', 'oO', 'aA'
                                              ],
                                      "="  => [
                                                '/?', ']}', undef, '\\|', undef, '-_'
                                              ],
                                      ">"  => [
                                                ',<', '3#', '4$', 'pP', 'eE', 'oO'
                                              ],
                                      "?"  => [
                                                'lL', '[{', ']}', '=+', '-_', 'sS'
                                              ],
                                      "\@" => [
                                                '1!', ( undef ) x 2, '3#', ',<', '\'"'
                                              ],
                                      A    => [
                                                undef, '\'"', ',<', 'oO', ';:', undef
                                              ],
                                      B    => [
                                                'xX', 'dD', 'hH', 'mM', ( undef ) x 2
                                              ],
                                      C    => [
                                                'gG', '8*', '9(', 'rR', 'tT', 'hH'
                                              ],
                                      D    => [
                                                'iI', 'fF', 'gG', 'hH', 'bB', 'xX'
                                              ],
                                      E    => [
                                                'oO', '.>', 'pP', 'uU', 'jJ', 'qQ'
                                              ],
                                      F    => [
                                                'yY', '6^', '7&', 'gG', 'dD', 'iI'
                                              ],
                                      G    => [
                                                'fF', '7&', '8*', 'cC', 'hH', 'dD'
                                              ],
                                      H    => [
                                                'dD', 'gG', 'cC', 'tT', 'mM', 'bB'
                                              ],
                                      I    => [
                                                'uU', 'yY', 'fF', 'dD', 'xX', 'kK'
                                              ],
                                      J    => [
                                                'qQ', 'eE', 'uU', 'kK', ( undef ) x 2
                                              ],
                                      K    => [
                                                'jJ', 'uU', 'iI', 'xX', ( undef ) x 2
                                              ],
                                      L    => [
                                                'rR', '0)', '[{', '/?', 'sS', 'nN'
                                              ],
                                      M    => [
                                                'bB', 'hH', 'tT', 'wW', ( undef ) x 2
                                              ],
                                      N    => [
                                                'tT', 'rR', 'lL', 'sS', 'vV', 'wW'
                                              ],
                                      O    => [
                                                'aA', ',<', '.>', 'eE', 'qQ', ';:'
                                              ],
                                      P    => [
                                                '.>', '4$', '5%', 'yY', 'uU', 'eE'
                                              ],
                                      Q    => [
                                                ';:', 'oO', 'eE', 'jJ', ( undef ) x 2
                                              ],
                                      R    => [
                                                'cC', '9(', '0)', 'lL', 'nN', 'tT'
                                              ],
                                      S    => [
                                                'nN', 'lL', '/?', '-_', 'zZ', 'vV'
                                              ],
                                      T    => [
                                                'hH', 'cC', 'rR', 'nN', 'wW', 'mM'
                                              ],
                                      U    => [
                                                'eE', 'pP', 'yY', 'iI', 'kK', 'jJ'
                                              ],
                                      V    => [
                                                'wW', 'nN', 'sS', 'zZ', ( undef ) x 2
                                              ],
                                      W    => [
                                                'mM', 'tT', 'nN', 'vV', ( undef ) x 2
                                              ],
                                      X    => [
                                                'kK', 'iI', 'dD', 'bB', ( undef ) x 2
                                              ],
                                      Y    => [
                                                'pP', '5%', '6^', 'fF', 'iI', 'uU'
                                              ],
                                      Z    => [
                                                'vV', 'sS', '-_', ( undef ) x 3
                                              ],
                                      "["  => [
                                                '0)', ( undef ) x 2, ']}', '/?', 'lL'
                                              ],
                                      "\\" => [
                                                '=+', ( undef ) x 5
                                              ],
                                      "]"  => [
                                                '[{', ( undef ) x 3, '=+', '/?'
                                              ],
                                      "^"  => [
                                                '5%', ( undef ) x 2, '7&', 'fF', 'yY'
                                              ],
                                      _    => [
                                                'sS', '/?', '=+', ( undef ) x 2, 'zZ'
                                              ],
                                      "`"  => [
                                                ( undef ) x 3, '1!', ( undef ) x 2
                                              ],
                                      a    => [
                                                undef, '\'"', ',<', 'oO', ';:', undef
                                              ],
                                      b    => [
                                                'xX', 'dD', 'hH', 'mM', ( undef ) x 2
                                              ],
                                      c    => [
                                                'gG', '8*', '9(', 'rR', 'tT', 'hH'
                                              ],
                                      d    => [
                                                'iI', 'fF', 'gG', 'hH', 'bB', 'xX'
                                              ],
                                      e    => [
                                                'oO', '.>', 'pP', 'uU', 'jJ', 'qQ'
                                              ],
                                      f    => [
                                                'yY', '6^', '7&', 'gG', 'dD', 'iI'
                                              ],
                                      g    => [
                                                'fF', '7&', '8*', 'cC', 'hH', 'dD'
                                              ],
                                      h    => [
                                                'dD', 'gG', 'cC', 'tT', 'mM', 'bB'
                                              ],
                                      i    => [
                                                'uU', 'yY', 'fF', 'dD', 'xX', 'kK'
                                              ],
                                      j    => [
                                                'qQ', 'eE', 'uU', 'kK', ( undef ) x 2
                                              ],
                                      k    => [
                                                'jJ', 'uU', 'iI', 'xX', ( undef ) x 2
                                              ],
                                      l    => [
                                                'rR', '0)', '[{', '/?', 'sS', 'nN'
                                              ],
                                      m    => [
                                                'bB', 'hH', 'tT', 'wW', ( undef ) x 2
                                              ],
                                      n    => [
                                                'tT', 'rR', 'lL', 'sS', 'vV', 'wW'
                                              ],
                                      o    => [
                                                'aA', ',<', '.>', 'eE', 'qQ', ';:'
                                              ],
                                      p    => [
                                                '.>', '4$', '5%', 'yY', 'uU', 'eE'
                                              ],
                                      q    => [
                                                ';:', 'oO', 'eE', 'jJ', ( undef ) x 2
                                              ],
                                      r    => [
                                                'cC', '9(', '0)', 'lL', 'nN', 'tT'
                                              ],
                                      s    => [
                                                'nN', 'lL', '/?', '-_', 'zZ', 'vV'
                                              ],
                                      t    => [
                                                'hH', 'cC', 'rR', 'nN', 'wW', 'mM'
                                              ],
                                      u    => [
                                                'eE', 'pP', 'yY', 'iI', 'kK', 'jJ'
                                              ],
                                      v    => [
                                                'wW', 'nN', 'sS', 'zZ', ( undef ) x 2
                                              ],
                                      w    => [
                                                'mM', 'tT', 'nN', 'vV', ( undef ) x 2
                                              ],
                                      x    => [
                                                'kK', 'iI', 'dD', 'bB', ( undef ) x 2
                                              ],
                                      y    => [
                                                'pP', '5%', '6^', 'fF', 'iI', 'uU'
                                              ],
                                      z    => [
                                                'vV', 'sS', '-_', ( undef ) x 3
                                              ],
                                      "{"  => [
                                                '0)', ( undef ) x 2, ']}', '/?', 'lL'
                                              ],
                                      "|"  => [
                                                '=+', ( undef ) x 5
                                              ],
                                      "}"  => [
                                                '[{', ( undef ) x 3, '=+', '/?'
                                              ],
                                      "~"  => [
                                                ( undef ) x 3, '1!', ( undef ) x 2
                                              ]
                                    },
              starting_positions => 94
            },
  qwerty => {
              average_degree     => 4.59574468085106,
              keys               => {
                                      "!"  => [
                                                '`~', ( undef ) x 2, '2@', 'qQ', undef
                                              ],
                                      "\"" => [
                                                ';:', '[{', ']}', ( undef ) x 2, '/?'
                                              ],
                                      "#"  => [
                                                '2@', ( undef ) x 2, '4$', 'eE', 'wW'
                                              ],
                                      "\$" => [
                                                '3#', ( undef ) x 2, '5%', 'rR', 'eE'
                                              ],
                                      "%"  => [
                                                '4$', ( undef ) x 2, '6^', 'tT', 'rR'
                                              ],
                                      "&"  => [
                                                '6^', ( undef ) x 2, '8*', 'uU', 'yY'
                                              ],
                                      "'"  => [
                                                ';:', '[{', ']}', ( undef ) x 2, '/?'
                                              ],
                                      "("  => [
                                                '8*', ( undef ) x 2, '0)', 'oO', 'iI'
                                              ],
                                      ")"  => [
                                                '9(', ( undef ) x 2, '-_', 'pP', 'oO'
                                              ],
                                      "*"  => [
                                                '7&', ( undef ) x 2, '9(', 'iI', 'uU'
                                              ],
                                      "+"  => [
                                                '-_', ( undef ) x 3, ']}', '[{'
                                              ],
                                      ","  => [
                                                'mM', 'kK', 'lL', '.>', ( undef ) x 2
                                              ],
                                      "-"  => [
                                                '0)', ( undef ) x 2, '=+', '[{', 'pP'
                                              ],
                                      "."  => [
                                                ',<', 'lL', ';:', '/?', ( undef ) x 2
                                              ],
                                      "/"  => [
                                                '.>', ';:', '\'"', ( undef ) x 3
                                              ],
                                      0    => [
                                                '9(', ( undef ) x 2, '-_', 'pP', 'oO'
                                              ],
                                      1    => [
                                                '`~', ( undef ) x 2, '2@', 'qQ', undef
                                              ],
                                      2    => [
                                                '1!', ( undef ) x 2, '3#', 'wW', 'qQ'
                                              ],
                                      3    => [
                                                '2@', ( undef ) x 2, '4$', 'eE', 'wW'
                                              ],
                                      4    => [
                                                '3#', ( undef ) x 2, '5%', 'rR', 'eE'
                                              ],
                                      5    => [
                                                '4$', ( undef ) x 2, '6^', 'tT', 'rR'
                                              ],
                                      6    => [
                                                '5%', ( undef ) x 2, '7&', 'yY', 'tT'
                                              ],
                                      7    => [
                                                '6^', ( undef ) x 2, '8*', 'uU', 'yY'
                                              ],
                                      8    => [
                                                '7&', ( undef ) x 2, '9(', 'iI', 'uU'
                                              ],
                                      9    => [
                                                '8*', ( undef ) x 2, '0)', 'oO', 'iI'
                                              ],
                                      ":"  => [
                                                'lL', 'pP', '[{', '\'"', '/?', '.>'
                                              ],
                                      ";"  => [
                                                'lL', 'pP', '[{', '\'"', '/?', '.>'
                                              ],
                                      "<"  => [
                                                'mM', 'kK', 'lL', '.>', ( undef ) x 2
                                              ],
                                      "="  => [
                                                '-_', ( undef ) x 3, ']}', '[{'
                                              ],
                                      ">"  => [
                                                ',<', 'lL', ';:', '/?', ( undef ) x 2
                                              ],
                                      "?"  => [
                                                '.>', ';:', '\'"', ( undef ) x 3
                                              ],
                                      "\@" => [
                                                '1!', ( undef ) x 2, '3#', 'wW', 'qQ'
                                              ],
                                      A    => [
                                                undef, 'qQ', 'wW', 'sS', 'zZ', undef
                                              ],
                                      B    => [
                                                'vV', 'gG', 'hH', 'nN', ( undef ) x 2
                                              ],
                                      C    => [
                                                'xX', 'dD', 'fF', 'vV', ( undef ) x 2
                                              ],
                                      D    => [
                                                'sS', 'eE', 'rR', 'fF', 'cC', 'xX'
                                              ],
                                      E    => [
                                                'wW', '3#', '4$', 'rR', 'dD', 'sS'
                                              ],
                                      F    => [
                                                'dD', 'rR', 'tT', 'gG', 'vV', 'cC'
                                              ],
                                      G    => [
                                                'fF', 'tT', 'yY', 'hH', 'bB', 'vV'
                                              ],
                                      H    => [
                                                'gG', 'yY', 'uU', 'jJ', 'nN', 'bB'
                                              ],
                                      I    => [
                                                'uU', '8*', '9(', 'oO', 'kK', 'jJ'
                                              ],
                                      J    => [
                                                'hH', 'uU', 'iI', 'kK', 'mM', 'nN'
                                              ],
                                      K    => [
                                                'jJ', 'iI', 'oO', 'lL', ',<', 'mM'
                                              ],
                                      L    => [
                                                'kK', 'oO', 'pP', ';:', '.>', ',<'
                                              ],
                                      M    => [
                                                'nN', 'jJ', 'kK', ',<', ( undef ) x 2
                                              ],
                                      N    => [
                                                'bB', 'hH', 'jJ', 'mM', ( undef ) x 2
                                              ],
                                      O    => [
                                                'iI', '9(', '0)', 'pP', 'lL', 'kK'
                                              ],
                                      P    => [
                                                'oO', '0)', '-_', '[{', ';:', 'lL'
                                              ],
                                      Q    => [
                                                undef, '1!', '2@', 'wW', 'aA', undef
                                              ],
                                      R    => [
                                                'eE', '4$', '5%', 'tT', 'fF', 'dD'
                                              ],
                                      S    => [
                                                'aA', 'wW', 'eE', 'dD', 'xX', 'zZ'
                                              ],
                                      T    => [
                                                'rR', '5%', '6^', 'yY', 'gG', 'fF'
                                              ],
                                      U    => [
                                                'yY', '7&', '8*', 'iI', 'jJ', 'hH'
                                              ],
                                      V    => [
                                                'cC', 'fF', 'gG', 'bB', ( undef ) x 2
                                              ],
                                      W    => [
                                                'qQ', '2@', '3#', 'eE', 'sS', 'aA'
                                              ],
                                      X    => [
                                                'zZ', 'sS', 'dD', 'cC', ( undef ) x 2
                                              ],
                                      Y    => [
                                                'tT', '6^', '7&', 'uU', 'hH', 'gG'
                                              ],
                                      Z    => [
                                                undef, 'aA', 'sS', 'xX', ( undef ) x 2
                                              ],
                                      "["  => [
                                                'pP', '-_', '=+', ']}', '\'"', ';:'
                                              ],
                                      "\\" => [
                                                ']}', ( undef ) x 5
                                              ],
                                      "]"  => [
                                                '[{', '=+', undef, '\\|', undef, '\'"'
                                              ],
                                      "^"  => [
                                                '5%', ( undef ) x 2, '7&', 'yY', 'tT'
                                              ],
                                      _    => [
                                                '0)', ( undef ) x 2, '=+', '[{', 'pP'
                                              ],
                                      "`"  => [
                                                ( undef ) x 3, '1!', ( undef ) x 2
                                              ],
                                      a    => [
                                                undef, 'qQ', 'wW', 'sS', 'zZ', undef
                                              ],
                                      b    => [
                                                'vV', 'gG', 'hH', 'nN', ( undef ) x 2
                                              ],
                                      c    => [
                                                'xX', 'dD', 'fF', 'vV', ( undef ) x 2
                                              ],
                                      d    => [
                                                'sS', 'eE', 'rR', 'fF', 'cC', 'xX'
                                              ],
                                      e    => [
                                                'wW', '3#', '4$', 'rR', 'dD', 'sS'
                                              ],
                                      f    => [
                                                'dD', 'rR', 'tT', 'gG', 'vV', 'cC'
                                              ],
                                      g    => [
                                                'fF', 'tT', 'yY', 'hH', 'bB', 'vV'
                                              ],
                                      h    => [
                                                'gG', 'yY', 'uU', 'jJ', 'nN', 'bB'
                                              ],
                                      i    => [
                                                'uU', '8*', '9(', 'oO', 'kK', 'jJ'
                                              ],
                                      j    => [
                                                'hH', 'uU', 'iI', 'kK', 'mM', 'nN'
                                              ],
                                      k    => [
                                                'jJ', 'iI', 'oO', 'lL', ',<', 'mM'
                                              ],
                                      l    => [
                                                'kK', 'oO', 'pP', ';:', '.>', ',<'
                                              ],
                                      m    => [
                                                'nN', 'jJ', 'kK', ',<', ( undef ) x 2
                                              ],
                                      n    => [
                                                'bB', 'hH', 'jJ', 'mM', ( undef ) x 2
                                              ],
                                      o    => [
                                                'iI', '9(', '0)', 'pP', 'lL', 'kK'
                                              ],
                                      p    => [
                                                'oO', '0)', '-_', '[{', ';:', 'lL'
                                              ],
                                      q    => [
                                                undef, '1!', '2@', 'wW', 'aA', undef
                                              ],
                                      r    => [
                                                'eE', '4$', '5%', 'tT', 'fF', 'dD'
                                              ],
                                      s    => [
                                                'aA', 'wW', 'eE', 'dD', 'xX', 'zZ'
                                              ],
                                      t    => [
                                                'rR', '5%', '6^', 'yY', 'gG', 'fF'
                                              ],
                                      u    => [
                                                'yY', '7&', '8*', 'iI', 'jJ', 'hH'
                                              ],
                                      v    => [
                                                'cC', 'fF', 'gG', 'bB', ( undef ) x 2
                                              ],
                                      w    => [
                                                'qQ', '2@', '3#', 'eE', 'sS', 'aA'
                                              ],
                                      x    => [
                                                'zZ', 'sS', 'dD', 'cC', ( undef ) x 2
                                              ],
                                      y    => [
                                                'tT', '6^', '7&', 'uU', 'hH', 'gG'
                                              ],
                                      z    => [
                                                undef, 'aA', 'sS', 'xX', ( undef ) x 2
                                              ],
                                      "{"  => [
                                                'pP', '-_', '=+', ']}', '\'"', ';:'
                                              ],
                                      "|"  => [
                                                ']}', ( undef ) x 5
                                              ],
                                      "}"  => [
                                                '[{', '=+', undef, '\\|', undef, '\'"'
                                              ],
                                      "~"  => [
                                                ( undef ) x 3, '1!', ( undef ) x 2
                                              ]
                                    },
              starting_positions => 94
            }
)
;

1;
