package DB::Pluggable::Role::WatchFunction;
use strict;
use warnings;
use 5.010;
use Role::Basic;
with qw(Brickyard::Role::Plugin);
requires qw(watchfunction);
our $VERSION = '1.12';
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

DB::Pluggable::Role::WatchFunction

=head1 VERSION

version 1.12

=for stopwords watchfunction

=head1 NAME

DB::Pluggable::Role::WatchFunction - Do something during the debugger's watchfunction()

=head1 IMPLEMENTING

The C<WatchFunction> role indicates that a plugin wants to do
something during the debugger's C<watchfunction()> function. The
plugin must provide the C<watchfunction()> method.

=head1 AUTHORS

=over 4

=item *

Keith Carangelo <mail@kcaran.com>

=item *

Marcel Gruenauer <marcel@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2008 by Marcel Gruenauer <marcel@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
