/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.PIGrabber;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.StylesheetSpaceStrippingRule;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.value.DecimalValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStylesheet
extends Executable
implements Templates,
Serializable {
    private CompilerInfo compilerInfo;
    private transient StyleNodeFactory nodeFactory;
    private int errorCount = 0;
    private HashMap<URI, PreparedStylesheet> nextStylesheetCache;
    private DecimalFormatManager decimalFormatManager;
    private RuleManager ruleManager;
    private HashMap<StructuredQName, Template> namedTemplateTable;
    private boolean usesTunnel = false;

    protected PreparedStylesheet(Configuration config, CompilerInfo info) {
        super(config);
        this.nodeFactory = config.makeStyleNodeFactory();
        this.nodeFactory.setXsltProcessorVersion(info.getXsltVersion());
        RuleManager rm = new RuleManager();
        rm.setRecoveryPolicy(info.getRecoveryPolicy());
        this.setRuleManager(rm);
        this.setHostLanguage(50, info.getXsltVersion().equals(DecimalValue.THREE));
        this.setCollationMap(new CollationMap(config.getCollationMap()));
        this.setSchemaAware(info.isSchemaAware());
        this.compilerInfo = info;
        if (this.compilerInfo.getErrorListener() == null) {
            this.compilerInfo.setErrorListener(config.getErrorListener());
        }
    }

    public static PreparedStylesheet compile(Source source, Configuration config, CompilerInfo info) throws TransformerConfigurationException {
        PreparedStylesheet pss = new PreparedStylesheet(config, info);
        pss.prepare(source);
        return pss;
    }

    @Override
    public Transformer newTransformer() {
        Controller c = new Controller(this.getConfiguration(), this);
        c.setPreparedStylesheet(this);
        if (this.compilerInfo.getDefaultInitialTemplate() != null) {
            try {
                c.setInitialTemplate(this.compilerInfo.getDefaultInitialTemplate().getClarkName());
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        if (this.compilerInfo.getDefaultInitialMode() != null) {
            c.setInitialMode(this.compilerInfo.getDefaultInitialMode().getClarkName());
        }
        return c;
    }

    @Override
    public void setConfiguration(Configuration config) {
        super.setConfiguration(config);
        this.compilerInfo = config.getDefaultXsltCompilerInfo();
    }

    public StyleNodeFactory getStyleNodeFactory() {
        return this.nodeFactory;
    }

    public void setDecimalFormatManager(DecimalFormatManager dfm) {
        this.decimalFormatManager = dfm;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setUsesTunnelParameters() {
        this.usesTunnel = true;
    }

    public boolean usesTunnelParameters() {
        return this.usesTunnel;
    }

    protected void prepare(Source styleSource) throws TransformerConfigurationException {
        block5: {
            try {
                DocumentImpl doc = this.loadStylesheetModule(styleSource);
                this.setStylesheetDocument(doc);
            }
            catch (XPathException e) {
                try {
                    this.compilerInfo.getErrorListener().fatalError(e);
                }
                catch (TransformerException e2) {
                    // empty catch block
                }
                if (this.errorCount != 0) break block5;
                ++this.errorCount;
            }
        }
        if (this.errorCount > 0) {
            throw new TransformerConfigurationException("Failed to compile stylesheet. " + this.errorCount + (this.errorCount == 1 ? " error " : " errors ") + "detected.");
        }
    }

    public DocumentImpl loadStylesheetModule(Source styleSource) throws XPathException {
        ParseOptions options;
        StyleNodeFactory nodeFactory = this.getStyleNodeFactory();
        PipelineConfiguration pipe = this.getConfiguration().makePipelineConfiguration();
        LinkedTreeBuilder styleBuilder = new LinkedTreeBuilder(pipe);
        pipe.setURIResolver(this.compilerInfo.getURIResolver());
        styleBuilder.setSystemId(styleSource.getSystemId());
        styleBuilder.setNodeFactory(nodeFactory);
        styleBuilder.setLineNumbering(true);
        UseWhenFilter useWhenFilter = new UseWhenFilter(styleBuilder);
        StartTagBuffer startTagBuffer = new StartTagBuffer(useWhenFilter);
        useWhenFilter.setStartTagBuffer(startTagBuffer);
        StylesheetSpaceStrippingRule rule = new StylesheetSpaceStrippingRule(this.getConfiguration().getNamePool());
        Stripper styleStripper = new Stripper(rule, startTagBuffer);
        CommentStripper commentStripper = new CommentStripper(styleStripper);
        if (styleSource instanceof AugmentedSource) {
            options = ((AugmentedSource)styleSource).getParseOptions();
            styleSource = ((AugmentedSource)styleSource).getContainedSource();
        } else {
            options = new ParseOptions();
        }
        options.setSchemaValidationMode(4);
        options.setDTDValidationMode(4);
        options.setLineNumbering(true);
        options.setStripSpace(0);
        if (options.getXMLReader() == null && Configuration.getPlatform().isJava()) {
            XMLReader styleParser = this.getConfiguration().getStyleParser();
            options.setXMLReader(styleParser);
            Sender.send(styleSource, commentStripper, options);
            this.getConfiguration().reuseStyleParser(styleParser);
        } else {
            Sender.send(styleSource, commentStripper, options);
        }
        DocumentImpl doc = (DocumentImpl)styleBuilder.getCurrentRoot();
        styleBuilder.reset();
        if (options.isPleaseCloseAfterUse()) {
            ParseOptions.close(styleSource);
        }
        return doc;
    }

    protected void setStylesheetDocument(DocumentImpl doc) throws XPathException {
        DocumentImpl styleDoc = doc;
        StyleElement topnode = (StyleElement)styleDoc.getDocumentElement();
        if (topnode instanceof LiteralResultElement) {
            styleDoc = ((LiteralResultElement)topnode).makeStylesheet(this);
        }
        if (!(styleDoc.getDocumentElement() instanceof XSLStylesheet)) {
            throw new XPathException("Outermost element of stylesheet is not xsl:stylesheet or xsl:transform or literal result element");
        }
        XSLStylesheet top = (XSLStylesheet)styleDoc.getDocumentElement();
        if (this.compilerInfo.isVersionWarning() && top.getEffectiveVersion().compareTo(this.getStyleNodeFactory().getXsltProcessorVersion()) != 0) {
            try {
                TransformerException w = new TransformerException("Running an XSLT " + top.getEffectiveVersion() + " stylesheet with an XSLT " + this.getStyleNodeFactory().getXsltProcessorVersion() + " processor");
                w.setLocator(topnode);
                this.getConfiguration().getErrorListener().warning(w);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        if (this.getStyleNodeFactory().getXsltProcessorVersion().compareTo(DecimalValue.TWO) > 0) {
            this.getConfiguration().checkLicensedFeature(8, "XSLT 3.0");
        }
        PrincipalStylesheetModule psm = new PrincipalStylesheetModule(top, 0);
        psm.setPreparedStylesheet(this);
        psm.setVersion(top.getAttributeValue("version"));
        psm.createFunctionLibrary(this.compilerInfo);
        top.setPrincipalStylesheetModule(psm);
        try {
            psm.preprocess();
        }
        catch (XPathException e) {
            Throwable e2 = e.getException();
            if (e2 instanceof XPathException) {
                try {
                    this.compilerInfo.getErrorListener().fatalError((XPathException)e2);
                }
                catch (TransformerException e3) {
                    // empty catch block
                }
            }
            throw e;
        }
        psm.compileStylesheet();
    }

    public void setRuleManager(RuleManager rm) {
        this.ruleManager = rm;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public Template getNamedTemplate(StructuredQName qName) {
        if (this.namedTemplateTable == null) {
            return null;
        }
        return this.namedTemplateTable.get(qName);
    }

    public void putNamedTemplate(StructuredQName templateName, Template template) {
        if (this.namedTemplateTable == null) {
            this.namedTemplateTable = new HashMap(32);
        }
        this.namedTemplateTable.put(templateName, template);
    }

    public Iterator<Template> iterateNamedTemplates() {
        if (this.namedTemplateTable == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.namedTemplateTable.values().iterator();
    }

    public void explainNamedTemplates(ExpressionPresenter presenter) {
        presenter.startElement("namedTemplates");
        if (this.namedTemplateTable != null) {
            for (Template t : this.namedTemplateTable.values()) {
                presenter.startElement("template");
                presenter.emitAttribute("name", t.getTemplateName().getDisplayName());
                presenter.emitAttribute("line", t.getLineNumber() + "");
                presenter.emitAttribute("module", t.getSystemId());
                if (t.getBody() != null) {
                    t.getBody().explain(presenter);
                }
                presenter.endElement();
            }
        }
        presenter.endElement();
    }

    public boolean isCompileWithTracing() {
        return this.compilerInfo.isCompileWithTracing();
    }

    @Override
    public Properties getOutputProperties() {
        Properties details = this.getDefaultOutputProperties();
        return new Properties(details);
    }

    public void reportError(TransformerException err) throws TransformerException {
        if (err instanceof XPathException) {
            if (!((XPathException)err).hasBeenReported()) {
                ++this.errorCount;
                try {
                    this.compilerInfo.getErrorListener().fatalError(err);
                    ((XPathException)err).setHasBeenReported(true);
                }
                catch (Exception exception) {}
            } else if (this.errorCount == 0) {
                ++this.errorCount;
            }
        } else {
            ++this.errorCount;
            this.compilerInfo.getErrorListener().fatalError(err);
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void reportWarning(TransformerException err) {
        try {
            this.compilerInfo.getErrorListener().warning(err);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public PreparedStylesheet getCachedStylesheet(String href, String baseURI) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException err) {
            // empty catch block
        }
        PreparedStylesheet result = null;
        if (abs != null && this.nextStylesheetCache != null) {
            result = this.nextStylesheetCache.get(abs);
        }
        return result;
    }

    public void putCachedStylesheet(String href, String baseURI, PreparedStylesheet pss) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException err) {
            // empty catch block
        }
        if (abs != null) {
            if (this.nextStylesheetCache == null) {
                this.nextStylesheetCache = new HashMap(4);
            }
            this.nextStylesheetCache.put(abs, pss);
        }
    }

    public CompilerInfo getCompilerInfo() {
        return this.compilerInfo;
    }

    public void explain(ExpressionPresenter presenter) {
        presenter.startElement("stylesheet");
        this.getKeyManager().explainKeys(presenter);
        this.explainGlobalVariables(presenter);
        this.ruleManager.explainTemplateRules(presenter);
        this.explainNamedTemplates(presenter);
        FunctionLibraryList libList = this.getFunctionLibrary();
        List<FunctionLibrary> libraryList = libList.getLibraryList();
        presenter.startElement("functions");
        for (FunctionLibrary lib : libraryList) {
            if (!(lib instanceof ExecutableFunctionLibrary)) continue;
            Iterator<UserFunction> f = ((ExecutableFunctionLibrary)lib).iterateFunctions();
            while (f.hasNext()) {
                UserFunction func = f.next();
                presenter.startElement("function");
                presenter.emitAttribute("name", func.getFunctionName().getDisplayName());
                presenter.emitAttribute("line", func.getLineNumber() + "");
                presenter.emitAttribute("module", func.getSystemId());
                func.getBody().explain(presenter);
                presenter.endElement();
            }
        }
        presenter.endElement();
        presenter.endElement();
    }

    public static Source getAssociatedStylesheet(Configuration config, Source source, String media, String title, String charset) throws TransformerConfigurationException {
        PIGrabber grabber;
        block6: {
            grabber = new PIGrabber(new Sink(config.makePipelineConfiguration()));
            grabber.setFactory(config);
            grabber.setCriteria(media, title);
            grabber.setBaseURI(source.getSystemId());
            grabber.setURIResolver(config.getURIResolver());
            try {
                Sender.send(source, grabber, null);
            }
            catch (XPathException err) {
                if (grabber.isTerminated()) break block6;
                throw new TransformerConfigurationException("Failed while looking for xml-stylesheet PI", err);
            }
        }
        try {
            Source[] sources = grabber.getAssociatedStylesheets();
            if (sources == null) {
                throw new TransformerConfigurationException("No matching <?xml-stylesheet?> processing instruction found");
            }
            return PreparedStylesheet.compositeStylesheet(config, source.getSystemId(), sources);
        }
        catch (TransformerException err) {
            if (err instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)err;
            }
            throw new TransformerConfigurationException(err);
        }
    }

    private static Source compositeStylesheet(Configuration config, String baseURI, Source[] sources) throws TransformerConfigurationException {
        if (sources.length == 1) {
            return sources[0];
        }
        if (sources.length == 0) {
            throw new TransformerConfigurationException("No stylesheets were supplied");
        }
        StringBuilder sb = new StringBuilder(250);
        sb.append("<xsl:stylesheet version='1.0' ");
        sb.append(" xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
        for (Source source : sources) {
            sb.append("<xsl:import href='").append(source.getSystemId()).append("'/>");
        }
        sb.append("</xsl:stylesheet>");
        InputSource composite = new InputSource();
        composite.setSystemId(baseURI);
        composite.setCharacterStream(new StringReader(sb.toString()));
        return new SAXSource(config.getSourceParser(), composite);
    }
}

