##############################################################################
# Games::Roshambo::Thrownames - Throw names and actions.
# v1.00
# Copyright (c) 2007 Chris Thompson
##############################################################################
package Games::Roshambo::Thrownames;
$VERSION ="1.00";
use warnings;
use strict;

sub getnames {
	my $gametype = shift;
	
	my $names = {
		"3" => {"_names" => [qw(Zero Rock Scissors Paper)],
				"ROCK" => 1,
				"SCISSORS" => 2,
				"PAPER" => 3,
				"_actions" => { 
					"1" => {
						"2" => "breaks"
					},
					"2" => {
						"3" => "cuts"
					},
					"3" => {
						"1" => "covers"
					}
			 	}
				},
		"101" => { 
				"DYNAMITE" => 1, 
				"TORNADO" => 2, 
				"QUICKSAND" => 3, 
				"PIT" => 4, 
				"CHAIN" => 5, 
				"GUN" => 6, 
				"LAW" => 7, 
				"WHIP" => 8, 
				"SWORD" => 9, 
				"ROCK" => 10, 
				"DEATH" => 11, 
				"WALL" => 12, 
				"SUN" => 13, 
				"CAMERA" => 14, 
				"FIRE" => 15, 
				"CHAINSAW" => 16, 
				"SCHOOL" => 17, 
				"SCISSORS" => 18, 
				"POISON" => 19, 
				"CAGE" => 20, 
				"AXE" => 21, 
				"PEACE" => 22, 
				"COMPUTER" => 23, 
				"CASTLE" => 24, 
				"SNAKE" => 25, 
				"BLOOD" => 26, 
				"PORCUPINE" => 27, 
				"VULTURE" => 28, 
				"MONKEY" => 29, 
				"KING" => 30, 
				"QUEEN" => 31, 
				"PRINCE" => 32, 
				"PRINCESS" => 33, 
				"POLICE" => 34, 
				"WOMAN" => 35, 
				"BABY" => 36, 
				"MAN" => 37, 
				"HOME" => 38, 
				"TRAIN" => 39, 
				"CAR" => 40, 
				"NOISE" => 41, 
				"BICYCLE" => 42, 
				"TREE" => 43, 
				"TURNIP" => 44, 
				"DUCK" => 45, 
				"WOLF" => 46, 
				"CAT" => 47, 
				"BIRD" => 48, 
				"FISH" => 49, 
				"SPIDER" => 50, 
				"COCKROACH" => 51, 
				"BRAIN" => 52, 
				"COMMUNITY" => 53, 
				"CROSS" => 54, 
				"MONEY" => 55, 
				"VAMPIRE" => 56, 
				"SPONGE" => 57, 
				"CHURCH" => 58, 
				"BUTTER" => 59, 
				"BOOK" => 60, 
				"PAPER" => 61, 
				"CLOUD" => 62, 
				"AIRPLANE" => 63, 
				"MOON" => 64, 
				"GRASS" => 65, 
				"FILM" => 66, 
				"TOILET" => 67, 
				"AIR" => 68, 
				"PLANET" => 69, 
				"GUITAR" => 70, 
				"BOWL" => 71, 
				"CUP" => 72, 
				"BEER" => 73, 
				"RAIN" => 74, 
				"WATER" => 75, 
				"TV" => 76, 
				"RAINBOW" => 77, 
				"UFO" => 78, 
				"ALIEN" => 79, 
				"PRAYER" => 80, 
				"MOUNTAIN" => 81, 
				"SATAN" => 82, 
				"DRAGON" => 83, 
				"DIAMOND" => 84, 
				"PLATINUM" => 85, 
				"GOLD" => 86, 
				"DEVIL" => 87, 
				"FENCE" => 88, 
				"VIDEOGAME" => 89, 
				"MATH" => 90, 
				"ROBOT" => 91, 
				"HEART" => 92, 
				"ELECTRICITY" => 93, 
				"LIGHTNING" => 94, 
				"MEDUSA" => 95, 
				"POWER" => 96, 
				"LASER" => 97, 
				"NUKE" => 98, 
				"SKY" => 99, 
				"TANK" => 100, 
				"HELICOPTER" => 101, 
				_names => [qw(Zero Dynamite Tornado Quicksand Pit Chain Gun Law Whip Sword Rock Death Wall Sun Camera Fire Chainsaw School Scissors Poison Cage Axe Peace Computer Castle Snake Blood Porcupine Vulture Monkey King Queen Prince Princess Police Woman Baby Man Home Train Car Noise Bicycle Tree Turnip Duck Wolf Cat Bird Fish Spider Cockroach Brain Community Cross Money Vampire Sponge Church Butter Book Paper Cloud Airplane Moon Grass Film Toilet Air Planet Guitar Bowl Cup Beer Rain Water TV Rainbow UFO Alien Prayer Mountain Satan Dragon Diamond Platinum Gold Devil Fence Videogame Math Robot Heart Electricity Lightning Medusa Power Laser Nuke Sky Tank Helicopter )],
"_actions" => {
          '33' => {
                    '67' => 'uses',
                    '63' => 'flies on',
                    '71' => 'eats from',
                    '70' => 'plays',
                    '80' => 'in',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'eats',
                    '82' => 'enthralls',
                    '55' => 'has',
                    '74' => 'walks in',
                    '83' => 'subdues',
                    '75' => 'drinks',
                    '57' => 'owns',
                    '40' => 'rides in',
                    '61' => 'writes',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '35' => 'rules',
                    '53' => 'rules',
                    '78' => 'disbelieves',
                    '79' => 'disbelieves',
                    '48' => 'eats',
                    '42' => 'rides',
                    '77' => 'looks at',
                    '46' => 'tames',
                    '65' => 'walks on',
                    '50' => 'steps on',
                    '39' => 'rides on',
                    '36' => 'has',
                    '64' => 'looks at',
                    '51' => 'steps on',
                    '41' => 'makes',
                    '58' => 'attends',
                    '47' => 'owns',
                    '81' => 'climbs',
                    '38' => 'lives in',
                    '52' => 'has',
                    '60' => 'inspires',
                    '34' => 'governs',
                    '56' => 'could be',
                    '73' => 'drinks',
                    '66' => 'inspires',
                    '45' => 'eats',
                    '37' => 'rules',
                    '76' => 'on',
                    '43' => 'owns',
                    '62' => 'looks at',
                    '54' => 'acts'
                  },
          '32' => {
                    '67' => 'uses',
                    '33' => 'rules over',
                    '63' => 'flies on',
                    '71' => 'eats from',
                    '70' => 'plays',
                    '80' => 'in',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'eats',
                    '82' => 'of darkness is',
                    '55' => 'has',
                    '74' => 'walks in',
                    '75' => 'drinks',
                    '57' => 'owns',
                    '40' => 'rides in',
                    '61' => 'writes',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '35' => 'rules',
                    '53' => 'rules',
                    '78' => 'disbelieves',
                    '79' => 'disbelieves',
                    '48' => 'eats',
                    '42' => 'rides',
                    '77' => 'looks at',
                    '46' => 'tames',
                    '65' => 'walks on',
                    '50' => 'steps on',
                    '39' => 'rides on',
                    '36' => 'sires',
                    '64' => 'looks at',
                    '51' => 'steps on',
                    '41' => 'makes',
                    '58' => 'attends',
                    '47' => 'owns',
                    '81' => 'climbs',
                    '38' => 'lives in',
                    '52' => 'has',
                    '60' => 'inspires',
                    '34' => 'governs',
                    '56' => 'could be',
                    '73' => 'drinks',
                    '66' => 'inspires',
                    '45' => 'eats',
                    '37' => 'rules',
                    '76' => 'on',
                    '43' => 'owns',
                    '62' => 'looks at',
                    '54' => 'wears'
                  },
          '90' => {
                    '33' => 'confuses',
                    '32' => 'confuses',
                    '21' => 'whiz sharper than',
                    '7' => 'formulates',
                    '26' => 'calculates',
                    '17' => 'bores',
                    '2' => 'predicts',
                    '1' => 'measures',
                    '99' => 'class denies',
                    '18' => 'guides',
                    '30' => 'confuses',
                    '16' => 'directs',
                    '100' => 'navigates',
                    '27' => 'counts',
                    '25' => 'measures',
                    '28' => 'test attracts',
                    '95' => 'confuses',
                    '20' => 'mental',
                    '14' => 'shapes',
                    '92' => 'darkens',
                    '24' => 'measures',
                    '10' => 'schoolhouse',
                    '31' => 'confuses',
                    '35' => 'confuses',
                    '11' => 'transcends',
                    '91' => 'navigates',
                    '22' => 'prevents',
                    '93' => 'calculates',
                    '13' => 'calculates',
                    '23' => 'on',
                    '29' => 'enrages',
                    '96' => 'brain',
                    '6' => 'test inspires',
                    '39' => 'word problem w/',
                    '36' => 'confuses',
                    '3' => 'test like',
                    '97' => 'formulates',
                    '94' => 'calculates',
                    '9' => 'measures',
                    '12' => 'measures',
                    '15' => 'measures',
                    '38' => 'after',
                    '8' => 'whiz sharp as',
                    '4' => 'is the',
                    '98' => 'formulates',
                    '34' => 'confuses',
                    '37' => 'confuses',
                    '101' => 'navigates',
                    '19' => 'mental',
                    '5' => 'uses number'
                  },
          '63' => {
                    '67' => 'has',
                    '90' => 'pilot uses',
                    '71' => 'carries',
                    '70' => 'carries',
                    '7' => 'has many',
                    '80' => 'inspires',
                    '68' => 'flies through',
                    '2' => 'flies over',
                    '1' => 'flies over',
                    '99' => 'traverses',
                    '88' => 'flies over',
                    '72' => 'carries',
                    '100' => 'flies over',
                    '82' => 'scarier than',
                    '84' => 'pricier than',
                    '74' => 'flies over',
                    '95' => 'flies over',
                    '83' => 'faster than',
                    '75' => 'has',
                    '92' => 'stops',
                    '69' => 'travels',
                    '89' => 'in',
                    '10' => 'flies over',
                    '11' => 'can cause',
                    '91' => 'has',
                    '78' => 'spots',
                    '79' => 'spots',
                    '87' => 'scarier than',
                    '77' => 'flies over',
                    '93' => 'uses',
                    '96' => 'consumes',
                    '65' => 'flies over',
                    '6' => 'bans',
                    '85' => 'pricier than',
                    '3' => 'flies over',
                    '64' => 'eclipses',
                    '97' => 'carries',
                    '94' => 'attracts',
                    '9' => 'bans',
                    '12' => 'flies over',
                    '8' => 'bans',
                    '81' => 'flies over',
                    '4' => 'flies over',
                    '98' => 'carries',
                    '101' => 'outflies',
                    '73' => 'serves',
                    '66' => 'shows',
                    '76' => 'has',
                    '86' => 'pricier than',
                    '5' => 'flies over'
                  },
          '21' => {
                    '67' => 'smashes',
                    '33' => 'cleaves',
                    '32' => 'cleaves',
                    '63' => 'terrorizes',
                    '71' => 'chops',
                    '70' => 'chops',
                    '68' => 'flies through',
                    '26' => 'splatters',
                    '30' => 'cleaves',
                    '44' => 'chops',
                    '55' => 'costs',
                    '25' => 'chops',
                    '27' => 'chops',
                    '28' => 'chops',
                    '57' => 'chops',
                    '40' => 'chops',
                    '61' => 'chops',
                    '69' => 'changes',
                    '59' => 'chops',
                    '49' => 'chops',
                    '24' => 'sieges',
                    '31' => 'cleaves',
                    '35' => 'cleaves',
                    '53' => 'clears way for',
                    '48' => 'chops',
                    '22' => 'disturbs',
                    '42' => 'chops',
                    '46' => 'cleaves',
                    '23' => 'chops',
                    '65' => 'chops',
                    '29' => 'cleaves',
                    '50' => 'chops',
                    '39' => 'holds up',
                    '64' => 'reflects',
                    '36' => 'hurts',
                    '51' => 'chops',
                    '58' => 'terrorizes',
                    '41' => 'makes',
                    '47' => 'chops',
                    '38' => 'terrorizes',
                    '52' => 'cleaves',
                    '60' => 'chops',
                    '34' => 'cleaves',
                    '56' => 'beheads',
                    '66' => 'chops',
                    '37' => 'cleaves',
                    '45' => 'chops',
                    '43' => 'chops down',
                    '62' => 'creates blood',
                    '54' => 'chops down'
                  },
          '71' => {
                    '90' => 'parabolic',
                    '7' => 'knows no',
                    '80' => 'blesses',
                    '17' => '-ing after',
                    '2' => 'shaped',
                    '1' => 'splashes',
                    '99' => 'shaped',
                    '18' => 'splashes',
                    '88' => 'sits on',
                    '72' => 'bigger than',
                    '16' => 'splashes',
                    '100' => 'turreted',
                    '82' => 'blesses',
                    '74' => 'catches',
                    '84' => 'holds',
                    '95' => 'drowns',
                    '75' => 'holds',
                    '83' => 'drowns',
                    '20' => 'rattles',
                    '14' => 'lensed',
                    '92' => 'holds',
                    '89' => '-ing',
                    '10' => 'made of',
                    '11' => 'blessing transcends',
                    '91' => 'splashes',
                    '78' => 'shapes',
                    '79' => 'shapes',
                    '87' => 'blesses',
                    '77' => 'reflects',
                    '93' => 'focuses',
                    '13' => 'focuses',
                    '96' => 'focuses',
                    '6' => 'splashes',
                    '85' => 'made of',
                    '3' => 'floats on',
                    '94' => 'focuses',
                    '97' => 'reflects',
                    '9' => 'splashes',
                    '12' => 'smashes against',
                    '15' => 'snuffs out',
                    '8' => 'resists',
                    '81' => 'holds food',
                    '4' => 'emerges from well',
                    '98' => 'encases core of',
                    '73' => '-ing inspires',
                    '101' => 'shaped',
                    '19' => 'holds',
                    '86' => 'made of',
                    '76' => 'sits on',
                    '5' => 'holds'
                  },
          '7' => {
                   '33' => 'protects',
                   '32' => 'protects',
                   '21' => 'makes',
                   '26' => 'protects',
                   '17' => 'provides',
                   '18' => 'makes',
                   '30' => 'protects',
                   '16' => 'makes',
                   '44' => 'protects',
                   '55' => 'costs',
                   '27' => 'protects',
                   '25' => 'protects',
                   '28' => 'protects',
                   '57' => 'cleans like',
                   '40' => 'protects',
                   '14' => 'restricts',
                   '20' => 'puts you in',
                   '49' => 'protects',
                   '24' => 'protects',
                   '10' => 'set in stone',
                   '31' => 'protects',
                   '35' => 'protects',
                   '11' => 'prevents',
                   '53' => 'protects',
                   '48' => 'protects',
                   '42' => 'makes',
                   '22' => 'keeps',
                   '46' => 'protects',
                   '13' => 'explains',
                   '23' => 'restricts',
                   '29' => 'protects',
                   '50' => 'protects rare',
                   '39' => 'protects',
                   '36' => 'protects',
                   '51' => 'kills',
                   '9' => 'restricts',
                   '41' => 'restricts',
                   '12' => 'protects',
                   '47' => 'protects',
                   '15' => 'restricts',
                   '52' => 'confounds',
                   '8' => 'restricts',
                   '38' => 'protects',
                   '34' => 'protects',
                   '56' => 'chases',
                   '45' => 'protects',
                   '37' => 'protects',
                   '43' => 'protects',
                   '19' => 'restricts',
                   '54' => 'respects'
                 },
          '80' => {
                    '21' => 'against',
                    '90' => 'for',
                    '7' => 'for fair',
                    '26' => 'calms',
                    '17' => 'starts',
                    '2' => 'against',
                    '1' => 'against',
                    '99' => 'to',
                    '18' => 'for straight',
                    '88' => 'knows no',
                    '16' => 'against',
                    '100' => 'against',
                    '82' => 'casts out',
                    '27' => 'protects like',
                    '25' => 'rebukes',
                    '84' => 'for',
                    '28' => 'dispels',
                    '83' => 'subdues',
                    '95' => 'dispels',
                    '20' => 'in',
                    '14' => 'not captured on',
                    '92' => 'heals',
                    '24' => 'in',
                    '89' => 'to win',
                    '10' => 'atop',
                    '11' => 'against',
                    '91' => 'routine like',
                    '22' => 'brings',
                    '87' => 'casts out',
                    '93' => 'for low',
                    '23' => 'salvages',
                    '13' => 'for',
                    '29' => 'confuses',
                    '96' => 'is spiritual',
                    '6' => 'against',
                    '85' => 'for',
                    '3' => 'solidifies',
                    '97' => 'more accurate than',
                    '94' => 'faster than',
                    '9' => 'against',
                    '12' => 'knows no',
                    '15' => 'against',
                    '81' => 'atop',
                    '8' => 'against',
                    '98' => 'against',
                    '4' => 'in',
                    '101' => 'against',
                    '19' => 'heals',
                    '86' => 'for',
                    '5' => 'breaks'
                  },
          '26' => {
                    '67' => 'fills',
                    '33' => 'powers',
                    '32' => 'powers',
                    '63' => 'turns around',
                    '71' => 'drips in',
                    '70' => 'stains',
                    '68' => 'consumes',
                    '72' => 'drips in',
                    '30' => 'powers',
                    '44' => 'stains',
                    '55' => 'bloodmoney',
                    '74' => 'flows like',
                    '27' => 'powers',
                    '28' => 'powers',
                    '75' => 'thicker than',
                    '57' => 'stains',
                    '40' => 'stains',
                    '61' => 'stains',
                    '69' => 'red',
                    '59' => 'stains',
                    '49' => 'powers',
                    '31' => 'powers',
                    '35' => 'powers',
                    '53' => 'donations for',
                    '48' => 'powers',
                    '42' => 'stains',
                    '46' => 'powers',
                    '65' => 'covers',
                    '29' => 'powers',
                    '50' => 'powers',
                    '39' => 'coarses like',
                    '64' => 'red',
                    '36' => 'powers',
                    '51' => 'powers',
                    '41' => 'makes no',
                    '58' => 'stains',
                    '47' => 'powers',
                    '38' => 'stains',
                    '52' => 'powers',
                    '60' => 'stains',
                    '34' => 'powers',
                    '56' => 'feeds',
                    '73' => 'drips in',
                    '66' => 'on',
                    '37' => 'powers',
                    '45' => 'powers',
                    '76' => 'on',
                    '43' => 'marks',
                    '62' => 'red',
                    '54' => 'on the'
                  },
          '99' => {
                    '33' => 'above',
                    '32' => 'above',
                    '21' => 'above',
                    '7' => 'is limit of',
                    '26' => 'above',
                    '17' => 'above',
                    '2' => 'houses',
                    '1' => 'above',
                    '18' => 'above',
                    '30' => 'above',
                    '16' => 'above',
                    '44' => 'above',
                    '100' => 'above',
                    '27' => 'above',
                    '25' => 'above',
                    '28' => 'above',
                    '40' => 'above',
                    '20' => 'evades',
                    '14' => 'challenges',
                    '24' => 'above',
                    '10' => 'above',
                    '31' => 'above',
                    '35' => 'above',
                    '11' => 'transcends',
                    '48' => 'above',
                    '42' => 'above',
                    '22' => 'at',
                    '46' => 'above',
                    '13' => 'surrounds',
                    '23' => 'above',
                    '29' => 'above',
                    '6' => 'above',
                    '39' => 'above',
                    '36' => 'above',
                    '3' => 'above',
                    '9' => 'above',
                    '41' => 'makes no',
                    '12' => 'above',
                    '47' => 'above',
                    '15' => 'above',
                    '38' => 'above',
                    '8' => 'above',
                    '4' => 'evades',
                    '34' => 'above',
                    '45' => 'above',
                    '37' => 'above',
                    '101' => 'above',
                    '43' => 'above',
                    '19' => 'above',
                    '5' => 'above'
                  },
          '18' => {
                    '67' => 'clog',
                    '33' => 'cut',
                    '32' => 'cut',
                    '63' => 'alert',
                    '21' => 'sharper than',
                    '68' => 'swish through',
                    '26' => 'spurt',
                    '30' => 'cut',
                    '44' => 'cut',
                    '55' => 'cut up',
                    '25' => 'stab',
                    '27' => 'stab',
                    '28' => 'stab',
                    '57' => 'cut up',
                    '40' => 'stab',
                    '61' => 'cut',
                    '20' => 'pick lock of',
                    '59' => 'spread',
                    '49' => 'gut',
                    '24' => 'carve into',
                    '31' => 'cut',
                    '35' => 'cut',
                    '53' => 'cut',
                    '48' => 'stab',
                    '22' => 'cut',
                    '42' => 'stab',
                    '46' => 'cut',
                    '23' => 'stab',
                    '65' => 'cut',
                    '29' => 'cut',
                    '50' => 'stab',
                    '39' => 'trim dress',
                    '64' => 'reflect',
                    '36' => 'cut',
                    '51' => 'stab',
                    '58' => 'carve into',
                    '41' => 'make snipping',
                    '47' => 'cut',
                    '38' => 'carve into',
                    '52' => 'stab',
                    '60' => 'cut up',
                    '34' => 'cut',
                    '56' => 'impale',
                    '66' => 'cut',
                    '37' => 'cut',
                    '45' => 'stab',
                    '19' => 'more direct than',
                    '43' => 'carve into',
                    '62' => 'swish through',
                    '54' => 'carve into'
                  },
          '72' => {
                    '21' => 'splashes',
                    '90' => 'for',
                    '7' => 'toasts',
                    '80' => 'accompanies',
                    '17' => 'for',
                    '2' => 'ears for',
                    '1' => 'ears for',
                    '99' => 'reflects',
                    '18' => 'splashes',
                    '88' => 'sits on',
                    '16' => 'splashes',
                    '100' => 'ears for',
                    '82' => 'blesses',
                    '74' => 'catches',
                    '84' => 'holds',
                    '95' => 'attracts',
                    '75' => 'holds',
                    '83' => 'attracts',
                    '20' => 'rattles',
                    '14' => 'lensed',
                    '92' => 'hand over',
                    '89' => 'splashes',
                    '10' => 'made of',
                    '11' => 'toasts',
                    '91' => 'splashes',
                    '78' => 'shapes',
                    '79' => 'shapes',
                    '87' => 'blesses',
                    '77' => 'reflects',
                    '93' => 'conducts',
                    '13' => 'reflects',
                    '96' => 'holds holy',
                    '6' => 'splashes',
                    '85' => 'made of',
                    '3' => 'floats on',
                    '94' => 'focuses',
                    '97' => 'reflects',
                    '9' => 'commands',
                    '12' => 'smashes against',
                    '15' => 'splashes',
                    '8' => 'ears for',
                    '81' => 'for climbing',
                    '4' => 'shaped',
                    '98' => 'shaped',
                    '73' => 'holds',
                    '101' => 'ears for',
                    '19' => 'holds',
                    '86' => 'made of',
                    '76' => 'sits on',
                    '5' => 'holds'
                  },
          '16' => {
                    '33' => 'wounds',
                    '32' => 'wounds',
                    '63' => 'terrorizes',
                    '21' => 'outclasses',
                    '26' => 'splatters',
                    '17' => 'destroys',
                    '18' => 'outclasses',
                    '30' => 'wounds',
                    '44' => 'dices',
                    '55' => 'costs',
                    '25' => 'chops up',
                    '27' => 'kills',
                    '28' => 'kills',
                    '57' => 'cuts up',
                    '40' => 'destroys',
                    '61' => 'tears up',
                    '20' => 'cuts through',
                    '59' => 'splatters',
                    '49' => 'splatters',
                    '24' => 'ruins',
                    '31' => 'wounds',
                    '35' => 'wounds',
                    '53' => 'makes way for',
                    '48' => 'scares',
                    '22' => 'disturbs',
                    '42' => 'destroys',
                    '46' => 'wounds',
                    '23' => 'gleefully ravages',
                    '65' => 'cuts',
                    '29' => 'kills',
                    '50' => 'slices',
                    '39' => 'holds up',
                    '64' => 'user drinks',
                    '36' => 'scares',
                    '51' => 'dices',
                    '58' => 'terrorizes',
                    '41' => 'makes',
                    '47' => 'wounds',
                    '38' => 'destroys',
                    '52' => 'burns',
                    '60' => 'tears up',
                    '34' => 'wounds',
                    '56' => 'beheads',
                    '66' => 'massacre',
                    '37' => 'wounds',
                    '45' => 'kills',
                    '19' => 'more direct than',
                    '43' => 'cuts down',
                    '62' => 'produces',
                    '54' => 'chops down'
                  },
          '44' => {
                    '67' => 'ends up in',
                    '90' => 'doesn\'t need',
                    '63' => 'in',
                    '71' => 'stains',
                    '70' => 'thrown at',
                    '80' => 'answers',
                    '68' => 'odorizes',
                    '88' => 'grows along',
                    '72' => 'stains',
                    '82' => 'disgusts',
                    '55' => 'costs',
                    '84' => 'roots hide',
                    '74' => 'loves',
                    '83' => 'thrown at',
                    '75' => 'drinks',
                    '57' => 'tastier than',
                    '61' => 'stains',
                    '92' => 'good for',
                    '69' => 'grows on',
                    '59' => 'in',
                    '49' => 'simpler than',
                    '89' => 'healthier than',
                    '53' => 'feeds',
                    '91' => 'thrown at',
                    '78' => 'thrown at',
                    '48' => 'thrown at',
                    '79' => 'disgusts',
                    '87' => 'disgusts',
                    '93' => 'conducts',
                    '77' => 'flavor',
                    '46' => 'thrown at',
                    '65' => 'grows in',
                    '50' => 'squashes',
                    '85' => 'roots hide',
                    '64' => 'grows despite',
                    '94' => 'hides from',
                    '51' => 'squashes',
                    '58' => 'thrown at',
                    '47' => 'thrown at',
                    '81' => 'grows on',
                    '52' => 'has no',
                    '60' => 'recipe',
                    '56' => 'thrown at',
                    '45' => 'thrown at',
                    '66' => 'stains',
                    '73' => 'falls in',
                    '86' => 'roots hide',
                    '76' => 'thrown at',
                    '62' => 'gas',
                    '54' => 'roots form'
                  },
          '55' => {
                    '67' => 'fixes',
                    '90' => 'uses',
                    '63' => 'bankrupts',
                    '71' => 'fills',
                    '70' => 'funds',
                    '80' => 'answers',
                    '68' => 'pollutes',
                    '2' => 'for',
                    '1' => 'funds',
                    '99' => 'debt',
                    '88' => 'repairs',
                    '72' => 'fills',
                    '100' => 'funds',
                    '82' => 'brings souls to',
                    '84' => 'mines',
                    '74' => 'flows like',
                    '95' => 'bribes',
                    '83' => 'enthralls',
                    '75' => 'floats on',
                    '57' => 'hires',
                    '61' => 'funds news',
                    '92' => 'tricks',
                    '59' => 'evades',
                    '69' => 'conquers',
                    '89' => 'develops',
                    '91' => 'funds',
                    '78' => 'doesn\'t interest',
                    '79' => 'doesn\'t interest',
                    '87' => 'makes men',
                    '93' => 'conducts',
                    '77' => 'has new',
                    '96' => 'brings',
                    '65' => 'landscapes',
                    '85' => 'is',
                    '3' => 'debt is',
                    '64' => 'funds trip to',
                    '97' => 'funds',
                    '94' => 'vanishes like',
                    '58' => 'funds',
                    '81' => 'buys',
                    '4' => 'money pit',
                    '98' => 'funds',
                    '60' => 'funds',
                    '56' => 'bribes',
                    '101' => 'funds',
                    '66' => 'funds',
                    '73' => 'imports',
                    '76' => 'corrupts',
                    '86' => 'is',
                    '62' => 'clears'
                  },
          '84' => {
                    '33' => 'adorns',
                    '32' => 'adorns',
                    '21' => 'engraves',
                    '90' => 'geometric',
                    '7' => 'bribes',
                    '26' => 'outlasts',
                    '17' => 'more desirable than',
                    '2' => 'survives',
                    '1' => 'survives',
                    '99' => 'with lucy in',
                    '18' => 'engraves',
                    '88' => 'harder than',
                    '30' => 'adorns',
                    '16' => 'resists',
                    '100' => 'harder than',
                    '27' => 'sharper than',
                    '25' => 'charms',
                    '28' => 'attracts',
                    '95' => 'enthralls',
                    '20' => 'engraves',
                    '14' => 'pricier than',
                    '92' => 'wins',
                    '24' => 'decorates',
                    '89' => 'pricier than',
                    '10' => 'hardest',
                    '31' => 'adorns',
                    '11' => '\'till',
                    '91' => 'pricier than',
                    '22' => 'disturbs',
                    '87' => 'imprisons',
                    '93' => 'withstands',
                    '23' => 'pricier than',
                    '13' => 'catches',
                    '29' => 'hypnotizes',
                    '96' => 'focuses',
                    '6' => 'resists',
                    '85' => 'pricier than',
                    '3' => 'hides in',
                    '97' => 'diffracts',
                    '94' => 'withstands',
                    '9' => 'engraves',
                    '12' => 'engraves',
                    '15' => 'resists',
                    '8' => 'resists',
                    '98' => 'survives',
                    '4' => 'hides in',
                    '101' => 'engraves',
                    '19' => 'resists',
                    '86' => 'pricier than',
                    '5' => 'harder than'
                  },
          '74' => {
                    '21' => 'rusts',
                    '90' => 'measured with',
                    '7' => 'soaks',
                    '80' => 'answers',
                    '17' => 'closes',
                    '2' => 'brings',
                    '1' => 'soaks',
                    '99' => 'darkens',
                    '18' => 'rusts',
                    '88' => 'rusts',
                    '16' => 'thwarts',
                    '100' => 'falls on',
                    '82' => 'drowns',
                    '84' => 'cleans',
                    '95' => 'drowns',
                    '75' => 'made of',
                    '83' => 'drowns',
                    '20' => 'rusts',
                    '14' => 'ruins',
                    '92' => 'saddens',
                    '89' => 'inspires',
                    '10' => 'erodes',
                    '11' => 'makes lonely',
                    '91' => 'short-circuits',
                    '78' => 'diverts',
                    '79' => 'drowns',
                    '22' => 'disturbs',
                    '87' => 'drowns',
                    '77' => 'creates',
                    '93' => 'conducts',
                    '23' => 'short-circuits',
                    '13' => 'blocks',
                    '96' => 'blacks out',
                    '6' => 'rusts',
                    '85' => 'cleans',
                    '3' => 'creates',
                    '94' => 'brings',
                    '97' => 'diffracts',
                    '9' => 'rusts',
                    '12' => 'leaks through',
                    '15' => 'douses',
                    '8' => 'soaks',
                    '81' => 'on the',
                    '98' => 'diverts',
                    '4' => 'fills',
                    '101' => 'diverts',
                    '19' => 'acidic',
                    '86' => 'cleans',
                    '76' => 'inspires',
                    '5' => 'rusts'
                  },
          '27' => {
                    '67' => 'scrubs',
                    '33' => 'pricks',
                    '32' => 'pricks',
                    '63' => 'terrorizes',
                    '71' => 'tips over',
                    '70' => 'sleeps in',
                    '68' => 'breathes',
                    '72' => 'tips over',
                    '30' => 'pricks',
                    '44' => 'eats',
                    '55' => 'shreds',
                    '74' => 'hunts despite',
                    '28' => 'pricks',
                    '75' => 'drinks',
                    '57' => 'catches',
                    '40' => 'punctures',
                    '61' => 'shreds',
                    '69' => 'lives on',
                    '59' => 'licks',
                    '49' => 'eats',
                    '31' => 'pricks',
                    '35' => 'pricks',
                    '53' => 'annoys',
                    '48' => 'pricks',
                    '42' => 'punctures',
                    '77' => 'looks at',
                    '46' => 'pricks',
                    '65' => 'eats',
                    '29' => 'pricks',
                    '50' => 'eats',
                    '39' => 'creeps onto',
                    '64' => 'hunts by',
                    '36' => 'pricks',
                    '51' => 'eats',
                    '41' => 'makes no',
                    '58' => 'scurries into',
                    '47' => 'pricks',
                    '38' => 'scurries into',
                    '52' => 'has',
                    '60' => 'shreds',
                    '34' => 'pricks',
                    '56' => 'pricks',
                    '73' => 'spills',
                    '66' => 'tears',
                    '37' => 'pricks',
                    '45' => 'pricks',
                    '76' => 'on',
                    '43' => 'lives among',
                    '62' => 'makes fart',
                    '54' => 'makes you'
                  },
          '95' => {
                    '33' => 'petrifies',
                    '32' => 'petrifies',
                    '21' => 'weilds',
                    '7' => 'breaks',
                    '26' => 'freezes',
                    '17' => 'terrorizes',
                    '2' => 'hides from',
                    '99' => 'curses',
                    '1' => 'before',
                    '18' => 'runs with',
                    '30' => 'petrifies',
                    '16' => 'before',
                    '44' => 'discards',
                    '100' => 'resists',
                    '27' => 'petrifies',
                    '25' => 'head',
                    '28' => 'petrifies',
                    '40' => 'before',
                    '20' => 'escapes',
                    '14' => 'before',
                    '24' => 'terrorizes',
                    '10' => 'hurls',
                    '31' => 'petrifies',
                    '35' => 'petrifies',
                    '11' => 'causes',
                    '42' => 'before',
                    '22' => 'disturbs',
                    '13' => 'curses',
                    '23' => 'before',
                    '29' => 'petrifies',
                    '96' => 'craves',
                    '6' => 'before',
                    '39' => 'before',
                    '36' => 'petrifies',
                    '3' => 'plants',
                    '97' => 'before',
                    '9' => 'weilds',
                    '41' => 'screeches',
                    '12' => 'hides behind',
                    '15' => 'starts',
                    '38' => 'terrifies',
                    '8' => 'cracks',
                    '4' => 'lives in',
                    '98' => 'before',
                    '34' => 'petrifies',
                    '37' => 'petrifies',
                    '101' => 'evades',
                    '43' => 'hides behind',
                    '19' => 'deadlier than',
                    '5' => 'breaks'
                  },
          '57' => {
                    '67' => 'cleans',
                    '90' => 'doesn\'t use',
                    '63' => 'cleans',
                    '71' => 'cleans',
                    '70' => 'cleans',
                    '80' => 'answers',
                    '68' => 'uses',
                    '2' => 'cleans after',
                    '1' => 'soaks',
                    '99' => 'cleans',
                    '88' => 'cleans',
                    '72' => 'cleans',
                    '100' => 'cleans',
                    '82' => 'cleanses',
                    '84' => 'cleans',
                    '74' => 'absorbs',
                    '95' => 'cleanses',
                    '83' => 'cleanses',
                    '75' => 'absorbs',
                    '61' => 'soaks',
                    '92' => 'has no',
                    '59' => 'sops up',
                    '69' => 'lives on',
                    '89' => 'cleans',
                    '91' => 'cleans',
                    '78' => 'cleans',
                    '79' => 'intrigues',
                    '87' => 'cleanses',
                    '93' => 'conducts',
                    '77' => 'creates',
                    '96' => 'has cleaning',
                    '65' => 'sits on',
                    '6' => 'cleans',
                    '85' => 'cleans',
                    '3' => 'floats on',
                    '64' => 'looks like',
                    '97' => 'cleans',
                    '94' => 'conducts',
                    '58' => 'cleans',
                    '81' => 'pile',
                    '4' => 'cleans',
                    '98' => 'cleans',
                    '60' => 'soaks',
                    '101' => 'cleans',
                    '73' => 'absorbs',
                    '66' => 'cleans',
                    '76' => 'bob on',
                    '86' => 'cleans',
                    '62' => 'denser than',
                    '5' => 'cleans'
                  },
          '61' => {
                    '67' => 'toilet cover',
                    '90' => 'tests',
                    '63' => 'paper airplane',
                    '71' => 'mache',
                    '70' => 'wraps',
                    '7' => 'explains',
                    '80' => 'contains',
                    '68' => 'fans',
                    '2' => 'predicts',
                    '1' => 'encases',
                    '99' => 'confetti fills',
                    '88' => 'thrown over',
                    '72' => 'paper cup',
                    '100' => 'about',
                    '82' => 'rebukes',
                    '84' => 'receipt for',
                    '74' => 'blocks',
                    '95' => 'about',
                    '83' => 'rebukes',
                    '75' => 'floats on',
                    '92' => 'cutout of',
                    '69' => 'about',
                    '89' => 'label for',
                    '10' => 'covers',
                    '91' => 'describes',
                    '78' => 'disproves',
                    '79' => 'disproves',
                    '87' => 'rebukes',
                    '77' => 'cutout of',
                    '93' => 'defines',
                    '96' => 'about',
                    '65' => 'covers',
                    '6' => 'outlaws',
                    '85' => 'note for',
                    '3' => 'floats on',
                    '64' => 'paper moon',
                    '97' => 'defines',
                    '94' => 'defines',
                    '9' => 'wraps',
                    '8' => 'wraps',
                    '81' => 'pile',
                    '4' => 'covers',
                    '98' => 'defines',
                    '101' => 'about',
                    '73' => 'beer label',
                    '66' => 'reviews',
                    '76' => 'more info than',
                    '86' => 'note for',
                    '62' => 'fans',
                    '5' => 'starts'
                  },
          '20' => {
                    '67' => 'has poor',
                    '33' => 'traps',
                    '32' => 'traps',
                    '63' => 'structure in',
                    '21' => 'not affected by',
                    '70' => 'has no',
                    '68' => 'stagnates',
                    '26' => 'boils',
                    '30' => 'traps',
                    '44' => 'contains',
                    '55' => 'costs',
                    '25' => 'traps',
                    '27' => 'traps',
                    '28' => 'traps',
                    '57' => 'knows no',
                    '40' => '(rollcage) protects',
                    '61' => 'has no',
                    '69' => 'teaches',
                    '59' => 'has no',
                    '49' => 'traps',
                    '24' => 'more fortified than',
                    '31' => 'traps',
                    '35' => 'imprisons',
                    '53' => 'protects',
                    '48' => 'traps',
                    '22' => 'keeps',
                    '42' => 'contains',
                    '46' => 'traps',
                    '23' => 'contains',
                    '65' => 'has no',
                    '29' => 'traps',
                    '50' => 'traps',
                    '39' => 'structure in',
                    '64' => 'blocks',
                    '36' => 'traps',
                    '51' => 'traps',
                    '58' => 'saddens',
                    '41' => 'door makes',
                    '47' => 'traps',
                    '38' => 'becomes',
                    '52' => 'traps',
                    '60' => 'has no',
                    '34' => 'traps',
                    '56' => 'traps',
                    '66' => 'has no',
                    '37' => 'imprisons',
                    '45' => 'traps',
                    '43' => 'blocks',
                    '62' => 'clouds freedom',
                    '54' => 'makes you'
                  },
          '92' => {
                    '33' => 'guides',
                    '32' => 'guides',
                    '21' => 'stays',
                    '7' => 'upholds',
                    '26' => 'pumps',
                    '17' => 'excels at',
                    '2' => 'survives',
                    '1' => 'bans',
                    '99' => 'clears',
                    '18' => 'guides',
                    '30' => 'guides',
                    '16' => 'bans',
                    '100' => 'bans',
                    '27' => 'outsmarts',
                    '25' => 'resists',
                    '28' => 'outsmarts',
                    '40' => 'invents eco',
                    '95' => 'pities',
                    '20' => 'transcends',
                    '14' => 'guides',
                    '24' => 'builds',
                    '10' => 'like a',
                    '31' => 'guides',
                    '35' => 'guides',
                    '11' => 'transcends',
                    '22' => 'upholds',
                    '93' => 'uses bio',
                    '13' => 'of the',
                    '23' => 'excels at',
                    '29' => 'guides',
                    '96' => 'provides',
                    '6' => 'bans',
                    '39' => 'prefers',
                    '36' => 'protects',
                    '3' => 'rescues from',
                    '97' => 'laser surgery',
                    '94' => 'survives',
                    '9' => 'stays',
                    '41' => 'makes',
                    '12' => 'knows no',
                    '15' => 'on',
                    '38' => 'builds',
                    '8' => 'stays',
                    '4' => 'survives',
                    '98' => 'bans',
                    '34' => 'bolsters',
                    '37' => 'guides',
                    '101' => 'soars like',
                    '19' => 'bans',
                    '5' => 'un'
                  },
          '89' => {
                    '33' => 'has',
                    '32' => 'has',
                    '21' => 'has',
                    '90' => 'code uses',
                    '7' => 'breaks fcc',
                    '26' => 'glorifies',
                    '17' => 'after',
                    '2' => 'graphics',
                    '1' => 'has',
                    '99' => 'simulates',
                    '18' => 'more fun than',
                    '30' => 'has',
                    '16' => 'has',
                    '100' => 'has',
                    '27' => 'resists',
                    '25' => 'cables',
                    '28' => 'sold by',
                    '95' => 'confuses',
                    '20' => 'mental',
                    '14' => 'multiple',
                    '92' => 'affects',
                    '24' => 'before',
                    '10' => 'rock soundtrack',
                    '31' => 'has',
                    '35' => 'entertains',
                    '11' => 'restarts after',
                    '91' => 'turns you into',
                    '22' => 'disturbs',
                    '93' => 'uses',
                    '23' => 'on',
                    '13' => 'replaces',
                    '29' => 'stars',
                    '96' => 'consumes',
                    '6' => 'uses',
                    '36' => 'confuses',
                    '3' => 'mental',
                    '97' => 'has',
                    '94' => 'attracts',
                    '9' => 'has',
                    '12' => 'simulates',
                    '15' => 'catches',
                    '38' => 'clutters',
                    '8' => 'has',
                    '4' => 'mental',
                    '98' => 'has',
                    '34' => 'distracts',
                    '37' => 'entertains',
                    '101' => 'has',
                    '19' => 'mental',
                    '5' => 'has'
                  },
          '10' => {
                    '33' => 'crushes',
                    '32' => 'crushes',
                    '21' => 'chips',
                    '26' => 'contains',
                    '17' => 'smashes',
                    '18' => 'smashes',
                    '30' => 'crushes',
                    '16' => 'dulls',
                    '44' => 'blocks',
                    '55' => '(rare) costs',
                    '25' => 'crushes',
                    '27' => 'crushes',
                    '28' => 'hits',
                    '57' => 'crushes',
                    '40' => 'smashes',
                    '14' => 'smashes',
                    '20' => 'crushes',
                    '59' => 'splatters',
                    '49' => 'smooshes',
                    '24' => 'builds',
                    '31' => 'crushes',
                    '35' => 'crushes',
                    '11' => 'indicates',
                    '53' => 'solid',
                    '48' => 'hits',
                    '22' => 'marks eternal',
                    '42' => 'crushes',
                    '46' => 'crushes',
                    '13' => 'shades',
                    '23' => 'crushes',
                    '29' => 'crushes',
                    '50' => 'squishes',
                    '39' => 'blocks',
                    '36' => 'crushes',
                    '51' => 'squishes',
                    '58' => 'smashes',
                    '12' => 'builds',
                    '41' => 'grinds',
                    '47' => 'crushes',
                    '15' => 'pounds out',
                    '52' => 'crushes',
                    '38' => 'builds',
                    '60' => 'crushes',
                    '34' => 'crushes',
                    '56' => 'encases',
                    '45' => 'hits',
                    '37' => 'crushes',
                    '43' => 'blocks',
                    '19' => 'smashes',
                    '54' => 'supports'
                  },
          '31' => {
                    '67' => 'uses',
                    '33' => 'rules over',
                    '32' => 'rules over',
                    '63' => 'flies on',
                    '71' => 'eats from',
                    '70' => 'rocks',
                    '80' => 'in',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'eats',
                    '55' => 'has',
                    '74' => 'walks in',
                    '75' => 'drinks',
                    '57' => 'owns',
                    '40' => 'rides in',
                    '61' => 'writes',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '35' => 'rules',
                    '53' => 'rules',
                    '78' => 'disbelieves',
                    '79' => 'disbelieves',
                    '48' => 'eats',
                    '42' => 'rides',
                    '77' => 'looks at',
                    '46' => 'tames',
                    '65' => 'walks on',
                    '50' => 'steps on',
                    '39' => 'rides on',
                    '64' => 'looks at',
                    '36' => 'has',
                    '51' => 'steps on',
                    '41' => 'outlaws',
                    '58' => 'funds',
                    '47' => 'owns',
                    '81' => 'bosom is',
                    '38' => 'taxes',
                    '52' => 'has',
                    '60' => 'inspires',
                    '34' => 'governs',
                    '56' => 'could be',
                    '73' => 'drinks',
                    '66' => 'inspires',
                    '45' => 'eats',
                    '37' => 'rules',
                    '76' => 'on',
                    '43' => 'owns',
                    '62' => 'looks at',
                    '54' => 'erects'
                  },
          '35' => {
                    '67' => 'uses',
                    '63' => 'flies on',
                    '71' => 'eats from',
                    '70' => 'plays',
                    '80' => 'in',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'eats',
                    '82' => 'enthralls',
                    '55' => 'spends',
                    '84' => 'wears',
                    '74' => 'walks in',
                    '83' => 'tempts',
                    '75' => 'drinks',
                    '57' => 'cleans with',
                    '40' => 'drives',
                    '61' => 'writes',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'owns',
                    '53' => 'lives in',
                    '78' => 'debunks',
                    '79' => 'disproves',
                    '48' => 'owns',
                    '42' => 'rides',
                    '77' => 'looks at',
                    '46' => 'tames',
                    '65' => 'walks on',
                    '50' => 'steps on',
                    '85' => 'hair colored',
                    '39' => 'rides on',
                    '36' => 'has',
                    '64' => 'aligns with',
                    '51' => 'steps on',
                    '41' => 'makes',
                    '58' => 'attends',
                    '47' => 'owns',
                    '81' => 'climbs',
                    '52' => 'has',
                    '38' => 'lives in',
                    '60' => 'reads',
                    '56' => 'becomes',
                    '73' => 'drinks',
                    '45' => 'eats',
                    '37' => 'tempts',
                    '66' => 'watches',
                    '76' => 'watches',
                    '43' => 'plants',
                    '62' => 'looks at',
                    '54' => 'acts'
                  },
          '11' => {
                    '33' => 'claims',
                    '32' => 'claims',
                    '21' => 'carries',
                    '26' => 'cools',
                    '17' => 'saddens',
                    '18' => 'not caused by',
                    '30' => 'claims',
                    '16' => 'dismantles',
                    '44' => 'claims',
                    '55' => '(funeral) costs',
                    '25' => 'claims',
                    '27' => 'claims',
                    '28' => 'feeds',
                    '57' => 'dries',
                    '40' => 'crashes',
                    '61' => 'crumbles',
                    '14' => 'ruins',
                    '20' => 'inside',
                    '59' => 'spoils',
                    '49' => 'claims',
                    '24' => 'crumbles',
                    '31' => 'claims',
                    '35' => 'claims',
                    '53' => 'saddens',
                    '48' => 'claims',
                    '22' => 'rest in',
                    '42' => 'crashes',
                    '46' => 'claims',
                    '13' => 'claims',
                    '23' => 'crashes',
                    '29' => 'claims',
                    '50' => 'claims',
                    '39' => 'stops',
                    '36' => 'claims',
                    '51' => 'claims',
                    '58' => 'saddens',
                    '12' => 'knows no',
                    '41' => 'rattle',
                    '47' => 'claims',
                    '15' => 'cools',
                    '52' => 'claims',
                    '38' => 'saddens',
                    '60' => 'crumbles',
                    '34' => 'claims',
                    '56' => 'eludes',
                    '45' => 'claims',
                    '37' => 'claims',
                    '19' => 'all life',
                    '43' => 'claims',
                    '54' => 'on the'
                  },
          '91' => {
                    '33' => 'frightens',
                    '32' => 'frightens',
                    '21' => 'carries',
                    '7' => 'three',
                    '26' => 'has no',
                    '17' => 'tramples',
                    '2' => 'chases',
                    '1' => 'throws',
                    '99' => 'pollutes',
                    '18' => 'carries',
                    '30' => 'frightens',
                    '16' => 'carries',
                    '100' => 'pilots',
                    '27' => 'steps on',
                    '25' => 'steps on',
                    '28' => 'resists',
                    '40' => 'builds',
                    '95' => 'tramples',
                    '20' => 'bends bars of',
                    '14' => 'has',
                    '92' => 'envies',
                    '24' => 'explores',
                    '10' => 'hurls',
                    '31' => 'frightens',
                    '35' => 'carries off',
                    '11' => 'knows no',
                    '22' => 'disturbs',
                    '93' => 'uses',
                    '13' => 'reflects',
                    '23' => 'uses',
                    '29' => 'scares',
                    '96' => 'consumes',
                    '6' => 'fires',
                    '39' => 'builds',
                    '36' => 'carries off',
                    '3' => 'detects',
                    '97' => 'shoots',
                    '94' => 'shoots',
                    '9' => 'carries',
                    '12' => 'smashes through',
                    '15' => 'resists',
                    '38' => 'enhances',
                    '8' => 'resists',
                    '4' => 'climbs out of',
                    '98' => 'launches',
                    '34' => 'tramples',
                    '37' => 'overthrows',
                    '101' => 'pilots',
                    '19' => 'resists',
                    '5' => 'breaks'
                  },
          '78' => {
                    '21' => 'resists',
                    '90' => 'uses advanced',
                    '7' => 'breaks physical',
                    '26' => 'collects',
                    '80' => 'despite',
                    '17' => 'flies over',
                    '2' => 'flies over',
                    '1' => 'resists',
                    '99' => 'flies across',
                    '18' => 'resists',
                    '88' => 'flies over',
                    '16' => 'resists',
                    '100' => 'flies over',
                    '82' => 'unaware of',
                    '27' => 'vaporizes',
                    '25' => 'abducts',
                    '84' => 'uses',
                    '83' => 'spies on',
                    '95' => 'outclasses',
                    '20' => 'evades',
                    '14' => 'evades',
                    '92' => 'abducts',
                    '24' => 'flies over',
                    '89' => 'in',
                    '10' => 'vaporizes',
                    '11' => 'causes',
                    '91' => 'commands',
                    '79' => 'carries',
                    '22' => 'disturbs',
                    '87' => 'unaware of',
                    '93' => 'uses',
                    '23' => 'uses',
                    '13' => 'flies to',
                    '96' => 'uses advanced',
                    '6' => 'resists',
                    '85' => 'made of',
                    '3' => 'flies over',
                    '94' => 'shoots',
                    '97' => 'shoots',
                    '9' => 'resists',
                    '12' => 'flies over',
                    '15' => 'starts',
                    '81' => 'flies over',
                    '8' => 'resists',
                    '98' => 'steals',
                    '4' => 'flies over',
                    '101' => 'evades',
                    '19' => 'resists',
                    '86' => 'made of',
                    '5' => 'vaporizes'
                  },
          '48' => {
                    '67' => 'doesn\'t use',
                    '90' => 'doesn\'t need',
                    '63' => 'flies like',
                    '71' => 'bathes in',
                    '70' => 'nests in',
                    '80' => 'in',
                    '68' => 'breathes',
                    '88' => 'flies over',
                    '72' => 'knocks over',
                    '82' => 'recognizes',
                    '55' => 'costs',
                    '84' => 'carries off',
                    '74' => 'flies above',
                    '95' => 'escapes',
                    '83' => 'faster than',
                    '75' => 'drinks',
                    '57' => 'carries off',
                    '61' => 'nests in',
                    '92' => 'has',
                    '69' => 'lives on',
                    '59' => 'dirties',
                    '49' => 'eats',
                    '89' => 'brained',
                    '53' => 'beautifies',
                    '91' => 'perches on',
                    '78' => 'hides from',
                    '79' => 'intrigues',
                    '87' => 'recognizes',
                    '93' => 'on wire despite',
                    '77' => 'flies over',
                    '96' => 'has spiritual',
                    '65' => 'flies over',
                    '50' => 'eats',
                    '85' => 'colored',
                    '64' => 'hunts by',
                    '97' => 'dodges',
                    '94' => 'attracts',
                    '51' => 'eats',
                    '58' => 'perches on',
                    '81' => 'lives on',
                    '52' => 'has',
                    '98' => 'of peace prevents',
                    '60' => 'carries off',
                    '56' => 'escapes',
                    '66' => 'on',
                    '73' => 'drinks',
                    '86' => 'colored',
                    '76' => 'on',
                    '62' => 'flies above',
                    '54' => 'perches on'
                  },
          '87' => {
                    '33' => 'tempts',
                    '32' => 'tempts',
                    '21' => 'weilds',
                    '90' => 'quizzes',
                    '7' => 'breaks',
                    '26' => 'poisons',
                    '17' => 'skips',
                    '2' => 'commands',
                    '1' => 'lights',
                    '99' => 'darkens',
                    '18' => 'resists',
                    '88' => 'hops',
                    '30' => 'tempts',
                    '16' => 'weilds',
                    '100' => 'drives',
                    '27' => 'sharper than',
                    '25' => 'eats',
                    '28' => 'is soul',
                    '95' => 'commands',
                    '20' => 'escapes',
                    '14' => 'blurs',
                    '92' => 'darkens',
                    '24' => 'has',
                    '89' => 'inspires',
                    '10' => 'hurls',
                    '31' => 'tempts',
                    '35' => 'possesses',
                    '11' => 'after',
                    '91' => 'glitches',
                    '22' => 'disturbs',
                    '93' => 'cuts',
                    '23' => 'hacks',
                    '13' => 'curses',
                    '29' => 'burns',
                    '96' => 'has',
                    '6' => 'inspires',
                    '36' => 'possesses',
                    '3' => 'lures into',
                    '97' => 'rewires',
                    '94' => 'brings',
                    '9' => 'weilds',
                    '12' => 'in the',
                    '15' => 'commands',
                    '8' => 'cracks',
                    '98' => 'inspires',
                    '4' => 'hides in',
                    '34' => 'evades',
                    '101' => 'crashes',
                    '19' => 'uses',
                    '5' => 'breaks'
                  },
          '93' => {
                    '33' => 'electrocutes',
                    '32' => 'electrocutes',
                    '21' => 'charges',
                    '7' => 'has physical',
                    '26' => 'fries',
                    '17' => 'bills',
                    '2' => 'envelops',
                    '1' => 'natural',
                    '99' => 'charges',
                    '18' => 'charges',
                    '30' => 'electrocutes',
                    '16' => 'short-circuits',
                    '100' => 'short-circuits',
                    '27' => 'fries',
                    '25' => 'in cable',
                    '28' => 'repels',
                    '40' => 'short-circuits',
                    '95' => 'fries',
                    '20' => 'charges',
                    '14' => 'powers',
                    '24' => 'bills',
                    '10' => 'powers',
                    '31' => 'electrocutes',
                    '35' => 'electrocutes',
                    '11' => 'causes',
                    '42' => 'charges',
                    '22' => 'disturbs',
                    '13' => 'replicates',
                    '23' => 'short-circuits',
                    '29' => 'electrocutes',
                    '96' => 'produces',
                    '6' => 'charges',
                    '39' => 'short-circuits',
                    '36' => 'electrocutes',
                    '3' => 'charges',
                    '97' => 'powers',
                    '94' => 'produces',
                    '9' => 'charges',
                    '41' => 'makes',
                    '12' => 'in',
                    '15' => 'starts',
                    '38' => 'bills',
                    '8' => 'fries',
                    '4' => 'brightens',
                    '98' => 'short-circuits',
                    '34' => 'electrocutes',
                    '37' => 'electrocutes',
                    '101' => 'short-circuits',
                    '19' => 'mixes',
                    '5' => 'starts'
                  },
          '77' => {
                    '21' => 'resists',
                    '90' => 'optics use',
                    '7' => 'despite',
                    '26' => 'after',
                    '80' => 'enhances',
                    '17' => 'over',
                    '2' => 'after',
                    '1' => 'over',
                    '99' => 'decorates',
                    '18' => 'colored',
                    '88' => 'over',
                    '16' => 'over',
                    '100' => 'over',
                    '82' => 'irritates',
                    '25' => 'colored',
                    '84' => 'indicates',
                    '95' => 'irritates',
                    '83' => 'over',
                    '20' => 'beyond',
                    '14' => 'challenges',
                    '92' => 'cheers',
                    '24' => 'over',
                    '89' => 'colored',
                    '10' => 'over',
                    '11' => 'despite',
                    '91' => 'over',
                    '78' => 'attracts',
                    '79' => 'intrigues',
                    '22' => 'indicates',
                    '87' => 'irritates',
                    '93' => 'wired',
                    '23' => 'colored',
                    '13' => 'diffracts',
                    '96' => 'rainbow power',
                    '6' => 'resists',
                    '85' => 'points to',
                    '3' => 'over',
                    '94' => 'after',
                    '97' => 'colored',
                    '9' => 'over',
                    '12' => 'hits',
                    '15' => 'over',
                    '81' => 'over',
                    '8' => 'sharp as a',
                    '98' => 'after',
                    '4' => 'over',
                    '101' => 'over',
                    '19' => 'resists',
                    '86' => 'points to',
                    '5' => 'color'
                  },
          '65' => {
                    '67' => 'becomes',
                    '90' => 'unlocks',
                    '71' => 'fills',
                    '70' => 'inspires',
                    '7' => 'breaks',
                    '80' => 'more visceral than',
                    '68' => 'produces',
                    '2' => 'survives',
                    '1' => 'survives',
                    '99' => 'smoke clouds',
                    '88' => 'overgrows',
                    '72' => 'hides',
                    '100' => 'gives cover from',
                    '82' => 'inspires',
                    '84' => 'hides',
                    '74' => 'loves',
                    '95' => 'starts',
                    '83' => 'causes',
                    '75' => 'drinks',
                    '14' => 'blurry in',
                    '92' => 'speeds up',
                    '69' => 'covers',
                    '89' => 'inspires',
                    '10' => 'overgrows',
                    '11' => 'annual despite',
                    '91' => 'turns you into',
                    '78' => 'causes',
                    '79' => 'causes',
                    '87' => 'inspires',
                    '77' => 'causes',
                    '93' => 'conducts',
                    '13' => 'prefers moderate',
                    '96' => 'brings flower',
                    '6' => 'hides',
                    '85' => 'hides',
                    '3' => 'hides',
                    '94' => 'survives',
                    '97' => 'too widespread for',
                    '9' => 'hides',
                    '12' => 'overgrows',
                    '8' => 'constructs',
                    '81' => 'grows on',
                    '4' => 'hides',
                    '98' => 'inspires',
                    '101' => 'too rough for',
                    '66' => 'blurry in',
                    '73' => 'stronger than',
                    '76' => 'inspires',
                    '86' => 'hides',
                    '5' => 'hides'
                  },
          '29' => {
                    '67' => 'goes everywhere but',
                    '33' => 'flings poop at',
                    '32' => 'flings poop at',
                    '63' => 'flies on',
                    '71' => 'smashes',
                    '70' => 'smashes',
                    '68' => 'breathes',
                    '72' => 'smashes',
                    '30' => 'flings poop at',
                    '44' => 'eats',
                    '55' => 'shreds',
                    '74' => 'doesn\'t mind',
                    '75' => 'drinks',
                    '57' => 'rips up',
                    '40' => 'climbs on',
                    '61' => 'rips up',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '31' => 'flings poop at',
                    '35' => 'flings poop at',
                    '53' => 'irritates',
                    '78' => 'shrieks at',
                    '79' => 'infuriates',
                    '48' => 'scares',
                    '42' => 'climbs on',
                    '77' => 'glares at',
                    '46' => 'enrages',
                    '65' => 'sits on',
                    '50' => 'eats',
                    '39' => 'climbs on',
                    '64' => 'screeches at',
                    '36' => 'scares',
                    '51' => 'eats',
                    '41' => 'makes',
                    '58' => 'climbs',
                    '47' => 'scares',
                    '38' => 'climbs on',
                    '52' => 'has',
                    '60' => 'rips up',
                    '34' => 'flings poop at',
                    '56' => 'irritates',
                    '73' => 'chugs',
                    '66' => 'rips out',
                    '45' => 'scares',
                    '37' => 'flings poop at',
                    '76' => 'smashes',
                    '43' => 'climbs',
                    '62' => 'shrieks at',
                    '54' => 'climbs'
                  },
          '50' => {
                    '67' => 'hides in',
                    '90' => 'doesn\'t need',
                    '63' => 'creeps into',
                    '71' => 'hides under',
                    '70' => 'hides in',
                    '80' => 'despite',
                    '68' => 'breathes',
                    '99' => 'unaware of',
                    '88' => 'crawls over',
                    '72' => 'crawls into',
                    '100' => 'creeps into',
                    '82' => 'amuses',
                    '55' => 'costs',
                    '84' => 'eyes like',
                    '74' => 'doesn\'t mind',
                    '95' => 'amuses',
                    '83' => 'amuses',
                    '75' => 'drinks',
                    '57' => 'nests in',
                    '61' => 'crawls across',
                    '92' => 'has',
                    '69' => 'lives on',
                    '59' => 'crawls across',
                    '89' => 'in',
                    '53' => 'frightens',
                    '91' => 'crawls over',
                    '78' => 'undetected by',
                    '79' => 'intrigues',
                    '87' => 'amuses',
                    '93' => 'hides from',
                    '77' => 'unaware of',
                    '96' => 'has',
                    '65' => 'in',
                    '85' => 'web like',
                    '64' => 'lives by',
                    '97' => 'dodges',
                    '94' => 'hides from',
                    '51' => 'bigger than',
                    '58' => 'creeps into',
                    '52' => 'has',
                    '81' => 'lives on',
                    '98' => 'survives',
                    '60' => 'behind',
                    '56' => 'entertains',
                    '66' => 'on',
                    '73' => 'in your',
                    '86' => 'colored',
                    '76' => 'crawls across',
                    '62' => 'web like',
                    '54' => 'crawls up'
                  },
          '39' => {
                    '67' => 'has',
                    '63' => 'safer than',
                    '71' => 'carries',
                    '70' => 'carries',
                    '80' => 'answers',
                    '68' => 'is',
                    '88' => 'crashes through',
                    '72' => 'carries',
                    '44' => 'contains',
                    '82' => 'amuses',
                    '55' => 'costs',
                    '84' => 'pricier than',
                    '74' => 'blocks',
                    '83' => 'outruns',
                    '75' => 'plumbs',
                    '57' => 'carries',
                    '40' => 'faster than',
                    '61' => 'contains',
                    '69' => 'travels',
                    '59' => 'contains',
                    '49' => 'contains',
                    '89' => 'in',
                    '53' => 'serves',
                    '78' => 'attracts',
                    '79' => 'intrigues',
                    '48' => 'scares',
                    '42' => 'faster than',
                    '87' => 'amuses',
                    '77' => 'reflects',
                    '46' => 'scares',
                    '65' => 'whizzes through',
                    '50' => 'houses',
                    '85' => 'pricier than',
                    '64' => 'reflects',
                    '51' => 'houses',
                    '41' => 'makes',
                    '58' => 'cozier than',
                    '47' => 'scares',
                    '81' => 'climbs',
                    '52' => 'requires',
                    '60' => 'contains',
                    '56' => 'outruns',
                    '73' => 'sells',
                    '45' => 'scares',
                    '66' => 'in',
                    '86' => 'pricier than',
                    '76' => 'has',
                    '43' => 'around',
                    '62' => 'creates',
                    '54' => 'train crossing'
                  },
          '64' => {
                    '67' => 'has no',
                    '90' => 'lander uses',
                    '71' => 'shaped like',
                    '70' => 'adorns',
                    '7' => 'has no',
                    '80' => 'shines on',
                    '68' => 'has no',
                    '2' => 'far above',
                    '1' => 'suffocates',
                    '99' => 'adorns',
                    '88' => 'far above',
                    '72' => '-shine in',
                    '100' => 'far above',
                    '82' => 'confuses',
                    '84' => 'shines like',
                    '74' => 'far above',
                    '95' => 'far above',
                    '83' => 'shines on',
                    '75' => 'has no',
                    '92' => '-light walk with sweet',
                    '69' => 'orbits',
                    '89' => 'patrol',
                    '10' => 'is giant',
                    '11' => 'symbolizes',
                    '91' => 'lander uses',
                    '78' => 'houses',
                    '79' => 'houses',
                    '87' => 'terrifies',
                    '77' => 'far above',
                    '93' => 'has no',
                    '13' => 'eclipses',
                    '65' => 'has no',
                    '96' => 'visit uses',
                    '6' => 'too far for',
                    '85' => 'colored',
                    '3' => 'far above',
                    '97' => 'too far for',
                    '94' => 'far above',
                    '9' => 'adorns',
                    '12' => 'far above',
                    '8' => 'far above',
                    '81' => 'far above',
                    '4' => 'crater',
                    '98' => 'too far for',
                    '101' => 'too far for',
                    '73' => '-shine stronger than',
                    '66' => 'in',
                    '76' => 'on',
                    '86' => 'colored',
                    '5' => 'far above'
                  },
          '97' => {
                    '33' => 'targets',
                    '32' => 'targets',
                    '21' => 'outlcasses',
                    '7' => 'upholds',
                    '26' => 'cooks',
                    '17' => 'teaches',
                    '2' => 'penetrates',
                    '99' => 'traverses',
                    '1' => 'outclasses',
                    '18' => 'melts',
                    '30' => 'targets',
                    '16' => 'outclasses',
                    '44' => 'discintigrates',
                    '100' => 'targets',
                    '27' => 'fries',
                    '25' => 'fries',
                    '28' => 'fries',
                    '40' => 'targets',
                    '20' => 'melts',
                    '14' => 'burns',
                    '24' => 'targets',
                    '10' => 'burns through',
                    '31' => 'targets',
                    '35' => 'targets',
                    '11' => 'causes',
                    '42' => 'melts',
                    '22' => 'disturbs',
                    '46' => 'fries',
                    '13' => 'has power of',
                    '23' => 'backs up',
                    '29' => 'fries',
                    '6' => 'laser gun',
                    '39' => 'targets',
                    '36' => 'targets',
                    '3' => 'burns off',
                    '9' => 'outclasses',
                    '41' => 'zap',
                    '12' => 'burns through',
                    '15' => 'starts',
                    '38' => 'targets',
                    '8' => 'outclasses',
                    '98' => 'guides',
                    '4' => 'lights',
                    '34' => 'helps',
                    '45' => 'fries',
                    '37' => 'targets',
                    '101' => 'targets',
                    '43' => 'burns through',
                    '19' => 'more exact than',
                    '5' => 'starts'
                  },
          '58' => {
                    '67' => 'has',
                    '90' => 'accounts use',
                    '63' => 'blesses',
                    '71' => 'has',
                    '70' => 'bans',
                    '7' => 'creates',
                    '80' => 'in',
                    '68' => 'clears the',
                    '2' => 'survives',
                    '1' => 'survives',
                    '99' => 'lights up',
                    '88' => 'has',
                    '72' => 'worships with',
                    '100' => 'bans',
                    '82' => 'renounces',
                    '84' => 'collects',
                    '74' => 'blocks',
                    '95' => 'hunts',
                    '83' => 'hunts',
                    '75' => 'blesses',
                    '61' => 'program',
                    '92' => 'heals',
                    '59' => 'blesses',
                    '69' => 'across',
                    '89' => 'bans',
                    '91' => 'frowns on',
                    '78' => 'disbelieves',
                    '79' => 'disbelieves',
                    '87' => 'renounces',
                    '93' => 'uses',
                    '77' => 'blocks',
                    '96' => 'has healing',
                    '65' => 'sits on',
                    '6' => 'bans',
                    '85' => 'collects',
                    '3' => 'too big for',
                    '64' => 'blocks',
                    '97' => 'bans',
                    '94' => 'attracts',
                    '81' => 'atop',
                    '4' => 'threatens',
                    '98' => 'bans',
                    '60' => 'teaches',
                    '101' => 'bans',
                    '73' => 'frowns on',
                    '66' => 'bans',
                    '76' => 'on',
                    '86' => 'collects',
                    '62' => 'dispells',
                    '5' => 'binds like'
                  },
          '41' => {
                    '67' => 'of broken',
                    '90' => 'wave',
                    '63' => 'disrupts',
                    '71' => 'through',
                    '70' => 'amplified',
                    '80' => 'disrupts',
                    '68' => 'permeates',
                    '88' => 'heard over',
                    '72' => 'through',
                    '44' => 'locates',
                    '82' => 'summons',
                    '55' => 'fine costs',
                    '84' => 'locates',
                    '74' => 'heard in',
                    '83' => 'attracts',
                    '75' => 'across',
                    '57' => 'envelops',
                    '61' => 'heard through',
                    '69' => 'heard across',
                    '59' => 'melts',
                    '49' => 'locates',
                    '89' => 'in',
                    '53' => 'annoys',
                    '91' => 'navigates',
                    '78' => 'attracts',
                    '79' => 'attracts',
                    '48' => 'scares',
                    '42' => 'knocks over',
                    '87' => 'louder than',
                    '77' => 'spectrum',
                    '46' => 'scares',
                    '65' => 'in',
                    '50' => 'attracts',
                    '85' => 'locates',
                    '64' => 'travels to',
                    '51' => 'kills',
                    '58' => 'disrupts',
                    '47' => 'scares',
                    '81' => 'echoes across',
                    '52' => 'stimulates',
                    '60' => 'ruins',
                    '56' => 'annoys',
                    '45' => 'scares',
                    '66' => 'track in',
                    '73' => 'inspires',
                    '86' => 'locates',
                    '76' => 'on',
                    '43' => 'in',
                    '62' => 'heard through',
                    '54' => 'makes you'
                  },
          '12' => {
                    '33' => 'blocks',
                    '32' => 'blocks',
                    '21' => 'resists',
                    '26' => 'shelf holds',
                    '17' => 'supports',
                    '18' => 'shelf holds',
                    '30' => 'blocks',
                    '16' => 'too thick for',
                    '44' => 'blocks',
                    '55' => 'costs',
                    '25' => 'blocks',
                    '27' => 'blocks',
                    '28' => 'blocks',
                    '57' => 'too big for',
                    '40' => 'blocks',
                    '61' => 'shelf holds',
                    '14' => 'blocks',
                    '20' => 'creates',
                    '59' => 'shelf holds',
                    '49' => 'blocks',
                    '24' => 'supports',
                    '31' => 'blocks',
                    '35' => 'blocks',
                    '53' => 'surrounds',
                    '48' => 'blocks',
                    '22' => 'prevents',
                    '42' => 'blocks',
                    '46' => 'blocks',
                    '13' => 'shades',
                    '23' => '(firewall) protects',
                    '29' => 'blocks',
                    '50' => 'houses',
                    '39' => 'blocks',
                    '36' => 'blocks',
                    '51' => 'houses',
                    '58' => 'supports',
                    '41' => 'blocks',
                    '47' => 'blocks',
                    '15' => 'blocks',
                    '52' => 'challenges',
                    '38' => 'supports',
                    '60' => 'shelf holds',
                    '34' => 'blocks',
                    '56' => 'blocks',
                    '45' => 'blocks',
                    '37' => 'blocks',
                    '19' => 'not affected by',
                    '43' => 'blocks',
                    '62' => 'outlasts',
                    '54' => 'supports'
                  },
          '15' => {
                    '33' => 'burns',
                    '32' => 'burns',
                    '63' => 'consumes',
                    '21' => 'melts',
                    '26' => 'boils',
                    '17' => 'destroys',
                    '18' => 'melts',
                    '30' => 'burns',
                    '16' => 'melts',
                    '44' => 'cooks',
                    '55' => 'burns',
                    '25' => 'burns',
                    '27' => 'burns',
                    '28' => 'burns',
                    '57' => 'burns',
                    '40' => 'burns',
                    '61' => 'burns',
                    '20' => 'melts',
                    '59' => 'melts',
                    '49' => 'cooks',
                    '24' => 'burns',
                    '31' => 'burns',
                    '35' => 'burns',
                    '53' => 'threatens',
                    '48' => 'cooks',
                    '22' => 'breaks',
                    '42' => 'burns',
                    '46' => 'burns',
                    '23' => 'burns',
                    '65' => 'burns',
                    '29' => 'burns',
                    '50' => 'burns',
                    '39' => 'burns',
                    '64' => '(campfire) by',
                    '36' => 'burns',
                    '51' => 'burns',
                    '58' => 'burns',
                    '41' => 'crackling',
                    '47' => 'burns',
                    '52' => 'burns',
                    '38' => 'burns',
                    '60' => 'burns',
                    '34' => 'burns',
                    '56' => 'thwarts',
                    '37' => 'burns',
                    '45' => 'cooks',
                    '19' => 'boils',
                    '43' => 'burns down',
                    '62' => 'creates smoke',
                    '54' => 'burns'
                  },
          '81' => {
                    '21' => 'survives',
                    '90' => 'height',
                    '7' => 'outlasts',
                    '26' => 'outlasts',
                    '17' => 'rises above',
                    '2' => 'bigger than',
                    '1' => 'survives',
                    '99' => 'fills',
                    '18' => 'unaffected by',
                    '88' => 'taller than',
                    '30' => 'challenges old',
                    '16' => 'survives',
                    '100' => 'too steep for',
                    '82' => 'houses',
                    '27' => 'houses',
                    '25' => 'houses',
                    '84' => 'contains',
                    '28' => 'houses',
                    '83' => 'houses',
                    '95' => 'houses',
                    '20' => 'outlasts',
                    '14' => 'challenges',
                    '92' => 'stimulates',
                    '24' => 'taller than',
                    '89' => 'outlasts',
                    '10' => 'made of',
                    '11' => 'transcends',
                    '91' => 'too rough for',
                    '22' => 'stands in',
                    '87' => 'houses',
                    '93' => 'conducts',
                    '23' => 'outlasts',
                    '13' => 'blocks',
                    '29' => 'houses',
                    '96' => 'represents',
                    '6' => 'echoes',
                    '85' => 'contains',
                    '3' => 'contains',
                    '97' => 'too big for',
                    '94' => 'attracts',
                    '9' => 'unaffected by',
                    '12' => 'forms',
                    '15' => 'survives',
                    '8' => 'echoes',
                    '98' => 'survives',
                    '4' => 'hides',
                    '101' => 'too high for',
                    '19' => 'unaffected by',
                    '86' => 'contains',
                    '5' => 'can\'t be'
                  },
          '52' => {
                    '67' => 'invents',
                    '90' => 'performs',
                    '63' => 'invents',
                    '71' => 'invents',
                    '70' => 'learns',
                    '80' => 'writes',
                    '68' => 'cleans',
                    '1' => 'invents',
                    '99' => 'conquers',
                    '88' => 'builds',
                    '72' => 'invents',
                    '100' => 'invents',
                    '82' => 'invents',
                    '55' => 'desires',
                    '84' => 'desires',
                    '74' => 'adapts to',
                    '95' => 'foils',
                    '83' => 'concocts',
                    '75' => 'refines',
                    '57' => 'like',
                    '61' => 'writes',
                    '92' => 'regulates',
                    '59' => 'invents',
                    '69' => 'discovers',
                    '89' => 'designs',
                    '53' => 'builds',
                    '91' => 'invents',
                    '78' => 'perceives',
                    '79' => 'outsmarts',
                    '87' => 'invents',
                    '93' => 'conducts',
                    '77' => 'replicates',
                    '96' => 'brain power',
                    '65' => 'landscapes',
                    '85' => 'desires',
                    '64' => 'travels to',
                    '97' => 'invents',
                    '94' => 'harnesses',
                    '58' => 'builds',
                    '81' => 'conquers',
                    '98' => 'invents',
                    '60' => 'writes',
                    '56' => 'foils',
                    '101' => 'invents',
                    '66' => 'directs',
                    '73' => 'brews',
                    '86' => 'desires',
                    '76' => 'invents',
                    '62' => 'names',
                    '54' => 'envisions'
                  },
          '60' => {
                    '67' => 'entertains on',
                    '90' => 'teaches',
                    '63' => 'about',
                    '71' => 'about',
                    '70' => 'teaches',
                    '7' => 'of',
                    '80' => 'of',
                    '68' => 'makes musty',
                    '2' => 'explains',
                    '1' => 'explains',
                    '99' => 'explains',
                    '88' => 'sits on',
                    '72' => 'about',
                    '100' => 'about',
                    '82' => 'about',
                    '84' => 'about',
                    '74' => 'blocks',
                    '95' => 'about',
                    '83' => 'about',
                    '75' => 'jacket resists',
                    '61' => 'uses',
                    '92' => 'about the',
                    '69' => 'about',
                    '89' => 'better than',
                    '91' => 'about',
                    '78' => 'on',
                    '79' => 'about',
                    '87' => 'about',
                    '93' => 'about',
                    '77' => 'depicts',
                    '96' => 'knowledge is',
                    '65' => 'about',
                    '6' => 'about',
                    '85' => 'about',
                    '3' => 'story has',
                    '64' => 'about',
                    '97' => 'about',
                    '94' => 'about',
                    '9' => 'about',
                    '8' => 'makes you smart as',
                    '81' => 'about',
                    '4' => 'fills boredom',
                    '98' => 'about',
                    '101' => 'about',
                    '73' => 'about',
                    '66' => 'better than',
                    '76' => 'better than',
                    '86' => 'about',
                    '62' => 'about',
                    '5' => 'starts'
                  },
          '56' => {
                    '67' => 'uses',
                    '90' => 'teaches',
                    '63' => 'flies on',
                    '71' => 'discards',
                    '70' => 'plays',
                    '80' => 'laughs at',
                    '68' => 'breathes',
                    '2' => 'flies in',
                    '1' => 'survives',
                    '99' => 'flies in',
                    '88' => 'flies over',
                    '72' => 'discards',
                    '100' => 'survives',
                    '82' => 'defines',
                    '84' => 'seduces with',
                    '74' => 'stalks in',
                    '95' => 'outlives',
                    '83' => 'outlives',
                    '75' => 'discards',
                    '57' => 'discards',
                    '61' => 'writes on',
                    '92' => 'has immortal',
                    '59' => 'discards',
                    '69' => 'legendary across',
                    '89' => 'in',
                    '91' => 'before',
                    '78' => 'before',
                    '79' => 'before',
                    '87' => 'defines',
                    '93' => 'conducts',
                    '77' => 'never sees',
                    '96' => 'has great',
                    '65' => 'walks on',
                    '85' => 'owns',
                    '3' => 'flies over',
                    '64' => 'lives by',
                    '97' => 'survives',
                    '94' => 'resists',
                    '58' => 'angers',
                    '81' => 'flies over',
                    '4' => 'lives in',
                    '98' => 'survives',
                    '60' => 'in',
                    '101' => 'flies',
                    '73' => 'seduces with',
                    '66' => 'in',
                    '76' => 'on',
                    '86' => 'owns',
                    '62' => 'prefers',
                    '5' => 'escapes'
                  },
          '101' => {
                     '33' => 'carries',
                     '32' => 'carries',
                     '21' => 'flies over',
                     '7' => 'imposes',
                     '26' => 'gets',
                     '17' => 'flies over',
                     '2' => 'flies over',
                     '1' => 'drops',
                     '18' => 'flies over',
                     '30' => 'carries',
                     '16' => 'flies over',
                     '44' => 'flies over',
                     '27' => 'flies over',
                     '25' => 'flies over',
                     '28' => 'flies over',
                     '40' => 'faster than',
                     '20' => 'flies over',
                     '14' => 'carries',
                     '49' => 'flies over',
                     '24' => 'flies over',
                     '10' => 'flies over',
                     '31' => 'carries',
                     '35' => 'carries',
                     '11' => 'causes',
                     '48' => 'faster than',
                     '42' => 'faster than',
                     '22' => 'disturbs',
                     '46' => 'flies over',
                     '13' => 'cloud blocks',
                     '23' => 'uses',
                     '29' => 'flies over',
                     '6' => 'has',
                     '50' => 'flies over',
                     '39' => 'faster than',
                     '36' => 'carries',
                     '3' => 'flies over',
                     '9' => 'flies over',
                     '41' => 'makes',
                     '12' => 'flies over',
                     '47' => 'flies over',
                     '15' => 'flies over',
                     '38' => 'flies over',
                     '8' => 'flies over',
                     '4' => 'flies over',
                     '34' => 'carries',
                     '45' => 'flies over',
                     '37' => 'carries',
                     '43' => 'flies over',
                     '19' => 'flies over',
                     '5' => 'breaks'
                   },
          '73' => {
                    '21' => 'rusts',
                    '90' => 'measured with',
                    '7' => 'breaks',
                    '80' => 'answers',
                    '17' => 'angers',
                    '2' => 'after',
                    '1' => 'soaks',
                    '99' => 'no matter what',
                    '18' => 'rusts',
                    '88' => 'sits on',
                    '16' => 'affects',
                    '100' => 'affects',
                    '82' => 'logo depicts',
                    '74' => 'despite',
                    '84' => 'logo has',
                    '95' => 'chokes',
                    '75' => 'tastier than',
                    '83' => 'logo has',
                    '20' => 'rusts',
                    '14' => 'inspires',
                    '92' => 'affects',
                    '89' => 'inspires',
                    '10' => 'rolling',
                    '11' => 'toasts',
                    '91' => 'short-circuits',
                    '78' => 'invokes',
                    '79' => 'chokes',
                    '22' => 'brings',
                    '87' => 'drinker is',
                    '77' => 'flavor',
                    '93' => 'conducts',
                    '13' => 'catches',
                    '96' => 'gives false',
                    '6' => 'inspires',
                    '85' => 'colored',
                    '3' => 'floats on',
                    '94' => 'logo depicts',
                    '97' => 'diffracts',
                    '9' => 'rusts',
                    '12' => 'on the',
                    '15' => 'by the',
                    '8' => 'inspires',
                    '81' => 'logo has',
                    '98' => 'is brain',
                    '4' => 'fills',
                    '101' => 'affects',
                    '19' => 'can be',
                    '86' => 'colored',
                    '76' => 'sits on',
                    '5' => 'rusts'
                  },
          '66' => {
                    '67' => 'in the can (',
                    '90' => 'teaches',
                    '71' => 'covers super',
                    '70' => 'score uses',
                    '7' => 'about',
                    '80' => 'disrupts',
                    '68' => 'developer spoils',
                    '2' => 'about',
                    '1' => 'effects use',
                    '99' => 'earnings',
                    '88' => 'projected on',
                    '72' => 'covers world',
                    '100' => 'rents',
                    '82' => 'about',
                    '84' => 'about',
                    '74' => '- singing in the',
                    '95' => 'features',
                    '75' => 'coats',
                    '83' => 'about',
                    '14' => 'fills',
                    '92' => 'has',
                    '69' => 'entertains',
                    '89' => 'based on',
                    '10' => 'starring the',
                    '11' => 'glorifies',
                    '91' => 'about',
                    '78' => 'about',
                    '79' => 'about',
                    '87' => 'about',
                    '77' => 'has technicolor',
                    '93' => 'teaches',
                    '13' => 'production prefers',
                    '96' => 'grants',
                    '6' => 'rents',
                    '85' => 'pricier than',
                    '3' => 'scene with',
                    '94' => 'about',
                    '97' => 'becomes',
                    '9' => 'hero uses',
                    '12' => 'projected on',
                    '15' => 'captures',
                    '8' => 'hero uses',
                    '81' => 'set on',
                    '4' => 'is the',
                    '98' => 'depicts',
                    '101' => 'rents',
                    '73' => 'inspires',
                    '76' => 'before',
                    '86' => 'pricier than',
                    '5' => 'edits'
                  },
          '45' => {
                    '67' => 'goes everyhere but',
                    '90' => 'doesn\'t need',
                    '63' => 'blocks',
                    '71' => 'tips over',
                    '70' => 'ruins',
                    '80' => 'answers',
                    '68' => 'breathes',
                    '88' => 'flies over',
                    '72' => 'tips over',
                    '82' => 'doesn\'t interest',
                    '55' => 'costs',
                    '84' => 'swallows',
                    '74' => 'loves',
                    '95' => 'bites',
                    '83' => 'at',
                    '75' => 'drinks',
                    '57' => 'eats',
                    '61' => 'carries off',
                    '92' => 'has',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '89' => 'hunt',
                    '53' => 'feeds',
                    '91' => 'flies over',
                    '78' => 'hides from',
                    '48' => 'larger than',
                    '79' => 'hides from',
                    '87' => 'doesn\'t interest',
                    '93' => 'on wire despite',
                    '77' => 'looks at',
                    '46' => 'flies from',
                    '65' => 'nests in',
                    '50' => 'eats',
                    '85' => 'swallows',
                    '64' => 'looks at',
                    '94' => 'hides from',
                    '51' => 'eats',
                    '58' => 'disrupts',
                    '47' => 'intimidates',
                    '81' => 'flies over',
                    '52' => 'has',
                    '60' => 'recipe',
                    '56' => 'disgusts',
                    '66' => 'on',
                    '73' => 'drinks',
                    '86' => 'lays',
                    '76' => 'on',
                    '62' => 'flies in',
                    '54' => 'acts'
                  },
          '86' => {
                    '33' => 'adorns',
                    '32' => 'adorns',
                    '21' => 'plated',
                    '90' => 'market uses',
                    '7' => 'bribes',
                    '26' => 'outlasts',
                    '17' => 'more desirable than',
                    '2' => 'survives',
                    '1' => 'survives',
                    '99' => 'reflects',
                    '18' => 'plated',
                    '88' => 'funds',
                    '30' => 'adorns',
                    '16' => 'resists',
                    '100' => 'funds',
                    '27' => 'harder than',
                    '25' => 'charms',
                    '28' => 'attracts',
                    '95' => 'enthralls',
                    '20' => 'plated',
                    '14' => 'pricier than',
                    '92' => 'wins',
                    '24' => 'funds',
                    '89' => 'pricier than',
                    '10' => 'rarer than',
                    '31' => 'adorns',
                    '35' => 'enthralls',
                    '11' => 'outlasts',
                    '91' => 'plated',
                    '22' => 'disturbs',
                    '87' => 'tempts',
                    '93' => 'conducts',
                    '23' => 'wired',
                    '13' => 'reflects',
                    '29' => 'hypnotizes',
                    '96' => 'conducts',
                    '6' => 'plated',
                    '3' => 'hides in',
                    '97' => 'wired',
                    '94' => 'conducts',
                    '9' => 'decorates',
                    '12' => 'plated',
                    '15' => 'resists',
                    '8' => 'resists',
                    '98' => 'wired',
                    '4' => 'hides in',
                    '34' => 'badged',
                    '101' => 'funds',
                    '19' => 'resists',
                    '5' => 'gold chain'
                  },
          '76' => {
                    '21' => 'show',
                    '90' => 'tech uses',
                    '7' => 'regulators make',
                    '80' => 'delivers',
                    '17' => 'teaches',
                    '2' => 'predicts',
                    '1' => 'character says',
                    '99' => 'replaces',
                    '18' => 'resists',
                    '88' => 'broadcast over',
                    '16' => 'airs',
                    '100' => 'guides',
                    '82' => 'about',
                    '25' => 'run by',
                    '84' => 'sharp as',
                    '95' => 'about',
                    '83' => 'about',
                    '20' => 'turns room into',
                    '14' => 'tv camera',
                    '92' => 'bad for',
                    '24' => 'about',
                    '89' => 'before',
                    '10' => 'airs rock concert',
                    '11' => 'glorifies',
                    '91' => 'before',
                    '78' => 'debunks',
                    '79' => 'debunks',
                    '22' => 'disturbs',
                    '87' => 'inspires',
                    '77' => 'color',
                    '93' => 'uses',
                    '23' => 'before',
                    '13' => 'about',
                    '96' => 'consumes',
                    '6' => 'glorifies',
                    '85' => 'wires are',
                    '3' => 'time',
                    '94' => 'attracts',
                    '97' => 'media uses',
                    '9' => 'about',
                    '12' => 'hangs on',
                    '15' => 'reports',
                    '81' => 'broadcast over',
                    '8' => 'sharp as a',
                    '98' => 'about',
                    '4' => 'is the',
                    '101' => 'news',
                    '19' => 'is',
                    '86' => 'wires are',
                    '5' => 'stolen despite'
                  },
          '19' => {
                    '67' => 'on',
                    '33' => 'kills',
                    '32' => 'kills',
                    '63' => 'endangers',
                    '21' => 'on',
                    '68' => 'can be',
                    '26' => 'targets',
                    '30' => 'kills',
                    '44' => 'in',
                    '55' => 'costs',
                    '25' => 'kills',
                    '27' => 'kills',
                    '28' => 'kills',
                    '57' => 'in',
                    '40' => 'impairs',
                    '61' => 'soaks',
                    '20' => 'faster than',
                    '69' => 'endangers',
                    '59' => 'in',
                    '49' => 'kills',
                    '24' => 'endangers',
                    '31' => 'kills',
                    '35' => 'kills',
                    '53' => 'endangers',
                    '48' => 'kills',
                    '22' => 'ruins',
                    '42' => 'kills',
                    '46' => 'kills',
                    '23' => 'short-circuits',
                    '65' => 'kills',
                    '29' => 'kills',
                    '50' => 'kills',
                    '39' => 'endangers',
                    '64' => 'by',
                    '36' => 'kills',
                    '51' => 'kills',
                    '58' => 'endangers',
                    '41' => 'makes no',
                    '47' => 'kills',
                    '38' => 'endangers',
                    '52' => 'kills',
                    '60' => 'in',
                    '34' => 'kills',
                    '56' => 'knocks out',
                    '66' => 'inspires',
                    '37' => 'kills',
                    '45' => 'kills',
                    '43' => 'kills',
                    '62' => 'in acid rain',
                    '54' => 'brings red'
                  },
          '62' => {
                    '67' => 'surrounds',
                    '90' => 'cancels',
                    '63' => 'diverts',
                    '71' => 'rains in',
                    '70' => 'adorns',
                    '7' => 'knows no',
                    '80' => 'despite',
                    '68' => 'made of',
                    '2' => 'becomes',
                    '1' => 'rains on',
                    '99' => 'decorates',
                    '88' => 'over',
                    '72' => 'rains in',
                    '100' => 'over',
                    '82' => 'indicates',
                    '84' => 'over',
                    '74' => 'produces',
                    '95' => 'over',
                    '83' => 'over',
                    '75' => 'contains',
                    '92' => 'makes',
                    '69' => 'covers',
                    '89' => 'in',
                    '10' => 'over',
                    '11' => 'indicates',
                    '91' => 'over',
                    '78' => 'blocks',
                    '79' => 'blocks',
                    '87' => 'indicates',
                    '77' => 'blocks',
                    '93' => 'conducts',
                    '96' => 'disrupts solar',
                    '65' => 'over',
                    '6' => 'too far for',
                    '85' => 'over',
                    '3' => 'over',
                    '64' => 'blocks',
                    '97' => 'not affected by',
                    '94' => 'brings',
                    '9' => 'over',
                    '8' => 'over',
                    '81' => 'over',
                    '4' => 'over',
                    '98' => 'diverts',
                    '101' => 'over',
                    '73' => 'rains in',
                    '66' => 'ruins',
                    '76' => 'on',
                    '86' => 'over',
                    '5' => 'starts'
                  },
          '54' => {
                    '67' => 'blesses',
                    '90' => 'adds for',
                    '63' => 'blesses',
                    '71' => 'blesses',
                    '70' => 'blesses',
                    '80' => 'in',
                    '68' => 'winds move',
                    '2' => 'fingers before',
                    '1' => 'fingers before',
                    '99' => 'lights up',
                    '88' => 'tears down',
                    '72' => 'on holy',
                    '100' => 'blesses',
                    '82' => 'denounces',
                    '55' => 'costs',
                    '84' => 'jewelry holds',
                    '74' => 'winds bring',
                    '95' => 'thwarts',
                    '83' => 'denounces',
                    '75' => 'blesses holy',
                    '57' => 'impales',
                    '61' => 'drawn on',
                    '92' => 'your',
                    '59' => 'impales',
                    '69' => 'blesses',
                    '89' => 'platform',
                    '91' => 'section diagram of',
                    '78' => 'doesn\'t interest',
                    '79' => 'doesn\'t interest',
                    '87' => 'denounces',
                    '93' => 'conducts',
                    '77' => 'reflects',
                    '96' => 'represents',
                    '65' => 'erected in',
                    '85' => 'made of',
                    '3' => 'above',
                    '64' => 'tracks on',
                    '97' => 'reflects',
                    '94' => 'attracts',
                    '58' => 'atop',
                    '81' => 'atop',
                    '98' => 'bans',
                    '60' => 'on good',
                    '56' => 'thwarts',
                    '101' => 'blesses',
                    '66' => 'on',
                    '73' => 'adorns',
                    '76' => 'hangs over',
                    '86' => 'made of',
                    '62' => 'clears'
                  },
          '67' => {
                    '90' => 'easier than',
                    '71' => 'toilet bowl',
                    '70' => '-mouthed guitarist',
                    '7' => 'flushes',
                    '80' => 'answers',
                    '68' => 'spoils',
                    '2' => 'survives',
                    '1' => 'stinkier than',
                    '99' => 'stinks',
                    '88' => 'can be',
                    '72' => 'holds more than',
                    '16' => 'resists',
                    '100' => 'toilet tank',
                    '82' => 'smells of',
                    '74' => 'catches',
                    '84' => 'hides',
                    '95' => 'less stinky than',
                    '75' => 'uses',
                    '83' => 'confuses',
                    '14' => 'flushes',
                    '92' => 'good for',
                    '69' => 'pollutes',
                    '89' => 'disrupts',
                    '10' => 'hard as',
                    '11' => 'smells of',
                    '91' => 'confuses',
                    '78' => 'holds',
                    '87' => 'smells like',
                    '77' => 'reflects',
                    '93' => 'conducts',
                    '13' => 'better without',
                    '96' => 'has stink',
                    '6' => 'resists',
                    '85' => 'colored',
                    '3' => 'contains',
                    '94' => 'attracts',
                    '97' => 'reflects',
                    '9' => 'resists',
                    '12' => 'more legal than',
                    '15' => 'douses',
                    '8' => 'resists',
                    '81' => 'holds',
                    '4' => 'is the',
                    '98' => 'smells like',
                    '101' => 'need diverts',
                    '73' => 'soon contains',
                    '76' => 'less offensive than',
                    '86' => 'contains',
                    '5' => 'uses'
                  },
          '70' => {
                    '90' => 'notes use',
                    '71' => 'at hollywood',
                    '7' => 'breaks',
                    '80' => 'accompanies',
                    '17' => 'distracts',
                    '2' => 'cheers',
                    '1' => 'rallies against',
                    '99' => 'echoes across',
                    '18' => 'strings resists',
                    '88' => 'heard over',
                    '72' => 'fills donation',
                    '16' => 'sounds like',
                    '100' => 'rallies against',
                    '82' => 'invokes',
                    '74' => 'notes like',
                    '84' => 'shines like',
                    '95' => 'hypnotizes',
                    '75' => 'echoes across',
                    '83' => 'subdues',
                    '14' => 'pricier than',
                    '92' => 'played with',
                    '89' => 'sountracks',
                    '10' => 'plays',
                    '11' => 'song about',
                    '91' => 'confuses',
                    '78' => 'group',
                    '79' => 'intrigues',
                    '87' => 'invokes',
                    '77' => 'song about',
                    '93' => 'uses',
                    '13' => 'reflects',
                    '96' => 'power ballad',
                    '6' => 'rallies against',
                    '85' => 'album goes',
                    '3' => 'floats in',
                    '94' => 'fingered like',
                    '97' => 'concert uses',
                    '9' => 'stays',
                    '12' => 'echoes off',
                    '15' => 'on',
                    '8' => 'accompanies',
                    '81' => 'echoes across',
                    '4' => 'echoes',
                    '98' => 'rallies against',
                    '73' => 'inspires',
                    '101' => 'rallies against',
                    '19' => 'poisons ears',
                    '86' => 'album goes',
                    '76' => 'on',
                    '5' => 'breaks'
                  },
          '68' => {
                    '90' => 'scatters',
                    '71' => 'tips over',
                    '70' => 'air guitar',
                    '7' => 'scatters',
                    '80' => 'echoes',
                    '17' => 'headed',
                    '2' => 'creates',
                    '1' => 'blows out',
                    '99' => 'becomes',
                    '88' => 'wobbles',
                    '72' => 'tips over',
                    '16' => 'echoes',
                    '100' => 'air tank',
                    '82' => 'chokes',
                    '74' => 'creates',
                    '84' => 'scatters',
                    '95' => 'freezes',
                    '75' => 'evaporates',
                    '83' => 'freezes',
                    '14' => 'knocks over',
                    '92' => 'feeds',
                    '69' => 'covers',
                    '89' => 'freezes',
                    '10' => 'erodes',
                    '11' => 'carries smell of',
                    '91' => 'tarnishes',
                    '78' => 'chokes',
                    '79' => 'chokes',
                    '87' => 'chokes',
                    '77' => 'suspends',
                    '93' => 'conducts',
                    '13' => 'cools heat of',
                    '96' => 'makes wind',
                    '6' => 'tarnishes',
                    '85' => 'cools',
                    '3' => 'escapes',
                    '94' => 'conducts',
                    '97' => 'weakens',
                    '9' => 'tarnishes',
                    '12' => 'buffets',
                    '15' => 'spreads',
                    '8' => 'echoes',
                    '81' => 'chills',
                    '4' => 'fills',
                    '98' => 'blows astray',
                    '101' => 'tosses',
                    '73' => 'stales',
                    '76' => 'headed',
                    '86' => 'cools',
                    '5' => 'tarnishes'
                  },
          '2' => {
                   '33' => 'sweeps away',
                   '32' => 'sweeps away',
                   '21' => 'sweeps away',
                   '7' => 'knows no',
                   '26' => 'spills',
                   '17' => 'destroys',
                   '18' => 'sweeps away',
                   '30' => 'sweeps away',
                   '16' => 'sweeps away',
                   '44' => 'sweeps away',
                   '27' => 'sweeps away',
                   '25' => 'sweeps away',
                   '28' => 'sweeps away',
                   '40' => 'sweeps away',
                   '20' => 'sweeps away',
                   '14' => 'challenges',
                   '49' => 'sweeps away',
                   '24' => 'destroys',
                   '10' => 'sweeps away',
                   '31' => 'sweeps away',
                   '35' => 'sweeps away',
                   '11' => 'causes',
                   '48' => 'sweeps away',
                   '42' => 'sweeps away',
                   '22' => 'disturbs',
                   '46' => 'sweeps away',
                   '13' => 'blocks',
                   '23' => 'destroys',
                   '29' => 'sweeps away',
                   '6' => 'sweeps away',
                   '50' => 'sweeps away',
                   '39' => 'derails',
                   '3' => 'outclasses',
                   '36' => 'sweeps away',
                   '51' => 'wrecks home of',
                   '9' => 'sweeps away',
                   '41' => 'makes',
                   '12' => 'destroys',
                   '47' => 'sweeps away',
                   '15' => 'starts',
                   '52' => 'confounds',
                   '38' => 'destroys',
                   '8' => 'sweeps away',
                   '4' => 'is air',
                   '34' => 'sweeps away',
                   '45' => 'sweeps away',
                   '37' => 'sweeps away',
                   '43' => 'sweeps away',
                   '19' => 'sweeps away',
                   '5' => 'breaks'
                 },
          '17' => {
                    '67' => 'has',
                    '33' => 'teaches about',
                    '32' => 'teaches about',
                    '63' => 'teaches about',
                    '21' => 'makes you sharper than',
                    '26' => 'teaches about',
                    '18' => 'children use',
                    '30' => 'teaches about',
                    '44' => 'teaches about',
                    '55' => 'lunch',
                    '25' => 'teaches about',
                    '27' => 'teaches about',
                    '28' => 'teaches about',
                    '57' => 'kitchen has',
                    '40' => 'teaches',
                    '61' => 'makes you write',
                    '20' => 'is',
                    '59' => 'kitchen has',
                    '49' => 'teaches about',
                    '24' => 'teaches about',
                    '31' => 'teaches about',
                    '35' => 'teaches',
                    '53' => 'educates',
                    '48' => 'teaches about',
                    '22' => 'requires',
                    '42' => 'teaches',
                    '46' => 'teaches about',
                    '23' => 'uses',
                    '65' => 'yard has',
                    '29' => 'teaches about',
                    '50' => 'houses',
                    '39' => 'trains',
                    '64' => 'teaches about',
                    '36' => 'teaches',
                    '51' => 'houses',
                    '58' => 'ignores',
                    '41' => 'bell makes',
                    '47' => 'teaches about',
                    '38' => 'away from',
                    '52' => 'nourishes',
                    '60' => 'has',
                    '34' => 'trains',
                    '56' => 'play about',
                    '66' => 'shows',
                    '37' => 'teaches',
                    '45' => 'teaches about',
                    '19' => 'teaches about',
                    '43' => 'yard has',
                    '62' => 'teaches about',
                    '54' => 'bans'
                  },
          '1' => {
                   '33' => 'explodes',
                   '32' => 'explodes',
                   '21' => 'explodes',
                   '7' => 'breaks',
                   '26' => 'spills',
                   '17' => 'explodes',
                   '2' => 'outclasses',
                   '18' => 'explodes',
                   '30' => 'explodes',
                   '16' => 'explodes',
                   '44' => 'explodes',
                   '27' => 'explodes',
                   '25' => 'explodes',
                   '28' => 'explodes',
                   '40' => 'explodes',
                   '20' => 'explodes',
                   '14' => 'explodes',
                   '49' => 'explodes',
                   '24' => 'explodes',
                   '10' => 'explodes',
                   '31' => 'explodes',
                   '35' => 'explodes',
                   '11' => 'causes',
                   '48' => 'explodes',
                   '42' => 'explodes',
                   '22' => 'disturbs',
                   '46' => 'explodes',
                   '13' => 'smoke blots out',
                   '23' => 'explodes',
                   '29' => 'explodes',
                   '6' => 'outclasses',
                   '50' => 'explodes',
                   '39' => 'explodes',
                   '36' => 'explodes',
                   '3' => 'clears',
                   '51' => 'explodes',
                   '9' => 'explodes',
                   '41' => 'makes',
                   '12' => 'explodes',
                   '47' => 'explodes',
                   '15' => 'starts',
                   '38' => 'explodes',
                   '8' => 'explodes',
                   '4' => 'creates',
                   '34' => 'explodes',
                   '45' => 'explodes',
                   '37' => 'explodes',
                   '43' => 'explodes',
                   '19' => 'explodes',
                   '5' => 'explodes'
                 },
          '88' => {
                    '33' => 'around',
                    '32' => 'around',
                    '21' => 'resists',
                    '90' => 'height',
                    '7' => 'breaks zoning',
                    '26' => 'guards',
                    '17' => 'around',
                    '2' => 'survives',
                    '1' => 'guards',
                    '99' => 'blocks',
                    '18' => 'resists',
                    '30' => 'around',
                    '16' => 'guards',
                    '100' => 'blocks',
                    '27' => 'blocks',
                    '25' => 'blocks',
                    '28' => 'blocks',
                    '95' => 'blocks',
                    '20' => 'surrounds',
                    '14' => 'confuses',
                    '92' => 'saddens',
                    '24' => 'around',
                    '89' => 'guards',
                    '10' => 'made of',
                    '31' => 'around',
                    '35' => 'around',
                    '11' => 'guards from',
                    '91' => 'blocks',
                    '22' => 'protects',
                    '93' => 'uses',
                    '23' => 'around',
                    '13' => 'blocks',
                    '29' => 'blocks',
                    '96' => 'around',
                    '6' => 'guards',
                    '36' => 'around',
                    '3' => 'above',
                    '97' => 'blocks',
                    '94' => 'attracts',
                    '9' => 'resists',
                    '12' => 'forms',
                    '15' => 'surrounds',
                    '8' => 'resists',
                    '98' => 'guards',
                    '4' => 'around',
                    '34' => 'blocks',
                    '37' => 'around',
                    '101' => 'guards',
                    '19' => 'resists',
                    '5' => 'made of'
                  },
          '30' => {
                    '67' => 'uses',
                    '33' => 'rules over',
                    '32' => 'rules over',
                    '63' => 'flies on',
                    '71' => 'eats from',
                    '70' => 'outlaws',
                    '80' => 'in',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'eats',
                    '55' => 'has',
                    '74' => 'walks in',
                    '75' => 'drinks',
                    '57' => 'owns',
                    '40' => 'rides in',
                    '61' => 'writes',
                    '69' => 'declares flat',
                    '59' => 'eats',
                    '49' => 'eats',
                    '31' => 'rules over',
                    '35' => 'rules',
                    '53' => 'rules',
                    '78' => 'disbelieves',
                    '79' => 'disbelieves',
                    '48' => 'eats',
                    '42' => 'rides',
                    '77' => 'looks at',
                    '46' => 'tames',
                    '65' => 'walks on',
                    '50' => 'steps on',
                    '39' => 'rides on',
                    '64' => 'looks at',
                    '36' => 'sires',
                    '51' => 'steps on',
                    '41' => 'outlaws',
                    '58' => 'funds',
                    '47' => 'owns',
                    '38' => 'taxes',
                    '52' => 'has',
                    '60' => 'inspires',
                    '34' => 'governs',
                    '56' => 'could be',
                    '73' => 'drinks',
                    '66' => 'inspires',
                    '45' => 'eats',
                    '37' => 'rules',
                    '76' => 'on',
                    '43' => 'owns',
                    '62' => 'looks at',
                    '54' => 'erects'
                  },
          '100' => {
                     '33' => 'squashes',
                     '32' => 'squashes',
                     '21' => 'outclasses',
                     '7' => 'imposes',
                     '26' => 'spills',
                     '17' => 'crumbles',
                     '2' => 'survives',
                     '1' => 'resists',
                     '18' => 'crushes',
                     '30' => 'squashes',
                     '16' => 'outclasses',
                     '44' => 'pulverizes',
                     '27' => 'squashes',
                     '25' => 'flattens',
                     '28' => 'attracts',
                     '40' => 'flattens',
                     '20' => 'smashes through',
                     '14' => 'crushes',
                     '49' => 'squooshes',
                     '24' => 'seiges',
                     '10' => 'crumbles',
                     '31' => 'squashes',
                     '35' => 'squashes',
                     '11' => 'brings',
                     '48' => 'squashes',
                     '42' => 'flattens',
                     '22' => 'breaks',
                     '46' => 'squashes',
                     '13' => 'cloud blocks',
                     '23' => 'flattens',
                     '29' => 'squishes',
                     '6' => 'has',
                     '39' => 'barrels though',
                     '36' => 'squashes',
                     '3' => 'plows over',
                     '9' => 'outclasses',
                     '41' => 'makes',
                     '12' => 'crumbles',
                     '47' => 'squashes',
                     '15' => 'resists',
                     '38' => 'flattens',
                     '8' => 'outclasses',
                     '4' => 'creates',
                     '34' => 'outclasses',
                     '45' => 'squashes',
                     '37' => 'squashes',
                     '101' => 'outclasses',
                     '43' => 'knocks down',
                     '19' => 'more direct than',
                     '5' => 'breaks'
                   },
          '82' => {
                    '21' => 'laughs at',
                    '90' => 'good at',
                    '7' => 'knows no',
                    '26' => 'poisons',
                    '17' => 'enthralls',
                    '2' => 'commands',
                    '1' => 'laughs at',
                    '99' => 'darkens',
                    '18' => 'laughs at',
                    '88' => 'knows no',
                    '30' => 'possesses',
                    '16' => 'evades',
                    '100' => 'laughs at',
                    '27' => 'sharper than',
                    '25' => 'is',
                    '84' => 'likes king',
                    '28' => 'is soul',
                    '83' => 'commands',
                    '95' => 'commands',
                    '20' => 'escapes',
                    '14' => 'evades',
                    '92' => 'darkens',
                    '24' => 'has',
                    '89' => 'inspires',
                    '10' => 'hurls',
                    '31' => 'possesses',
                    '11' => 'after',
                    '91' => 'laughs at',
                    '22' => 'prevents',
                    '87' => 'commands',
                    '93' => 'doesn\'t need',
                    '23' => 'laughs at',
                    '13' => 'curses',
                    '29' => 'owns',
                    '96' => 'has',
                    '6' => 'laughs at',
                    '85' => 'tempts with',
                    '3' => 'dispels',
                    '97' => 'laughs at',
                    '94' => 'brings',
                    '9' => 'laughs at',
                    '12' => 'knows no',
                    '15' => 'commands',
                    '8' => 'cracks',
                    '98' => 'laughs at',
                    '4' => 'commands',
                    '101' => 'laughs at',
                    '19' => 'laughs at',
                    '86' => 'tempts with',
                    '5' => 'un'
                  },
          '25' => {
                    '67' => 'hides in',
                    '33' => 'bites',
                    '32' => 'bites',
                    '63' => 'on a',
                    '71' => 'sleeps in',
                    '70' => 'hides in',
                    '68' => 'breathes',
                    '26' => 'poisons',
                    '72' => 'tips over',
                    '30' => 'bites',
                    '44' => 'swallows',
                    '55' => 'swallows',
                    '74' => 'hunts despite',
                    '27' => 'scares',
                    '28' => 'hides from',
                    '75' => 'drinks',
                    '57' => 'swallows',
                    '40' => 'creeps into',
                    '61' => 'nests in',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '31' => 'bites',
                    '35' => 'bites',
                    '53' => 'terrorizes',
                    '48' => 'eats',
                    '42' => 'entangles',
                    '46' => 'bites',
                    '65' => 'in the',
                    '29' => 'bites',
                    '50' => 'eats',
                    '39' => 'terrorizes',
                    '64' => 'nocturnal with',
                    '36' => 'scares',
                    '51' => 'eats',
                    '58' => 'creeps into',
                    '41' => 'rattles',
                    '47' => 'bites',
                    '38' => 'creeps into',
                    '52' => 'intimidates',
                    '60' => 'swallows',
                    '34' => 'bites',
                    '56' => 'charms',
                    '73' => 'spills',
                    '66' => 'inspires',
                    '37' => 'bites',
                    '45' => 'eats',
                    '43' => 'climbs',
                    '62' => 'not affected by',
                    '54' => 'climbs'
                  },
          '28' => {
                    '67' => 'doesn\'t need',
                    '33' => 'eats',
                    '32' => 'eats',
                    '63' => 'flies like',
                    '71' => 'tips over',
                    '70' => 'scratches',
                    '68' => 'breathes',
                    '72' => 'tips over',
                    '30' => 'eats',
                    '44' => 'flies over',
                    '55' => 'carries off',
                    '74' => 'hunts despite',
                    '75' => 'drinks',
                    '57' => 'carries off',
                    '40' => 'flies over',
                    '61' => 'tears up',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '31' => 'eats',
                    '35' => 'eats',
                    '53' => 'annoys',
                    '78' => 'spots',
                    '48' => 'is large',
                    '42' => 'flies over',
                    '77' => 'looks at',
                    '46' => 'eats',
                    '65' => 'lands in',
                    '29' => 'eats',
                    '50' => 'eats',
                    '39' => 'flies over',
                    '64' => 'hunts by',
                    '36' => 'eats',
                    '51' => 'eats',
                    '41' => 'makes no',
                    '58' => 'flies over',
                    '47' => 'eats',
                    '38' => 'flies over',
                    '52' => 'has',
                    '60' => 'tears up',
                    '34' => 'eats',
                    '56' => 'delivers to',
                    '73' => 'spills',
                    '66' => 'shreds',
                    '37' => 'eats',
                    '45' => 'larger than',
                    '76' => 'on',
                    '43' => 'flies over',
                    '62' => 'flies among',
                    '54' => 'perches on'
                  },
          '83' => {
                    '32' => 'eats',
                    '21' => 'resists',
                    '90' => 'doesn\'t use',
                    '7' => 'knows no',
                    '26' => 'spills',
                    '17' => 'torches',
                    '2' => 'flies over',
                    '1' => 'before',
                    '99' => 'flies across',
                    '18' => 'resists',
                    '88' => 'flies over',
                    '30' => 'angers',
                    '16' => 'before',
                    '100' => 'before',
                    '27' => 'outclasses',
                    '25' => 'bigger than',
                    '84' => 'hoards',
                    '28' => 'torches',
                    '95' => 'torches',
                    '20' => 'escapes',
                    '14' => 'before',
                    '92' => 'dragon heart',
                    '24' => 'terrorizes',
                    '89' => 'in',
                    '10' => 'atop',
                    '31' => 'angers',
                    '11' => 'causes',
                    '91' => 'torches',
                    '22' => 'disturbs',
                    '87' => 'commands',
                    '93' => 'conducts',
                    '23' => 'before',
                    '13' => 'flies across',
                    '29' => 'torches',
                    '96' => 'has',
                    '6' => 'resists',
                    '85' => 'hoards',
                    '3' => 'too big for',
                    '97' => 'before',
                    '94' => 'breathes',
                    '9' => 'resists',
                    '12' => 'flies over',
                    '15' => 'breathes',
                    '8' => 'torches',
                    '98' => 'before',
                    '4' => 'escapes',
                    '101' => 'before',
                    '19' => 'breath is',
                    '86' => 'hoards',
                    '5' => 'breaks'
                  },
          '75' => {
                    '21' => 'rusts',
                    '90' => 'measured with',
                    '7' => 'has',
                    '80' => 'answers',
                    '17' => 'leak closes',
                    '2' => 'spout',
                    '1' => 'soaks',
                    '99' => 'reflects',
                    '18' => 'rusts',
                    '88' => 'rises over',
                    '16' => 'floods',
                    '100' => 'short-circuits',
                    '82' => 'drowns',
                    '84' => 'cleans',
                    '95' => 'drowns',
                    '83' => 'drowns',
                    '20' => 'rusts',
                    '14' => 'ruins',
                    '92' => 'strengthens',
                    '24' => 'floods',
                    '89' => 'damages',
                    '10' => 'erodes',
                    '11' => 'causes',
                    '91' => 'short-circuits',
                    '78' => 'diverts',
                    '79' => 'toxic to',
                    '22' => 'inspires',
                    '87' => 'drowns',
                    '77' => 'creates',
                    '93' => 'conducts',
                    '23' => 'short-circuits',
                    '13' => 'reflects',
                    '96' => 'creates hydro',
                    '6' => 'rusts',
                    '85' => 'cleans',
                    '3' => 'floats on',
                    '94' => 'attracts',
                    '97' => 'diffracts',
                    '9' => 'rusts',
                    '12' => 'cleans',
                    '15' => 'douses',
                    '8' => 'soaks',
                    '81' => 'rains on',
                    '98' => 'short-circuits',
                    '4' => 'fills',
                    '101' => 'short-circuits',
                    '19' => 'dilutes',
                    '86' => 'cleans',
                    '76' => 'damages',
                    '5' => 'rusts'
                  },
          '40' => {
                    '67' => 'has no',
                    '90' => 'to',
                    '63' => 'to',
                    '71' => 'carries',
                    '70' => 'radio plays',
                    '80' => 'inspires',
                    '68' => 'is',
                    '88' => 'wrecks',
                    '72' => 'has',
                    '44' => 'carries',
                    '82' => 'amuses',
                    '55' => 'costs',
                    '84' => 'pricier than',
                    '74' => 'drives in',
                    '83' => 'outruns',
                    '75' => 'coolant is',
                    '57' => 'is money',
                    '61' => 'has',
                    '69' => 'travels',
                    '59' => 'sexier than',
                    '49' => 'carries',
                    '89' => 'in',
                    '53' => 'congests',
                    '78' => 'attracts',
                    '79' => 'intrigues',
                    '48' => 'hits',
                    '42' => 'faster than',
                    '87' => 'amuses',
                    '77' => 'reflects',
                    '46' => 'scares',
                    '65' => 'destroys',
                    '50' => 'houses',
                    '85' => 'pricier than',
                    '64' => 'reflects',
                    '51' => 'houses',
                    '41' => 'makes',
                    '58' => 'cozier than',
                    '47' => 'hits',
                    '81' => 'climbs',
                    '52' => 'requires',
                    '60' => 'has',
                    '56' => 'outruns',
                    '73' => 'makes',
                    '45' => 'hits',
                    '66' => 'in',
                    '86' => 'pricier than',
                    '76' => 'can have',
                    '43' => 'hits',
                    '62' => 'creates',
                    '54' => 'crosses'
                  },
          '14' => {
                    '33' => 'captures',
                    '32' => 'captures',
                    '63' => 'captures',
                    '21' => 'captures',
                    '26' => 'captures',
                    '17' => 'captures',
                    '18' => 'captures',
                    '30' => 'captures',
                    '16' => 'captures',
                    '44' => 'captures',
                    '55' => 'costs',
                    '25' => 'captures',
                    '27' => 'captures',
                    '28' => 'captures',
                    '57' => 'captures',
                    '40' => 'captures',
                    '61' => 'pictures use',
                    '20' => 'captures',
                    '59' => 'captures',
                    '49' => 'captures',
                    '24' => 'captures',
                    '31' => 'captures',
                    '35' => 'captures',
                    '53' => 'captures',
                    '48' => 'captures',
                    '22' => 'captures',
                    '42' => 'captures',
                    '46' => 'captures',
                    '23' => 'downloads onto',
                    '29' => 'captures',
                    '50' => 'captures',
                    '39' => 'captures',
                    '64' => 'captures',
                    '36' => 'captures',
                    '51' => 'captures',
                    '58' => 'captures',
                    '41' => 'makes',
                    '15' => 'captures',
                    '47' => 'captures',
                    '52' => 'captures',
                    '38' => 'captures',
                    '60' => 'outclasses',
                    '34' => 'captures',
                    '56' => 'captures',
                    '37' => 'captures',
                    '45' => 'captures',
                    '19' => 'captures',
                    '43' => 'captures',
                    '62' => 'captures',
                    '54' => 'has'
                  },
          '69' => {
                    '90' => 'orbit uses',
                    '71' => 'decorates',
                    '70' => 'reveres',
                    '7' => 'above our',
                    '80' => 'in',
                    '17' => 'goes to',
                    '2' => 'supports',
                    '1' => 'survives',
                    '99' => 'supports',
                    '18' => 'uses',
                    '88' => 'builds',
                    '72' => 'decorates',
                    '16' => 'survives',
                    '100' => 'survives',
                    '82' => 'rebukes',
                    '74' => 'develops',
                    '84' => 'creates',
                    '95' => 'rebukes',
                    '75' => 'supports',
                    '83' => 'rebukes',
                    '14' => 'too big for',
                    '92' => 'has',
                    '89' => 'plays',
                    '10' => 'supports',
                    '11' => 'renews',
                    '91' => 'uses',
                    '78' => 'houses',
                    '79' => 'houses',
                    '87' => 'rebukes',
                    '77' => 'diverse as',
                    '93' => 'conducts',
                    '13' => 'orbits',
                    '96' => 'has untold',
                    '6' => 'survives',
                    '85' => 'creates',
                    '3' => 'supports',
                    '94' => 'supports',
                    '97' => 'survives',
                    '9' => 'survives',
                    '12' => 'supports',
                    '15' => 'mantle contains',
                    '8' => 'whips around axis',
                    '81' => 'supports',
                    '4' => 'crater is',
                    '98' => 'survives',
                    '73' => 'drinks',
                    '101' => 'survives',
                    '86' => 'creates',
                    '76' => 'watches',
                    '5' => 'supports food'
                  },
          '59' => {
                    '67' => 'ends up in',
                    '90' => 'accounts use',
                    '63' => 'for',
                    '71' => 'fills',
                    '70' => 'greases',
                    '7' => 'stains',
                    '80' => 'answers',
                    '68' => 'aroma fills',
                    '2' => 'taste',
                    '1' => 'coats',
                    '99' => 'smears',
                    '88' => 'stains',
                    '72' => 'fills',
                    '100' => 'greases',
                    '82' => 'disgusts',
                    '84' => 'smears',
                    '74' => 'resists',
                    '95' => 'trips',
                    '83' => 'disgusts',
                    '75' => 'resists',
                    '61' => 'stains',
                    '92' => 'bad for',
                    '69' => 'used across',
                    '89' => 'ruins',
                    '91' => 'trips',
                    '78' => 'smears',
                    '79' => 'trips',
                    '87' => 'disgusts',
                    '93' => 'before',
                    '77' => 'grease',
                    '96' => 'flavor',
                    '65' => 'flavors',
                    '6' => 'greases',
                    '85' => 'smears',
                    '3' => 'floats on',
                    '64' => 'color of',
                    '97' => 'smears',
                    '94' => 'survives',
                    '8' => 'greases',
                    '81' => 'popcorn',
                    '4' => 'fills hunger',
                    '98' => 'greases',
                    '60' => 'stains',
                    '101' => 'greases',
                    '73' => 'ruins',
                    '66' => 'stains',
                    '76' => 'smears',
                    '86' => 'smears',
                    '62' => 'aroma',
                    '5' => 'greases'
                  },
          '49' => {
                    '67' => 'doesn\'t use',
                    '90' => 'doesn\'t need',
                    '63' => 'feeds',
                    '71' => 'fish bowl',
                    '70' => 'soaks',
                    '80' => 'answers',
                    '68' => 'breathes occasional',
                    '99' => 'unaware of',
                    '88' => 'swims under',
                    '72' => 'swims in',
                    '82' => 'unaware of',
                    '55' => 'costs',
                    '84' => 'eyes like',
                    '74' => 'unaware of',
                    '95' => 'disgusts',
                    '83' => 'unaware of',
                    '75' => 'breathes',
                    '57' => 'swims over',
                    '61' => 'soaks',
                    '92' => 'has',
                    '69' => 'lives on',
                    '59' => 'in',
                    '89' => 'in',
                    '53' => 'feeds',
                    '91' => 'unaware of',
                    '78' => 'hides from',
                    '79' => 'intrigues',
                    '87' => 'unaware of',
                    '93' => 'dives from',
                    '77' => 'is',
                    '96' => 'has spiritual',
                    '65' => 'in sea',
                    '50' => 'eats',
                    '85' => 'colored',
                    '64' => 'unaware of',
                    '97' => 'dodges',
                    '94' => 'dives from',
                    '51' => 'eats',
                    '58' => 'feeds',
                    '52' => 'has',
                    '81' => 'in',
                    '98' => 'dodges torpedo',
                    '60' => 'recipe',
                    '56' => 'amuses',
                    '66' => 'on',
                    '73' => 'drinks',
                    '86' => 'colored',
                    '76' => 'on',
                    '62' => 'makes undersea',
                    '54' => 'thrown at'
                  },
          '24' => {
                    '67' => 'has',
                    '33' => 'houses',
                    '32' => 'houses',
                    '63' => 'pricier than',
                    '71' => 'contains',
                    '70' => 'contains',
                    '68' => 'displaces',
                    '26' => 'costs',
                    '72' => 'contains',
                    '30' => 'houses',
                    '44' => 'contains',
                    '55' => 'costs',
                    '74' => 'blocks',
                    '25' => 'houses',
                    '27' => 'protects',
                    '28' => 'attracts',
                    '57' => 'is money',
                    '40' => 'pricier than',
                    '61' => 'in',
                    '69' => 'on',
                    '59' => 'contains',
                    '49' => 'contains',
                    '31' => 'houses',
                    '35' => 'towers over',
                    '53' => 'towers over',
                    '48' => 'houses',
                    '42' => 'pricier than',
                    '46' => 'protects',
                    '65' => 'grounds have',
                    '29' => 'houses',
                    '50' => 'houses',
                    '39' => 'pricier than',
                    '64' => 'blocks',
                    '36' => 'houses',
                    '51' => 'houses',
                    '58' => 'taller than',
                    '41' => 'echoes',
                    '47' => 'houses',
                    '38' => 'outclasses',
                    '52' => 'intimidates',
                    '60' => 'in',
                    '34' => 'enlists',
                    '56' => 'houses',
                    '73' => 'has',
                    '66' => 'in',
                    '37' => 'towers over',
                    '45' => 'contains',
                    '43' => 'taller than',
                    '62' => 'in the',
                    '54' => 'taller than'
                  },
          '53' => {
                    '67' => 'uses',
                    '90' => 'census uses',
                    '63' => 'finances',
                    '71' => 'uses',
                    '70' => 'plays',
                    '80' => 'in',
                    '68' => 'pollutes',
                    '2' => 'survives',
                    '1' => 'uses',
                    '99' => 'pollutes',
                    '88' => 'builds',
                    '72' => 'uses',
                    '100' => 'funds',
                    '82' => 'rebukes',
                    '55' => 'makes',
                    '84' => 'possesses',
                    '74' => 'adapts to',
                    '95' => 'hunts',
                    '83' => 'hunts',
                    '75' => 'pollutes',
                    '57' => 'uses',
                    '61' => 'news',
                    '92' => 'has',
                    '59' => 'eats',
                    '69' => 'populates',
                    '89' => 'plays',
                    '91' => 'uses',
                    '78' => 'spots',
                    '79' => 'hunts',
                    '87' => 'rebukes',
                    '93' => 'uses',
                    '77' => 'looks at',
                    '96' => 'uses',
                    '65' => 'gathers in',
                    '85' => 'possesses',
                    '64' => 'gathers by',
                    '97' => 'uses',
                    '94' => 'survives',
                    '58' => 'builds',
                    '81' => 'lives on',
                    '98' => 'bans',
                    '60' => 'library',
                    '56' => 'hunts',
                    '101' => 'funds',
                    '66' => 'produces',
                    '73' => 'drinks',
                    '76' => 'watches',
                    '86' => 'possesses',
                    '62' => 'population',
                    '54' => 'gathers by'
                  },
          '79' => {
                    '21' => 'vaporizes',
                    '90' => 'uses advanced',
                    '7' => 'breaks physical',
                    '26' => 'has',
                    '80' => 'doesn\'t use',
                    '17' => 'vaporizes',
                    '2' => 'dispels',
                    '1' => 'vaporizes',
                    '99' => 'from',
                    '18' => 'vaporizes',
                    '88' => 'vaporizes',
                    '16' => 'vaporizes',
                    '100' => 'vaporizes',
                    '82' => 'unaware of',
                    '27' => 'vaporizes',
                    '25' => 'vaporizes',
                    '84' => 'steals',
                    '28' => 'vaporizes',
                    '83' => 'vaporizes',
                    '95' => 'vaporizes',
                    '20' => 'vaporizes',
                    '14' => 'evades',
                    '92' => 'dissects',
                    '24' => 'explores',
                    '89' => 'in',
                    '10' => 'vaporizes',
                    '11' => 'causes',
                    '91' => 'commands',
                    '22' => 'disturbs',
                    '87' => 'unaware of',
                    '93' => 'uses',
                    '23' => 'uses',
                    '13' => 'flies to',
                    '96' => 'uses advanced',
                    '6' => 'vaporizes',
                    '85' => 'colored',
                    '3' => 'solidifies',
                    '94' => 'shoots',
                    '97' => 'shoots',
                    '9' => 'vaporizes',
                    '12' => 'vaporizes',
                    '15' => 'starts',
                    '81' => 'terraforms',
                    '8' => 'vaporizes',
                    '98' => 'disarms',
                    '4' => 'flies over',
                    '101' => 'vaporizes',
                    '19' => 'immune to',
                    '86' => 'colored',
                    '5' => 'vaporizes'
                  },
          '22' => {
                    '67' => 'cleans',
                    '33' => 'comforts',
                    '32' => 'comforts',
                    '63' => 'protects',
                    '71' => 'cleans',
                    '70' => 'inspires',
                    '68' => 'cleans',
                    '26' => 'spills no',
                    '72' => 'cleans',
                    '30' => 'comforts',
                    '44' => 'nurtures',
                    '55' => 'saves',
                    '25' => 'protects',
                    '27' => 'protects',
                    '28' => 'protects',
                    '57' => 'cleanses like',
                    '40' => 'protects',
                    '61' => 'inspires',
                    '69' => 'saves',
                    '59' => 'purifies',
                    '49' => 'protects',
                    '24' => 'protects',
                    '31' => 'comforts',
                    '35' => 'comforts',
                    '53' => 'protects',
                    '48' => 'protects',
                    '42' => 'protects',
                    '46' => 'protects',
                    '23' => 'cleans up',
                    '65' => 'protects',
                    '29' => 'protects',
                    '50' => 'protects',
                    '39' => 'protects',
                    '64' => 'by',
                    '36' => 'protects',
                    '51' => 'protects',
                    '58' => 'be with you in',
                    '41' => 'without',
                    '47' => 'protects',
                    '38' => 'protects',
                    '52' => 'of mind',
                    '60' => 'inspires',
                    '34' => 'keeping',
                    '56' => 'bores',
                    '66' => 'allows',
                    '37' => 'comforts',
                    '45' => 'protects',
                    '43' => 'chops down',
                    '62' => 'clears',
                    '54' => 'be with you on'
                  },
          '42' => {
                    '67' => 'has no',
                    '90' => 'to',
                    '63' => 'safer than',
                    '71' => 'helmet is',
                    '70' => 'carries',
                    '80' => 'inspires',
                    '68' => 'displaces',
                    '88' => 'hops',
                    '72' => 'wins',
                    '44' => 'runs over',
                    '82' => 'amuses',
                    '55' => 'costs',
                    '84' => 'shines like',
                    '74' => 'rides in',
                    '83' => 'outruns',
                    '75' => 'splashes',
                    '57' => 'carries',
                    '61' => 'delivers',
                    '92' => 'stimulates',
                    '69' => 'across',
                    '59' => 'carries',
                    '49' => 'runs over',
                    '89' => 'in',
                    '53' => 'across',
                    '91' => 'confuses',
                    '78' => 'attracts',
                    '79' => 'intrigues',
                    '48' => 'scares',
                    '87' => 'faster than',
                    '77' => 'reflects',
                    '46' => 'outruns',
                    '65' => 'rides in',
                    '50' => 'runs over',
                    '85' => 'uses',
                    '64' => 'reflects',
                    '51' => 'runs over',
                    '58' => 'to',
                    '47' => 'scares',
                    '81' => 'climbs',
                    '52' => 'stimulates',
                    '60' => 'carries',
                    '56' => 'outruns',
                    '45' => 'scares',
                    '66' => 'in',
                    '73' => 'inspires',
                    '86' => 'wins',
                    '76' => 'on',
                    '43' => 'hits',
                    '62' => 'makes dust',
                    '54' => 'crossing'
                  },
          '46' => {
                    '67' => 'doesn\'t use',
                    '90' => 'doesn\'t need',
                    '63' => 'howls at',
                    '71' => 'drinks from',
                    '70' => 'bites',
                    '80' => 'causes',
                    '68' => 'breathes',
                    '88' => 'hops',
                    '72' => 'knocks over',
                    '82' => 'bites',
                    '55' => 'steals',
                    '84' => 'swallows',
                    '74' => 'loves',
                    '95' => 'outruns',
                    '83' => 'outruns',
                    '75' => 'drinks',
                    '57' => 'rips up',
                    '61' => 'rips up',
                    '92' => 'has',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '89' => 'ravages',
                    '53' => 'frightens',
                    '91' => 'outruns',
                    '78' => 'hides from',
                    '48' => 'chases',
                    '79' => 'chases',
                    '87' => 'bites',
                    '93' => 'outruns',
                    '77' => 'howls at',
                    '96' => 'has',
                    '65' => 'in',
                    '50' => 'eats',
                    '85' => 'swallows',
                    '64' => 'howls at',
                    '94' => 'outruns',
                    '51' => 'eats',
                    '58' => 'disrupts',
                    '47' => 'chases',
                    '81' => 'lives on',
                    '52' => 'has',
                    '60' => 'rips up',
                    '56' => 'amuses',
                    '66' => 'on',
                    '73' => 'drinks',
                    '86' => 'swallows',
                    '76' => 'on',
                    '62' => 'creates dust',
                    '54' => 'acts'
                  },
          '23' => {
                    '67' => 'is',
                    '33' => 'confuses',
                    '32' => 'confuses',
                    '63' => 'guides',
                    '71' => 'pricier than',
                    '70' => 'downloads',
                    '68' => 'measures',
                    '26' => 'boils',
                    '72' => 'pricier than',
                    '30' => 'confuses',
                    '44' => 'turns brain into',
                    '55' => 'costs',
                    '25' => 'depicts',
                    '27' => 'depicts',
                    '28' => 'attracts',
                    '57' => 'is time',
                    '40' => 'enhances',
                    '61' => 'kills',
                    '69' => 'shrinks',
                    '59' => 'sexier than',
                    '49' => 'screensaver',
                    '24' => 'depicts',
                    '31' => 'confuses',
                    '35' => 'confuses',
                    '53' => 'shrinks',
                    '48' => 'depicts',
                    '42' => 'designs',
                    '46' => 'depicts',
                    '65' => 'depicts',
                    '29' => 'enrages',
                    '50' => 'houses',
                    '39' => 'controls',
                    '64' => 'depicts',
                    '36' => 'prevents',
                    '51' => 'houses',
                    '58' => 'accounts for',
                    '41' => 'makes',
                    '47' => 'depicts',
                    '38' => 'in every',
                    '52' => 'tires',
                    '60' => 'writes',
                    '34' => 'aids',
                    '56' => 'attracts',
                    '73' => 'inspires',
                    '66' => 'downloads',
                    '37' => 'confuses',
                    '45' => 'depicts',
                    '43' => 'depicts',
                    '62' => 'depicts',
                    '54' => 'depicts'
                  },
          '13' => {
                    '33' => 'warms',
                    '32' => 'warms',
                    '63' => 'above',
                    '21' => 'melts',
                    '26' => 'warms',
                    '17' => 'shines on',
                    '18' => 'melts',
                    '30' => 'warms',
                    '16' => 'warms',
                    '44' => 'feeds',
                    '55' => 'saves',
                    '25' => 'warms',
                    '27' => 'warms',
                    '28' => 'warms',
                    '57' => 'dries up',
                    '40' => 'shines on',
                    '61' => 'shines through',
                    '14' => 'ruins',
                    '20' => 'heats',
                    '59' => 'melts',
                    '49' => 'warms',
                    '24' => 'shines on',
                    '31' => 'warms',
                    '35' => 'warms',
                    '53' => 'warms',
                    '48' => 'warms',
                    '22' => 'embodies',
                    '42' => 'shines on',
                    '46' => 'warms',
                    '23' => 'cooks',
                    '29' => 'warms',
                    '50' => 'warms',
                    '39' => 'shines on',
                    '36' => 'warms',
                    '51' => 'warms',
                    '58' => 'shines on',
                    '41' => 'makes no',
                    '47' => 'warms',
                    '15' => 'made of',
                    '52' => 'warms',
                    '38' => 'warms',
                    '60' => 'shines in',
                    '34' => 'warms',
                    '56' => 'kills',
                    '37' => 'warms',
                    '45' => 'warms',
                    '19' => 'not affected by',
                    '43' => 'feeds',
                    '62' => 'burns off',
                    '54' => 'shines on'
                  },
          '96' => {
                    '33' => 'supplants',
                    '32' => 'supplants',
                    '21' => 'gives you the',
                    '7' => 'imposes',
                    '26' => 'sacrifices',
                    '17' => 'superintends',
                    '2' => 'plant survives',
                    '99' => 'lines clutter',
                    '1' => 'plants',
                    '18' => 'charges',
                    '30' => 'overthrows',
                    '16' => 'clears with',
                    '44' => 'cooks',
                    '100' => 'engages',
                    '27' => 'fries',
                    '25' => 'hungry',
                    '28' => 'hungry',
                    '40' => 'plant in',
                    '20' => 'imposes',
                    '14' => 'charges',
                    '24' => 'seiges',
                    '10' => 'moves',
                    '31' => 'overthrows',
                    '35' => 'corrupts',
                    '11' => 'of life and',
                    '42' => 'outperforms',
                    '22' => 'breaks',
                    '13' => 'of',
                    '23' => 'crashes',
                    '29' => 'fries',
                    '6' => 'play with',
                    '39' => 'runs',
                    '36' => 'electrocutes',
                    '3' => 'clears',
                    '97' => 'charges',
                    '9' => 'weilds',
                    '41' => 'makes',
                    '12' => 'in',
                    '15' => 'to',
                    '38' => 'lights',
                    '8' => 'cracks',
                    '98' => 'charges',
                    '4' => 'lights',
                    '34' => 'governs',
                    '45' => 'cooks',
                    '37' => 'corrupts',
                    '101' => 'deploys',
                    '43' => 'consumes',
                    '19' => 'assissinates w/',
                    '5' => 'struggle food'
                  },
          '6' => {
                   '33' => 'shoots',
                   '32' => 'shoots',
                   '21' => 'outclasses',
                   '7' => 'breaks',
                   '26' => 'spills',
                   '17' => 'closes',
                   '18' => 'outclasses',
                   '30' => 'shoots',
                   '16' => 'outclasses',
                   '44' => 'blasts apart',
                   '55' => 'robs',
                   '27' => 'shoots',
                   '25' => 'shoots',
                   '28' => 'shoots',
                   '40' => 'hijacks',
                   '14' => 'shoots at',
                   '20' => 'shoots through',
                   '49' => 'shoots',
                   '24' => 'fires into',
                   '10' => 'targets',
                   '31' => 'shoots',
                   '35' => 'shoots',
                   '11' => 'causes',
                   '53' => 'threatens',
                   '48' => 'shoots',
                   '42' => 'shoots',
                   '22' => 'disturbs',
                   '46' => 'shoots',
                   '13' => 'shoots at',
                   '23' => 'shoots',
                   '29' => 'shoots',
                   '50' => 'shoots',
                   '39' => 'holds up',
                   '36' => 'shoots',
                   '51' => 'shoots',
                   '9' => 'outclasses',
                   '41' => 'makes',
                   '12' => 'targets',
                   '47' => 'shoots',
                   '15' => 'fires',
                   '52' => 'splatters',
                   '8' => 'outclasses',
                   '38' => 'protects',
                   '34' => 'shoots',
                   '56' => '(silver bullet) shoots',
                   '45' => 'shoots',
                   '37' => 'shoots',
                   '43' => 'targets',
                   '19' => 'deadlier than',
                   '54' => 'cross(hair)'
                 },
          '85' => {
                    '33' => 'adorns',
                    '32' => 'adorns',
                    '21' => 'decorates',
                    '90' => 'market uses',
                    '7' => 'bribes',
                    '26' => 'outlasts',
                    '17' => 'more desirable than',
                    '2' => 'survives',
                    '1' => 'survives',
                    '99' => 'reflects',
                    '18' => 'coated',
                    '88' => 'funds',
                    '30' => 'adorns',
                    '16' => 'resists',
                    '100' => 'wired',
                    '27' => 'harder than',
                    '25' => 'charms',
                    '28' => 'attracts',
                    '95' => 'enthralls',
                    '20' => 'coated',
                    '14' => 'pricier than',
                    '92' => 'wins',
                    '24' => 'funds',
                    '89' => 'pricier than',
                    '10' => 'rarer than',
                    '31' => 'adorns',
                    '11' => 'outlasts',
                    '91' => 'wired',
                    '22' => 'disturbs',
                    '87' => 'tempts',
                    '93' => 'conducts',
                    '23' => 'wired',
                    '13' => 'reflects',
                    '29' => 'hypnotizes',
                    '96' => 'conducts',
                    '6' => 'decorates',
                    '3' => 'hides in',
                    '97' => 'wired',
                    '94' => 'conducts',
                    '9' => 'decorates',
                    '12' => 'decorates',
                    '15' => 'resists',
                    '8' => 'resists',
                    '98' => 'wired',
                    '4' => 'hides in',
                    '34' => 'badged',
                    '101' => 'decorates',
                    '19' => 'resists',
                    '86' => 'pricier than',
                    '5' => 'platinum chain'
                  },
          '3' => {
                   '33' => 'swallows',
                   '32' => 'swallows',
                   '21' => 'swallows',
                   '7' => 'knows no',
                   '26' => 'suffocates',
                   '17' => 'closes',
                   '18' => 'swallows',
                   '30' => 'swallows',
                   '16' => 'swallows',
                   '44' => 'swallows',
                   '27' => 'swallows',
                   '25' => 'swallows',
                   '28' => 'swallows',
                   '40' => 'swallows',
                   '20' => 'surrounds',
                   '14' => 'swallows',
                   '49' => 'swallows',
                   '24' => 'protects',
                   '10' => 'swallows',
                   '31' => 'swallows',
                   '35' => 'swallows',
                   '11' => 'causes',
                   '53' => 'threatens',
                   '48' => 'swallows',
                   '42' => 'swallows',
                   '22' => 'disturbs',
                   '46' => 'swallows',
                   '13' => 'removes',
                   '23' => 'swallows',
                   '29' => 'swallows',
                   '6' => 'swallows',
                   '50' => 'swallows',
                   '39' => 'ruins',
                   '36' => 'swallows',
                   '51' => 'swallows',
                   '9' => 'swallows',
                   '41' => 'engulfs',
                   '12' => 'protects',
                   '47' => 'swallows',
                   '15' => 'engulfs',
                   '52' => 'swallows',
                   '38' => 'ruins',
                   '8' => 'too big for',
                   '4' => 'becomes',
                   '34' => 'swallows',
                   '45' => 'swallows',
                   '37' => 'swallows',
                   '43' => 'topples',
                   '19' => 'engulfs',
                   '5' => 'swallows'
                 },
          '36' => {
                    '67' => 'toilet trained',
                    '63' => 'annoys',
                    '71' => 'eats from',
                    '70' => 'ruins',
                    '80' => 'answers',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'throws',
                    '82' => 'unaware of',
                    '55' => 'costs',
                    '84' => 'swallows',
                    '74' => 'plays in',
                    '83' => 'subdues',
                    '75' => 'drinks',
                    '57' => 'eats',
                    '40' => 'rides in',
                    '61' => 'rips up',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '53' => 'lives in',
                    '78' => 'draws',
                    '79' => 'draws',
                    '48' => 'scares',
                    '42' => 'carried on',
                    '77' => 'looks at',
                    '46' => 'rides on',
                    '65' => 'crawls in',
                    '50' => 'eats',
                    '85' => 'plays with',
                    '39' => 'rides on',
                    '64' => 'looks at',
                    '51' => 'eats',
                    '41' => 'makes',
                    '58' => 'disrupts',
                    '47' => 'scares',
                    '81' => 'lives on',
                    '52' => 'has',
                    '38' => 'lives in',
                    '60' => 'tears up',
                    '56' => 'becomes',
                    '73' => 'spills',
                    '45' => 'chases',
                    '37' => 'tires',
                    '66' => 'on',
                    '86' => 'plays with',
                    '76' => 'on',
                    '43' => 'up in a',
                    '62' => 'makes gas',
                    '54' => 'makes parents'
                  },
          '94' => {
                    '33' => 'strikes',
                    '32' => 'strikes',
                    '21' => 'charges',
                    '7' => 'has physical',
                    '26' => 'cooks',
                    '17' => 'strikes',
                    '2' => 'envelops',
                    '99' => 'decorates',
                    '1' => 'ignites',
                    '18' => 'charges',
                    '30' => 'strikes',
                    '16' => 'outclasses',
                    '100' => 'strikes',
                    '27' => 'strikes',
                    '25' => 'strikes',
                    '28' => 'strikes',
                    '40' => '(greased)',
                    '95' => 'strikes',
                    '20' => 'charges',
                    '14' => 'challenges',
                    '24' => 'strikes',
                    '10' => 'splits',
                    '31' => 'strikes',
                    '35' => 'strikes',
                    '11' => 'causes',
                    '42' => 'strikes',
                    '22' => 'disturbs',
                    '13' => 'storm blocks',
                    '23' => 'short-circuits',
                    '29' => 'strikes',
                    '96' => 'produces',
                    '6' => 'charges',
                    '39' => 'strikes',
                    '36' => 'scares',
                    '3' => 'creates',
                    '97' => 'outclasses',
                    '9' => 'strikes',
                    '41' => 'makes',
                    '12' => 'strikes through',
                    '15' => 'starts',
                    '38' => 'strikes',
                    '8' => 'fries',
                    '4' => 'creates',
                    '98' => 'short-circuits',
                    '34' => 'strikes',
                    '37' => 'strikes',
                    '101' => 'strikes',
                    '43' => 'strikes',
                    '19' => 'deadlier than',
                    '5' => 'starts'
                  },
          '9' => {
                   '33' => 'slays',
                   '32' => 'slays',
                   '21' => 'outclasses',
                   '26' => 'spills',
                   '17' => 'terrorizes',
                   '18' => 'outclasses',
                   '30' => 'slays',
                   '16' => 'faster than',
                   '44' => 'cuts up',
                   '55' => 'costs',
                   '25' => 'chops up',
                   '27' => 'stabs',
                   '28' => 'stabs',
                   '57' => 'chops',
                   '40' => 'punctures',
                   '14' => 'chops',
                   '20' => 'picks',
                   '59' => 'spreads',
                   '49' => 'guts',
                   '24' => 'protects',
                   '10' => 'in the stone',
                   '31' => 'slays',
                   '35' => 'stabs',
                   '11' => 'causes',
                   '53' => 'protects',
                   '48' => 'stabs',
                   '42' => 'punctures',
                   '22' => 'breaks',
                   '46' => 'slices',
                   '13' => 'reflects',
                   '23' => 'smites',
                   '29' => 'stabs',
                   '50' => 'minces',
                   '39' => 'unhooks',
                   '36' => 'stabs',
                   '51' => 'juliennes',
                   '58' => 'defends',
                   '12' => 'scars',
                   '41' => 'makes',
                   '47' => 'dices',
                   '15' => '(flaming) has',
                   '52' => 'chops up',
                   '38' => 'protects',
                   '34' => 'stabs',
                   '56' => 'impales',
                   '45' => 'stabs',
                   '37' => 'stabs',
                   '43' => 'carves',
                   '19' => 'faster than',
                   '54' => 'serves'
                 },
          '51' => {
                    '67' => 'hides in',
                    '90' => 'doesn\'t need',
                    '63' => 'creeps into',
                    '71' => 'hides under',
                    '70' => 'hides in',
                    '80' => 'despite',
                    '68' => 'breathes',
                    '99' => 'unaware of',
                    '88' => 'crawls over',
                    '72' => 'crawls into',
                    '100' => 'creeps into',
                    '82' => 'amuses',
                    '55' => 'nests in',
                    '84' => 'crawls across',
                    '74' => 'doesn\'t mind',
                    '95' => 'amuses',
                    '83' => 'eats',
                    '75' => 'drinks',
                    '57' => 'nests in',
                    '61' => 'nests between',
                    '92' => 'has',
                    '59' => 'crawls across',
                    '69' => 'lives on',
                    '89' => 'nests in',
                    '53' => 'annoys',
                    '91' => 'crawls over',
                    '78' => 'stows away with',
                    '79' => 'stows away with',
                    '87' => 'makes men',
                    '93' => 'hides from',
                    '77' => 'unaware of',
                    '96' => 'has survival',
                    '65' => 'in',
                    '85' => 'crawls across',
                    '64' => 'nocturnal with',
                    '97' => 'too numerous for',
                    '94' => 'hides from',
                    '58' => 'creeps into',
                    '52' => 'has',
                    '81' => 'lives on',
                    '98' => 'survives',
                    '60' => 'behind',
                    '56' => 'amuses',
                    '101' => 'creeps into',
                    '66' => 'nests in',
                    '73' => 'in your',
                    '86' => 'crawls across',
                    '76' => 'crawls across',
                    '62' => 'swarms like',
                    '54' => 'crawls up'
                  },
          '47' => {
                    '67' => 'doesn\'t use',
                    '90' => 'doesn\'t need',
                    '63' => 'rides on',
                    '71' => 'drinks from',
                    '70' => 'gut',
                    '80' => 'in',
                    '68' => 'breathes',
                    '88' => 'atop',
                    '72' => 'knocks over',
                    '82' => 'recognizes',
                    '55' => 'steals',
                    '84' => 'plays with',
                    '74' => 'hates',
                    '95' => 'outruns',
                    '83' => 'outruns',
                    '75' => 'drinks',
                    '57' => 'plays with',
                    '61' => 'rips up',
                    '92' => 'has',
                    '69' => 'lives on',
                    '59' => 'licks',
                    '49' => 'eats',
                    '89' => 'hair ruins',
                    '53' => 'amuses',
                    '91' => 'outruns',
                    '78' => 'hides from',
                    '48' => 'chases',
                    '79' => 'allergy kills',
                    '87' => 'recognizes',
                    '93' => '9 lives despite',
                    '77' => 'looks at',
                    '96' => 'has spiritual',
                    '65' => 'in',
                    '50' => 'eats',
                    '85' => 'colored',
                    '64' => 'hunts by',
                    '97' => 'chases',
                    '94' => '9 lives despite',
                    '51' => 'eats',
                    '58' => 'disrupts',
                    '81' => 'lives on',
                    '52' => 'has',
                    '60' => 'rips up',
                    '56' => 'entertains',
                    '66' => 'on',
                    '73' => 'drinks',
                    '86' => 'colored',
                    '76' => 'sleeps on',
                    '62' => 'creates dust',
                    '54' => 'acts'
                  },
          '8' => {
                   '33' => 'tortures',
                   '32' => 'tortures',
                   '21' => 'snags',
                   '26' => 'spills',
                   '17' => 'terrorizes',
                   '18' => 'snags',
                   '30' => 'tortures',
                   '16' => 'snags',
                   '44' => 'splatters',
                   '55' => 'robs',
                   '27' => 'scares',
                   '25' => 'stronger than',
                   '28' => 'scares',
                   '57' => 'rips',
                   '40' => 'smashes',
                   '14' => 'shatters',
                   '20' => 'opens',
                   '49' => 'kills',
                   '24' => 'breaks into',
                   '10' => 'shatters',
                   '31' => 'tortures',
                   '35' => 'tortures',
                   '11' => 'causes',
                   '53' => 'threatens',
                   '48' => 'kills',
                   '42' => 'snags',
                   '22' => 'disturbs',
                   '46' => 'drives',
                   '13' => 'burns like',
                   '23' => 'smashes',
                   '29' => 'cracks',
                   '50' => 'splatters',
                   '39' => 'holds up',
                   '36' => 'scares',
                   '51' => 'splatters',
                   '9' => 'snags',
                   '58' => 'frightens',
                   '41' => 'restricts',
                   '12' => 'marks up',
                   '47' => 'scares',
                   '15' => 'burns like',
                   '52' => 'intimidates',
                   '38' => 'breaks into',
                   '34' => 'thwarts',
                   '56' => 'thwarts',
                   '45' => 'kills',
                   '37' => 'tortures',
                   '43' => 'around',
                   '19' => 'shatters',
                   '54' => 'forces you onto'
                 },
          '38' => {
                    '67' => 'has',
                    '63' => 'cozier than',
                    '71' => 'contains',
                    '70' => 'contains',
                    '80' => 'answers',
                    '68' => 'has central',
                    '88' => 'has',
                    '72' => 'contains',
                    '44' => 'garden has',
                    '82' => 'denounces',
                    '55' => 'costs',
                    '84' => 'pricier than',
                    '74' => 'blocks',
                    '83' => 'blocks',
                    '75' => 'plumbs',
                    '57' => 'contains',
                    '40' => 'pricier than',
                    '61' => 'contains',
                    '69' => 'on',
                    '59' => 'contains',
                    '49' => 'contains',
                    '53' => 'populates',
                    '78' => 'blocks',
                    '79' => 'keeps out',
                    '48' => 'contains',
                    '42' => 'pricier than',
                    '87' => 'envied by',
                    '77' => 'blocks',
                    '46' => 'keeps out',
                    '65' => 'yard has',
                    '50' => 'houses',
                    '85' => 'pricier than',
                    '39' => 'cozier than',
                    '64' => 'blocks',
                    '51' => 'houses',
                    '41' => 'blocks',
                    '58' => 'cozier than',
                    '47' => 'contains',
                    '81' => 'atop',
                    '52' => 'requires',
                    '60' => 'contains',
                    '56' => 'blocks',
                    '73' => 'contains',
                    '45' => 'yard has',
                    '66' => 'in',
                    '86' => 'pricier than',
                    '76' => 'has',
                    '43' => 'yard has',
                    '62' => 'blocks',
                    '54' => 'contains'
                  },
          '98' => {
                    '33' => 'incinerates',
                    '32' => 'incinerates',
                    '21' => 'incinerates',
                    '7' => 'breaks',
                    '26' => 'incinerates',
                    '17' => 'incinerates',
                    '2' => 'outclasses',
                    '99' => 'poisons',
                    '1' => 'outclasses',
                    '18' => 'incinerates',
                    '30' => 'incinerates',
                    '16' => 'incinerates',
                    '44' => 'incinerates',
                    '100' => 'incinerates',
                    '27' => 'incinerates',
                    '25' => 'incinerates',
                    '28' => 'incinerates',
                    '40' => 'incinerates',
                    '20' => 'incinerates',
                    '14' => 'incinerates',
                    '24' => 'incinerates',
                    '10' => 'incinerates',
                    '31' => 'incinerates',
                    '35' => 'incinerates',
                    '11' => 'causes',
                    '42' => 'incinerates',
                    '22' => 'breaks',
                    '46' => 'incinerates',
                    '13' => 'has power of',
                    '23' => 'incinerates',
                    '29' => 'incinerates',
                    '6' => 'outclasses',
                    '39' => 'incinerates',
                    '36' => 'incinerates',
                    '3' => 'incinerates',
                    '9' => 'incinerates',
                    '41' => 'makes',
                    '12' => 'incinerates',
                    '47' => 'incinerates',
                    '15' => 'starts',
                    '38' => 'incinerates',
                    '8' => 'incinerates',
                    '4' => 'emerges from',
                    '34' => 'incinerates',
                    '45' => 'incinerates',
                    '37' => 'incinerates',
                    '101' => 'incinerates',
                    '43' => 'incinerates',
                    '19' => 'incinerates',
                    '5' => 'starts'
                  },
          '4' => {
                   '33' => 'swallows',
                   '32' => 'swallows',
                   '21' => 'swallows',
                   '7' => 'knows no',
                   '26' => 'contains',
                   '17' => 'endangers',
                   '18' => 'swallows',
                   '30' => 'swallows',
                   '16' => 'swallows',
                   '44' => 'swallows',
                   '27' => 'swallows',
                   '25' => 'swallows',
                   '28' => 'swallows',
                   '40' => 'swallows',
                   '14' => 'swallows',
                   '20' => 'becomes',
                   '49' => 'contains',
                   '24' => 'protects',
                   '10' => 'swallows',
                   '31' => 'swallows',
                   '35' => 'swallows',
                   '11' => 'causes',
                   '53' => 'threatens',
                   '48' => 'swallows',
                   '42' => 'swallows',
                   '22' => 'disturbs',
                   '46' => 'swallows',
                   '13' => 'removes',
                   '23' => 'swallows',
                   '29' => 'swallows',
                   '6' => 'swallows',
                   '50' => 'houses',
                   '39' => 'wrecks',
                   '36' => 'swallows',
                   '51' => 'houses',
                   '9' => 'swallows',
                   '41' => 'echoes',
                   '12' => 'protects',
                   '47' => 'swallows',
                   '15' => 'contains',
                   '52' => 'swallows',
                   '38' => 'wrecks',
                   '8' => 'too deep for',
                   '34' => 'swallows',
                   '45' => 'swallows',
                   '37' => 'swallows',
                   '43' => 'prevents',
                   '19' => 'engulfs',
                   '54' => 'swallows',
                   '5' => 'swallows'
                 },
          '34' => {
                    '67' => 'uses',
                    '63' => 'flies on',
                    '71' => 'eats from',
                    '70' => 'recovers',
                    '80' => 'has a',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'eats',
                    '82' => 'disbelieves in',
                    '55' => 'recovers',
                    '84' => 'recovers',
                    '74' => 'works in',
                    '83' => 'disbelieves in',
                    '75' => 'drinks',
                    '57' => 'cleans with',
                    '40' => 'impounds',
                    '61' => 'files',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '35' => 'arrests',
                    '53' => 'protects',
                    '78' => 'disbelieves',
                    '79' => 'disbelieves',
                    '48' => 'eats',
                    '42' => 'recovers',
                    '77' => 'looks at',
                    '46' => 'tranquilizes',
                    '65' => 'walks on',
                    '50' => 'steps on',
                    '39' => 'commandeers',
                    '36' => 'saves',
                    '64' => 'looks at',
                    '51' => 'steps on',
                    '41' => 'arrests',
                    '58' => 'patrols',
                    '47' => 'saves',
                    '81' => 'climbs',
                    '52' => 'has',
                    '38' => 'protects',
                    '60' => 'books \'em',
                    '56' => 'could be',
                    '73' => 'drinks',
                    '45' => 'eats',
                    '37' => 'arrests',
                    '66' => 'inspires',
                    '76' => 'on',
                    '43' => 'climbs',
                    '62' => 'looks at',
                    '54' => 'acts'
                  },
          '37' => {
                    '67' => 'uses',
                    '63' => 'flies on',
                    '71' => 'eats from',
                    '70' => 'plays',
                    '80' => 'in',
                    '68' => 'breathes',
                    '72' => 'drinks from',
                    '44' => 'eats',
                    '82' => 'denounces',
                    '55' => 'spends',
                    '84' => 'mines',
                    '74' => 'plays in',
                    '83' => 'slays',
                    '75' => 'drinks',
                    '57' => 'cleans with',
                    '40' => 'drives',
                    '61' => 'writes',
                    '69' => 'lives on',
                    '59' => 'eats',
                    '49' => 'eats',
                    '53' => 'lives in',
                    '78' => 'debunks',
                    '79' => 'disproves',
                    '48' => 'flips',
                    '42' => 'rides',
                    '87' => 'exorcises',
                    '77' => 'looks at',
                    '46' => 'tames',
                    '65' => 'walks on',
                    '50' => 'steps on',
                    '85' => 'refines',
                    '39' => 'rides on',
                    '64' => 'travels to',
                    '51' => 'steps on',
                    '41' => 'makes',
                    '58' => 'attends',
                    '47' => 'owns',
                    '81' => 'climbs',
                    '52' => 'has',
                    '38' => 'lives in',
                    '60' => 'reads',
                    '56' => 'becomes',
                    '73' => 'drinks',
                    '45' => 'eats',
                    '66' => 'watches',
                    '86' => 'mines',
                    '76' => 'watches',
                    '43' => 'plants',
                    '62' => 'looks at',
                    '54' => 'hangs on'
                  },
          '43' => {
                    '67' => 'becomes',
                    '90' => 'doesn\'t need',
                    '63' => 'diverts',
                    '71' => 'wood creates',
                    '70' => 'wood creates',
                    '80' => 'shelters',
                    '68' => 'produces',
                    '88' => 'taller than',
                    '72' => 'wood creates',
                    '44' => 'taller than',
                    '82' => 'imprisons',
                    '55' => 'doesn\'t grow',
                    '84' => 'roots hide',
                    '74' => 'loves',
                    '83' => 'shelters',
                    '75' => 'drinks',
                    '57' => 'outlives',
                    '61' => 'creates',
                    '92' => 'has no',
                    '69' => 'grows on',
                    '59' => 'outlasts',
                    '49' => 'shelters',
                    '89' => 'wiser than',
                    '53' => 'beautifies',
                    '91' => 'taller than',
                    '78' => 'ensnares',
                    '79' => 'ensnares',
                    '48' => 'houses',
                    '87' => 'imprisons',
                    '93' => 'conducts',
                    '77' => 'blocks',
                    '46' => 'shelters',
                    '65' => 'grows in',
                    '50' => 'houses',
                    '85' => 'roots hide',
                    '64' => 'blocks',
                    '51' => 'shelters',
                    '58' => 'shades',
                    '47' => 'traps',
                    '81' => 'grows on',
                    '52' => 'has no',
                    '60' => 'creates',
                    '56' => 'hides',
                    '45' => 'shelters',
                    '66' => 'in',
                    '73' => 'inspires',
                    '86' => 'roots hide',
                    '76' => 'on',
                    '62' => 'blocks',
                    '54' => 'builds'
                  },
          '5' => {
                   '33' => 'restrains',
                   '32' => 'restrains',
                   '21' => 'nicks',
                   '7' => 'guards',
                   '26' => 'constricts',
                   '17' => 'locks',
                   '18' => 'dulls',
                   '30' => 'restrains',
                   '16' => 'holds down',
                   '44' => 'protects',
                   '55' => 'costs',
                   '27' => 'restrains',
                   '25' => 'stronger than',
                   '28' => 'restrains',
                   '40' => 'holds back',
                   '14' => 'holds down',
                   '20' => 'locks',
                   '49' => 'smooshes',
                   '24' => 'locks',
                   '10' => 'pins down',
                   '31' => 'restrains',
                   '35' => 'restrains',
                   '11' => 'chokes for',
                   '53' => 'protects',
                   '48' => 'crushes',
                   '42' => 'locks',
                   '22' => 'keeps',
                   '46' => 'restrains',
                   '13' => 'reflects',
                   '23' => 'smashes',
                   '29' => 'restrains',
                   '6' => 'holds down',
                   '50' => 'crushes',
                   '39' => 'holds back',
                   '36' => 'restrains',
                   '51' => 'crushes',
                   '9' => 'nicks',
                   '41' => 'clinks',
                   '12' => 'protects',
                   '47' => 'restrains',
                   '15' => 'resists',
                   '52' => 'puzzles',
                   '38' => 'locks',
                   '8' => 'outclasses',
                   '34' => 'restrains',
                   '45' => 'crushes',
                   '37' => 'restrains',
                   '43' => 'around',
                   '19' => 'immune to',
                   '54' => 'holds'
                 }
}
}
		};
		
		return $names->{$gametype};
}

1;
__END__

