# Games::Checkers, Copyright (C) 1996-2012 Mikhael Goikhman, migo@cpan.org
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Games::Checkers::Board::_12x12;

use strict;
use warnings;

use base 'Games::Checkers::Board';
use Games::Checkers::Constants;

use constant size_x => 12;
use constant size_y => 12;
use constant locs => 72;
use constant default_rows => 5;

use constant loc_directions => [
	[ NL,  6, NL, NL ], [  6,  7, NL, NL ], [  7,  8, NL, NL ], [  8,  9, NL, NL ], [  9, 10, NL, NL ], [ 10, 11, NL, NL ],
	[ 12, 13,  0,  1 ], [ 13, 14,  1,  2 ], [ 14, 15,  2,  3 ], [ 15, 16,  3,  4 ], [ 16, 17,  4,  5 ], [ 17, NL,  5, NL ],
	[ NL, 18, NL,  6 ], [ 18, 19,  6,  7 ], [ 19, 20,  7,  8 ], [ 20, 21,  8,  9 ], [ 21, 22,  9, 10 ], [ 22, 23, 10, 11 ],
	[ 24, 25, 12, 13 ], [ 25, 26, 13, 14 ], [ 26, 27, 14, 15 ], [ 27, 28, 15, 16 ], [ 28, 29, 16, 17 ], [ 29, NL, 17, NL ],
	[ NL, 30, NL, 18 ], [ 30, 31, 18, 19 ], [ 31, 32, 19, 20 ], [ 32, 33, 20, 21 ], [ 33, 34, 21, 22 ], [ 34, 35, 22, 23 ],
	[ 36, 37, 24, 25 ], [ 37, 38, 25, 26 ], [ 38, 39, 26, 27 ], [ 39, 40, 27, 28 ], [ 40, 41, 28, 29 ], [ 41, NL, 29, NL ],
	[ NL, 42, NL, 30 ], [ 42, 43, 30, 31 ], [ 43, 44, 31, 32 ], [ 44, 45, 32, 33 ], [ 45, 46, 33, 34 ], [ 46, 47, 34, 35 ],
	[ 48, 49, 36, 37 ], [ 49, 50, 37, 38 ], [ 50, 51, 38, 39 ], [ 51, 52, 39, 40 ], [ 52, 53, 40, 41 ], [ 53, NL, 41, NL ],
	[ NL, 54, NL, 42 ], [ 54, 55, 42, 43 ], [ 55, 56, 43, 44 ], [ 56, 57, 44, 45 ], [ 57, 58, 45, 46 ], [ 58, 59, 46, 47 ],
	[ 60, 61, 48, 49 ], [ 61, 62, 49, 50 ], [ 62, 63, 50, 51 ], [ 63, 64, 51, 52 ], [ 64, 65, 52, 53 ], [ 65, NL, 53, NL ],
	[ NL, 66, NL, 54 ], [ 66, 67, 54, 55 ], [ 67, 68, 55, 56 ], [ 68, 69, 56, 57 ], [ 69, 70, 57, 58 ], [ 70, 71, 58, 59 ],
	[ NL, NL, 60, 61 ], [ NL, NL, 61, 62 ], [ NL, NL, 62, 63 ], [ NL, NL, 63, 64 ], [ NL, NL, 64, 65 ], [ NL, NL, 65, NL ],
];

use constant is_crowning => [
[
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1,
], [
	1, 1, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
]
];

use constant pawn_step => [
[
	[      6 ], [  6,  7 ], [  7,  8 ], [  8,  9 ], [  9, 10 ], [ 10, 11 ],
	[ 12, 13 ], [ 13, 14 ], [ 14, 15 ], [ 15, 16 ], [ 16, 17 ], [ 17     ],
	[     18 ], [ 18, 19 ], [ 19, 20 ], [ 20, 21 ], [ 21, 22 ], [ 22, 23 ],
	[ 24, 25 ], [ 25, 26 ], [ 26, 27 ], [ 27, 28 ], [ 28, 29 ], [ 29     ],
	[     30 ], [ 30, 31 ], [ 31, 32 ], [ 32, 33 ], [ 33, 34 ], [ 34, 35 ],
	[ 36, 37 ], [ 37, 38 ], [ 38, 39 ], [ 39, 40 ], [ 40, 41 ], [ 41     ],
	[     42 ], [ 42, 43 ], [ 43, 44 ], [ 44, 45 ], [ 45, 46 ], [ 46, 47 ],
	[ 48, 49 ], [ 49, 50 ], [ 50, 51 ], [ 51, 52 ], [ 52, 53 ], [ 53     ],
	[     54 ], [ 54, 55 ], [ 55, 56 ], [ 56, 57 ], [ 57, 58 ], [ 58, 59 ],
	[ 60, 61 ], [ 61, 62 ], [ 62, 63 ], [ 63, 64 ], [ 64, 65 ], [ 65     ],
	[     66 ], [ 66, 67 ], [ 67, 68 ], [ 68, 69 ], [ 69, 70 ], [ 70, 71 ],
	[        ], [        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ], [        ],
	[  0,  1 ], [  1,  2 ], [  2,  3 ], [  3,  4 ], [  4,  5 ], [  5     ],
	[      6 ], [  6,  7 ], [  7,  8 ], [  8,  9 ], [  9, 10 ], [ 10, 11 ],
	[ 12, 13 ], [ 13, 14 ], [ 14, 15 ], [ 15, 16 ], [ 16, 17 ], [ 17     ],
	[     18 ], [ 18, 19 ], [ 19, 20 ], [ 20, 21 ], [ 21, 22 ], [ 22, 23 ],
	[ 24, 25 ], [ 25, 26 ], [ 26, 27 ], [ 27, 28 ], [ 28, 29 ], [ 29     ],
	[     30 ], [ 30, 31 ], [ 31, 32 ], [ 32, 33 ], [ 33, 34 ], [ 34, 35 ],
	[ 36, 37 ], [ 37, 38 ], [ 38, 39 ], [ 39, 40 ], [ 40, 41 ], [ 41     ],
	[     42 ], [ 42, 43 ], [ 43, 44 ], [ 44, 45 ], [ 45, 46 ], [ 46, 47 ],
	[ 48, 49 ], [ 49, 50 ], [ 50, 51 ], [ 51, 52 ], [ 52, 53 ], [ 53     ],
	[     54 ], [ 54, 55 ], [ 55, 56 ], [ 56, 57 ], [ 57, 58 ], [ 58, 59 ],
	[ 60, 61 ], [ 61, 62 ], [ 62, 63 ], [ 63, 64 ], [ 64, 65 ], [ 65     ],
]
];

use constant pawn_beat => [
	[     13         ], [ 12, 14         ], [ 13, 15         ], [ 14, 16         ], [ 15, 17         ], [ 16             ],
	[     19         ], [ 18, 20         ], [ 19, 21         ], [ 20, 22         ], [ 21, 23         ], [ 22             ],
	[     25,      1 ], [ 24, 26,  0,  2 ], [ 25, 27,  1,  3 ], [ 26, 28,  2,  4 ], [ 27, 29,  3,  5 ], [ 28,      4     ],
	[     31,      7 ], [ 30, 32,  6,  8 ], [ 31, 33,  7,  9 ], [ 32, 34,  8, 10 ], [ 33, 35,  9, 11 ], [ 34,     10     ],
	[     37,     13 ], [ 36, 38, 12, 14 ], [ 37, 39, 13, 15 ], [ 38, 40, 14, 16 ], [ 39, 41, 15, 17 ], [ 40,     16     ],
	[     43,     19 ], [ 42, 44, 18, 20 ], [ 43, 45, 19, 21 ], [ 44, 46, 20, 22 ], [ 45, 47, 21, 23 ], [ 46,     22     ],
	[     49,     25 ], [ 48, 50, 24, 26 ], [ 49, 51, 25, 27 ], [ 50, 52, 26, 28 ], [ 51, 53, 27, 29 ], [ 52,     28     ],
	[     55,     31 ], [ 54, 56, 30, 32 ], [ 55, 57, 31, 33 ], [ 56, 58, 32, 34 ], [ 57, 59, 33, 35 ], [ 58,     34     ],
	[     61,     37 ], [ 60, 62, 36, 38 ], [ 61, 63, 37, 39 ], [ 62, 64, 38, 40 ], [ 63, 65, 39, 41 ], [ 64,     40     ],
	[     67,     43 ], [ 66, 68, 42, 44 ], [ 67, 69, 43, 45 ], [ 68, 70, 44, 46 ], [ 69, 71, 45, 47 ], [ 70,     46     ],
	[             49 ], [         48, 50 ], [         49, 51 ], [         50, 52 ], [         51, 53 ], [         52     ],
	[             55 ], [         54, 56 ], [         55, 57 ], [         56, 58 ], [         57, 59 ], [         58     ],
];

use constant pawn_beat_forward => [
[
	[     13 ], [ 12, 14 ], [ 13, 15 ], [ 14, 16 ], [ 15, 17 ], [ 16     ],
	[     19 ], [ 18, 20 ], [ 19, 21 ], [ 20, 22 ], [ 21, 23 ], [ 22     ],
	[     25 ], [ 24, 26 ], [ 25, 27 ], [ 26, 28 ], [ 27, 29 ], [ 28     ],
	[     31 ], [ 30, 32 ], [ 31, 33 ], [ 32, 34 ], [ 33, 35 ], [ 34     ],
	[     37 ], [ 36, 38 ], [ 37, 39 ], [ 38, 40 ], [ 39, 41 ], [ 40     ],
	[     43 ], [ 42, 44 ], [ 43, 45 ], [ 44, 46 ], [ 45, 47 ], [ 46     ],
	[     49 ], [ 48, 50 ], [ 49, 51 ], [ 50, 52 ], [ 51, 53 ], [ 52     ],
	[     55 ], [ 54, 56 ], [ 55, 57 ], [ 56, 58 ], [ 57, 59 ], [ 58     ],
	[     61 ], [ 60, 62 ], [ 61, 63 ], [ 62, 64 ], [ 63, 65 ], [ 64     ],
	[     67 ], [ 66, 68 ], [ 67, 69 ], [ 68, 70 ], [ 69, 71 ], [ 70     ],
	[        ], [        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ], [        ],
], [
	[        ], [        ], [        ], [        ], [        ], [        ],
	[        ], [        ], [        ], [        ], [        ], [        ],
	[      1 ], [  0,  2 ], [  1,  3 ], [  2,  4 ], [  3,  5 ], [  4     ],
	[      7 ], [  6,  8 ], [  7,  9 ], [  8, 10 ], [  9, 11 ], [ 10     ],
	[     13 ], [ 12, 14 ], [ 13, 15 ], [ 14, 16 ], [ 15, 17 ], [ 16     ],
	[     19 ], [ 18, 20 ], [ 19, 21 ], [ 20, 22 ], [ 21, 23 ], [ 22     ],
	[     25 ], [ 24, 26 ], [ 25, 27 ], [ 26, 28 ], [ 27, 29 ], [ 28     ],
	[     31 ], [ 30, 32 ], [ 31, 33 ], [ 32, 34 ], [ 33, 35 ], [ 34     ],
	[     37 ], [ 36, 38 ], [ 37, 39 ], [ 38, 40 ], [ 39, 41 ], [ 40     ],
	[     43 ], [ 42, 44 ], [ 43, 45 ], [ 44, 46 ], [ 45, 47 ], [ 46     ],
	[     49 ], [ 48, 50 ], [ 49, 51 ], [ 50, 52 ], [ 51, 53 ], [ 52     ],
	[     55 ], [ 54, 56 ], [ 55, 57 ], [ 56, 58 ], [ 57, 59 ], [ 58     ],
]
];

use constant pawn_beat_8dirs => [
	[     13,                 24,  2 ], [ 12, 14,                 25,  3 ], [ 13, 15,              0, 26,  4 ], [ 14, 16,              1, 27,  5 ], [ 15, 17,              2, 28     ], [ 16,                  3, 29     ],
	[     19,                 30,  8 ], [ 18, 20,                 31,  9 ], [ 19, 21,              6, 32, 10 ], [ 20, 22,              7, 33, 11 ], [ 21, 23,              8, 34     ], [ 22,                  9, 35     ],
	[     25,      1,         36, 14 ], [ 24, 26,  0,  2,         37, 15 ], [ 25, 27,  1,  3,     12, 38, 16 ], [ 26, 28,  2,  4,     13, 39, 17 ], [ 27, 29,  3,  5,     14, 40     ], [ 28,      4,         15, 41     ],
	[     31,      7,         42, 20 ], [ 30, 32,  6,  8,         43, 21 ], [ 31, 33,  7,  9,     18, 44, 22 ], [ 32, 34,  8, 10,     19, 45, 23 ], [ 33, 35,  9, 11,     20, 46     ], [ 34,     10,         21, 47     ],
	[     37,     13,  0,     48, 26 ], [ 36, 38, 12, 14,  1,     49, 27 ], [ 37, 39, 13, 15,  2, 24, 50, 28 ], [ 38, 40, 14, 16,  3, 25, 51, 29 ], [ 39, 41, 15, 17,  4, 26, 52     ], [ 40,     16,      5, 27, 53     ],
	[     43,     19,  6,     54, 32 ], [ 42, 44, 18, 20,  7,     55, 33 ], [ 43, 45, 19, 21,  8, 30, 56, 34 ], [ 44, 46, 20, 22,  9, 31, 57, 35 ], [ 45, 47, 21, 23, 10, 32, 58     ], [ 46,     22,     11, 33, 59     ],
	[     49,     25, 12,     60, 38 ], [ 48, 50, 24, 26, 13,     61, 39 ], [ 49, 51, 25, 27, 14, 36, 62, 40 ], [ 50, 52, 26, 28, 15, 37, 63, 41 ], [ 51, 53, 27, 29, 16, 38, 64     ], [ 52,     28,     17, 39, 65     ],
	[     55,     31, 18,     66, 44 ], [ 54, 56, 30, 32, 19,     67, 45 ], [ 55, 57, 31, 33, 20, 42, 68, 46 ], [ 56, 58, 32, 34, 21, 43, 69, 47 ], [ 57, 59, 33, 35, 22, 44, 70     ], [ 58,     34,     23, 45, 71     ],
	[     61,     37, 24,         50 ], [ 60, 62, 36, 38, 25,         51 ], [ 61, 63, 37, 39, 26, 48,     52 ], [ 62, 64, 38, 40, 27, 49,     53 ], [ 63, 65, 39, 41, 28, 50         ], [ 64,     40,     29, 51         ],
	[     67,     43, 30,         56 ], [ 66, 68, 42, 44, 31,         57 ], [ 67, 69, 43, 45, 32, 54,     58 ], [ 68, 70, 44, 46, 33, 55,     59 ], [ 69, 71, 45, 47, 34, 56         ], [ 70,     46,     35, 57         ],
	[             49, 36,         62 ], [         48, 50, 37,         63 ], [         49, 51, 38, 60,     64 ], [         50, 52, 39, 61,     65 ], [         51, 53, 40, 62         ], [         52,     41, 63         ],
	[             55, 42,         68 ], [         54, 56, 43,         69 ], [         55, 57, 44, 66,     70 ], [         56, 58, 45, 67,     71 ], [         57, 59, 46, 68         ], [         58,     47, 69         ],
];

use constant king_step => [
	[      6,             13,             19,             26,             32,             39,             45,             52,             58,             65,             71         ],
	[  6,  7,         12, 14,             20,             27,             33,             40,             46,             53,             59                                         ],
	[  7,  8,         13, 15,         18, 21,         24, 28,             34,             41,             47                                                                         ],
	[  8,  9,         14, 16,         19, 22,         25, 29,         30, 35,         36                                                                                             ],
	[  9, 10,         15, 17,         20, 23,         26,             31,             37,             42,             48                                                             ],
	[ 10, 11,         16,             21,             27,             32,             38,             43,             49,             54,             60                             ],
	[ 12, 13,  0,  1,     19,             26,             32,             39,             45,             52,             58,             65,             71                         ],
	[ 13, 14,  1,  2, 18, 20,         24, 27,             33,             40,             46,             53,             59                                                         ],
	[ 14, 15,  2,  3, 19, 21,         25, 28,         30, 34,         36, 41,             47                                                                                         ],
	[ 15, 16,  3,  4, 20, 22,         26, 29,         31, 35,         37,             42,             48                                                                             ],
	[ 16, 17,  4,  5, 21, 23,         27,             32,             38,             43,             49,             54,             60                                             ],
	[ 17,      5,     22,             28,             33,             39,             44,             50,             55,             61,             66                             ],
	[     18,      6,     25,      1,     31,             38,             44,             51,             57,             64,             70                                         ],
	[ 18, 19,  6,  7, 24, 26,  0,  2,     32,             39,             45,             52,             58,             65,             71                                         ],
	[ 19, 20,  7,  8, 25, 27,  1,  3, 30, 33,         36, 40,             46,             53,             59                                                                         ],
	[ 20, 21,  8,  9, 26, 28,  2,  4, 31, 34,         37, 41,         42, 47,         48                                                                                             ],
	[ 21, 22,  9, 10, 27, 29,  3,  5, 32, 35,         38,             43,             49,             54,             60                                                             ],
	[ 22, 23, 10, 11, 28,      4,     33,             39,             44,             50,             55,             61,             66                                             ],
	[ 24, 25, 12, 13,     31,      7,     38,      2,     44,             51,             57,             64,             70                                                         ],
	[ 25, 26, 13, 14, 30, 32,  6,  8, 36, 39,  0,  3,     45,             52,             58,             65,             71                                                         ],
	[ 26, 27, 14, 15, 31, 33,  7,  9, 37, 40,  1,  4, 42, 46,         48, 53,             59                                                                                         ],
	[ 27, 28, 15, 16, 32, 34,  8, 10, 38, 41,  2,  5, 43, 47,         49,             54,             60                                                                             ],
	[ 28, 29, 16, 17, 33, 35,  9, 11, 39,      3,     44,             50,             55,             61,             66                                                             ],
	[ 29,     17,     34,     10,     40,      4,     45,             51,             56,             62,             67                                                             ],
	[     30,     18,     37,     13,     43,      7,     50,      2,     56,             63,             69                                                                         ],
	[ 30, 31, 18, 19, 36, 38, 12, 14,     44,      8,     51,      3,     57,             64,             70                                                                         ],
	[ 31, 32, 19, 20, 37, 39, 13, 15, 42, 45,  6,  9, 48, 52,  0,  4,     58,             65,             71                                                                         ],
	[ 32, 33, 20, 21, 38, 40, 14, 16, 43, 46,  7, 10, 49, 53,  1,  5, 54, 59,         60                                                                                             ],
	[ 33, 34, 21, 22, 39, 41, 15, 17, 44, 47,  8, 11, 50,      2,     55,             61,             66                                                                             ],
	[ 34, 35, 22, 23, 40,     16,     45,      9,     51,      3,     56,             62,             67                                                                             ],
	[ 36, 37, 24, 25,     43,     19,     50,     14,     56,      8,     63,      3,     69                                                                                         ],
	[ 37, 38, 25, 26, 42, 44, 18, 20, 48, 51, 12, 15,     57,      9,     64,      4,     70                                                                                         ],
	[ 38, 39, 26, 27, 43, 45, 19, 21, 49, 52, 13, 16, 54, 58,  6, 10, 60, 65,  0,  5,     71                                                                                         ],
	[ 39, 40, 27, 28, 44, 46, 20, 22, 50, 53, 14, 17, 55, 59,  7, 11, 61,      1,     66                                                                                             ],
	[ 40, 41, 28, 29, 45, 47, 21, 23, 51,     15,     56,      8,     62,      2,     67                                                                                             ],
	[ 41,     29,     46,     22,     52,     16,     57,      9,     63,      3,     68                                                                                             ],
	[     42,     30,     49,     25,     55,     19,     62,     14,     68,      8,              3                                                                                 ],
	[ 42, 43, 30, 31, 48, 50, 24, 26,     56,     20,     63,     15,     69,      9,              4                                                                                 ],
	[ 43, 44, 31, 32, 49, 51, 25, 27, 54, 57, 18, 21, 60, 64, 12, 16,     70,     10,              5                                                                                 ],
	[ 44, 45, 32, 33, 50, 52, 26, 28, 55, 58, 19, 22, 61, 65, 13, 17, 66, 71,  6, 11,          0                                                                                     ],
	[ 45, 46, 33, 34, 51, 53, 27, 29, 56, 59, 20, 23, 62,     14,     67,      7,              1                                                                                     ],
	[ 46, 47, 34, 35, 52,     28,     57,     21,     63,     15,     68,      8,              2                                                                                     ],
	[ 48, 49, 36, 37,     55,     31,     62,     26,     68,     20,             15,              9,              4                                                                 ],
	[ 49, 50, 37, 38, 54, 56, 30, 32, 60, 63, 24, 27,     69,     21,             16,             10,              5                                                                 ],
	[ 50, 51, 38, 39, 55, 57, 31, 33, 61, 64, 25, 28, 66, 70, 18, 22,         12, 17,             11                                                                                 ],
	[ 51, 52, 39, 40, 56, 58, 32, 34, 62, 65, 26, 29, 67, 71, 19, 23,         13,              6,              0                                                                     ],
	[ 52, 53, 40, 41, 57, 59, 33, 35, 63,     27,     68,     20,             14,              7,              1                                                                     ],
	[ 53,     41,     58,     34,     64,     28,     69,     21,             15,              8,              2                                                                     ],
	[     54,     42,     61,     37,     67,     31,             26,             20,             15,              9,              4                                                 ],
	[ 54, 55, 42, 43, 60, 62, 36, 38,     68,     32,             27,             21,             16,             10,              5                                                 ],
	[ 55, 56, 43, 44, 61, 63, 37, 39, 66, 69, 30, 33,         24, 28,             22,             17,             11                                                                 ],
	[ 56, 57, 44, 45, 62, 64, 38, 40, 67, 70, 31, 34,         25, 29,         18, 23,         12                                                                                     ],
	[ 57, 58, 45, 46, 63, 65, 39, 41, 68, 71, 32, 35,         26,             19,             13,              6,              0                                                     ],
	[ 58, 59, 46, 47, 64,     40,     69,     33,             27,             20,             14,              7,              1                                                     ],
	[ 60, 61, 48, 49,     67,     43,             38,             32,             27,             21,             16,             10,              5                                 ],
	[ 61, 62, 49, 50, 66, 68, 42, 44,         36, 39,             33,             28,             22,             17,             11                                                 ],
	[ 62, 63, 50, 51, 67, 69, 43, 45,         37, 40,         30, 34,         24, 29,             23                                                                                 ],
	[ 63, 64, 51, 52, 68, 70, 44, 46,         38, 41,         31, 35,         25,             18,             12                                                                     ],
	[ 64, 65, 52, 53, 69, 71, 45, 47,         39,             32,             26,             19,             13,              6,              0                                     ],
	[ 65,     53,     70,     46,             40,             33,             27,             20,             14,              7,              1                                     ],
	[     66,     54,             49,             43,             38,             32,             27,             21,             16,             10,              5                 ],
	[ 66, 67, 54, 55,         48, 50,             44,             39,             33,             28,             22,             17,             11                                 ],
	[ 67, 68, 55, 56,         49, 51,         42, 45,         36, 40,             34,             29,             23                                                                 ],
	[ 68, 69, 56, 57,         50, 52,         43, 46,         37, 41,         30, 35,         24                                                                                     ],
	[ 69, 70, 57, 58,         51, 53,         44, 47,         38,             31,             25,             18,             12                                                     ],
	[ 70, 71, 58, 59,         52,             45,             39,             32,             26,             19,             13,              6,              0                     ],
	[         60, 61,             55,             50,             44,             39,             33,             28,             22,             17,             11                 ],
	[         61, 62,         54, 56,         48, 51,             45,             40,             34,             29,             23                                                 ],
	[         62, 63,         55, 57,         49, 52,         42, 46,         36, 41,             35                                                                                 ],
	[         63, 64,         56, 58,         50, 53,         43, 47,         37,             30,             24                                                                     ],
	[         64, 65,         57, 59,         51,             44,             38,             31,             25,             18,             12                                     ],
	[         65,             58,             52,             45,             39,             32,             26,             19,             13,              6,              0     ],
];

use constant king_beat => [
	[     13,             19,             26,             32,             39,             45,             52,             58,             65,             71         ],
	[ 12, 14,             20,             27,             33,             40,             46,             53,             59                                         ],
	[ 13, 15,         18, 21,         24, 28,             34,             41,             47                                                                         ],
	[ 14, 16,         19, 22,         25, 29,         30, 35,         36                                                                                             ],
	[ 15, 17,         20, 23,         26,             31,             37,             42,             48                                                             ],
	[ 16,             21,             27,             32,             38,             43,             49,             54,             60                             ],
	[     19,             26,             32,             39,             45,             52,             58,             65,             71                         ],
	[ 18, 20,         24, 27,             33,             40,             46,             53,             59                                                         ],
	[ 19, 21,         25, 28,         30, 34,         36, 41,             47                                                                                         ],
	[ 20, 22,         26, 29,         31, 35,         37,             42,             48                                                                             ],
	[ 21, 23,         27,             32,             38,             43,             49,             54,             60                                             ],
	[ 22,             28,             33,             39,             44,             50,             55,             61,             66                             ],
	[     25,      1,     31,             38,             44,             51,             57,             64,             70                                         ],
	[ 24, 26,  0,  2,     32,             39,             45,             52,             58,             65,             71                                         ],
	[ 25, 27,  1,  3, 30, 33,         36, 40,             46,             53,             59                                                                         ],
	[ 26, 28,  2,  4, 31, 34,         37, 41,         42, 47,         48                                                                                             ],
	[ 27, 29,  3,  5, 32, 35,         38,             43,             49,             54,             60                                                             ],
	[ 28,      4,     33,             39,             44,             50,             55,             61,             66                                             ],
	[     31,      7,     38,      2,     44,             51,             57,             64,             70                                                         ],
	[ 30, 32,  6,  8, 36, 39,  0,  3,     45,             52,             58,             65,             71                                                         ],
	[ 31, 33,  7,  9, 37, 40,  1,  4, 42, 46,         48, 53,             59                                                                                         ],
	[ 32, 34,  8, 10, 38, 41,  2,  5, 43, 47,         49,             54,             60                                                                             ],
	[ 33, 35,  9, 11, 39,      3,     44,             50,             55,             61,             66                                                             ],
	[ 34,     10,     40,      4,     45,             51,             56,             62,             67                                                             ],
	[     37,     13,     43,      7,     50,      2,     56,             63,             69                                                                         ],
	[ 36, 38, 12, 14,     44,      8,     51,      3,     57,             64,             70                                                                         ],
	[ 37, 39, 13, 15, 42, 45,  6,  9, 48, 52,  0,  4,     58,             65,             71                                                                         ],
	[ 38, 40, 14, 16, 43, 46,  7, 10, 49, 53,  1,  5, 54, 59,         60                                                                                             ],
	[ 39, 41, 15, 17, 44, 47,  8, 11, 50,      2,     55,             61,             66                                                                             ],
	[ 40,     16,     45,      9,     51,      3,     56,             62,             67                                                                             ],
	[     43,     19,     50,     14,     56,      8,     63,      3,     69                                                                                         ],
	[ 42, 44, 18, 20, 48, 51, 12, 15,     57,      9,     64,      4,     70                                                                                         ],
	[ 43, 45, 19, 21, 49, 52, 13, 16, 54, 58,  6, 10, 60, 65,  0,  5,     71                                                                                         ],
	[ 44, 46, 20, 22, 50, 53, 14, 17, 55, 59,  7, 11, 61,      1,     66                                                                                             ],
	[ 45, 47, 21, 23, 51,     15,     56,      8,     62,      2,     67                                                                                             ],
	[ 46,     22,     52,     16,     57,      9,     63,      3,     68                                                                                             ],
	[     49,     25,     55,     19,     62,     14,     68,      8,              3                                                                                 ],
	[ 48, 50, 24, 26,     56,     20,     63,     15,     69,      9,              4                                                                                 ],
	[ 49, 51, 25, 27, 54, 57, 18, 21, 60, 64, 12, 16,     70,     10,              5                                                                                 ],
	[ 50, 52, 26, 28, 55, 58, 19, 22, 61, 65, 13, 17, 66, 71,  6, 11,          0                                                                                     ],
	[ 51, 53, 27, 29, 56, 59, 20, 23, 62,     14,     67,      7,              1                                                                                     ],
	[ 52,     28,     57,     21,     63,     15,     68,      8,              2                                                                                     ],
	[     55,     31,     62,     26,     68,     20,             15,              9,              4                                                                 ],
	[ 54, 56, 30, 32, 60, 63, 24, 27,     69,     21,             16,             10,              5                                                                 ],
	[ 55, 57, 31, 33, 61, 64, 25, 28, 66, 70, 18, 22,         12, 17,             11                                                                                 ],
	[ 56, 58, 32, 34, 62, 65, 26, 29, 67, 71, 19, 23,         13,              6,              0                                                                     ],
	[ 57, 59, 33, 35, 63,     27,     68,     20,             14,              7,              1                                                                     ],
	[ 58,     34,     64,     28,     69,     21,             15,              8,              2                                                                     ],
	[     61,     37,     67,     31,             26,             20,             15,              9,              4                                                 ],
	[ 60, 62, 36, 38,     68,     32,             27,             21,             16,             10,              5                                                 ],
	[ 61, 63, 37, 39, 66, 69, 30, 33,         24, 28,             22,             17,             11                                                                 ],
	[ 62, 64, 38, 40, 67, 70, 31, 34,         25, 29,         18, 23,         12                                                                                     ],
	[ 63, 65, 39, 41, 68, 71, 32, 35,         26,             19,             13,              6,              0                                                     ],
	[ 64,     40,     69,     33,             27,             20,             14,              7,              1                                                     ],
	[     67,     43,             38,             32,             27,             21,             16,             10,              5                                 ],
	[ 66, 68, 42, 44,         36, 39,             33,             28,             22,             17,             11                                                 ],
	[ 67, 69, 43, 45,         37, 40,         30, 34,         24, 29,             23                                                                                 ],
	[ 68, 70, 44, 46,         38, 41,         31, 35,         25,             18,             12                                                                     ],
	[ 69, 71, 45, 47,         39,             32,             26,             19,             13,              6,              0                                     ],
	[ 70,     46,             40,             33,             27,             20,             14,              7,              1                                     ],
	[             49,             43,             38,             32,             27,             21,             16,             10,              5                 ],
	[         48, 50,             44,             39,             33,             28,             22,             17,             11                                 ],
	[         49, 51,         42, 45,         36, 40,             34,             29,             23                                                                 ],
	[         50, 52,         43, 46,         37, 41,         30, 35,         24                                                                                     ],
	[         51, 53,         44, 47,         38,             31,             25,             18,             12                                                     ],
	[         52,             45,             39,             32,             26,             19,             13,              6,              0                     ],
	[             55,             50,             44,             39,             33,             28,             22,             17,             11                 ],
	[         54, 56,         48, 51,             45,             40,             34,             29,             23                                                 ],
	[         55, 57,         49, 52,         42, 46,         36, 41,             35                                                                                 ],
	[         56, 58,         50, 53,         43, 47,         37,             30,             24                                                                     ],
	[         57, 59,         51,             44,             38,             31,             25,             18,             12                                     ],
	[         58,             52,             45,             39,             32,             26,             19,             13,              6,              0     ],
];

use constant king_step_short => [
	[      6         ], [  6,  7         ], [  7,  8         ], [  8,  9         ], [  9, 10         ], [ 10, 11         ],
	[ 12, 13,  0,  1 ], [ 13, 14,  1,  2 ], [ 14, 15,  2,  3 ], [ 15, 16,  3,  4 ], [ 16, 17,  4,  5 ], [ 17,      5     ],
	[     18,      6 ], [ 18, 19,  6,  7 ], [ 19, 20,  7,  8 ], [ 20, 21,  8,  9 ], [ 21, 22,  9, 10 ], [ 22, 23, 10, 11 ],
	[ 24, 25, 12, 13 ], [ 25, 26, 13, 14 ], [ 26, 27, 14, 15 ], [ 27, 28, 15, 16 ], [ 28, 29, 16, 17 ], [ 29,     17     ],
	[     30,     18 ], [ 30, 31, 18, 19 ], [ 31, 32, 19, 20 ], [ 32, 33, 20, 21 ], [ 33, 34, 21, 22 ], [ 34, 35, 22, 23 ],
	[ 36, 37, 24, 25 ], [ 37, 38, 25, 26 ], [ 38, 39, 26, 27 ], [ 39, 40, 27, 28 ], [ 40, 41, 28, 29 ], [ 41,     29     ],
	[     42,     30 ], [ 42, 43, 30, 31 ], [ 43, 44, 31, 32 ], [ 44, 45, 32, 33 ], [ 45, 46, 33, 34 ], [ 46, 47, 34, 35 ],
	[ 48, 49, 36, 37 ], [ 49, 50, 37, 38 ], [ 50, 51, 38, 39 ], [ 51, 52, 39, 40 ], [ 52, 53, 40, 41 ], [ 53,     41     ],
	[     54,     42 ], [ 54, 55, 42, 43 ], [ 55, 56, 43, 44 ], [ 56, 57, 44, 45 ], [ 57, 58, 45, 46 ], [ 58, 59, 46, 47 ],
	[ 60, 61, 48, 49 ], [ 61, 62, 49, 50 ], [ 62, 63, 50, 51 ], [ 63, 64, 51, 52 ], [ 64, 65, 52, 53 ], [ 65,     53     ],
	[     66,     54 ], [ 66, 67, 54, 55 ], [ 67, 68, 55, 56 ], [ 68, 69, 56, 57 ], [ 69, 70, 57, 58 ], [ 70, 71, 58, 59 ],
	[         60, 61 ], [         61, 62 ], [         62, 63 ], [         63, 64 ], [         64, 65 ], [         65     ],
];

use constant king_beat_short => [
	[     13         ], [ 12, 14         ], [ 13, 15         ], [ 14, 16         ], [ 15, 17         ], [ 16             ],
	[     19         ], [ 18, 20         ], [ 19, 21         ], [ 20, 22         ], [ 21, 23         ], [ 22             ],
	[     25,      1 ], [ 24, 26,  0,  2 ], [ 25, 27,  1,  3 ], [ 26, 28,  2,  4 ], [ 27, 29,  3,  5 ], [ 28,      4     ],
	[     31,      7 ], [ 30, 32,  6,  8 ], [ 31, 33,  7,  9 ], [ 32, 34,  8, 10 ], [ 33, 35,  9, 11 ], [ 34,     10     ],
	[     37,     13 ], [ 36, 38, 12, 14 ], [ 37, 39, 13, 15 ], [ 38, 40, 14, 16 ], [ 39, 41, 15, 17 ], [ 40,     16     ],
	[     43,     19 ], [ 42, 44, 18, 20 ], [ 43, 45, 19, 21 ], [ 44, 46, 20, 22 ], [ 45, 47, 21, 23 ], [ 46,     22     ],
	[     49,     25 ], [ 48, 50, 24, 26 ], [ 49, 51, 25, 27 ], [ 50, 52, 26, 28 ], [ 51, 53, 27, 29 ], [ 52,     28     ],
	[     55,     31 ], [ 54, 56, 30, 32 ], [ 55, 57, 31, 33 ], [ 56, 58, 32, 34 ], [ 57, 59, 33, 35 ], [ 58,     34     ],
	[     61,     37 ], [ 60, 62, 36, 38 ], [ 61, 63, 37, 39 ], [ 62, 64, 38, 40 ], [ 63, 65, 39, 41 ], [ 64,     40     ],
	[     67,     43 ], [ 66, 68, 42, 44 ], [ 67, 69, 43, 45 ], [ 68, 70, 44, 46 ], [ 69, 71, 45, 47 ], [ 70,     46     ],
	[             49 ], [         48, 50 ], [         49, 51 ], [         50, 52 ], [         51, 53 ], [         52     ],
	[             55 ], [         54, 56 ], [         55, 57 ], [         56, 58 ], [         57, 59 ], [         58     ],
];

use constant king_beat_8dirs => [
	[     13,                 24,  2,     19,                 36,  3,     26,                 48,  4,     32,                 60,  5,     39,                             45,                             52,                             58,                             65,                             71                         ],
	[ 12, 14,                 25,  3,     20,                 37,  4,     27,                 49,  5,     33,                 61,         40,                             46,                             53,                             59                                                                                         ],
	[ 13, 15,              0, 26,  4, 18, 21,                 38,  5, 24, 28,                 50,         34,                 62,         41,                             47                                                                                                                                                         ],
	[ 14, 16,              1, 27,  5, 19, 22,              0, 39,     25, 29,                 51,     30, 35,                 63,     36                                                                                                                                                                                             ],
	[ 15, 17,              2, 28,     20, 23,              1, 40,     26,                  0, 52,     31,                     64,     37,                             42,                             48                                                                                                                             ],
	[ 16,                  3, 29,     21,                  2, 41,     27,                  1, 53,     32,                  0, 65,     38,                             43,                             49,                             54,                             60                                                             ],
	[     19,                 30,  8,     26,                 42,  9,     32,                 54, 10,     39,                 66, 11,     45,                             52,                             58,                             65,                             71                                                         ],
	[ 18, 20,                 31,  9, 24, 27,                 43, 10,     33,                 55, 11,     40,                 67,         46,                             53,                             59                                                                                                                         ],
	[ 19, 21,              6, 32, 10, 25, 28,                 44, 11, 30, 34,                 56,     36, 41,                 68,         47                                                                                                                                                                                         ],
	[ 20, 22,              7, 33, 11, 26, 29,              6, 45,     31, 35,                 57,     37,                     69,     42,                             48                                                                                                                                                             ],
	[ 21, 23,              8, 34,     27,                  7, 46,     32,                  6, 58,     38,                     70,     43,                             49,                             54,                             60                                                                                             ],
	[ 22,                  9, 35,     28,                  8, 47,     33,                  7, 59,     39,                  6, 71,     44,                             50,                             55,                             61,                             66                                                             ],
	[     25,      1,         36, 14,     31,                 48, 15,     38,                 60, 16,     44,                     17,     51,                             57,                             64,                             70                                                                                         ],
	[ 24, 26,  0,  2,         37, 15,     32,                 49, 16,     39,                 61, 17,     45,                             52,                             58,                             65,                             71                                                                                         ],
	[ 25, 27,  1,  3,     12, 38, 16, 30, 33,                 50, 17, 36, 40,                 62,         46,                             53,                             59                                                                                                                                                         ],
	[ 26, 28,  2,  4,     13, 39, 17, 31, 34,             12, 51,     37, 41,                 63,     42, 47,                         48                                                                                                                                                                                             ],
	[ 27, 29,  3,  5,     14, 40,     32, 35,             13, 52,     38,                 12, 64,     43,                             49,                             54,                             60                                                                                                                             ],
	[ 28,      4,         15, 41,     33,                 14, 53,     39,                 13, 65,     44,                 12,         50,                             55,                             61,                             66                                                                                             ],
	[     31,      7,         42, 20,     38,      2,         54, 21,     44,                 66, 22,     51,                     23,     57,                             64,                             70                                                                                                                         ],
	[ 30, 32,  6,  8,         43, 21, 36, 39,  0,  3,         55, 22,     45,                 67, 23,     52,                             58,                             65,                             71                                                                                                                         ],
	[ 31, 33,  7,  9,     18, 44, 22, 37, 40,  1,  4,         56, 23, 42, 46,                 68,     48, 53,                             59                                                                                                                                                                                         ],
	[ 32, 34,  8, 10,     19, 45, 23, 38, 41,  2,  5,     18, 57,     43, 47,                 69,     49,                             54,                             60                                                                                                                                                             ],
	[ 33, 35,  9, 11,     20, 46,     39,      3,         19, 58,     44,                 18, 70,     50,                             55,                             61,                             66                                                                                                                             ],
	[ 34,     10,         21, 47,     40,      4,         20, 59,     45,                 19, 71,     51,                 18,         56,                             62,                             67                                                                                                                             ],
	[     37,     13,  0,     48, 26,     43,      7,         60, 27,     50,      2,             28,     56,                     29,     63,                             69                                                                                                                                                         ],
	[ 36, 38, 12, 14,  1,     49, 27,     44,      8,         61, 28,     51,      3,             29,     57,                             64,                             70                                                                                                                                                         ],
	[ 37, 39, 13, 15,  2, 24, 50, 28, 42, 45,  6,  9,         62, 29, 48, 52,  0,  4,                     58,                             65,                             71                                                                                                                                                         ],
	[ 38, 40, 14, 16,  3, 25, 51, 29, 43, 46,  7, 10,     24, 63,     49, 53,  1,  5,                 54, 59,                         60                                                                                                                                                                                             ],
	[ 39, 41, 15, 17,  4, 26, 52,     44, 47,  8, 11,     25, 64,     50,      2,         24,         55,                             61,                             66                                                                                                                                                             ],
	[ 40,     16,      5, 27, 53,     45,      9,         26, 65,     51,      3,         25,         56,                 24,         62,                             67                                                                                                                                                             ],
	[     43,     19,  6,     54, 32,     50,     14,         66, 33,     56,      8,             34,     63,      3,             35,     69                                                                                                                                                                                         ],
	[ 42, 44, 18, 20,  7,     55, 33, 48, 51, 12, 15,         67, 34,     57,      9,             35,     64,      4,                     70                                                                                                                                                                                         ],
	[ 43, 45, 19, 21,  8, 30, 56, 34, 49, 52, 13, 16,         68, 35, 54, 58,  6, 10,                 60, 65,  0,  5,                     71                                                                                                                                                                                         ],
	[ 44, 46, 20, 22,  9, 31, 57, 35, 50, 53, 14, 17,     30, 69,     55, 59,  7, 11,                 61,      1,                     66                                                                                                                                                                                             ],
	[ 45, 47, 21, 23, 10, 32, 58,     51,     15,         31, 70,     56,      8,         30,         62,      2,                     67                                                                                                                                                                                             ],
	[ 46,     22,     11, 33, 59,     52,     16,         32, 71,     57,      9,         31,         63,      3,         30,         68                                                                                                                                                                                             ],
	[     49,     25, 12,     60, 38,     55,     19,  0,         39,     62,     14,             40,     68,      8,             41,              3                                                                                                                                                                                 ],
	[ 48, 50, 24, 26, 13,     61, 39,     56,     20,  1,         40,     63,     15,             41,     69,      9,                              4                                                                                                                                                                                 ],
	[ 49, 51, 25, 27, 14, 36, 62, 40, 54, 57, 18, 21,  2,         41, 60, 64, 12, 16,                     70,     10,                              5                                                                                                                                                                                 ],
	[ 50, 52, 26, 28, 15, 37, 63, 41, 55, 58, 19, 22,  3, 36,         61, 65, 13, 17,                 66, 71,  6, 11,                          0                                                                                                                                                                                     ],
	[ 51, 53, 27, 29, 16, 38, 64,     56, 59, 20, 23,  4, 37,         62,     14,         36,         67,      7,                              1                                                                                                                                                                                     ],
	[ 52,     28,     17, 39, 65,     57,     21,      5, 38,         63,     15,         37,         68,      8,         36,                  2                                                                                                                                                                                     ],
	[     55,     31, 18,     66, 44,     62,     26,  6,         45,     68,     20,             46,             15,             47,              9,                              4                                                                                                                                                 ],
	[ 54, 56, 30, 32, 19,     67, 45, 60, 63, 24, 27,  7,         46,     69,     21,             47,             16,                             10,                              5                                                                                                                                                 ],
	[ 55, 57, 31, 33, 20, 42, 68, 46, 61, 64, 25, 28,  8,         47, 66, 70, 18, 22,                         12, 17,                             11                                                                                                                                                                                 ],
	[ 56, 58, 32, 34, 21, 43, 69, 47, 62, 65, 26, 29,  9, 42,         67, 71, 19, 23,                         13,                              6,                              0                                                                                                                                                     ],
	[ 57, 59, 33, 35, 22, 44, 70,     63,     27,     10, 43,         68,     20,         42,                 14,                              7,                              1                                                                                                                                                     ],
	[ 58,     34,     23, 45, 71,     64,     28,     11, 44,         69,     21,         43,                 15,         42,                  8,                              2                                                                                                                                                     ],
	[     61,     37, 24,         50,     67,     31, 12,         51,             26,  0,         52,             20,             53,             15,                              9,                              4                                                                                                                 ],
	[ 60, 62, 36, 38, 25,         51,     68,     32, 13,         52,             27,  1,         53,             21,                             16,                             10,                              5                                                                                                                 ],
	[ 61, 63, 37, 39, 26, 48,     52, 66, 69, 30, 33, 14,         53,         24, 28,  2,                         22,                             17,                             11                                                                                                                                                 ],
	[ 62, 64, 38, 40, 27, 49,     53, 67, 70, 31, 34, 15, 48,                 25, 29,  3,                     18, 23,                         12                                                                                                                                                                                     ],
	[ 63, 65, 39, 41, 28, 50,         68, 71, 32, 35, 16, 49,                 26,      4, 48,                 19,                             13,                              6,                              0                                                                                                                     ],
	[ 64,     40,     29, 51,         69,     33,     17, 50,                 27,      5, 49,                 20,         48,                 14,                              7,                              1                                                                                                                     ],
	[     67,     43, 30,         56,             38, 18,         57,             32,  6,         58,             27,             59,             21,                             16,                             10,                              5                                                                                 ],
	[ 66, 68, 42, 44, 31,         57,         36, 39, 19,         58,             33,  7,         59,             28,                             22,                             17,                             11                                                                                                                 ],
	[ 67, 69, 43, 45, 32, 54,     58,         37, 40, 20,         59,         30, 34,  8,                     24, 29,                             23                                                                                                                                                                                 ],
	[ 68, 70, 44, 46, 33, 55,     59,         38, 41, 21, 54,                 31, 35,  9,                     25,                             18,                             12                                                                                                                                                     ],
	[ 69, 71, 45, 47, 34, 56,                 39,     22, 55,                 32,     10, 54,                 26,                             19,                             13,                              6,                              0                                                                                     ],
	[ 70,     46,     35, 57,                 40,     23, 56,                 33,     11, 55,                 27,         54,                 20,                             14,                              7,                              1                                                                                     ],
	[             49, 36,         62,             43, 24,         63,             38, 12,         64,             32,  0,         65,             27,                             21,                             16,                             10,                              5                                                 ],
	[         48, 50, 37,         63,             44, 25,         64,             39, 13,         65,             33,  1,                         28,                             22,                             17,                             11                                                                                 ],
	[         49, 51, 38, 60,     64,         42, 45, 26,         65,         36, 40, 14,                         34,  2,                         29,                             23                                                                                                                                                 ],
	[         50, 52, 39, 61,     65,         43, 46, 27, 60,                 37, 41, 15,                     30, 35,  3,                     24                                                                                                                                                                                     ],
	[         51, 53, 40, 62,                 44, 47, 28, 61,                 38,     16, 60,                 31,      4,                     25,                             18,                             12                                                                                                                     ],
	[         52,     41, 63,                 45,     29, 62,                 39,     17, 61,                 32,      5, 60,                 26,                             19,                             13,                              6,                              0                                                     ],
	[             55, 42,         68,             50, 30,         69,             44, 18,         70,             39,  6,         71,             33,                             28,                             22,                             17,                             11                                                 ],
	[         54, 56, 43,         69,         48, 51, 31,         70,             45, 19,         71,             40,  7,                         34,                             29,                             23                                                                                                                 ],
	[         55, 57, 44, 66,     70,         49, 52, 32,         71,         42, 46, 20,                     36, 41,  8,                         35                                                                                                                                                                                 ],
	[         56, 58, 45, 67,     71,         50, 53, 33, 66,                 43, 47, 21,                     37,      9,                     30,                             24                                                                                                                                                     ],
	[         57, 59, 46, 68,                 51,     34, 67,                 44,     22, 66,                 38,     10,                     31,                             25,                             18,                             12                                                                                     ],
	[         58,     47, 69,                 52,     35, 68,                 45,     23, 67,                 39,     11, 66,                 32,                             26,                             19,                             13,                              6,                              0                     ],
];

use constant enclosed_locs => [
	{ 13 => [  6 ], 19 => [  6, 13 ], 26 => [  6, 13, 19 ], 32 => [  6, 13, 19, 26 ], 39 => [  6, 13, 19, 26, 32 ], 45 => [  6, 13, 19, 26, 32, 39 ], 52 => [  6, 13, 19, 26, 32, 39, 45 ], 58 => [  6, 13, 19, 26, 32, 39, 45, 52 ], 65 => [  6, 13, 19, 26, 32, 39, 45, 52, 58 ], 71 => [  6, 13, 19, 26, 32, 39, 45, 52, 58, 65 ] },
	{ 12 => [  6 ], 14 => [  7 ], 20 => [  7, 14 ], 27 => [  7, 14, 20 ], 33 => [  7, 14, 20, 27 ], 40 => [  7, 14, 20, 27, 33 ], 46 => [  7, 14, 20, 27, 33, 40 ], 53 => [  7, 14, 20, 27, 33, 40, 46 ], 59 => [  7, 14, 20, 27, 33, 40, 46, 53 ] },
	{ 13 => [  7 ], 15 => [  8 ], 18 => [  7, 13 ], 21 => [  8, 15 ], 24 => [  7, 13, 18 ], 28 => [  8, 15, 21 ], 34 => [  8, 15, 21, 28 ], 41 => [  8, 15, 21, 28, 34 ], 47 => [  8, 15, 21, 28, 34, 41 ] },
	{ 14 => [  8 ], 16 => [  9 ], 19 => [  8, 14 ], 22 => [  9, 16 ], 25 => [  8, 14, 19 ], 29 => [  9, 16, 22 ], 30 => [  8, 14, 19, 25 ], 35 => [  9, 16, 22, 29 ], 36 => [  8, 14, 19, 25, 30 ] },
	{ 15 => [  9 ], 17 => [ 10 ], 20 => [  9, 15 ], 23 => [ 10, 17 ], 26 => [  9, 15, 20 ], 31 => [  9, 15, 20, 26 ], 37 => [  9, 15, 20, 26, 31 ], 42 => [  9, 15, 20, 26, 31, 37 ], 48 => [  9, 15, 20, 26, 31, 37, 42 ] },
	{ 16 => [ 10 ], 21 => [ 10, 16 ], 27 => [ 10, 16, 21 ], 32 => [ 10, 16, 21, 27 ], 38 => [ 10, 16, 21, 27, 32 ], 43 => [ 10, 16, 21, 27, 32, 38 ], 49 => [ 10, 16, 21, 27, 32, 38, 43 ], 54 => [ 10, 16, 21, 27, 32, 38, 43, 49 ], 60 => [ 10, 16, 21, 27, 32, 38, 43, 49, 54 ] },
	{ 19 => [ 13 ], 26 => [ 13, 19 ], 32 => [ 13, 19, 26 ], 39 => [ 13, 19, 26, 32 ], 45 => [ 13, 19, 26, 32, 39 ], 52 => [ 13, 19, 26, 32, 39, 45 ], 58 => [ 13, 19, 26, 32, 39, 45, 52 ], 65 => [ 13, 19, 26, 32, 39, 45, 52, 58 ], 71 => [ 13, 19, 26, 32, 39, 45, 52, 58, 65 ] },
	{ 18 => [ 13 ], 20 => [ 14 ], 24 => [ 13, 18 ], 27 => [ 14, 20 ], 33 => [ 14, 20, 27 ], 40 => [ 14, 20, 27, 33 ], 46 => [ 14, 20, 27, 33, 40 ], 53 => [ 14, 20, 27, 33, 40, 46 ], 59 => [ 14, 20, 27, 33, 40, 46, 53 ] },
	{ 19 => [ 14 ], 21 => [ 15 ], 25 => [ 14, 19 ], 28 => [ 15, 21 ], 30 => [ 14, 19, 25 ], 34 => [ 15, 21, 28 ], 36 => [ 14, 19, 25, 30 ], 41 => [ 15, 21, 28, 34 ], 47 => [ 15, 21, 28, 34, 41 ] },
	{ 20 => [ 15 ], 22 => [ 16 ], 26 => [ 15, 20 ], 29 => [ 16, 22 ], 31 => [ 15, 20, 26 ], 35 => [ 16, 22, 29 ], 37 => [ 15, 20, 26, 31 ], 42 => [ 15, 20, 26, 31, 37 ], 48 => [ 15, 20, 26, 31, 37, 42 ] },
	{ 21 => [ 16 ], 23 => [ 17 ], 27 => [ 16, 21 ], 32 => [ 16, 21, 27 ], 38 => [ 16, 21, 27, 32 ], 43 => [ 16, 21, 27, 32, 38 ], 49 => [ 16, 21, 27, 32, 38, 43 ], 54 => [ 16, 21, 27, 32, 38, 43, 49 ], 60 => [ 16, 21, 27, 32, 38, 43, 49, 54 ] },
	{ 22 => [ 17 ], 28 => [ 17, 22 ], 33 => [ 17, 22, 28 ], 39 => [ 17, 22, 28, 33 ], 44 => [ 17, 22, 28, 33, 39 ], 50 => [ 17, 22, 28, 33, 39, 44 ], 55 => [ 17, 22, 28, 33, 39, 44, 50 ], 61 => [ 17, 22, 28, 33, 39, 44, 50, 55 ], 66 => [ 17, 22, 28, 33, 39, 44, 50, 55, 61 ] },
	{  1 => [  6 ], 25 => [ 18 ], 31 => [ 18, 25 ], 38 => [ 18, 25, 31 ], 44 => [ 18, 25, 31, 38 ], 51 => [ 18, 25, 31, 38, 44 ], 57 => [ 18, 25, 31, 38, 44, 51 ], 64 => [ 18, 25, 31, 38, 44, 51, 57 ], 70 => [ 18, 25, 31, 38, 44, 51, 57, 64 ] },
	{  0 => [  6 ],  2 => [  7 ], 24 => [ 18 ], 26 => [ 19 ], 32 => [ 19, 26 ], 39 => [ 19, 26, 32 ], 45 => [ 19, 26, 32, 39 ], 52 => [ 19, 26, 32, 39, 45 ], 58 => [ 19, 26, 32, 39, 45, 52 ], 65 => [ 19, 26, 32, 39, 45, 52, 58 ], 71 => [ 19, 26, 32, 39, 45, 52, 58, 65 ] },
	{  1 => [  7 ],  3 => [  8 ], 25 => [ 19 ], 27 => [ 20 ], 30 => [ 19, 25 ], 33 => [ 20, 27 ], 36 => [ 19, 25, 30 ], 40 => [ 20, 27, 33 ], 46 => [ 20, 27, 33, 40 ], 53 => [ 20, 27, 33, 40, 46 ], 59 => [ 20, 27, 33, 40, 46, 53 ] },
	{  2 => [  8 ],  4 => [  9 ], 26 => [ 20 ], 28 => [ 21 ], 31 => [ 20, 26 ], 34 => [ 21, 28 ], 37 => [ 20, 26, 31 ], 41 => [ 21, 28, 34 ], 42 => [ 20, 26, 31, 37 ], 47 => [ 21, 28, 34, 41 ], 48 => [ 20, 26, 31, 37, 42 ] },
	{  3 => [  9 ],  5 => [ 10 ], 27 => [ 21 ], 29 => [ 22 ], 32 => [ 21, 27 ], 35 => [ 22, 29 ], 38 => [ 21, 27, 32 ], 43 => [ 21, 27, 32, 38 ], 49 => [ 21, 27, 32, 38, 43 ], 54 => [ 21, 27, 32, 38, 43, 49 ], 60 => [ 21, 27, 32, 38, 43, 49, 54 ] },
	{  4 => [ 10 ], 28 => [ 22 ], 33 => [ 22, 28 ], 39 => [ 22, 28, 33 ], 44 => [ 22, 28, 33, 39 ], 50 => [ 22, 28, 33, 39, 44 ], 55 => [ 22, 28, 33, 39, 44, 50 ], 61 => [ 22, 28, 33, 39, 44, 50, 55 ], 66 => [ 22, 28, 33, 39, 44, 50, 55, 61 ] },
	{  2 => [ 13,  7 ],  7 => [ 13 ], 31 => [ 25 ], 38 => [ 25, 31 ], 44 => [ 25, 31, 38 ], 51 => [ 25, 31, 38, 44 ], 57 => [ 25, 31, 38, 44, 51 ], 64 => [ 25, 31, 38, 44, 51, 57 ], 70 => [ 25, 31, 38, 44, 51, 57, 64 ] },
	{  0 => [ 13,  6 ],  3 => [ 14,  8 ],  6 => [ 13 ],  8 => [ 14 ], 30 => [ 25 ], 32 => [ 26 ], 36 => [ 25, 30 ], 39 => [ 26, 32 ], 45 => [ 26, 32, 39 ], 52 => [ 26, 32, 39, 45 ], 58 => [ 26, 32, 39, 45, 52 ], 65 => [ 26, 32, 39, 45, 52, 58 ], 71 => [ 26, 32, 39, 45, 52, 58, 65 ] },
	{  1 => [ 14,  7 ],  4 => [ 15,  9 ],  7 => [ 14 ],  9 => [ 15 ], 31 => [ 26 ], 33 => [ 27 ], 37 => [ 26, 31 ], 40 => [ 27, 33 ], 42 => [ 26, 31, 37 ], 46 => [ 27, 33, 40 ], 48 => [ 26, 31, 37, 42 ], 53 => [ 27, 33, 40, 46 ], 59 => [ 27, 33, 40, 46, 53 ] },
	{  2 => [ 15,  8 ],  5 => [ 16, 10 ],  8 => [ 15 ], 10 => [ 16 ], 32 => [ 27 ], 34 => [ 28 ], 38 => [ 27, 32 ], 41 => [ 28, 34 ], 43 => [ 27, 32, 38 ], 47 => [ 28, 34, 41 ], 49 => [ 27, 32, 38, 43 ], 54 => [ 27, 32, 38, 43, 49 ], 60 => [ 27, 32, 38, 43, 49, 54 ] },
	{  3 => [ 16,  9 ],  9 => [ 16 ], 11 => [ 17 ], 33 => [ 28 ], 35 => [ 29 ], 39 => [ 28, 33 ], 44 => [ 28, 33, 39 ], 50 => [ 28, 33, 39, 44 ], 55 => [ 28, 33, 39, 44, 50 ], 61 => [ 28, 33, 39, 44, 50, 55 ], 66 => [ 28, 33, 39, 44, 50, 55, 61 ] },
	{  4 => [ 17, 10 ], 10 => [ 17 ], 34 => [ 29 ], 40 => [ 29, 34 ], 45 => [ 29, 34, 40 ], 51 => [ 29, 34, 40, 45 ], 56 => [ 29, 34, 40, 45, 51 ], 62 => [ 29, 34, 40, 45, 51, 56 ], 67 => [ 29, 34, 40, 45, 51, 56, 62 ] },
	{  2 => [ 18, 13,  7 ],  7 => [ 18, 13 ], 13 => [ 18 ], 37 => [ 30 ], 43 => [ 30, 37 ], 50 => [ 30, 37, 43 ], 56 => [ 30, 37, 43, 50 ], 63 => [ 30, 37, 43, 50, 56 ], 69 => [ 30, 37, 43, 50, 56, 63 ] },
	{  3 => [ 19, 14,  8 ],  8 => [ 19, 14 ], 12 => [ 18 ], 14 => [ 19 ], 36 => [ 30 ], 38 => [ 31 ], 44 => [ 31, 38 ], 51 => [ 31, 38, 44 ], 57 => [ 31, 38, 44, 51 ], 64 => [ 31, 38, 44, 51, 57 ], 70 => [ 31, 38, 44, 51, 57, 64 ] },
	{  0 => [ 19, 13,  6 ],  4 => [ 20, 15,  9 ],  6 => [ 19, 13 ],  9 => [ 20, 15 ], 13 => [ 19 ], 15 => [ 20 ], 37 => [ 31 ], 39 => [ 32 ], 42 => [ 31, 37 ], 45 => [ 32, 39 ], 48 => [ 31, 37, 42 ], 52 => [ 32, 39, 45 ], 58 => [ 32, 39, 45, 52 ], 65 => [ 32, 39, 45, 52, 58 ], 71 => [ 32, 39, 45, 52, 58, 65 ] },
	{  1 => [ 20, 14,  7 ],  5 => [ 21, 16, 10 ],  7 => [ 20, 14 ], 10 => [ 21, 16 ], 14 => [ 20 ], 16 => [ 21 ], 38 => [ 32 ], 40 => [ 33 ], 43 => [ 32, 38 ], 46 => [ 33, 40 ], 49 => [ 32, 38, 43 ], 53 => [ 33, 40, 46 ], 54 => [ 32, 38, 43, 49 ], 59 => [ 33, 40, 46, 53 ], 60 => [ 32, 38, 43, 49, 54 ] },
	{  2 => [ 21, 15,  8 ],  8 => [ 21, 15 ], 11 => [ 22, 17 ], 15 => [ 21 ], 17 => [ 22 ], 39 => [ 33 ], 41 => [ 34 ], 44 => [ 33, 39 ], 47 => [ 34, 41 ], 50 => [ 33, 39, 44 ], 55 => [ 33, 39, 44, 50 ], 61 => [ 33, 39, 44, 50, 55 ], 66 => [ 33, 39, 44, 50, 55, 61 ] },
	{  3 => [ 22, 16,  9 ],  9 => [ 22, 16 ], 16 => [ 22 ], 40 => [ 34 ], 45 => [ 34, 40 ], 51 => [ 34, 40, 45 ], 56 => [ 34, 40, 45, 51 ], 62 => [ 34, 40, 45, 51, 56 ], 67 => [ 34, 40, 45, 51, 56, 62 ] },
	{  3 => [ 25, 19, 14,  8 ],  8 => [ 25, 19, 14 ], 14 => [ 25, 19 ], 19 => [ 25 ], 43 => [ 37 ], 50 => [ 37, 43 ], 56 => [ 37, 43, 50 ], 63 => [ 37, 43, 50, 56 ], 69 => [ 37, 43, 50, 56, 63 ] },
	{  4 => [ 26, 20, 15,  9 ],  9 => [ 26, 20, 15 ], 12 => [ 25, 18 ], 15 => [ 26, 20 ], 18 => [ 25 ], 20 => [ 26 ], 42 => [ 37 ], 44 => [ 38 ], 48 => [ 37, 42 ], 51 => [ 38, 44 ], 57 => [ 38, 44, 51 ], 64 => [ 38, 44, 51, 57 ], 70 => [ 38, 44, 51, 57, 64 ] },
	{  0 => [ 26, 19, 13,  6 ],  5 => [ 27, 21, 16, 10 ],  6 => [ 26, 19, 13 ], 10 => [ 27, 21, 16 ], 13 => [ 26, 19 ], 16 => [ 27, 21 ], 19 => [ 26 ], 21 => [ 27 ], 43 => [ 38 ], 45 => [ 39 ], 49 => [ 38, 43 ], 52 => [ 39, 45 ], 54 => [ 38, 43, 49 ], 58 => [ 39, 45, 52 ], 60 => [ 38, 43, 49, 54 ], 65 => [ 39, 45, 52, 58 ], 71 => [ 39, 45, 52, 58, 65 ] },
	{  1 => [ 27, 20, 14,  7 ],  7 => [ 27, 20, 14 ], 11 => [ 28, 22, 17 ], 14 => [ 27, 20 ], 17 => [ 28, 22 ], 20 => [ 27 ], 22 => [ 28 ], 44 => [ 39 ], 46 => [ 40 ], 50 => [ 39, 44 ], 53 => [ 40, 46 ], 55 => [ 39, 44, 50 ], 59 => [ 40, 46, 53 ], 61 => [ 39, 44, 50, 55 ], 66 => [ 39, 44, 50, 55, 61 ] },
	{  2 => [ 28, 21, 15,  8 ],  8 => [ 28, 21, 15 ], 15 => [ 28, 21 ], 21 => [ 28 ], 23 => [ 29 ], 45 => [ 40 ], 47 => [ 41 ], 51 => [ 40, 45 ], 56 => [ 40, 45, 51 ], 62 => [ 40, 45, 51, 56 ], 67 => [ 40, 45, 51, 56, 62 ] },
	{  3 => [ 29, 22, 16,  9 ],  9 => [ 29, 22, 16 ], 16 => [ 29, 22 ], 22 => [ 29 ], 46 => [ 41 ], 52 => [ 41, 46 ], 57 => [ 41, 46, 52 ], 63 => [ 41, 46, 52, 57 ], 68 => [ 41, 46, 52, 57, 63 ] },
	{  3 => [ 30, 25, 19, 14,  8 ],  8 => [ 30, 25, 19, 14 ], 14 => [ 30, 25, 19 ], 19 => [ 30, 25 ], 25 => [ 30 ], 49 => [ 42 ], 55 => [ 42, 49 ], 62 => [ 42, 49, 55 ], 68 => [ 42, 49, 55, 62 ] },
	{  4 => [ 31, 26, 20, 15,  9 ],  9 => [ 31, 26, 20, 15 ], 15 => [ 31, 26, 20 ], 20 => [ 31, 26 ], 24 => [ 30 ], 26 => [ 31 ], 48 => [ 42 ], 50 => [ 43 ], 56 => [ 43, 50 ], 63 => [ 43, 50, 56 ], 69 => [ 43, 50, 56, 63 ] },
	{  5 => [ 32, 27, 21, 16, 10 ], 10 => [ 32, 27, 21, 16 ], 12 => [ 31, 25, 18 ], 16 => [ 32, 27, 21 ], 18 => [ 31, 25 ], 21 => [ 32, 27 ], 25 => [ 31 ], 27 => [ 32 ], 49 => [ 43 ], 51 => [ 44 ], 54 => [ 43, 49 ], 57 => [ 44, 51 ], 60 => [ 43, 49, 54 ], 64 => [ 44, 51, 57 ], 70 => [ 44, 51, 57, 64 ] },
	{  0 => [ 32, 26, 19, 13,  6 ],  6 => [ 32, 26, 19, 13 ], 11 => [ 33, 28, 22, 17 ], 13 => [ 32, 26, 19 ], 17 => [ 33, 28, 22 ], 19 => [ 32, 26 ], 22 => [ 33, 28 ], 26 => [ 32 ], 28 => [ 33 ], 50 => [ 44 ], 52 => [ 45 ], 55 => [ 44, 50 ], 58 => [ 45, 52 ], 61 => [ 44, 50, 55 ], 65 => [ 45, 52, 58 ], 66 => [ 44, 50, 55, 61 ], 71 => [ 45, 52, 58, 65 ] },
	{  1 => [ 33, 27, 20, 14,  7 ],  7 => [ 33, 27, 20, 14 ], 14 => [ 33, 27, 20 ], 20 => [ 33, 27 ], 23 => [ 34, 29 ], 27 => [ 33 ], 29 => [ 34 ], 51 => [ 45 ], 53 => [ 46 ], 56 => [ 45, 51 ], 59 => [ 46, 53 ], 62 => [ 45, 51, 56 ], 67 => [ 45, 51, 56, 62 ] },
	{  2 => [ 34, 28, 21, 15,  8 ],  8 => [ 34, 28, 21, 15 ], 15 => [ 34, 28, 21 ], 21 => [ 34, 28 ], 28 => [ 34 ], 52 => [ 46 ], 57 => [ 46, 52 ], 63 => [ 46, 52, 57 ], 68 => [ 46, 52, 57, 63 ] },
	{  4 => [ 37, 31, 26, 20, 15,  9 ],  9 => [ 37, 31, 26, 20, 15 ], 15 => [ 37, 31, 26, 20 ], 20 => [ 37, 31, 26 ], 26 => [ 37, 31 ], 31 => [ 37 ], 55 => [ 49 ], 62 => [ 49, 55 ], 68 => [ 49, 55, 62 ] },
	{  5 => [ 38, 32, 27, 21, 16, 10 ], 10 => [ 38, 32, 27, 21, 16 ], 16 => [ 38, 32, 27, 21 ], 21 => [ 38, 32, 27 ], 24 => [ 37, 30 ], 27 => [ 38, 32 ], 30 => [ 37 ], 32 => [ 38 ], 54 => [ 49 ], 56 => [ 50 ], 60 => [ 49, 54 ], 63 => [ 50, 56 ], 69 => [ 50, 56, 63 ] },
	{ 11 => [ 39, 33, 28, 22, 17 ], 12 => [ 38, 31, 25, 18 ], 17 => [ 39, 33, 28, 22 ], 18 => [ 38, 31, 25 ], 22 => [ 39, 33, 28 ], 25 => [ 38, 31 ], 28 => [ 39, 33 ], 31 => [ 38 ], 33 => [ 39 ], 55 => [ 50 ], 57 => [ 51 ], 61 => [ 50, 55 ], 64 => [ 51, 57 ], 66 => [ 50, 55, 61 ], 70 => [ 51, 57, 64 ] },
	{  0 => [ 39, 32, 26, 19, 13,  6 ],  6 => [ 39, 32, 26, 19, 13 ], 13 => [ 39, 32, 26, 19 ], 19 => [ 39, 32, 26 ], 23 => [ 40, 34, 29 ], 26 => [ 39, 32 ], 29 => [ 40, 34 ], 32 => [ 39 ], 34 => [ 40 ], 56 => [ 51 ], 58 => [ 52 ], 62 => [ 51, 56 ], 65 => [ 52, 58 ], 67 => [ 51, 56, 62 ], 71 => [ 52, 58, 65 ] },
	{  1 => [ 40, 33, 27, 20, 14,  7 ],  7 => [ 40, 33, 27, 20, 14 ], 14 => [ 40, 33, 27, 20 ], 20 => [ 40, 33, 27 ], 27 => [ 40, 33 ], 33 => [ 40 ], 35 => [ 41 ], 57 => [ 52 ], 59 => [ 53 ], 63 => [ 52, 57 ], 68 => [ 52, 57, 63 ] },
	{  2 => [ 41, 34, 28, 21, 15,  8 ],  8 => [ 41, 34, 28, 21, 15 ], 15 => [ 41, 34, 28, 21 ], 21 => [ 41, 34, 28 ], 28 => [ 41, 34 ], 34 => [ 41 ], 58 => [ 53 ], 64 => [ 53, 58 ], 69 => [ 53, 58, 64 ] },
	{  4 => [ 42, 37, 31, 26, 20, 15,  9 ],  9 => [ 42, 37, 31, 26, 20, 15 ], 15 => [ 42, 37, 31, 26, 20 ], 20 => [ 42, 37, 31, 26 ], 26 => [ 42, 37, 31 ], 31 => [ 42, 37 ], 37 => [ 42 ], 61 => [ 54 ], 67 => [ 54, 61 ] },
	{  5 => [ 43, 38, 32, 27, 21, 16, 10 ], 10 => [ 43, 38, 32, 27, 21, 16 ], 16 => [ 43, 38, 32, 27, 21 ], 21 => [ 43, 38, 32, 27 ], 27 => [ 43, 38, 32 ], 32 => [ 43, 38 ], 36 => [ 42 ], 38 => [ 43 ], 60 => [ 54 ], 62 => [ 55 ], 68 => [ 55, 62 ] },
	{ 11 => [ 44, 39, 33, 28, 22, 17 ], 17 => [ 44, 39, 33, 28, 22 ], 22 => [ 44, 39, 33, 28 ], 24 => [ 43, 37, 30 ], 28 => [ 44, 39, 33 ], 30 => [ 43, 37 ], 33 => [ 44, 39 ], 37 => [ 43 ], 39 => [ 44 ], 61 => [ 55 ], 63 => [ 56 ], 66 => [ 55, 61 ], 69 => [ 56, 63 ] },
	{ 12 => [ 44, 38, 31, 25, 18 ], 18 => [ 44, 38, 31, 25 ], 23 => [ 45, 40, 34, 29 ], 25 => [ 44, 38, 31 ], 29 => [ 45, 40, 34 ], 31 => [ 44, 38 ], 34 => [ 45, 40 ], 38 => [ 44 ], 40 => [ 45 ], 62 => [ 56 ], 64 => [ 57 ], 67 => [ 56, 62 ], 70 => [ 57, 64 ] },
	{  0 => [ 45, 39, 32, 26, 19, 13,  6 ],  6 => [ 45, 39, 32, 26, 19, 13 ], 13 => [ 45, 39, 32, 26, 19 ], 19 => [ 45, 39, 32, 26 ], 26 => [ 45, 39, 32 ], 32 => [ 45, 39 ], 35 => [ 46, 41 ], 39 => [ 45 ], 41 => [ 46 ], 63 => [ 57 ], 65 => [ 58 ], 68 => [ 57, 63 ], 71 => [ 58, 65 ] },
	{  1 => [ 46, 40, 33, 27, 20, 14,  7 ],  7 => [ 46, 40, 33, 27, 20, 14 ], 14 => [ 46, 40, 33, 27, 20 ], 20 => [ 46, 40, 33, 27 ], 27 => [ 46, 40, 33 ], 33 => [ 46, 40 ], 40 => [ 46 ], 64 => [ 58 ], 69 => [ 58, 64 ] },
	{  5 => [ 49, 43, 38, 32, 27, 21, 16, 10 ], 10 => [ 49, 43, 38, 32, 27, 21, 16 ], 16 => [ 49, 43, 38, 32, 27, 21 ], 21 => [ 49, 43, 38, 32, 27 ], 27 => [ 49, 43, 38, 32 ], 32 => [ 49, 43, 38 ], 38 => [ 49, 43 ], 43 => [ 49 ], 67 => [ 61 ] },
	{ 11 => [ 50, 44, 39, 33, 28, 22, 17 ], 17 => [ 50, 44, 39, 33, 28, 22 ], 22 => [ 50, 44, 39, 33, 28 ], 28 => [ 50, 44, 39, 33 ], 33 => [ 50, 44, 39 ], 36 => [ 49, 42 ], 39 => [ 50, 44 ], 42 => [ 49 ], 44 => [ 50 ], 66 => [ 61 ], 68 => [ 62 ] },
	{ 23 => [ 51, 45, 40, 34, 29 ], 24 => [ 50, 43, 37, 30 ], 29 => [ 51, 45, 40, 34 ], 30 => [ 50, 43, 37 ], 34 => [ 51, 45, 40 ], 37 => [ 50, 43 ], 40 => [ 51, 45 ], 43 => [ 50 ], 45 => [ 51 ], 67 => [ 62 ], 69 => [ 63 ] },
	{ 12 => [ 51, 44, 38, 31, 25, 18 ], 18 => [ 51, 44, 38, 31, 25 ], 25 => [ 51, 44, 38, 31 ], 31 => [ 51, 44, 38 ], 35 => [ 52, 46, 41 ], 38 => [ 51, 44 ], 41 => [ 52, 46 ], 44 => [ 51 ], 46 => [ 52 ], 68 => [ 63 ], 70 => [ 64 ] },
	{  0 => [ 52, 45, 39, 32, 26, 19, 13,  6 ],  6 => [ 52, 45, 39, 32, 26, 19, 13 ], 13 => [ 52, 45, 39, 32, 26, 19 ], 19 => [ 52, 45, 39, 32, 26 ], 26 => [ 52, 45, 39, 32 ], 32 => [ 52, 45, 39 ], 39 => [ 52, 45 ], 45 => [ 52 ], 47 => [ 53 ], 69 => [ 64 ], 71 => [ 65 ] },
	{  1 => [ 53, 46, 40, 33, 27, 20, 14,  7 ],  7 => [ 53, 46, 40, 33, 27, 20, 14 ], 14 => [ 53, 46, 40, 33, 27, 20 ], 20 => [ 53, 46, 40, 33, 27 ], 27 => [ 53, 46, 40, 33 ], 33 => [ 53, 46, 40 ], 40 => [ 53, 46 ], 46 => [ 53 ], 70 => [ 65 ] },
	{  5 => [ 54, 49, 43, 38, 32, 27, 21, 16, 10 ], 10 => [ 54, 49, 43, 38, 32, 27, 21, 16 ], 16 => [ 54, 49, 43, 38, 32, 27, 21 ], 21 => [ 54, 49, 43, 38, 32, 27 ], 27 => [ 54, 49, 43, 38, 32 ], 32 => [ 54, 49, 43, 38 ], 38 => [ 54, 49, 43 ], 43 => [ 54, 49 ], 49 => [ 54 ] },
	{ 11 => [ 55, 50, 44, 39, 33, 28, 22, 17 ], 17 => [ 55, 50, 44, 39, 33, 28, 22 ], 22 => [ 55, 50, 44, 39, 33, 28 ], 28 => [ 55, 50, 44, 39, 33 ], 33 => [ 55, 50, 44, 39 ], 39 => [ 55, 50, 44 ], 44 => [ 55, 50 ], 48 => [ 54 ], 50 => [ 55 ] },
	{ 23 => [ 56, 51, 45, 40, 34, 29 ], 29 => [ 56, 51, 45, 40, 34 ], 34 => [ 56, 51, 45, 40 ], 36 => [ 55, 49, 42 ], 40 => [ 56, 51, 45 ], 42 => [ 55, 49 ], 45 => [ 56, 51 ], 49 => [ 55 ], 51 => [ 56 ] },
	{ 24 => [ 56, 50, 43, 37, 30 ], 30 => [ 56, 50, 43, 37 ], 35 => [ 57, 52, 46, 41 ], 37 => [ 56, 50, 43 ], 41 => [ 57, 52, 46 ], 43 => [ 56, 50 ], 46 => [ 57, 52 ], 50 => [ 56 ], 52 => [ 57 ] },
	{ 12 => [ 57, 51, 44, 38, 31, 25, 18 ], 18 => [ 57, 51, 44, 38, 31, 25 ], 25 => [ 57, 51, 44, 38, 31 ], 31 => [ 57, 51, 44, 38 ], 38 => [ 57, 51, 44 ], 44 => [ 57, 51 ], 47 => [ 58, 53 ], 51 => [ 57 ], 53 => [ 58 ] },
	{  0 => [ 58, 52, 45, 39, 32, 26, 19, 13,  6 ],  6 => [ 58, 52, 45, 39, 32, 26, 19, 13 ], 13 => [ 58, 52, 45, 39, 32, 26, 19 ], 19 => [ 58, 52, 45, 39, 32, 26 ], 26 => [ 58, 52, 45, 39, 32 ], 32 => [ 58, 52, 45, 39 ], 39 => [ 58, 52, 45 ], 45 => [ 58, 52 ], 52 => [ 58 ] },
	{ 11 => [ 61, 55, 50, 44, 39, 33, 28, 22, 17 ], 17 => [ 61, 55, 50, 44, 39, 33, 28, 22 ], 22 => [ 61, 55, 50, 44, 39, 33, 28 ], 28 => [ 61, 55, 50, 44, 39, 33 ], 33 => [ 61, 55, 50, 44, 39 ], 39 => [ 61, 55, 50, 44 ], 44 => [ 61, 55, 50 ], 50 => [ 61, 55 ], 55 => [ 61 ] },
	{ 23 => [ 62, 56, 51, 45, 40, 34, 29 ], 29 => [ 62, 56, 51, 45, 40, 34 ], 34 => [ 62, 56, 51, 45, 40 ], 40 => [ 62, 56, 51, 45 ], 45 => [ 62, 56, 51 ], 48 => [ 61, 54 ], 51 => [ 62, 56 ], 54 => [ 61 ], 56 => [ 62 ] },
	{ 35 => [ 63, 57, 52, 46, 41 ], 36 => [ 62, 55, 49, 42 ], 41 => [ 63, 57, 52, 46 ], 42 => [ 62, 55, 49 ], 46 => [ 63, 57, 52 ], 49 => [ 62, 55 ], 52 => [ 63, 57 ], 55 => [ 62 ], 57 => [ 63 ] },
	{ 24 => [ 63, 56, 50, 43, 37, 30 ], 30 => [ 63, 56, 50, 43, 37 ], 37 => [ 63, 56, 50, 43 ], 43 => [ 63, 56, 50 ], 47 => [ 64, 58, 53 ], 50 => [ 63, 56 ], 53 => [ 64, 58 ], 56 => [ 63 ], 58 => [ 64 ] },
	{ 12 => [ 64, 57, 51, 44, 38, 31, 25, 18 ], 18 => [ 64, 57, 51, 44, 38, 31, 25 ], 25 => [ 64, 57, 51, 44, 38, 31 ], 31 => [ 64, 57, 51, 44, 38 ], 38 => [ 64, 57, 51, 44 ], 44 => [ 64, 57, 51 ], 51 => [ 64, 57 ], 57 => [ 64 ], 59 => [ 65 ] },
	{  0 => [ 65, 58, 52, 45, 39, 32, 26, 19, 13,  6 ],  6 => [ 65, 58, 52, 45, 39, 32, 26, 19, 13 ], 13 => [ 65, 58, 52, 45, 39, 32, 26, 19 ], 19 => [ 65, 58, 52, 45, 39, 32, 26 ], 26 => [ 65, 58, 52, 45, 39, 32 ], 32 => [ 65, 58, 52, 45, 39 ], 39 => [ 65, 58, 52, 45 ], 45 => [ 65, 58, 52 ], 52 => [ 65, 58 ], 58 => [ 65 ] },
];

use constant enclosed_8dirs_locs => [
	{  2 => [  1 ],  3 => [  1,  2 ],  4 => [  1,  2,  3 ],  5 => [  1,  2,  3,  4 ], 13 => [  6 ], 19 => [  6, 13 ], 24 => [ 12 ], 26 => [  6, 13, 19 ], 32 => [  6, 13, 19, 26 ], 36 => [ 12, 24 ], 39 => [  6, 13, 19, 26, 32 ], 45 => [  6, 13, 19, 26, 32, 39 ], 48 => [ 12, 24, 36 ], 52 => [  6, 13, 19, 26, 32, 39, 45 ], 58 => [  6, 13, 19, 26, 32, 39, 45, 52 ], 60 => [ 12, 24, 36, 48 ], 65 => [  6, 13, 19, 26, 32, 39, 45, 52, 58 ], 71 => [  6, 13, 19, 26, 32, 39, 45, 52, 58, 65 ] },
	{  3 => [  2 ],  4 => [  2,  3 ],  5 => [  2,  3,  4 ], 12 => [  6 ], 14 => [  7 ], 20 => [  7, 14 ], 25 => [ 13 ], 27 => [  7, 14, 20 ], 33 => [  7, 14, 20, 27 ], 37 => [ 13, 25 ], 40 => [  7, 14, 20, 27, 33 ], 46 => [  7, 14, 20, 27, 33, 40 ], 49 => [ 13, 25, 37 ], 53 => [  7, 14, 20, 27, 33, 40, 46 ], 59 => [  7, 14, 20, 27, 33, 40, 46, 53 ], 61 => [ 13, 25, 37, 49 ] },
	{  0 => [  1 ],  4 => [  3 ],  5 => [  3,  4 ], 13 => [  7 ], 15 => [  8 ], 18 => [  7, 13 ], 21 => [  8, 15 ], 24 => [  7, 13, 18 ], 26 => [ 14 ], 28 => [  8, 15, 21 ], 34 => [  8, 15, 21, 28 ], 38 => [ 14, 26 ], 41 => [  8, 15, 21, 28, 34 ], 47 => [  8, 15, 21, 28, 34, 41 ], 50 => [ 14, 26, 38 ], 62 => [ 14, 26, 38, 50 ] },
	{  0 => [  2,  1 ],  1 => [  2 ],  5 => [  4 ], 14 => [  8 ], 16 => [  9 ], 19 => [  8, 14 ], 22 => [  9, 16 ], 25 => [  8, 14, 19 ], 27 => [ 15 ], 29 => [  9, 16, 22 ], 30 => [  8, 14, 19, 25 ], 35 => [  9, 16, 22, 29 ], 36 => [  8, 14, 19, 25, 30 ], 39 => [ 15, 27 ], 51 => [ 15, 27, 39 ], 63 => [ 15, 27, 39, 51 ] },
	{  0 => [  3,  2,  1 ],  1 => [  3,  2 ],  2 => [  3 ], 15 => [  9 ], 17 => [ 10 ], 20 => [  9, 15 ], 23 => [ 10, 17 ], 26 => [  9, 15, 20 ], 28 => [ 16 ], 31 => [  9, 15, 20, 26 ], 37 => [  9, 15, 20, 26, 31 ], 40 => [ 16, 28 ], 42 => [  9, 15, 20, 26, 31, 37 ], 48 => [  9, 15, 20, 26, 31, 37, 42 ], 52 => [ 16, 28, 40 ], 64 => [ 16, 28, 40, 52 ] },
	{  0 => [  4,  3,  2,  1 ],  1 => [  4,  3,  2 ],  2 => [  4,  3 ],  3 => [  4 ], 16 => [ 10 ], 21 => [ 10, 16 ], 27 => [ 10, 16, 21 ], 29 => [ 17 ], 32 => [ 10, 16, 21, 27 ], 38 => [ 10, 16, 21, 27, 32 ], 41 => [ 17, 29 ], 43 => [ 10, 16, 21, 27, 32, 38 ], 49 => [ 10, 16, 21, 27, 32, 38, 43 ], 53 => [ 17, 29, 41 ], 54 => [ 10, 16, 21, 27, 32, 38, 43, 49 ], 60 => [ 10, 16, 21, 27, 32, 38, 43, 49, 54 ], 65 => [ 17, 29, 41, 53 ] },
	{  8 => [  7 ],  9 => [  7,  8 ], 10 => [  7,  8,  9 ], 11 => [  7,  8,  9, 10 ], 19 => [ 13 ], 26 => [ 13, 19 ], 30 => [ 18 ], 32 => [ 13, 19, 26 ], 39 => [ 13, 19, 26, 32 ], 42 => [ 18, 30 ], 45 => [ 13, 19, 26, 32, 39 ], 52 => [ 13, 19, 26, 32, 39, 45 ], 54 => [ 18, 30, 42 ], 58 => [ 13, 19, 26, 32, 39, 45, 52 ], 65 => [ 13, 19, 26, 32, 39, 45, 52, 58 ], 66 => [ 18, 30, 42, 54 ], 71 => [ 13, 19, 26, 32, 39, 45, 52, 58, 65 ] },
	{  9 => [  8 ], 10 => [  8,  9 ], 11 => [  8,  9, 10 ], 18 => [ 13 ], 20 => [ 14 ], 24 => [ 13, 18 ], 27 => [ 14, 20 ], 31 => [ 19 ], 33 => [ 14, 20, 27 ], 40 => [ 14, 20, 27, 33 ], 43 => [ 19, 31 ], 46 => [ 14, 20, 27, 33, 40 ], 53 => [ 14, 20, 27, 33, 40, 46 ], 55 => [ 19, 31, 43 ], 59 => [ 14, 20, 27, 33, 40, 46, 53 ], 67 => [ 19, 31, 43, 55 ] },
	{  6 => [  7 ], 10 => [  9 ], 11 => [  9, 10 ], 19 => [ 14 ], 21 => [ 15 ], 25 => [ 14, 19 ], 28 => [ 15, 21 ], 30 => [ 14, 19, 25 ], 32 => [ 20 ], 34 => [ 15, 21, 28 ], 36 => [ 14, 19, 25, 30 ], 41 => [ 15, 21, 28, 34 ], 44 => [ 20, 32 ], 47 => [ 15, 21, 28, 34, 41 ], 56 => [ 20, 32, 44 ], 68 => [ 20, 32, 44, 56 ] },
	{  6 => [  8,  7 ],  7 => [  8 ], 11 => [ 10 ], 20 => [ 15 ], 22 => [ 16 ], 26 => [ 15, 20 ], 29 => [ 16, 22 ], 31 => [ 15, 20, 26 ], 33 => [ 21 ], 35 => [ 16, 22, 29 ], 37 => [ 15, 20, 26, 31 ], 42 => [ 15, 20, 26, 31, 37 ], 45 => [ 21, 33 ], 48 => [ 15, 20, 26, 31, 37, 42 ], 57 => [ 21, 33, 45 ], 69 => [ 21, 33, 45, 57 ] },
	{  6 => [  9,  8,  7 ],  7 => [  9,  8 ],  8 => [  9 ], 21 => [ 16 ], 23 => [ 17 ], 27 => [ 16, 21 ], 32 => [ 16, 21, 27 ], 34 => [ 22 ], 38 => [ 16, 21, 27, 32 ], 43 => [ 16, 21, 27, 32, 38 ], 46 => [ 22, 34 ], 49 => [ 16, 21, 27, 32, 38, 43 ], 54 => [ 16, 21, 27, 32, 38, 43, 49 ], 58 => [ 22, 34, 46 ], 60 => [ 16, 21, 27, 32, 38, 43, 49, 54 ], 70 => [ 22, 34, 46, 58 ] },
	{  6 => [ 10,  9,  8,  7 ],  7 => [ 10,  9,  8 ],  8 => [ 10,  9 ],  9 => [ 10 ], 22 => [ 17 ], 28 => [ 17, 22 ], 33 => [ 17, 22, 28 ], 35 => [ 23 ], 39 => [ 17, 22, 28, 33 ], 44 => [ 17, 22, 28, 33, 39 ], 47 => [ 23, 35 ], 50 => [ 17, 22, 28, 33, 39, 44 ], 55 => [ 17, 22, 28, 33, 39, 44, 50 ], 59 => [ 23, 35, 47 ], 61 => [ 17, 22, 28, 33, 39, 44, 50, 55 ], 66 => [ 17, 22, 28, 33, 39, 44, 50, 55, 61 ], 71 => [ 23, 35, 47, 59 ] },
	{  1 => [  6 ], 14 => [ 13 ], 15 => [ 13, 14 ], 16 => [ 13, 14, 15 ], 17 => [ 13, 14, 15, 16 ], 25 => [ 18 ], 31 => [ 18, 25 ], 36 => [ 24 ], 38 => [ 18, 25, 31 ], 44 => [ 18, 25, 31, 38 ], 48 => [ 24, 36 ], 51 => [ 18, 25, 31, 38, 44 ], 57 => [ 18, 25, 31, 38, 44, 51 ], 60 => [ 24, 36, 48 ], 64 => [ 18, 25, 31, 38, 44, 51, 57 ], 70 => [ 18, 25, 31, 38, 44, 51, 57, 64 ] },
	{  0 => [  6 ],  2 => [  7 ], 15 => [ 14 ], 16 => [ 14, 15 ], 17 => [ 14, 15, 16 ], 24 => [ 18 ], 26 => [ 19 ], 32 => [ 19, 26 ], 37 => [ 25 ], 39 => [ 19, 26, 32 ], 45 => [ 19, 26, 32, 39 ], 49 => [ 25, 37 ], 52 => [ 19, 26, 32, 39, 45 ], 58 => [ 19, 26, 32, 39, 45, 52 ], 61 => [ 25, 37, 49 ], 65 => [ 19, 26, 32, 39, 45, 52, 58 ], 71 => [ 19, 26, 32, 39, 45, 52, 58, 65 ] },
	{  1 => [  7 ],  3 => [  8 ], 12 => [ 13 ], 16 => [ 15 ], 17 => [ 15, 16 ], 25 => [ 19 ], 27 => [ 20 ], 30 => [ 19, 25 ], 33 => [ 20, 27 ], 36 => [ 19, 25, 30 ], 38 => [ 26 ], 40 => [ 20, 27, 33 ], 46 => [ 20, 27, 33, 40 ], 50 => [ 26, 38 ], 53 => [ 20, 27, 33, 40, 46 ], 59 => [ 20, 27, 33, 40, 46, 53 ], 62 => [ 26, 38, 50 ] },
	{  2 => [  8 ],  4 => [  9 ], 12 => [ 14, 13 ], 13 => [ 14 ], 17 => [ 16 ], 26 => [ 20 ], 28 => [ 21 ], 31 => [ 20, 26 ], 34 => [ 21, 28 ], 37 => [ 20, 26, 31 ], 39 => [ 27 ], 41 => [ 21, 28, 34 ], 42 => [ 20, 26, 31, 37 ], 47 => [ 21, 28, 34, 41 ], 48 => [ 20, 26, 31, 37, 42 ], 51 => [ 27, 39 ], 63 => [ 27, 39, 51 ] },
	{  3 => [  9 ],  5 => [ 10 ], 12 => [ 15, 14, 13 ], 13 => [ 15, 14 ], 14 => [ 15 ], 27 => [ 21 ], 29 => [ 22 ], 32 => [ 21, 27 ], 35 => [ 22, 29 ], 38 => [ 21, 27, 32 ], 40 => [ 28 ], 43 => [ 21, 27, 32, 38 ], 49 => [ 21, 27, 32, 38, 43 ], 52 => [ 28, 40 ], 54 => [ 21, 27, 32, 38, 43, 49 ], 60 => [ 21, 27, 32, 38, 43, 49, 54 ], 64 => [ 28, 40, 52 ] },
	{  4 => [ 10 ], 12 => [ 16, 15, 14, 13 ], 13 => [ 16, 15, 14 ], 14 => [ 16, 15 ], 15 => [ 16 ], 28 => [ 22 ], 33 => [ 22, 28 ], 39 => [ 22, 28, 33 ], 41 => [ 29 ], 44 => [ 22, 28, 33, 39 ], 50 => [ 22, 28, 33, 39, 44 ], 53 => [ 29, 41 ], 55 => [ 22, 28, 33, 39, 44, 50 ], 61 => [ 22, 28, 33, 39, 44, 50, 55 ], 65 => [ 29, 41, 53 ], 66 => [ 22, 28, 33, 39, 44, 50, 55, 61 ] },
	{  2 => [ 13,  7 ],  7 => [ 13 ], 20 => [ 19 ], 21 => [ 19, 20 ], 22 => [ 19, 20, 21 ], 23 => [ 19, 20, 21, 22 ], 31 => [ 25 ], 38 => [ 25, 31 ], 42 => [ 30 ], 44 => [ 25, 31, 38 ], 51 => [ 25, 31, 38, 44 ], 54 => [ 30, 42 ], 57 => [ 25, 31, 38, 44, 51 ], 64 => [ 25, 31, 38, 44, 51, 57 ], 66 => [ 30, 42, 54 ], 70 => [ 25, 31, 38, 44, 51, 57, 64 ] },
	{  0 => [ 13,  6 ],  3 => [ 14,  8 ],  6 => [ 13 ],  8 => [ 14 ], 21 => [ 20 ], 22 => [ 20, 21 ], 23 => [ 20, 21, 22 ], 30 => [ 25 ], 32 => [ 26 ], 36 => [ 25, 30 ], 39 => [ 26, 32 ], 43 => [ 31 ], 45 => [ 26, 32, 39 ], 52 => [ 26, 32, 39, 45 ], 55 => [ 31, 43 ], 58 => [ 26, 32, 39, 45, 52 ], 65 => [ 26, 32, 39, 45, 52, 58 ], 67 => [ 31, 43, 55 ], 71 => [ 26, 32, 39, 45, 52, 58, 65 ] },
	{  1 => [ 14,  7 ],  4 => [ 15,  9 ],  7 => [ 14 ],  9 => [ 15 ], 18 => [ 19 ], 22 => [ 21 ], 23 => [ 21, 22 ], 31 => [ 26 ], 33 => [ 27 ], 37 => [ 26, 31 ], 40 => [ 27, 33 ], 42 => [ 26, 31, 37 ], 44 => [ 32 ], 46 => [ 27, 33, 40 ], 48 => [ 26, 31, 37, 42 ], 53 => [ 27, 33, 40, 46 ], 56 => [ 32, 44 ], 59 => [ 27, 33, 40, 46, 53 ], 68 => [ 32, 44, 56 ] },
	{  2 => [ 15,  8 ],  5 => [ 16, 10 ],  8 => [ 15 ], 10 => [ 16 ], 18 => [ 20, 19 ], 19 => [ 20 ], 23 => [ 22 ], 32 => [ 27 ], 34 => [ 28 ], 38 => [ 27, 32 ], 41 => [ 28, 34 ], 43 => [ 27, 32, 38 ], 45 => [ 33 ], 47 => [ 28, 34, 41 ], 49 => [ 27, 32, 38, 43 ], 54 => [ 27, 32, 38, 43, 49 ], 57 => [ 33, 45 ], 60 => [ 27, 32, 38, 43, 49, 54 ], 69 => [ 33, 45, 57 ] },
	{  3 => [ 16,  9 ],  9 => [ 16 ], 11 => [ 17 ], 18 => [ 21, 20, 19 ], 19 => [ 21, 20 ], 20 => [ 21 ], 33 => [ 28 ], 35 => [ 29 ], 39 => [ 28, 33 ], 44 => [ 28, 33, 39 ], 46 => [ 34 ], 50 => [ 28, 33, 39, 44 ], 55 => [ 28, 33, 39, 44, 50 ], 58 => [ 34, 46 ], 61 => [ 28, 33, 39, 44, 50, 55 ], 66 => [ 28, 33, 39, 44, 50, 55, 61 ], 70 => [ 34, 46, 58 ] },
	{  4 => [ 17, 10 ], 10 => [ 17 ], 18 => [ 22, 21, 20, 19 ], 19 => [ 22, 21, 20 ], 20 => [ 22, 21 ], 21 => [ 22 ], 34 => [ 29 ], 40 => [ 29, 34 ], 45 => [ 29, 34, 40 ], 47 => [ 35 ], 51 => [ 29, 34, 40, 45 ], 56 => [ 29, 34, 40, 45, 51 ], 59 => [ 35, 47 ], 62 => [ 29, 34, 40, 45, 51, 56 ], 67 => [ 29, 34, 40, 45, 51, 56, 62 ], 71 => [ 35, 47, 59 ] },
	{  0 => [ 12 ],  2 => [ 18, 13,  7 ],  7 => [ 18, 13 ], 13 => [ 18 ], 26 => [ 25 ], 27 => [ 25, 26 ], 28 => [ 25, 26, 27 ], 29 => [ 25, 26, 27, 28 ], 37 => [ 30 ], 43 => [ 30, 37 ], 48 => [ 36 ], 50 => [ 30, 37, 43 ], 56 => [ 30, 37, 43, 50 ], 60 => [ 36, 48 ], 63 => [ 30, 37, 43, 50, 56 ], 69 => [ 30, 37, 43, 50, 56, 63 ] },
	{  1 => [ 13 ],  3 => [ 19, 14,  8 ],  8 => [ 19, 14 ], 12 => [ 18 ], 14 => [ 19 ], 27 => [ 26 ], 28 => [ 26, 27 ], 29 => [ 26, 27, 28 ], 36 => [ 30 ], 38 => [ 31 ], 44 => [ 31, 38 ], 49 => [ 37 ], 51 => [ 31, 38, 44 ], 57 => [ 31, 38, 44, 51 ], 61 => [ 37, 49 ], 64 => [ 31, 38, 44, 51, 57 ], 70 => [ 31, 38, 44, 51, 57, 64 ] },
	{  0 => [ 19, 13,  6 ],  2 => [ 14 ],  4 => [ 20, 15,  9 ],  6 => [ 19, 13 ],  9 => [ 20, 15 ], 13 => [ 19 ], 15 => [ 20 ], 24 => [ 25 ], 28 => [ 27 ], 29 => [ 27, 28 ], 37 => [ 31 ], 39 => [ 32 ], 42 => [ 31, 37 ], 45 => [ 32, 39 ], 48 => [ 31, 37, 42 ], 50 => [ 38 ], 52 => [ 32, 39, 45 ], 58 => [ 32, 39, 45, 52 ], 62 => [ 38, 50 ], 65 => [ 32, 39, 45, 52, 58 ], 71 => [ 32, 39, 45, 52, 58, 65 ] },
	{  1 => [ 20, 14,  7 ],  3 => [ 15 ],  5 => [ 21, 16, 10 ],  7 => [ 20, 14 ], 10 => [ 21, 16 ], 14 => [ 20 ], 16 => [ 21 ], 24 => [ 26, 25 ], 25 => [ 26 ], 29 => [ 28 ], 38 => [ 32 ], 40 => [ 33 ], 43 => [ 32, 38 ], 46 => [ 33, 40 ], 49 => [ 32, 38, 43 ], 51 => [ 39 ], 53 => [ 33, 40, 46 ], 54 => [ 32, 38, 43, 49 ], 59 => [ 33, 40, 46, 53 ], 60 => [ 32, 38, 43, 49, 54 ], 63 => [ 39, 51 ] },
	{  2 => [ 21, 15,  8 ],  4 => [ 16 ],  8 => [ 21, 15 ], 11 => [ 22, 17 ], 15 => [ 21 ], 17 => [ 22 ], 24 => [ 27, 26, 25 ], 25 => [ 27, 26 ], 26 => [ 27 ], 39 => [ 33 ], 41 => [ 34 ], 44 => [ 33, 39 ], 47 => [ 34, 41 ], 50 => [ 33, 39, 44 ], 52 => [ 40 ], 55 => [ 33, 39, 44, 50 ], 61 => [ 33, 39, 44, 50, 55 ], 64 => [ 40, 52 ], 66 => [ 33, 39, 44, 50, 55, 61 ] },
	{  3 => [ 22, 16,  9 ],  5 => [ 17 ],  9 => [ 22, 16 ], 16 => [ 22 ], 24 => [ 28, 27, 26, 25 ], 25 => [ 28, 27, 26 ], 26 => [ 28, 27 ], 27 => [ 28 ], 40 => [ 34 ], 45 => [ 34, 40 ], 51 => [ 34, 40, 45 ], 53 => [ 41 ], 56 => [ 34, 40, 45, 51 ], 62 => [ 34, 40, 45, 51, 56 ], 65 => [ 41, 53 ], 67 => [ 34, 40, 45, 51, 56, 62 ] },
	{  3 => [ 25, 19, 14,  8 ],  6 => [ 18 ],  8 => [ 25, 19, 14 ], 14 => [ 25, 19 ], 19 => [ 25 ], 32 => [ 31 ], 33 => [ 31, 32 ], 34 => [ 31, 32, 33 ], 35 => [ 31, 32, 33, 34 ], 43 => [ 37 ], 50 => [ 37, 43 ], 54 => [ 42 ], 56 => [ 37, 43, 50 ], 63 => [ 37, 43, 50, 56 ], 66 => [ 42, 54 ], 69 => [ 37, 43, 50, 56, 63 ] },
	{  4 => [ 26, 20, 15,  9 ],  7 => [ 19 ],  9 => [ 26, 20, 15 ], 12 => [ 25, 18 ], 15 => [ 26, 20 ], 18 => [ 25 ], 20 => [ 26 ], 33 => [ 32 ], 34 => [ 32, 33 ], 35 => [ 32, 33, 34 ], 42 => [ 37 ], 44 => [ 38 ], 48 => [ 37, 42 ], 51 => [ 38, 44 ], 55 => [ 43 ], 57 => [ 38, 44, 51 ], 64 => [ 38, 44, 51, 57 ], 67 => [ 43, 55 ], 70 => [ 38, 44, 51, 57, 64 ] },
	{  0 => [ 26, 19, 13,  6 ],  5 => [ 27, 21, 16, 10 ],  6 => [ 26, 19, 13 ],  8 => [ 20 ], 10 => [ 27, 21, 16 ], 13 => [ 26, 19 ], 16 => [ 27, 21 ], 19 => [ 26 ], 21 => [ 27 ], 30 => [ 31 ], 34 => [ 33 ], 35 => [ 33, 34 ], 43 => [ 38 ], 45 => [ 39 ], 49 => [ 38, 43 ], 52 => [ 39, 45 ], 54 => [ 38, 43, 49 ], 56 => [ 44 ], 58 => [ 39, 45, 52 ], 60 => [ 38, 43, 49, 54 ], 65 => [ 39, 45, 52, 58 ], 68 => [ 44, 56 ], 71 => [ 39, 45, 52, 58, 65 ] },
	{  1 => [ 27, 20, 14,  7 ],  7 => [ 27, 20, 14 ],  9 => [ 21 ], 11 => [ 28, 22, 17 ], 14 => [ 27, 20 ], 17 => [ 28, 22 ], 20 => [ 27 ], 22 => [ 28 ], 30 => [ 32, 31 ], 31 => [ 32 ], 35 => [ 34 ], 44 => [ 39 ], 46 => [ 40 ], 50 => [ 39, 44 ], 53 => [ 40, 46 ], 55 => [ 39, 44, 50 ], 57 => [ 45 ], 59 => [ 40, 46, 53 ], 61 => [ 39, 44, 50, 55 ], 66 => [ 39, 44, 50, 55, 61 ], 69 => [ 45, 57 ] },
	{  2 => [ 28, 21, 15,  8 ],  8 => [ 28, 21, 15 ], 10 => [ 22 ], 15 => [ 28, 21 ], 21 => [ 28 ], 23 => [ 29 ], 30 => [ 33, 32, 31 ], 31 => [ 33, 32 ], 32 => [ 33 ], 45 => [ 40 ], 47 => [ 41 ], 51 => [ 40, 45 ], 56 => [ 40, 45, 51 ], 58 => [ 46 ], 62 => [ 40, 45, 51, 56 ], 67 => [ 40, 45, 51, 56, 62 ], 70 => [ 46, 58 ] },
	{  3 => [ 29, 22, 16,  9 ],  9 => [ 29, 22, 16 ], 11 => [ 23 ], 16 => [ 29, 22 ], 22 => [ 29 ], 30 => [ 34, 33, 32, 31 ], 31 => [ 34, 33, 32 ], 32 => [ 34, 33 ], 33 => [ 34 ], 46 => [ 41 ], 52 => [ 41, 46 ], 57 => [ 41, 46, 52 ], 59 => [ 47 ], 63 => [ 41, 46, 52, 57 ], 68 => [ 41, 46, 52, 57, 63 ], 71 => [ 47, 59 ] },
	{  0 => [ 24, 12 ],  3 => [ 30, 25, 19, 14,  8 ],  8 => [ 30, 25, 19, 14 ], 12 => [ 24 ], 14 => [ 30, 25, 19 ], 19 => [ 30, 25 ], 25 => [ 30 ], 38 => [ 37 ], 39 => [ 37, 38 ], 40 => [ 37, 38, 39 ], 41 => [ 37, 38, 39, 40 ], 49 => [ 42 ], 55 => [ 42, 49 ], 60 => [ 48 ], 62 => [ 42, 49, 55 ], 68 => [ 42, 49, 55, 62 ] },
	{  1 => [ 25, 13 ],  4 => [ 31, 26, 20, 15,  9 ],  9 => [ 31, 26, 20, 15 ], 13 => [ 25 ], 15 => [ 31, 26, 20 ], 20 => [ 31, 26 ], 24 => [ 30 ], 26 => [ 31 ], 39 => [ 38 ], 40 => [ 38, 39 ], 41 => [ 38, 39, 40 ], 48 => [ 42 ], 50 => [ 43 ], 56 => [ 43, 50 ], 61 => [ 49 ], 63 => [ 43, 50, 56 ], 69 => [ 43, 50, 56, 63 ] },
	{  2 => [ 26, 14 ],  5 => [ 32, 27, 21, 16, 10 ], 10 => [ 32, 27, 21, 16 ], 12 => [ 31, 25, 18 ], 14 => [ 26 ], 16 => [ 32, 27, 21 ], 18 => [ 31, 25 ], 21 => [ 32, 27 ], 25 => [ 31 ], 27 => [ 32 ], 36 => [ 37 ], 40 => [ 39 ], 41 => [ 39, 40 ], 49 => [ 43 ], 51 => [ 44 ], 54 => [ 43, 49 ], 57 => [ 44, 51 ], 60 => [ 43, 49, 54 ], 62 => [ 50 ], 64 => [ 44, 51, 57 ], 70 => [ 44, 51, 57, 64 ] },
	{  0 => [ 32, 26, 19, 13,  6 ],  3 => [ 27, 15 ],  6 => [ 32, 26, 19, 13 ], 11 => [ 33, 28, 22, 17 ], 13 => [ 32, 26, 19 ], 15 => [ 27 ], 17 => [ 33, 28, 22 ], 19 => [ 32, 26 ], 22 => [ 33, 28 ], 26 => [ 32 ], 28 => [ 33 ], 36 => [ 38, 37 ], 37 => [ 38 ], 41 => [ 40 ], 50 => [ 44 ], 52 => [ 45 ], 55 => [ 44, 50 ], 58 => [ 45, 52 ], 61 => [ 44, 50, 55 ], 63 => [ 51 ], 65 => [ 45, 52, 58 ], 66 => [ 44, 50, 55, 61 ], 71 => [ 45, 52, 58, 65 ] },
	{  1 => [ 33, 27, 20, 14,  7 ],  4 => [ 28, 16 ],  7 => [ 33, 27, 20, 14 ], 14 => [ 33, 27, 20 ], 16 => [ 28 ], 20 => [ 33, 27 ], 23 => [ 34, 29 ], 27 => [ 33 ], 29 => [ 34 ], 36 => [ 39, 38, 37 ], 37 => [ 39, 38 ], 38 => [ 39 ], 51 => [ 45 ], 53 => [ 46 ], 56 => [ 45, 51 ], 59 => [ 46, 53 ], 62 => [ 45, 51, 56 ], 64 => [ 52 ], 67 => [ 45, 51, 56, 62 ] },
	{  2 => [ 34, 28, 21, 15,  8 ],  5 => [ 29, 17 ],  8 => [ 34, 28, 21, 15 ], 15 => [ 34, 28, 21 ], 17 => [ 29 ], 21 => [ 34, 28 ], 28 => [ 34 ], 36 => [ 40, 39, 38, 37 ], 37 => [ 40, 39, 38 ], 38 => [ 40, 39 ], 39 => [ 40 ], 52 => [ 46 ], 57 => [ 46, 52 ], 63 => [ 46, 52, 57 ], 65 => [ 53 ], 68 => [ 46, 52, 57, 63 ] },
	{  4 => [ 37, 31, 26, 20, 15,  9 ],  6 => [ 30, 18 ],  9 => [ 37, 31, 26, 20, 15 ], 15 => [ 37, 31, 26, 20 ], 18 => [ 30 ], 20 => [ 37, 31, 26 ], 26 => [ 37, 31 ], 31 => [ 37 ], 44 => [ 43 ], 45 => [ 43, 44 ], 46 => [ 43, 44, 45 ], 47 => [ 43, 44, 45, 46 ], 55 => [ 49 ], 62 => [ 49, 55 ], 66 => [ 54 ], 68 => [ 49, 55, 62 ] },
	{  5 => [ 38, 32, 27, 21, 16, 10 ],  7 => [ 31, 19 ], 10 => [ 38, 32, 27, 21, 16 ], 16 => [ 38, 32, 27, 21 ], 19 => [ 31 ], 21 => [ 38, 32, 27 ], 24 => [ 37, 30 ], 27 => [ 38, 32 ], 30 => [ 37 ], 32 => [ 38 ], 45 => [ 44 ], 46 => [ 44, 45 ], 47 => [ 44, 45, 46 ], 54 => [ 49 ], 56 => [ 50 ], 60 => [ 49, 54 ], 63 => [ 50, 56 ], 67 => [ 55 ], 69 => [ 50, 56, 63 ] },
	{  8 => [ 32, 20 ], 11 => [ 39, 33, 28, 22, 17 ], 12 => [ 38, 31, 25, 18 ], 17 => [ 39, 33, 28, 22 ], 18 => [ 38, 31, 25 ], 20 => [ 32 ], 22 => [ 39, 33, 28 ], 25 => [ 38, 31 ], 28 => [ 39, 33 ], 31 => [ 38 ], 33 => [ 39 ], 42 => [ 43 ], 46 => [ 45 ], 47 => [ 45, 46 ], 55 => [ 50 ], 57 => [ 51 ], 61 => [ 50, 55 ], 64 => [ 51, 57 ], 66 => [ 50, 55, 61 ], 68 => [ 56 ], 70 => [ 51, 57, 64 ] },
	{  0 => [ 39, 32, 26, 19, 13,  6 ],  6 => [ 39, 32, 26, 19, 13 ],  9 => [ 33, 21 ], 13 => [ 39, 32, 26, 19 ], 19 => [ 39, 32, 26 ], 21 => [ 33 ], 23 => [ 40, 34, 29 ], 26 => [ 39, 32 ], 29 => [ 40, 34 ], 32 => [ 39 ], 34 => [ 40 ], 42 => [ 44, 43 ], 43 => [ 44 ], 47 => [ 46 ], 56 => [ 51 ], 58 => [ 52 ], 62 => [ 51, 56 ], 65 => [ 52, 58 ], 67 => [ 51, 56, 62 ], 69 => [ 57 ], 71 => [ 52, 58, 65 ] },
	{  1 => [ 40, 33, 27, 20, 14,  7 ],  7 => [ 40, 33, 27, 20, 14 ], 10 => [ 34, 22 ], 14 => [ 40, 33, 27, 20 ], 20 => [ 40, 33, 27 ], 22 => [ 34 ], 27 => [ 40, 33 ], 33 => [ 40 ], 35 => [ 41 ], 42 => [ 45, 44, 43 ], 43 => [ 45, 44 ], 44 => [ 45 ], 57 => [ 52 ], 59 => [ 53 ], 63 => [ 52, 57 ], 68 => [ 52, 57, 63 ], 70 => [ 58 ] },
	{  2 => [ 41, 34, 28, 21, 15,  8 ],  8 => [ 41, 34, 28, 21, 15 ], 11 => [ 35, 23 ], 15 => [ 41, 34, 28, 21 ], 21 => [ 41, 34, 28 ], 23 => [ 35 ], 28 => [ 41, 34 ], 34 => [ 41 ], 42 => [ 46, 45, 44, 43 ], 43 => [ 46, 45, 44 ], 44 => [ 46, 45 ], 45 => [ 46 ], 58 => [ 53 ], 64 => [ 53, 58 ], 69 => [ 53, 58, 64 ], 71 => [ 59 ] },
	{  0 => [ 36, 24, 12 ],  4 => [ 42, 37, 31, 26, 20, 15,  9 ],  9 => [ 42, 37, 31, 26, 20, 15 ], 12 => [ 36, 24 ], 15 => [ 42, 37, 31, 26, 20 ], 20 => [ 42, 37, 31, 26 ], 24 => [ 36 ], 26 => [ 42, 37, 31 ], 31 => [ 42, 37 ], 37 => [ 42 ], 50 => [ 49 ], 51 => [ 49, 50 ], 52 => [ 49, 50, 51 ], 53 => [ 49, 50, 51, 52 ], 61 => [ 54 ], 67 => [ 54, 61 ] },
	{  1 => [ 37, 25, 13 ],  5 => [ 43, 38, 32, 27, 21, 16, 10 ], 10 => [ 43, 38, 32, 27, 21, 16 ], 13 => [ 37, 25 ], 16 => [ 43, 38, 32, 27, 21 ], 21 => [ 43, 38, 32, 27 ], 25 => [ 37 ], 27 => [ 43, 38, 32 ], 32 => [ 43, 38 ], 36 => [ 42 ], 38 => [ 43 ], 51 => [ 50 ], 52 => [ 50, 51 ], 53 => [ 50, 51, 52 ], 60 => [ 54 ], 62 => [ 55 ], 68 => [ 55, 62 ] },
	{  2 => [ 38, 26, 14 ], 11 => [ 44, 39, 33, 28, 22, 17 ], 14 => [ 38, 26 ], 17 => [ 44, 39, 33, 28, 22 ], 22 => [ 44, 39, 33, 28 ], 24 => [ 43, 37, 30 ], 26 => [ 38 ], 28 => [ 44, 39, 33 ], 30 => [ 43, 37 ], 33 => [ 44, 39 ], 37 => [ 43 ], 39 => [ 44 ], 48 => [ 49 ], 52 => [ 51 ], 53 => [ 51, 52 ], 61 => [ 55 ], 63 => [ 56 ], 66 => [ 55, 61 ], 69 => [ 56, 63 ] },
	{  3 => [ 39, 27, 15 ], 12 => [ 44, 38, 31, 25, 18 ], 15 => [ 39, 27 ], 18 => [ 44, 38, 31, 25 ], 23 => [ 45, 40, 34, 29 ], 25 => [ 44, 38, 31 ], 27 => [ 39 ], 29 => [ 45, 40, 34 ], 31 => [ 44, 38 ], 34 => [ 45, 40 ], 38 => [ 44 ], 40 => [ 45 ], 48 => [ 50, 49 ], 49 => [ 50 ], 53 => [ 52 ], 62 => [ 56 ], 64 => [ 57 ], 67 => [ 56, 62 ], 70 => [ 57, 64 ] },
	{  0 => [ 45, 39, 32, 26, 19, 13,  6 ],  4 => [ 40, 28, 16 ],  6 => [ 45, 39, 32, 26, 19, 13 ], 13 => [ 45, 39, 32, 26, 19 ], 16 => [ 40, 28 ], 19 => [ 45, 39, 32, 26 ], 26 => [ 45, 39, 32 ], 28 => [ 40 ], 32 => [ 45, 39 ], 35 => [ 46, 41 ], 39 => [ 45 ], 41 => [ 46 ], 48 => [ 51, 50, 49 ], 49 => [ 51, 50 ], 50 => [ 51 ], 63 => [ 57 ], 65 => [ 58 ], 68 => [ 57, 63 ], 71 => [ 58, 65 ] },
	{  1 => [ 46, 40, 33, 27, 20, 14,  7 ],  5 => [ 41, 29, 17 ],  7 => [ 46, 40, 33, 27, 20, 14 ], 14 => [ 46, 40, 33, 27, 20 ], 17 => [ 41, 29 ], 20 => [ 46, 40, 33, 27 ], 27 => [ 46, 40, 33 ], 29 => [ 41 ], 33 => [ 46, 40 ], 40 => [ 46 ], 48 => [ 52, 51, 50, 49 ], 49 => [ 52, 51, 50 ], 50 => [ 52, 51 ], 51 => [ 52 ], 64 => [ 58 ], 69 => [ 58, 64 ] },
	{  5 => [ 49, 43, 38, 32, 27, 21, 16, 10 ],  6 => [ 42, 30, 18 ], 10 => [ 49, 43, 38, 32, 27, 21, 16 ], 16 => [ 49, 43, 38, 32, 27, 21 ], 18 => [ 42, 30 ], 21 => [ 49, 43, 38, 32, 27 ], 27 => [ 49, 43, 38, 32 ], 30 => [ 42 ], 32 => [ 49, 43, 38 ], 38 => [ 49, 43 ], 43 => [ 49 ], 56 => [ 55 ], 57 => [ 55, 56 ], 58 => [ 55, 56, 57 ], 59 => [ 55, 56, 57, 58 ], 67 => [ 61 ] },
	{  7 => [ 43, 31, 19 ], 11 => [ 50, 44, 39, 33, 28, 22, 17 ], 17 => [ 50, 44, 39, 33, 28, 22 ], 19 => [ 43, 31 ], 22 => [ 50, 44, 39, 33, 28 ], 28 => [ 50, 44, 39, 33 ], 31 => [ 43 ], 33 => [ 50, 44, 39 ], 36 => [ 49, 42 ], 39 => [ 50, 44 ], 42 => [ 49 ], 44 => [ 50 ], 57 => [ 56 ], 58 => [ 56, 57 ], 59 => [ 56, 57, 58 ], 66 => [ 61 ], 68 => [ 62 ] },
	{  8 => [ 44, 32, 20 ], 20 => [ 44, 32 ], 23 => [ 51, 45, 40, 34, 29 ], 24 => [ 50, 43, 37, 30 ], 29 => [ 51, 45, 40, 34 ], 30 => [ 50, 43, 37 ], 32 => [ 44 ], 34 => [ 51, 45, 40 ], 37 => [ 50, 43 ], 40 => [ 51, 45 ], 43 => [ 50 ], 45 => [ 51 ], 54 => [ 55 ], 58 => [ 57 ], 59 => [ 57, 58 ], 67 => [ 62 ], 69 => [ 63 ] },
	{  9 => [ 45, 33, 21 ], 12 => [ 51, 44, 38, 31, 25, 18 ], 18 => [ 51, 44, 38, 31, 25 ], 21 => [ 45, 33 ], 25 => [ 51, 44, 38, 31 ], 31 => [ 51, 44, 38 ], 33 => [ 45 ], 35 => [ 52, 46, 41 ], 38 => [ 51, 44 ], 41 => [ 52, 46 ], 44 => [ 51 ], 46 => [ 52 ], 54 => [ 56, 55 ], 55 => [ 56 ], 59 => [ 58 ], 68 => [ 63 ], 70 => [ 64 ] },
	{  0 => [ 52, 45, 39, 32, 26, 19, 13,  6 ],  6 => [ 52, 45, 39, 32, 26, 19, 13 ], 10 => [ 46, 34, 22 ], 13 => [ 52, 45, 39, 32, 26, 19 ], 19 => [ 52, 45, 39, 32, 26 ], 22 => [ 46, 34 ], 26 => [ 52, 45, 39, 32 ], 32 => [ 52, 45, 39 ], 34 => [ 46 ], 39 => [ 52, 45 ], 45 => [ 52 ], 47 => [ 53 ], 54 => [ 57, 56, 55 ], 55 => [ 57, 56 ], 56 => [ 57 ], 69 => [ 64 ], 71 => [ 65 ] },
	{  1 => [ 53, 46, 40, 33, 27, 20, 14,  7 ],  7 => [ 53, 46, 40, 33, 27, 20, 14 ], 11 => [ 47, 35, 23 ], 14 => [ 53, 46, 40, 33, 27, 20 ], 20 => [ 53, 46, 40, 33, 27 ], 23 => [ 47, 35 ], 27 => [ 53, 46, 40, 33 ], 33 => [ 53, 46, 40 ], 35 => [ 47 ], 40 => [ 53, 46 ], 46 => [ 53 ], 54 => [ 58, 57, 56, 55 ], 55 => [ 58, 57, 56 ], 56 => [ 58, 57 ], 57 => [ 58 ], 70 => [ 65 ] },
	{  0 => [ 48, 36, 24, 12 ],  5 => [ 54, 49, 43, 38, 32, 27, 21, 16, 10 ], 10 => [ 54, 49, 43, 38, 32, 27, 21, 16 ], 12 => [ 48, 36, 24 ], 16 => [ 54, 49, 43, 38, 32, 27, 21 ], 21 => [ 54, 49, 43, 38, 32, 27 ], 24 => [ 48, 36 ], 27 => [ 54, 49, 43, 38, 32 ], 32 => [ 54, 49, 43, 38 ], 36 => [ 48 ], 38 => [ 54, 49, 43 ], 43 => [ 54, 49 ], 49 => [ 54 ], 62 => [ 61 ], 63 => [ 61, 62 ], 64 => [ 61, 62, 63 ], 65 => [ 61, 62, 63, 64 ] },
	{  1 => [ 49, 37, 25, 13 ], 11 => [ 55, 50, 44, 39, 33, 28, 22, 17 ], 13 => [ 49, 37, 25 ], 17 => [ 55, 50, 44, 39, 33, 28, 22 ], 22 => [ 55, 50, 44, 39, 33, 28 ], 25 => [ 49, 37 ], 28 => [ 55, 50, 44, 39, 33 ], 33 => [ 55, 50, 44, 39 ], 37 => [ 49 ], 39 => [ 55, 50, 44 ], 44 => [ 55, 50 ], 48 => [ 54 ], 50 => [ 55 ], 63 => [ 62 ], 64 => [ 62, 63 ], 65 => [ 62, 63, 64 ] },
	{  2 => [ 50, 38, 26, 14 ], 14 => [ 50, 38, 26 ], 23 => [ 56, 51, 45, 40, 34, 29 ], 26 => [ 50, 38 ], 29 => [ 56, 51, 45, 40, 34 ], 34 => [ 56, 51, 45, 40 ], 36 => [ 55, 49, 42 ], 38 => [ 50 ], 40 => [ 56, 51, 45 ], 42 => [ 55, 49 ], 45 => [ 56, 51 ], 49 => [ 55 ], 51 => [ 56 ], 60 => [ 61 ], 64 => [ 63 ], 65 => [ 63, 64 ] },
	{  3 => [ 51, 39, 27, 15 ], 15 => [ 51, 39, 27 ], 24 => [ 56, 50, 43, 37, 30 ], 27 => [ 51, 39 ], 30 => [ 56, 50, 43, 37 ], 35 => [ 57, 52, 46, 41 ], 37 => [ 56, 50, 43 ], 39 => [ 51 ], 41 => [ 57, 52, 46 ], 43 => [ 56, 50 ], 46 => [ 57, 52 ], 50 => [ 56 ], 52 => [ 57 ], 60 => [ 62, 61 ], 61 => [ 62 ], 65 => [ 64 ] },
	{  4 => [ 52, 40, 28, 16 ], 12 => [ 57, 51, 44, 38, 31, 25, 18 ], 16 => [ 52, 40, 28 ], 18 => [ 57, 51, 44, 38, 31, 25 ], 25 => [ 57, 51, 44, 38, 31 ], 28 => [ 52, 40 ], 31 => [ 57, 51, 44, 38 ], 38 => [ 57, 51, 44 ], 40 => [ 52 ], 44 => [ 57, 51 ], 47 => [ 58, 53 ], 51 => [ 57 ], 53 => [ 58 ], 60 => [ 63, 62, 61 ], 61 => [ 63, 62 ], 62 => [ 63 ] },
	{  0 => [ 58, 52, 45, 39, 32, 26, 19, 13,  6 ],  5 => [ 53, 41, 29, 17 ],  6 => [ 58, 52, 45, 39, 32, 26, 19, 13 ], 13 => [ 58, 52, 45, 39, 32, 26, 19 ], 17 => [ 53, 41, 29 ], 19 => [ 58, 52, 45, 39, 32, 26 ], 26 => [ 58, 52, 45, 39, 32 ], 29 => [ 53, 41 ], 32 => [ 58, 52, 45, 39 ], 39 => [ 58, 52, 45 ], 41 => [ 53 ], 45 => [ 58, 52 ], 52 => [ 58 ], 60 => [ 64, 63, 62, 61 ], 61 => [ 64, 63, 62 ], 62 => [ 64, 63 ], 63 => [ 64 ] },
	{  6 => [ 54, 42, 30, 18 ], 11 => [ 61, 55, 50, 44, 39, 33, 28, 22, 17 ], 17 => [ 61, 55, 50, 44, 39, 33, 28, 22 ], 18 => [ 54, 42, 30 ], 22 => [ 61, 55, 50, 44, 39, 33, 28 ], 28 => [ 61, 55, 50, 44, 39, 33 ], 30 => [ 54, 42 ], 33 => [ 61, 55, 50, 44, 39 ], 39 => [ 61, 55, 50, 44 ], 42 => [ 54 ], 44 => [ 61, 55, 50 ], 50 => [ 61, 55 ], 55 => [ 61 ], 68 => [ 67 ], 69 => [ 67, 68 ], 70 => [ 67, 68, 69 ], 71 => [ 67, 68, 69, 70 ] },
	{  7 => [ 55, 43, 31, 19 ], 19 => [ 55, 43, 31 ], 23 => [ 62, 56, 51, 45, 40, 34, 29 ], 29 => [ 62, 56, 51, 45, 40, 34 ], 31 => [ 55, 43 ], 34 => [ 62, 56, 51, 45, 40 ], 40 => [ 62, 56, 51, 45 ], 43 => [ 55 ], 45 => [ 62, 56, 51 ], 48 => [ 61, 54 ], 51 => [ 62, 56 ], 54 => [ 61 ], 56 => [ 62 ], 69 => [ 68 ], 70 => [ 68, 69 ], 71 => [ 68, 69, 70 ] },
	{  8 => [ 56, 44, 32, 20 ], 20 => [ 56, 44, 32 ], 32 => [ 56, 44 ], 35 => [ 63, 57, 52, 46, 41 ], 36 => [ 62, 55, 49, 42 ], 41 => [ 63, 57, 52, 46 ], 42 => [ 62, 55, 49 ], 44 => [ 56 ], 46 => [ 63, 57, 52 ], 49 => [ 62, 55 ], 52 => [ 63, 57 ], 55 => [ 62 ], 57 => [ 63 ], 66 => [ 67 ], 70 => [ 69 ], 71 => [ 69, 70 ] },
	{  9 => [ 57, 45, 33, 21 ], 21 => [ 57, 45, 33 ], 24 => [ 63, 56, 50, 43, 37, 30 ], 30 => [ 63, 56, 50, 43, 37 ], 33 => [ 57, 45 ], 37 => [ 63, 56, 50, 43 ], 43 => [ 63, 56, 50 ], 45 => [ 57 ], 47 => [ 64, 58, 53 ], 50 => [ 63, 56 ], 53 => [ 64, 58 ], 56 => [ 63 ], 58 => [ 64 ], 66 => [ 68, 67 ], 67 => [ 68 ], 71 => [ 70 ] },
	{ 10 => [ 58, 46, 34, 22 ], 12 => [ 64, 57, 51, 44, 38, 31, 25, 18 ], 18 => [ 64, 57, 51, 44, 38, 31, 25 ], 22 => [ 58, 46, 34 ], 25 => [ 64, 57, 51, 44, 38, 31 ], 31 => [ 64, 57, 51, 44, 38 ], 34 => [ 58, 46 ], 38 => [ 64, 57, 51, 44 ], 44 => [ 64, 57, 51 ], 46 => [ 58 ], 51 => [ 64, 57 ], 57 => [ 64 ], 59 => [ 65 ], 66 => [ 69, 68, 67 ], 67 => [ 69, 68 ], 68 => [ 69 ] },
	{  0 => [ 65, 58, 52, 45, 39, 32, 26, 19, 13,  6 ],  6 => [ 65, 58, 52, 45, 39, 32, 26, 19, 13 ], 11 => [ 59, 47, 35, 23 ], 13 => [ 65, 58, 52, 45, 39, 32, 26, 19 ], 19 => [ 65, 58, 52, 45, 39, 32, 26 ], 23 => [ 59, 47, 35 ], 26 => [ 65, 58, 52, 45, 39, 32 ], 32 => [ 65, 58, 52, 45, 39 ], 35 => [ 59, 47 ], 39 => [ 65, 58, 52, 45 ], 45 => [ 65, 58, 52 ], 47 => [ 59 ], 52 => [ 65, 58 ], 58 => [ 65 ], 66 => [ 70, 69, 68, 67 ], 67 => [ 70, 69, 68 ], 68 => [ 70, 69 ], 69 => [ 70 ] },
];

1;
