package WebService::Bonusly::Values;
$WebService::Bonusly::Values::VERSION = '0.151580';
use v5.14;
use Moose;
use Carp;
use JSON;
use URI::Escape;

has ws => (
    is          => 'ro',
    isa         => 'WebService::Bonusly',
    required    => 1,
    weak_ref    => 1,
    handles     => [ qw( token base_url ua ) ],
);


sub get {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter id is required for values->get"
        unless defined $params{id};
    
    $clean{id} = $params{id}
        if defined $params{id};
    
    my $path = $self->base_url . "values/:id";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub list {
    my ($self, %params) = @_;

    my %clean;
    
    my $path = $self->base_url . "values";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}


__PACKAGE__->meta->make_immutable;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Bonusly::Values

=head1 VERSION

version 0.151580

=for Pod::Coverage *EVERYTHING*

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
