# $Id: parse.t 4068 2008-09-20 18:41:28Z cfaerber $
#
use strict;
use warnings;

use Test::More tests => 30;
use DateTime 0.10;
use DateTime::Format::SQLite;

# 1.  YYYY-MM-DD
# 2. YYYY-MM-DD HH:MM
# 3. YYYY-MM-DD HH:MM:SS
# 4. YYYY-MM-DD HH:MM:SS.SSS
# 5. YYYY-MM-DDTHH:MM
# 6. YYYY-MM-DDTHH:MM:SS
# 7. YYYY-MM-DDTHH:MM:SS.SSS
# 8. HH:MM
# 9. HH:MM:SS
# 10. HH:MM:SS.SSS
# 11. now
# 12. DDDDDDDDDD 

my %tests = (
  # format 1
  #
  '2008-09-13'					=> '2008-09-13T00:00:00',
  '19999-09-13'					=> '19999-09-13T00:00:00',
  '-2-09-13',					=> '-0002-09-13T00:00:00',

  # format 2
  #
  '2008-09-13 13:00'				=> '2008-09-13T13:00:00',
  '19999-09-13 23:45'				=> '19999-09-13T23:45:00',
  '-2-09-13 2:3',				=> '-0002-09-13T02:03:00',

  # format 3
  #
  '2008-09-13 13:00:12'				=> '2008-09-13T13:00:12',
  '19999-09-13 23:45:6'				=> '19999-09-13T23:45:06',
  '-2-09-13 2:3:4',				=> '-0002-09-13T02:03:04',

  # format 4
  #
  '2008-09-13 13:00:12.123'			=> '2008-09-13T13:00:12',
  '19999-09-13 23:45:6.123'			=> '19999-09-13T23:45:06',
  '-2-09-13 2:3:4.123',				=> '-0002-09-13T02:03:04',

  # format 5
  #
  '2008-09-13T13:00'				=> '2008-09-13T13:00:00',
  '19999-09-13T23:45'				=> '19999-09-13T23:45:00',
  '-2-09-13t2:3',				=> '-0002-09-13T02:03:00',

  # format 6
  #
  '2008-09-13T13:00:12'				=> '2008-09-13T13:00:12',
  '19999-09-13T23:45:6'				=> '19999-09-13T23:45:06',
  '-2-09-13t2:3:4',				=> '-0002-09-13T02:03:04',

  # format 7
  #
  '2008-09-13T13:00:12.123'			=> '2008-09-13T13:00:12',
  '19999-09-13T23:45:6.123'			=> '19999-09-13T23:45:06',
  '-2-09-13t2:3:4.123',				=> '-0002-09-13T02:03:04',

  # format 8
  #
  '23:45'					=> '2000-01-01T23:45:00',
  '2:3',					=> '2000-01-01T02:03:00',

  # format 9
  #
  '23:45:6'					=> '2000-01-01T23:45:06',
  '2:3:4',					=> '2000-01-01T02:03:04',

  # format 10
  #
  '23:45:6.123'					=> '2000-01-01T23:45:06',
  '2:3:4.000',					=> '2000-01-01T02:03:04',

  # format 11
  # (tested separately)
  
  # format 12
  #
  0						=> '-4713-11-24T12:00:00',
  2454722.75					=> '2008-09-13T06:00:00',
);

foreach my $result (keys %tests) {
  is( DateTime::Format::SQLite->parse_datetime($result)->iso8601, $tests{$result} );
}

cmp_ok(DateTime::Format::SQLite->parse_datetime('now')
  ->subtract_datetime_absolute(DateTime->now)
    ->delta_seconds, '<', 5, 'now');
