######################################################################
#  capsid.pl
#
#  generate all coordinates for a viral capsid (1QGT)
#
######################################################################
use Modern::Perl;
use HackaMol;
use Math::Vector::Real;

my $pdbid = '1QGT';

my $mol = HackaMol->new()->pdbid_mol($pdbid);

my @symops = <DATA>;

my %sym_op = (); # a hash to store all symmetry operations
foreach my $line ( grep {m/BIOMT|SMTRY/} @symops ) {
    my @entries = split(' ', $line);
    push @{$sym_op{$entries[3]}}, V(@entries[4,5,6,7]);
}

# let's create a another molecule containing Hg atoms to map out a coarser represention of the capsid
my $hg_ball = HackaMol::Molecule->new(name => 'Hg Ball') ;

foreach my $symop (keys %sym_op){
    my @mat_d = @{$sym_op{$symop}};
    my $cx = V(map{$_->[0]} @mat_d); 
    my $cy = V(map{$_->[1]} @mat_d);
    my $cz = V(map{$_->[2]} @mat_d);
    my $dxyz = V(map{$_->[3]} @mat_d);
# hg
    my $COM = $mol->COM; # center of mass
    my $COM_transform = $COM->[0]*$cx + $COM->[1]*$cy + $COM->[2]*$cz + $dxyz;
    $hg_ball->push_atoms( HackaMol::Atom->new(symbol => 'Hg', coords =>[$COM_transform]));
# the protein
    foreach my $atom ($mol->all_atoms){
        my ($x,$y,$z) = @{$atom->xyz};
        my $xyz_new = $x*$cx + $y*$cy + $z*$cz + $dxyz;  
        $atom->push_coords($xyz_new);
    }    
}

# add a hg to the middle of the capsid using the Hg representation
my $hg      = HackaMol::Atom->new(symbol => 'Hg', coords =>[ $hg_ball->COM ] );
$hg_ball->push_atoms($hg);  # push on the center of mass Hg

$hg_ball->print_xyz;

foreach my $t (1 .. $mol->tmax) {
    $mol->t($t);
    say "$pdbid\_$t.pdb";
    $mol->print_pdb("$pdbid\_$t.pdb"); 
}

__DATA__
REMARK 350   BIOMT1   1  1.000000  0.000000  0.000000        0.00000            
REMARK 350   BIOMT2   1  0.000000  1.000000  0.000000        0.00000            
REMARK 350   BIOMT3   1  0.000000  0.000000  1.000000        0.00000            
REMARK 350   BIOMT1   2  0.458930 -0.507750  0.729091        0.00000            
REMARK 350   BIOMT2   2  0.846163  0.500000 -0.184413        0.00000            
REMARK 350   BIOMT3   2 -0.270909  0.701562  0.659104        0.00000            
REMARK 350   BIOMT1   3 -0.416540  0.024606  0.908784        0.00000            
REMARK 350   BIOMT2   3  0.861370 -0.309017  0.403175        0.00000            
REMARK 350   BIOMT3   3  0.290750  0.950738  0.107523        0.00000            
REMARK 350   BIOMT1   4 -0.416540  0.861370  0.290750        0.00000            
REMARK 350   BIOMT2   4  0.024606 -0.309017  0.950738        0.00000            
REMARK 350   BIOMT3   4  0.908784  0.403175  0.107523        0.00000            
REMARK 350   BIOMT1   5  0.458930  0.846163 -0.270909        0.00000            
REMARK 350   BIOMT2   5 -0.507750  0.500000  0.701562        0.00000            
REMARK 350   BIOMT3   5  0.729091 -0.184413  0.659104        0.00000            
REMARK 350   BIOMT1   6  0.483917  0.532356  0.694566        0.00000            
REMARK 350   BIOMT2   6  0.532356 -0.809017  0.249176        0.00000            
REMARK 350   BIOMT3   6  0.694566  0.249176 -0.674900        0.00000            
REMARK 350   BIOMT1   7  0.484379  0.507750  0.712437        0.00000            
REMARK 350   BIOMT2   7 -0.507750 -0.500000  0.701562        0.00000            
REMARK 350   BIOMT3   7  0.712437 -0.701562  0.015621        0.00000            
REMARK 350   BIOMT1   8  0.458930  0.507750  0.729091        0.00000            
REMARK 350   BIOMT2   8 -0.846163  0.500000  0.184414        0.00000            
REMARK 350   BIOMT3   8 -0.270909 -0.701562  0.659104        0.00000            
REMARK 350   BIOMT1   9  0.442738  0.532356  0.721512        0.00000            
REMARK 350   BIOMT2   9 -0.015207  0.809017 -0.587588        0.00000            
REMARK 350   BIOMT3   9 -0.896522  0.249176  0.366279        0.00000            
REMARK 350   BIOMT1  10  0.458181  0.547563  0.700175        0.00000            
REMARK 350   BIOMT2  10  0.836764  0.000000 -0.547563        0.00000            
REMARK 350   BIOMT3  10 -0.299826  0.836764 -0.458181        0.00000            
REMARK 350   BIOMT1  11 -0.484379 -0.507750 -0.712437        0.00000            
REMARK 350   BIOMT2  11 -0.507750 -0.500000  0.701562        0.00000            
REMARK 350   BIOMT3  11 -0.712437  0.701562 -0.015621        0.00000            
REMARK 350   BIOMT1  12 -0.458930 -0.507750 -0.729091        0.00000            
REMARK 350   BIOMT2  12 -0.846163  0.500000  0.184413        0.00000            
REMARK 350   BIOMT3  12  0.270909  0.701562 -0.659104        0.00000            
REMARK 350   BIOMT1  13 -0.442738 -0.532356 -0.721512        0.00000            
REMARK 350   BIOMT2  13 -0.015207  0.809017 -0.587589        0.00000            
REMARK 350   BIOMT3  13  0.896522 -0.249176 -0.366279        0.00000            
REMARK 350   BIOMT1  14 -0.458181 -0.547563 -0.700174        0.00000            
REMARK 350   BIOMT2  14  0.836764 -0.000000 -0.547563        0.00000            
REMARK 350   BIOMT3  14  0.299825 -0.836764  0.458181        0.00000            
REMARK 350   BIOMT1  15 -0.483917 -0.532356 -0.694566        0.00000            
REMARK 350   BIOMT2  15  0.532356 -0.809017  0.249176        0.00000            
REMARK 350   BIOMT3  15 -0.694566 -0.249176  0.674900        0.00000            
REMARK 350   BIOMT1  16 -0.999537 -0.024606  0.017871        0.00000            
REMARK 350   BIOMT2  16 -0.024606  0.309017 -0.950738        0.00000            
REMARK 350   BIOMT3  16  0.017871 -0.950738 -0.309479        0.00000            
REMARK 350   BIOMT1  17 -0.484379  0.507750 -0.712437        0.00000            
REMARK 350   BIOMT2  17  0.507750 -0.500000 -0.701562        0.00000            
REMARK 350   BIOMT3  17 -0.712437 -0.701562 -0.015621        0.00000            
REMARK 350   BIOMT1  18  0.400349  0.000000 -0.916363        0.00000            
REMARK 350   BIOMT2  18  0.000000 -1.000000 -0.000000        0.00000            
REMARK 350   BIOMT3  18 -0.916363 -0.000000 -0.400349        0.00000            
REMARK 350   BIOMT1  19  0.431983 -0.846163 -0.312088        0.00000            
REMARK 350   BIOMT2  19 -0.846163 -0.500000  0.184414        0.00000            
REMARK 350   BIOMT3  19 -0.312088  0.184414 -0.931983        0.00000            
REMARK 350   BIOMT1  20 -0.433194 -0.861370  0.265301        0.00000            
REMARK 350   BIOMT2  20 -0.861370  0.309017 -0.403175        0.00000            
REMARK 350   BIOMT3  20  0.265301 -0.403175 -0.875823        0.00000            
REMARK 350   BIOMT1  21 -0.442738  0.015207  0.896522        0.00000            
REMARK 350   BIOMT2  21  0.532356  0.809017  0.249176        0.00000            
REMARK 350   BIOMT3  21 -0.721512  0.587588 -0.366279        0.00000            
REMARK 350   BIOMT1  22 -0.433194  0.861370  0.265300        0.00000            
REMARK 350   BIOMT2  22  0.861370  0.309017  0.403175        0.00000            
REMARK 350   BIOMT3  22  0.265300  0.403175 -0.875823        0.00000            
REMARK 350   BIOMT1  23  0.458181  0.836764 -0.299826        0.00000            
REMARK 350   BIOMT2  23  0.547563  0.000000  0.836764        0.00000            
REMARK 350   BIOMT3  23  0.700175 -0.547563 -0.458181        0.00000            
REMARK 350   BIOMT1  24  0.999537 -0.024606 -0.017871        0.00000            
REMARK 350   BIOMT2  24  0.024606  0.309017  0.950738        0.00000            
REMARK 350   BIOMT3  24 -0.017871 -0.950738  0.309480        0.00000            
REMARK 350   BIOMT1  25  0.442738 -0.532356  0.721512        0.00000            
REMARK 350   BIOMT2  25  0.015207  0.809017  0.587589        0.00000            
REMARK 350   BIOMT3  25 -0.896522 -0.249176  0.366279        0.00000            
REMARK 350   BIOMT1  26  0.416540 -0.024606 -0.908784        0.00000            
REMARK 350   BIOMT2  26  0.861370 -0.309017  0.403175        0.00000            
REMARK 350   BIOMT3  26 -0.290750 -0.950738 -0.107523        0.00000            
REMARK 350   BIOMT1  27  0.416540 -0.861370 -0.290750        0.00000            
REMARK 350   BIOMT2  27  0.024606 -0.309017  0.950738        0.00000            
REMARK 350   BIOMT3  27 -0.908784 -0.403175 -0.107523        0.00000            
REMARK 350   BIOMT1  28 -0.458930 -0.846163  0.270909        0.00000            
REMARK 350   BIOMT2  28 -0.507750  0.500000  0.701562        0.00000            
REMARK 350   BIOMT3  28 -0.729091  0.184413 -0.659104        0.00000            
REMARK 350   BIOMT1  29 -1.000000 -0.000000  0.000000        0.00000            
REMARK 350   BIOMT2  29 -0.000000  1.000000 -0.000000        0.00000            
REMARK 350   BIOMT3  29  0.000000 -0.000000 -1.000000        0.00000            
REMARK 350   BIOMT1  30 -0.458930  0.507750 -0.729091        0.00000            
REMARK 350   BIOMT2  30  0.846163  0.500000 -0.184414        0.00000            
REMARK 350   BIOMT3  30  0.270909 -0.701562 -0.659104        0.00000            
REMARK 350   BIOMT1  31 -0.431983  0.846163  0.312088        0.00000            
REMARK 350   BIOMT2  31 -0.846163 -0.500000  0.184414        0.00000            
REMARK 350   BIOMT3  31  0.312088 -0.184413  0.931983        0.00000            
REMARK 350   BIOMT1  32  0.433194  0.861370 -0.265300        0.00000            
REMARK 350   BIOMT2  32 -0.861370  0.309017 -0.403175        0.00000            
REMARK 350   BIOMT3  32 -0.265300  0.403175  0.875823        0.00000            
REMARK 350   BIOMT1  33  0.999537  0.024606 -0.017871        0.00000            
REMARK 350   BIOMT2  33 -0.024606  0.309017 -0.950738        0.00000            
REMARK 350   BIOMT3  33 -0.017871  0.950738  0.309480        0.00000            
REMARK 350   BIOMT1  34  0.484379 -0.507750  0.712437        0.00000            
REMARK 350   BIOMT2  34  0.507750 -0.500000 -0.701562        0.00000            
REMARK 350   BIOMT3  34  0.712437  0.701562  0.015621        0.00000            
REMARK 350   BIOMT1  35 -0.400349  0.000000  0.916363        0.00000            
REMARK 350   BIOMT2  35  0.000000 -1.000000  0.000000        0.00000            
REMARK 350   BIOMT3  35  0.916363  0.000000  0.400349        0.00000            
REMARK 350   BIOMT1  36  0.458181 -0.836764 -0.299825        0.00000            
REMARK 350   BIOMT2  36 -0.547563 -0.000000 -0.836764        0.00000            
REMARK 350   BIOMT3  36  0.700175  0.547563 -0.458181        0.00000            
REMARK 350   BIOMT1  37 -0.416540 -0.861370  0.290750        0.00000            
REMARK 350   BIOMT2  37 -0.024606 -0.309017 -0.950738        0.00000            
REMARK 350   BIOMT3  37  0.908784 -0.403175  0.107523        0.00000            
REMARK 350   BIOMT1  38 -0.998789 -0.015207  0.046787        0.00000            
REMARK 350   BIOMT2  38 -0.015207 -0.809017 -0.587588        0.00000            
REMARK 350   BIOMT3  38  0.046787 -0.587588  0.807806        0.00000            
REMARK 350   BIOMT1  39 -0.483917  0.532356 -0.694566        0.00000            
REMARK 350   BIOMT2  39 -0.532356 -0.809017 -0.249176        0.00000            
REMARK 350   BIOMT3  39 -0.694566  0.249176  0.674900        0.00000            
REMARK 350   BIOMT1  40  0.416540  0.024606 -0.908784        0.00000            
REMARK 350   BIOMT2  40 -0.861370 -0.309017 -0.403175        0.00000            
REMARK 350   BIOMT3  40 -0.290750  0.950738 -0.107523        0.00000            
REMARK 350   BIOMT1  41 -0.442738  0.532356 -0.721512        0.00000            
REMARK 350   BIOMT2  41  0.015207  0.809017  0.587588        0.00000            
REMARK 350   BIOMT3  41  0.896522  0.249176 -0.366279        0.00000            
REMARK 350   BIOMT1  42  0.442738 -0.015207 -0.896522        0.00000            
REMARK 350   BIOMT2  42  0.532356  0.809017  0.249176        0.00000            
REMARK 350   BIOMT3  42  0.721512 -0.587588  0.366279        0.00000            
REMARK 350   BIOMT1  43  0.433194 -0.861370 -0.265300        0.00000            
REMARK 350   BIOMT2  43  0.861370  0.309017  0.403175        0.00000            
REMARK 350   BIOMT3  43 -0.265300 -0.403175  0.875823        0.00000            
REMARK 350   BIOMT1  44 -0.458181 -0.836764  0.299825        0.00000            
REMARK 350   BIOMT2  44  0.547563  0.000000  0.836764        0.00000            
REMARK 350   BIOMT3  44 -0.700175  0.547563  0.458181        0.00000            
REMARK 350   BIOMT1  45 -0.999537  0.024606  0.017871        0.00000            
REMARK 350   BIOMT2  45  0.024606  0.309017  0.950738        0.00000            
REMARK 350   BIOMT3  45  0.017871  0.950738 -0.309480        0.00000            
REMARK 350   BIOMT1  46 -0.431983 -0.846163  0.312088        0.00000            
REMARK 350   BIOMT2  46  0.846163 -0.500000 -0.184413        0.00000            
REMARK 350   BIOMT3  46  0.312088  0.184414  0.931983        0.00000            
REMARK 350   BIOMT1  47 -0.998789  0.015207  0.046787        0.00000            
REMARK 350   BIOMT2  47  0.015207 -0.809017  0.587589        0.00000            
REMARK 350   BIOMT3  47  0.046787  0.587589  0.807806        0.00000            
REMARK 350   BIOMT1  48 -0.458181  0.547563 -0.700175        0.00000            
REMARK 350   BIOMT2  48 -0.836764  0.000000  0.547563        0.00000            
REMARK 350   BIOMT3  48  0.299825  0.836764  0.458181        0.00000            
REMARK 350   BIOMT1  49  0.442738  0.015207 -0.896522        0.00000            
REMARK 350   BIOMT2  49 -0.532356  0.809017 -0.249176        0.00000            
REMARK 350   BIOMT3  49  0.721512  0.587589  0.366279        0.00000            
REMARK 350   BIOMT1  50  0.458930 -0.846163 -0.270909        0.00000            
REMARK 350   BIOMT2  50  0.507750  0.500000 -0.701562        0.00000            
REMARK 350   BIOMT3  50  0.729091  0.184414  0.659104        0.00000            
REMARK 350   BIOMT1  51  0.458181 -0.547563  0.700175        0.00000            
REMARK 350   BIOMT2  51 -0.836764 -0.000000  0.547563        0.00000            
REMARK 350   BIOMT3  51 -0.299825 -0.836764 -0.458181        0.00000            
REMARK 350   BIOMT1  52 -0.442738 -0.015207  0.896522        0.00000            
REMARK 350   BIOMT2  52 -0.532356  0.809017 -0.249176        0.00000            
REMARK 350   BIOMT3  52 -0.721512 -0.587589 -0.366279        0.00000            
REMARK 350   BIOMT1  53 -0.458930  0.846163  0.270909        0.00000            
REMARK 350   BIOMT2  53  0.507750  0.500000 -0.701562        0.00000            
REMARK 350   BIOMT3  53 -0.729091 -0.184414 -0.659104        0.00000            
REMARK 350   BIOMT1  54  0.431983  0.846163 -0.312088        0.00000            
REMARK 350   BIOMT2  54  0.846163 -0.500000 -0.184414        0.00000            
REMARK 350   BIOMT3  54 -0.312088 -0.184414 -0.931983        0.00000            
REMARK 350   BIOMT1  55  0.998789 -0.015207 -0.046787        0.00000            
REMARK 350   BIOMT2  55  0.015207 -0.809017  0.587588        0.00000            
REMARK 350   BIOMT3  55 -0.046787 -0.587588 -0.807806        0.00000            
REMARK 350   BIOMT1  56  0.416540  0.861370 -0.290750        0.00000            
REMARK 350   BIOMT2  56 -0.024606 -0.309017 -0.950738        0.00000            
REMARK 350   BIOMT3  56 -0.908784  0.403175 -0.107523        0.00000            
REMARK 350   BIOMT1  57  0.998789  0.015207 -0.046787        0.00000            
REMARK 350   BIOMT2  57 -0.015207 -0.809017 -0.587588        0.00000            
REMARK 350   BIOMT3  57 -0.046787  0.587588 -0.807806        0.00000            
REMARK 350   BIOMT1  58  0.483917 -0.532356  0.694566        0.00000            
REMARK 350   BIOMT2  58 -0.532356 -0.809017 -0.249176        0.00000            
REMARK 350   BIOMT3  58  0.694566 -0.249176 -0.674900        0.00000            
REMARK 350   BIOMT1  59 -0.416540 -0.024606  0.908784        0.00000            
REMARK 350   BIOMT2  59 -0.861370 -0.309017 -0.403175        0.00000            
REMARK 350   BIOMT3  59  0.290750 -0.950738  0.107523        0.00000            
REMARK 350   BIOMT1  60 -0.458181  0.836764  0.299825        0.00000            
REMARK 350   BIOMT2  60 -0.547563 -0.000000 -0.836764        0.00000            
REMARK 350   BIOMT3  60 -0.700174 -0.547563  0.458181        0.00000  
