package HTTP::Throwable::Role::Status::UseProxy 0.028;
our $AUTHORITY = 'cpan:STEVAN';

use Moo::Role;

with(
    'HTTP::Throwable',
    'HTTP::Throwable::Role::Redirect',
    'HTTP::Throwable::Role::BoringText',
);

sub default_status_code { 305 }
sub default_reason      { 'Use Proxy' }

no Moo::Role; 1;

=pod

=encoding UTF-8

=head1 NAME

HTTP::Throwable::Role::Status::UseProxy - 305 Use Proxy

=head1 VERSION

version 0.028

=head1 DESCRIPTION

The requested resource MUST be accessed through the proxy given
by the Location field. The Location field gives the URI of the
proxy. The recipient is expected to repeat this single request
via the proxy. 305 responses MUST only be generated by origin
servers.

=head1 PERL VERSION

This library should run on perls released even a long time ago.  It should work
on any version of perl released in the last five years.

Although it may work on older versions of perl, no guarantee is made that the
minimum required version will not be increased.  The version may be increased
for any reason, and there is no promise that patches will be accepted to lower
the minimum required perl.

=head1 AUTHORS

=over 4

=item *

Stevan Little <stevan.little@iinteractive.com>

=item *

Ricardo Signes <cpan@semiotic.systems>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Infinity Interactive, Inc.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__END__

# ABSTRACT: 305 Use Proxy

#pod =head1 DESCRIPTION
#pod
#pod The requested resource MUST be accessed through the proxy given
#pod by the Location field. The Location field gives the URI of the
#pod proxy. The recipient is expected to repeat this single request
#pod via the proxy. 305 responses MUST only be generated by origin
#pod servers.
#pod
