######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT -3
package Geo::Location::TimeZone::P;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude -52.5 to -37.5
	"-3" => {
		# Grid -3:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"200" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5199127197266,-82.5],[-37.5,-82.5],[-37.5,-90],[-37.5199089050293,-90],[-37.5198917712617,-82.5],[-37.5,-82.5],[-37.5199127197266,-82.5],],
			},
		},
		# Grid -3:-5 ; 1 records
		"-5" => {
			"201" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5199127197266,-67.5],[-37.5,-67.5],[-37.5,-82.5],[-37.5198917712617,-82.5],[-37.5198575037264,-67.5],[-37.5,-67.5],[-37.5199127197266,-67.5],],
			},
		},
		# Grid -3:-4 ; 1 records
		"-4" => {
			"202" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5199127197266,-52.5],[-37.5,-52.5],[-37.5,-67.5],[-37.5198575037264,-67.5],[-37.5198287963867,-54.9338760375977],[-45.015022277832,-54.9338760375977],[-45.015022277832,-52.5],[-37.5,-52.5],[-37.5199127197266,-52.5],],
			},
		},
		# Grid -3:-3 ; 1 records
		"-3" => {
			"203" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5199127197266,-37.5],[-37.5,-37.5],[-37.5,-52.5],[-45.015022277832,-52.5],[-45.015022277832,-52.088134765625],[-37.5198211669922,-52.088134765625],[-37.5197982788086,-42.1738891601562],[-37.5197877218841,-37.5],[-37.5,-37.5],[-37.5199127197266,-37.5],],
			},
		},
		# Grid -3:-2 ; 1 records
		"-2" => {
			"204" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5199127197266,-22.5],[-37.5,-22.5],[-37.5,-37.5],[-37.5197877218841,-37.5],[-37.5197538413488,-22.5],[-37.5,-22.5],[-37.5199127197266,-22.5],],
			},
		},
		# Grid -3:-1 ; 2 records
		"-1" => {
			"def_z" => "Etc/GMT-4",
			"205" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5,-7.5],[-37.5,-22.5],[-37.5197538413488,-22.5],[-37.5197296142578,-11.773889541626],[-37.5,-11.7339087360429],[-37.5,-11.4272232055664],[-37.5,-7.5],],
			},
		},
		# Grid -3:0 ; 2 records
		"0" => {
			"def_z" => "Etc/GMT-4",
			"206" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5,-5.05222225189209],[-37.5,-4.64188003559005],[-37.5199089050293,-4.63390493392944],[-37.5199089050293,7.5],[-37.5,7.5],[-37.5,-7.5],[-37.5,-7.5],[-37.5,-5.05222225189209],],
			},
		},
		# Grid -3:1 ; 1 records
		"1" => {
			"207" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5,7.5],[-37.5199089050293,7.5],[-37.5199089050293,22.5],[-37.5,22.5],[-37.5,7.5],],
			},
		},
		# Grid -3:2 ; 1 records
		"2" => {
			"208" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5,22.5],[-37.5199089050293,22.5],[-37.5199089050293,29.9684257507324],[-37.5199097212417,37.5],[-37.5,37.5],[-37.5,22.5],],
			},
		},
		# Grid -3:3 ; 1 records
		"3" => {
			"209" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5,37.5],[-37.5199097212417,37.5],[-37.5199113468228,52.5],[-37.5,52.5],[-37.5,37.5],],
			},
		},
		# Grid -3:4 ; 1 records
		"4" => {
			"210" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,2",
				"p" => [[-37.5,52.5],[-37.5199113468228,52.5],[-37.5199127197266,65.1684265136719],[-37.5,65.1752836169732],[-37.5,67.5],[-37.5,52.5],],
			},
		},
		# Grid -3:5 ; No records found
		# Grid -3:6 ; 1 records
		"6" => {
			"199" => {
				"z" => "Etc/GMT-2",
				"c" => "ESRI",
				"s" => "14,1",
				"p" => [[-37.5,83.0645294189453],[-37.5,83.7461685952141],[-37.5199165344238,83.7459030151367],[-37.5199165344238,90],[-37.5,90],[-37.5,83.0645294189453],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
