/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FilterIterator
implements SequenceIterator {
    protected FocusIterator base;
    protected Expression filter;
    protected XPathContext filterContext;

    public FilterIterator(SequenceIterator base, Expression filter, XPathContext context) {
        this.base = new FocusTrackingIterator(base);
        this.filter = filter;
        this.filterContext = context.newMinorContext();
        this.filterContext.setCurrentIterator(this.base);
    }

    public void setSequence(SequenceIterator base, XPathContext context) {
        this.base = new FocusTrackingIterator(base);
        this.filterContext = context.newMinorContext();
        this.filterContext.setCurrentIterator(this.base);
    }

    public Item next() throws XPathException {
        return this.getNextMatchingItem();
    }

    protected Item getNextMatchingItem() throws XPathException {
        Item next;
        while ((next = this.base.next()) != null) {
            if (!this.matches()) continue;
            return next;
        }
        return null;
    }

    protected boolean matches() throws XPathException {
        SequenceIterator iterator = this.filter.iterate(this.filterContext);
        return FilterIterator.testPredicateValue(iterator, this.base.position());
    }

    public static boolean testPredicateValue(SequenceIterator iterator, long position) throws XPathException {
        Item first = iterator.next();
        if (first == null) {
            return false;
        }
        if (first instanceof NodeInfo) {
            return true;
        }
        if (first instanceof BooleanValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a boolean");
            }
            return ((BooleanValue)first).getBooleanValue();
        }
        if (first instanceof StringValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a string");
            }
            return first.getStringValueCS().length() != 0;
        }
        if (first instanceof Int64Value) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return ((Int64Value)first).longValue() == position;
        }
        if (first instanceof NumericValue) {
            if (iterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            return ((NumericValue)first).compareTo(position) == 0;
        }
        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, or string");
        return false;
    }

    public void close() {
        this.base.close();
    }

    public int getProperties() {
        return 0;
    }

    public static final class NonNumeric
    extends FilterIterator {
        public NonNumeric(SequenceIterator base, Expression filter, XPathContext context) {
            super(base, filter, context);
        }

        protected boolean matches() throws XPathException {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }
    }
}

