# Generated by default/object.tt
package Paws::MediaLive::FailoverConditionSettings;
  use Moose;
  has AudioSilenceSettings => (is => 'ro', isa => 'Paws::MediaLive::AudioSilenceFailoverSettings', request_name => 'audioSilenceSettings', traits => ['NameInRequest']);
  has InputLossSettings => (is => 'ro', isa => 'Paws::MediaLive::InputLossFailoverSettings', request_name => 'inputLossSettings', traits => ['NameInRequest']);
  has VideoBlackSettings => (is => 'ro', isa => 'Paws::MediaLive::VideoBlackFailoverSettings', request_name => 'videoBlackSettings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::FailoverConditionSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::FailoverConditionSettings object:

  $service_obj->Method(Att1 => { AudioSilenceSettings => $value, ..., VideoBlackSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::FailoverConditionSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AudioSilenceSettings

=head1 DESCRIPTION

Settings for one failover condition.

=head1 ATTRIBUTES


=head2 AudioSilenceSettings => L<Paws::MediaLive::AudioSilenceFailoverSettings>

MediaLive will perform a failover if the specified audio selector is
silent for the specified period.


=head2 InputLossSettings => L<Paws::MediaLive::InputLossFailoverSettings>

MediaLive will perform a failover if content is not detected in this
input for the specified period.


=head2 VideoBlackSettings => L<Paws::MediaLive::VideoBlackFailoverSettings>

MediaLive will perform a failover if content is considered black for
the specified period.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

