#!/usr/bin/env perl

use strict;

use Test::More tests => 3925;

use FindBin;
use lib "$FindBin::Bin/lib";
use My_Growth_Test;

require_ok('Medical::Growth::NHANES_2000::Weight_for_Age::Child::Male');

my $h = Medical::Growth::NHANES_2000::Weight_for_Age::Child::Male->new;
My_Growth_Test::run_data_tests($h);

__DATA__
# age %ile value
 24.0	 3	 10.382
 24.0	 5	 10.640
 24.0	10	 11.053
 24.0	25	 11.786
 24.0	50	 12.671
 24.0	75	 13.637
 24.0	90	 14.583
 24.0	95	 15.188
 24.0	97	 15.596
 24.5	 3	 10.441
 24.5	 5	 10.701
 24.5	10	 11.115
 24.5	25	 11.852
 24.5	50	 12.742
 24.5	75	 13.714
 24.5	90	 14.667
 24.5	95	 15.276
 24.5	97	 15.688
 25.5	 3	 10.558
 25.5	 5	 10.820
 25.5	10	 11.237
 25.5	25	 11.981
 25.5	50	 12.881
 25.5	75	 13.866
 25.5	90	 14.833
 25.5	95	 15.452
 25.5	97	 15.872
 26.5	 3	 10.674
 26.5	 5	 10.937
 26.5	10	 11.358
 26.5	25	 12.109
 26.5	50	 13.018
 26.5	75	 14.016
 26.5	90	 14.998
 26.5	95	 15.628
 26.5	97	 16.055
 27.5	 3	 10.788
 27.5	 5	 11.053
 27.5	10	 11.477
 27.5	25	 12.235
 27.5	50	 13.154
 27.5	75	 14.166
 27.5	90	 15.164
 27.5	95	 15.805
 27.5	97	 16.240
 28.5	 3	 10.901
 28.5	 5	 11.168
 28.5	10	 11.596
 28.5	25	 12.360
 28.5	50	 13.290
 28.5	75	 14.315
 28.5	90	 15.329
 28.5	95	 15.982
 28.5	97	 16.426
 29.5	 3	 11.015
 29.5	 5	 11.283
 29.5	10	 11.714
 29.5	25	 12.485
 29.5	50	 13.425
 29.5	75	 14.465
 29.5	90	 15.496
 29.5	95	 16.162
 29.5	97	 16.615
 30.5	 3	 11.128
 30.5	 5	 11.398
 30.5	10	 11.832
 30.5	25	 12.610
 30.5	50	 13.561
 30.5	75	 14.615
 30.5	90	 15.665
 30.5	95	 16.344
 30.5	97	 16.807
 31.5	 3	 11.241
 31.5	 5	 11.513
 31.5	10	 11.950
 31.5	25	 12.735
 31.5	50	 13.697
 31.5	75	 14.767
 31.5	90	 15.836
 31.5	95	 16.529
 31.5	97	 17.003
 32.5	 3	 11.355
 32.5	 5	 11.629
 32.5	10	 12.069
 32.5	25	 12.861
 32.5	50	 13.835
 32.5	75	 14.921
 32.5	90	 16.010
 32.5	95	 16.718
 32.5	97	 17.203
 33.5	 3	 11.470
 33.5	 5	 11.745
 33.5	10	 12.189
 33.5	25	 12.989
 33.5	50	 13.974
 33.5	75	 15.077
 33.5	90	 16.186
 33.5	95	 16.910
 33.5	97	 17.407
 34.5	 3	 11.585
 34.5	 5	 11.862
 34.5	10	 12.309
 34.5	25	 13.117
 34.5	50	 14.115
 34.5	75	 15.235
 34.5	90	 16.366
 34.5	95	 17.106
 34.5	97	 17.615
 35.5	 3	 11.701
 35.5	 5	 11.980
 35.5	10	 12.431
 35.5	25	 13.247
 35.5	50	 14.258
 35.5	75	 15.396
 35.5	90	 16.549
 35.5	95	 17.306
 35.5	97	 17.828
 36.5	 3	 11.818
 36.5	 5	 12.100
 36.5	10	 12.554
 36.5	25	 13.379
 36.5	50	 14.403
 36.5	75	 15.560
 36.5	90	 16.736
 36.5	95	 17.511
 36.5	97	 18.046
 37.5	 3	 11.936
 37.5	 5	 12.220
 37.5	10	 12.679
 37.5	25	 13.512
 37.5	50	 14.550
 37.5	75	 15.726
 37.5	90	 16.927
 37.5	95	 17.720
 37.5	97	 18.268
 38.5	 3	 12.055
 38.5	 5	 12.341
 38.5	10	 12.804
 38.5	25	 13.647
 38.5	50	 14.699
 38.5	75	 15.896
 38.5	90	 17.121
 38.5	95	 17.933
 38.5	97	 18.495
 39.5	 3	 12.175
 39.5	 5	 12.464
 39.5	10	 12.931
 39.5	25	 13.784
 39.5	50	 14.851
 39.5	75	 16.068
 39.5	90	 17.319
 39.5	95	 18.150
 39.5	97	 18.727
 40.5	 3	 12.296
 40.5	 5	 12.587
 40.5	10	 13.060
 40.5	25	 13.922
 40.5	50	 15.004
 40.5	75	 16.243
 40.5	90	 17.520
 40.5	95	 18.371
 40.5	97	 18.964
 41.5	 3	 12.418
 41.5	 5	 12.712
 41.5	10	 13.189
 41.5	25	 14.062
 41.5	50	 15.161
 41.5	75	 16.422
 41.5	90	 17.725
 41.5	95	 18.597
 41.5	97	 19.205
 42.5	 3	 12.540
 42.5	 5	 12.837
 42.5	10	 13.320
 42.5	25	 14.205
 42.5	50	 15.319
 42.5	75	 16.603
 42.5	90	 17.934
 42.5	95	 18.827
 42.5	97	 19.450
 43.5	 3	 12.663
 43.5	 5	 12.964
 43.5	10	 13.452
 43.5	25	 14.348
 43.5	50	 15.480
 43.5	75	 16.787
 43.5	90	 18.147
 43.5	95	 19.060
 43.5	97	 19.700
 44.5	 3	 12.787
 44.5	 5	 13.091
 44.5	10	 13.586
 44.5	25	 14.494
 44.5	50	 15.643
 44.5	75	 16.974
 44.5	90	 18.362
 44.5	95	 19.298
 44.5	97	 19.954
 45.5	 3	 12.912
 45.5	 5	 13.220
 45.5	10	 13.720
 45.5	25	 14.641
 45.5	50	 15.809
 45.5	75	 17.163
 45.5	90	 18.581
 45.5	95	 19.539
 45.5	97	 20.212
 46.5	 3	 13.038
 46.5	 5	 13.349
 46.5	10	 13.856
 46.5	25	 14.790
 46.5	50	 15.976
 46.5	75	 17.356
 46.5	90	 18.803
 46.5	95	 19.784
 46.5	97	 20.474
 47.5	 3	 13.164
 47.5	 5	 13.479
 47.5	10	 13.993
 47.5	25	 14.940
 47.5	50	 16.145
 47.5	75	 17.550
 47.5	90	 19.029
 47.5	95	 20.032
 47.5	97	 20.739
 48.5	 3	 13.291
 48.5	 5	 13.610
 48.5	10	 14.131
 48.5	25	 15.092
 48.5	50	 16.317
 48.5	75	 17.748
 48.5	90	 19.257
 48.5	95	 20.283
 48.5	97	 21.008
 49.5	 3	 13.419
 49.5	 5	 13.742
 49.5	10	 14.270
 49.5	25	 15.245
 49.5	50	 16.490
 49.5	75	 17.947
 49.5	90	 19.488
 49.5	95	 20.538
 49.5	97	 21.280
 50.5	 3	 13.547
 50.5	 5	 13.874
 50.5	10	 14.409
 50.5	25	 15.399
 50.5	50	 16.665
 50.5	75	 18.149
 50.5	90	 19.722
 50.5	95	 20.795
 50.5	97	 21.556
 51.5	 3	 13.675
 51.5	 5	 14.007
 51.5	10	 14.550
 51.5	25	 15.554
 51.5	50	 16.841
 51.5	75	 18.353
 51.5	90	 19.958
 51.5	95	 21.056
 51.5	97	 21.834
 52.5	 3	 13.805
 52.5	 5	 14.141
 52.5	10	 14.691
 52.5	25	 15.711
 52.5	50	 17.019
 52.5	75	 18.558
 52.5	90	 20.196
 52.5	95	 21.319
 52.5	97	 22.116
 53.5	 3	 13.934
 53.5	 5	 14.275
 53.5	10	 14.834
 53.5	25	 15.869
 53.5	50	 17.198
 53.5	75	 18.766
 53.5	90	 20.437
 53.5	95	 21.585
 53.5	97	 22.400
 54.5	 3	 14.065
 54.5	 5	 14.410
 54.5	10	 14.977
 54.5	25	 16.027
 54.5	50	 17.379
 54.5	75	 18.975
 54.5	90	 20.680
 54.5	95	 21.853
 54.5	97	 22.687
 55.5	 3	 14.195
 55.5	 5	 14.546
 55.5	10	 15.120
 55.5	25	 16.187
 55.5	50	 17.561
 55.5	75	 19.186
 55.5	90	 20.925
 55.5	95	 22.123
 55.5	97	 22.977
 56.5	 3	 14.327
 56.5	 5	 14.682
 56.5	10	 15.265
 56.5	25	 16.347
 56.5	50	 17.744
 56.5	75	 19.398
 56.5	90	 21.172
 56.5	95	 22.396
 56.5	97	 23.269
 57.5	 3	 14.459
 57.5	 5	 14.819
 57.5	10	 15.410
 57.5	25	 16.509
 57.5	50	 17.928
 57.5	75	 19.612
 57.5	90	 21.421
 57.5	95	 22.671
 57.5	97	 23.563
 58.5	 3	 14.591
 58.5	 5	 14.956
 58.5	10	 15.555
 58.5	25	 16.671
 58.5	50	 18.113
 58.5	75	 19.827
 58.5	90	 21.672
 58.5	95	 22.948
 58.5	97	 23.861
 59.5	 3	 14.724
 59.5	 5	 15.094
 59.5	10	 15.701
 59.5	25	 16.834
 59.5	50	 18.299
 59.5	75	 20.043
 59.5	90	 21.924
 59.5	95	 23.227
 59.5	97	 24.160
 60.5	 3	 14.857
 60.5	 5	 15.232
 60.5	10	 15.848
 60.5	25	 16.997
 60.5	50	 18.486
 60.5	75	 20.261
 60.5	90	 22.177
 60.5	95	 23.508
 60.5	97	 24.462
 61.5	 3	 14.991
 61.5	 5	 15.371
 61.5	10	 15.995
 61.5	25	 17.161
 61.5	50	 18.673
 61.5	75	 20.479
 61.5	90	 22.433
 61.5	95	 23.791
 61.5	97	 24.766
 62.5	 3	 15.125
 62.5	 5	 15.510
 62.5	10	 16.143
 62.5	25	 17.326
 62.5	50	 18.862
 62.5	75	 20.699
 62.5	90	 22.689
 62.5	95	 24.076
 62.5	97	 25.072
 63.5	 3	 15.260
 63.5	 5	 15.650
 63.5	10	 16.292
 63.5	25	 17.491
 63.5	50	 19.051
 63.5	75	 20.919
 63.5	90	 22.948
 63.5	95	 24.363
 63.5	97	 25.381
 64.5	 3	 15.396
 64.5	 5	 15.791
 64.5	10	 16.441
 64.5	25	 17.657
 64.5	50	 19.240
 64.5	75	 21.140
 64.5	90	 23.207
 64.5	95	 24.652
 64.5	97	 25.692
 65.5	 3	 15.532
 65.5	 5	 15.932
 65.5	10	 16.590
 65.5	25	 17.823
 65.5	50	 19.431
 65.5	75	 21.362
 65.5	90	 23.468
 65.5	95	 24.943
 65.5	97	 26.005
 66.5	 3	 15.669
 66.5	 5	 16.074
 66.5	10	 16.740
 66.5	25	 17.990
 66.5	50	 19.621
 66.5	75	 21.585
 66.5	90	 23.730
 66.5	95	 25.235
 66.5	97	 26.321
 67.5	 3	 15.806
 67.5	 5	 16.216
 67.5	10	 16.891
 67.5	25	 18.157
 67.5	50	 19.813
 67.5	75	 21.809
 67.5	90	 23.994
 67.5	95	 25.530
 67.5	97	 26.639
 68.5	 3	 15.944
 68.5	 5	 16.359
 68.5	10	 17.042
 68.5	25	 18.325
 68.5	50	 20.005
 68.5	75	 22.034
 68.5	90	 24.259
 68.5	95	 25.826
 68.5	97	 26.960
 69.5	 3	 16.083
 69.5	 5	 16.502
 69.5	10	 17.194
 69.5	25	 18.493
 69.5	50	 20.197
 69.5	75	 22.259
 69.5	90	 24.525
 69.5	95	 26.125
 69.5	97	 27.284
 70.5	 3	 16.223
 70.5	 5	 16.647
 70.5	10	 17.346
 70.5	25	 18.662
 70.5	50	 20.390
 70.5	75	 22.485
 70.5	90	 24.793
 70.5	95	 26.425
 70.5	97	 27.610
 71.5	 3	 16.363
 71.5	 5	 16.791
 71.5	10	 17.499
 71.5	25	 18.832
 71.5	50	 20.584
 71.5	75	 22.712
 71.5	90	 25.062
 71.5	95	 26.728
 71.5	97	 27.939
 72.5	 3	 16.504
 72.5	 5	 16.937
 72.5	10	 17.653
 72.5	25	 19.001
 72.5	50	 20.778
 72.5	75	 22.940
 72.5	90	 25.333
 72.5	95	 27.033
 72.5	97	 28.271
 73.5	 3	 16.645
 73.5	 5	 17.083
 73.5	10	 17.807
 73.5	25	 19.172
 73.5	50	 20.972
 73.5	75	 23.168
 73.5	90	 25.605
 73.5	95	 27.340
 73.5	97	 28.606
 74.5	 3	 16.788
 74.5	 5	 17.230
 74.5	10	 17.962
 74.5	25	 19.343
 74.5	50	 21.168
 74.5	75	 23.398
 74.5	90	 25.879
 74.5	95	 27.650
 74.5	97	 28.944
 75.5	 3	 16.931
 75.5	 5	 17.378
 75.5	10	 18.118
 75.5	25	 19.515
 75.5	50	 21.364
 75.5	75	 23.629
 75.5	90	 26.155
 75.5	95	 27.962
 75.5	97	 29.286
 76.5	 3	 17.075
 76.5	 5	 17.527
 76.5	10	 18.274
 76.5	25	 19.687
 76.5	50	 21.561
 76.5	75	 23.860
 76.5	90	 26.432
 76.5	95	 28.277
 76.5	97	 29.631
 77.5	 3	 17.220
 77.5	 5	 17.676
 77.5	10	 18.431
 77.5	25	 19.860
 77.5	50	 21.758
 77.5	75	 24.093
 77.5	90	 26.711
 77.5	95	 28.595
 77.5	97	 29.979
 78.5	 3	 17.365
 78.5	 5	 17.826
 78.5	10	 18.588
 78.5	25	 20.034
 78.5	50	 21.956
 78.5	75	 24.327
 78.5	90	 26.992
 78.5	95	 28.915
 78.5	97	 30.331
 79.5	 3	 17.512
 79.5	 5	 17.976
 79.5	10	 18.747
 79.5	25	 20.209
 79.5	50	 22.156
 79.5	75	 24.562
 79.5	90	 27.276
 79.5	95	 29.238
 79.5	97	 30.687
 80.5	 3	 17.659
 80.5	 5	 18.128
 80.5	10	 18.906
 80.5	25	 20.384
 80.5	50	 22.356
 80.5	75	 24.798
 80.5	90	 27.561
 80.5	95	 29.564
 80.5	97	 31.046
 81.5	 3	 17.807
 81.5	 5	 18.280
 81.5	10	 19.066
 81.5	25	 20.560
 81.5	50	 22.557
 81.5	75	 25.036
 81.5	90	 27.848
 81.5	95	 29.894
 81.5	97	 31.410
 82.5	 3	 17.956
 82.5	 5	 18.433
 82.5	10	 19.227
 82.5	25	 20.737
 82.5	50	 22.759
 82.5	75	 25.275
 82.5	90	 28.138
 82.5	95	 30.226
 82.5	97	 31.778
 83.5	 3	 18.105
 83.5	 5	 18.587
 83.5	10	 19.389
 83.5	25	 20.916
 83.5	50	 22.963
 83.5	75	 25.516
 83.5	90	 28.430
 83.5	95	 30.562
 83.5	97	 32.150
 84.5	 3	 18.255
 84.5	 5	 18.742
 84.5	10	 19.551
 84.5	25	 21.095
 84.5	50	 23.167
 84.5	75	 25.759
 84.5	90	 28.725
 84.5	95	 30.902
 84.5	97	 32.526
 85.5	 3	 18.406
 85.5	 5	 18.898
 85.5	10	 19.715
 85.5	25	 21.275
 85.5	50	 23.373
 85.5	75	 26.003
 85.5	90	 29.023
 85.5	95	 31.245
 85.5	97	 32.907
 86.5	 3	 18.558
 86.5	 5	 19.054
 86.5	10	 19.879
 86.5	25	 21.456
 86.5	50	 23.581
 86.5	75	 26.250
 86.5	90	 29.323
 86.5	95	 31.592
 86.5	97	 33.292
 87.5	 3	 18.711
 87.5	 5	 19.211
 87.5	10	 20.044
 87.5	25	 21.638
 87.5	50	 23.790
 87.5	75	 26.498
 87.5	90	 29.627
 87.5	95	 31.942
 87.5	97	 33.683
 88.5	 3	 18.864
 88.5	 5	 19.369
 88.5	10	 20.211
 88.5	25	 21.822
 88.5	50	 24.000
 88.5	75	 26.749
 88.5	90	 29.933
 88.5	95	 32.297
 88.5	97	 34.078
 89.5	 3	 19.018
 89.5	 5	 19.528
 89.5	10	 20.378
 89.5	25	 22.007
 89.5	50	 24.213
 89.5	75	 27.002
 89.5	90	 30.243
 89.5	95	 32.656
 89.5	97	 34.477
 90.5	 3	 19.172
 90.5	 5	 19.687
 90.5	10	 20.546
 90.5	25	 22.193
 90.5	50	 24.426
 90.5	75	 27.257
 90.5	90	 30.556
 90.5	95	 33.019
 90.5	97	 34.882
 91.5	 3	 19.328
 91.5	 5	 19.848
 91.5	10	 20.715
 91.5	25	 22.380
 91.5	50	 24.642
 91.5	75	 27.515
 91.5	90	 30.872
 91.5	95	 33.386
 91.5	97	 35.292
 92.5	 3	 19.484
 92.5	 5	 20.009
 92.5	10	 20.885
 92.5	25	 22.569
 92.5	50	 24.860
 92.5	75	 27.776
 92.5	90	 31.192
 92.5	95	 33.757
 92.5	97	 35.707
 93.5	 3	 19.640
 93.5	 5	 20.171
 93.5	10	 21.056
 93.5	25	 22.760
 93.5	50	 25.080
 93.5	75	 28.039
 93.5	90	 31.516
 93.5	95	 34.134
 93.5	97	 36.127
 94.5	 3	 19.798
 94.5	 5	 20.334
 94.5	10	 21.229
 94.5	25	 22.951
 94.5	50	 25.302
 94.5	75	 28.306
 94.5	90	 31.843
 94.5	95	 34.514
 94.5	97	 36.553
 95.5	 3	 19.956
 95.5	 5	 20.497
 95.5	10	 21.402
 95.5	25	 23.145
 95.5	50	 25.526
 95.5	75	 28.575
 95.5	90	 32.175
 95.5	95	 34.900
 95.5	97	 36.983
 96.5	 3	 20.115
 96.5	 5	 20.662
 96.5	10	 21.576
 96.5	25	 23.340
 96.5	50	 25.753
 96.5	75	 28.847
 96.5	90	 32.510
 96.5	95	 35.290
 96.5	97	 37.419
 97.5	 3	 20.274
 97.5	 5	 20.827
 97.5	10	 21.752
 97.5	25	 23.537
 97.5	50	 25.981
 97.5	75	 29.123
 97.5	90	 32.850
 97.5	95	 35.684
 97.5	97	 37.861
 98.5	 3	 20.434
 98.5	 5	 20.993
 98.5	10	 21.929
 98.5	25	 23.735
 98.5	50	 26.213
 98.5	75	 29.402
 98.5	90	 33.194
 98.5	95	 36.084
 98.5	97	 38.307
 99.5	 3	 20.595
 99.5	 5	 21.160
 99.5	10	 22.107
 99.5	25	 23.936
 99.5	50	 26.447
 99.5	75	 29.684
 99.5	90	 33.542
 99.5	95	 36.489
 99.5	97	 38.759
100.5	 3	 20.756
100.5	 5	 21.328
100.5	10	 22.286
100.5	25	 24.138
100.5	50	 26.683
100.5	75	 29.970
100.5	90	 33.895
100.5	95	 36.899
100.5	97	 39.217
101.5	 3	 20.919
101.5	 5	 21.497
101.5	10	 22.467
101.5	25	 24.342
101.5	50	 26.923
101.5	75	 30.260
101.5	90	 34.252
101.5	95	 37.313
101.5	97	 39.679
102.5	 3	 21.082
102.5	 5	 21.667
102.5	10	 22.648
102.5	25	 24.548
102.5	50	 27.165
102.5	75	 30.553
102.5	90	 34.614
102.5	95	 37.733
102.5	97	 40.147
103.5	 3	 21.245
103.5	 5	 21.838
103.5	10	 22.832
103.5	25	 24.756
103.5	50	 27.410
103.5	75	 30.851
103.5	90	 34.980
103.5	95	 38.158
103.5	97	 40.621
104.5	 3	 21.410
104.5	 5	 22.010
104.5	10	 23.016
104.5	25	 24.967
104.5	50	 27.658
104.5	75	 31.152
104.5	90	 35.352
104.5	95	 38.588
104.5	97	 41.100
105.5	 3	 21.575
105.5	 5	 22.183
105.5	10	 23.202
105.5	25	 25.179
105.5	50	 27.909
105.5	75	 31.457
105.5	90	 35.728
105.5	95	 39.024
105.5	97	 41.583
106.5	 3	 21.742
106.5	 5	 22.357
106.5	10	 23.390
106.5	25	 25.394
106.5	50	 28.163
106.5	75	 31.766
106.5	90	 36.109
106.5	95	 39.464
106.5	97	 42.072
107.5	 3	 21.909
107.5	 5	 22.532
107.5	10	 23.579
107.5	25	 25.611
107.5	50	 28.421
107.5	75	 32.080
107.5	90	 36.495
107.5	95	 39.910
107.5	97	 42.567
108.5	 3	 22.077
108.5	 5	 22.709
108.5	10	 23.770
108.5	25	 25.830
108.5	50	 28.681
108.5	75	 32.397
108.5	90	 36.886
108.5	95	 40.361
108.5	97	 43.066
109.5	 3	 22.246
109.5	 5	 22.886
109.5	10	 23.962
109.5	25	 26.052
109.5	50	 28.945
109.5	75	 32.719
109.5	90	 37.282
109.5	95	 40.817
109.5	97	 43.570
110.5	 3	 22.416
110.5	 5	 23.066
110.5	10	 24.156
110.5	25	 26.276
110.5	50	 29.213
110.5	75	 33.046
110.5	90	 37.683
110.5	95	 41.278
110.5	97	 44.079
111.5	 3	 22.588
111.5	 5	 23.246
111.5	10	 24.352
111.5	25	 26.502
111.5	50	 29.484
111.5	75	 33.376
111.5	90	 38.089
111.5	95	 41.744
111.5	97	 44.593
112.5	 3	 22.760
112.5	 5	 23.428
112.5	10	 24.550
112.5	25	 26.732
112.5	50	 29.758
112.5	75	 33.712
112.5	90	 38.500
112.5	95	 42.215
112.5	97	 45.112
113.5	 3	 22.934
113.5	 5	 23.611
113.5	10	 24.749
113.5	25	 26.964
113.5	50	 30.036
113.5	75	 34.051
113.5	90	 38.916
113.5	95	 42.691
113.5	97	 45.635
114.5	 3	 23.109
114.5	 5	 23.796
114.5	10	 24.951
114.5	25	 27.199
114.5	50	 30.318
114.5	75	 34.396
114.5	90	 39.337
114.5	95	 43.172
114.5	97	 46.163
115.5	 3	 23.286
115.5	 5	 23.983
115.5	10	 25.155
115.5	25	 27.436
115.5	50	 30.603
115.5	75	 34.745
115.5	90	 39.764
115.5	95	 43.658
115.5	97	 46.695
116.5	 3	 23.464
116.5	 5	 24.171
116.5	10	 25.361
116.5	25	 27.677
116.5	50	 30.892
116.5	75	 35.098
116.5	90	 40.195
116.5	95	 44.149
116.5	97	 47.231
117.5	 3	 23.643
117.5	 5	 24.361
117.5	10	 25.569
117.5	25	 27.920
117.5	50	 31.185
117.5	75	 35.456
117.5	90	 40.631
117.5	95	 44.644
117.5	97	 47.771
118.5	 3	 23.825
118.5	 5	 24.554
118.5	10	 25.779
118.5	25	 28.167
118.5	50	 31.482
118.5	75	 35.819
118.5	90	 41.072
118.5	95	 45.144
118.5	97	 48.315
119.5	 3	 24.008
119.5	 5	 24.748
119.5	10	 25.992
119.5	25	 28.416
119.5	50	 31.783
119.5	75	 36.186
119.5	90	 41.518
119.5	95	 45.649
119.5	97	 48.863
120.5	 3	 24.193
120.5	 5	 24.944
120.5	10	 26.207
120.5	25	 28.669
120.5	50	 32.088
120.5	75	 36.559
120.5	90	 41.969
120.5	95	 46.158
120.5	97	 49.415
121.5	 3	 24.380
121.5	 5	 25.142
121.5	10	 26.425
121.5	25	 28.925
121.5	50	 32.397
121.5	75	 36.935
121.5	90	 42.425
121.5	95	 46.671
121.5	97	 49.970
122.5	 3	 24.569
122.5	 5	 25.343
122.5	10	 26.646
122.5	25	 29.184
122.5	50	 32.710
122.5	75	 37.317
122.5	90	 42.885
122.5	95	 47.188
122.5	97	 50.529
123.5	 3	 24.760
123.5	 5	 25.546
123.5	10	 26.869
123.5	25	 29.447
123.5	50	 33.027
123.5	75	 37.703
123.5	90	 43.350
123.5	95	 47.709
123.5	97	 51.091
124.5	 3	 24.953
124.5	 5	 25.752
124.5	10	 27.096
124.5	25	 29.714
124.5	50	 33.348
124.5	75	 38.094
124.5	90	 43.819
124.5	95	 48.234
124.5	97	 51.655
125.5	 3	 25.149
125.5	 5	 25.960
125.5	10	 27.325
125.5	25	 29.984
125.5	50	 33.674
125.5	75	 38.489
125.5	90	 44.293
125.5	95	 48.763
125.5	97	 52.223
126.5	 3	 25.347
126.5	 5	 26.171
126.5	10	 27.557
126.5	25	 30.257
126.5	50	 34.004
126.5	75	 38.889
126.5	90	 44.771
126.5	95	 49.295
126.5	97	 52.793
127.5	 3	 25.548
127.5	 5	 26.385
127.5	10	 27.793
127.5	25	 30.534
127.5	50	 34.338
127.5	75	 39.294
127.5	90	 45.254
127.5	95	 49.831
127.5	97	 53.366
128.5	 3	 25.752
128.5	 5	 26.602
128.5	10	 28.031
128.5	25	 30.815
128.5	50	 34.676
128.5	75	 39.703
128.5	90	 45.740
128.5	95	 50.370
128.5	97	 53.941
129.5	 3	 25.958
129.5	 5	 26.822
129.5	10	 28.273
129.5	25	 31.100
129.5	50	 35.019
129.5	75	 40.116
129.5	90	 46.231
129.5	95	 50.912
129.5	97	 54.518
130.5	 3	 26.168
130.5	 5	 27.045
130.5	10	 28.519
130.5	25	 31.389
130.5	50	 35.366
130.5	75	 40.534
130.5	90	 46.725
130.5	95	 51.458
130.5	97	 55.097
131.5	 3	 26.381
131.5	 5	 27.271
131.5	10	 28.768
131.5	25	 31.682
131.5	50	 35.717
131.5	75	 40.957
131.5	90	 47.223
131.5	95	 52.005
131.5	97	 55.678
132.5	 3	 26.596
132.5	 5	 27.500
132.5	10	 29.021
132.5	25	 31.979
132.5	50	 36.073
132.5	75	 41.384
132.5	90	 47.725
132.5	95	 52.556
132.5	97	 56.260
133.5	 3	 26.815
133.5	 5	 27.733
133.5	10	 29.277
133.5	25	 32.280
133.5	50	 36.433
133.5	75	 41.815
133.5	90	 48.231
133.5	95	 53.109
133.5	97	 56.844
134.5	 3	 27.038
134.5	 5	 27.970
134.5	10	 29.537
134.5	25	 32.585
134.5	50	 36.797
134.5	75	 42.250
134.5	90	 48.739
134.5	95	 53.664
134.5	97	 57.429
135.5	 3	 27.264
135.5	 5	 28.210
135.5	10	 29.801
135.5	25	 32.894
135.5	50	 37.166
135.5	75	 42.689
135.5	90	 49.251
135.5	95	 54.222
135.5	97	 58.015
136.5	 3	 27.493
136.5	 5	 28.454
136.5	10	 30.069
136.5	25	 33.207
136.5	50	 37.539
136.5	75	 43.133
136.5	90	 49.766
136.5	95	 54.781
136.5	97	 58.602
137.5	 3	 27.727
137.5	 5	 28.702
137.5	10	 30.341
137.5	25	 33.525
137.5	50	 37.916
137.5	75	 43.580
137.5	90	 50.284
137.5	95	 55.342
137.5	97	 59.190
138.5	 3	 27.964
138.5	 5	 28.954
138.5	10	 30.617
138.5	25	 33.847
138.5	50	 38.298
138.5	75	 44.031
138.5	90	 50.805
138.5	95	 55.905
138.5	97	 59.778
139.5	 3	 28.205
139.5	 5	 29.210
139.5	10	 30.897
139.5	25	 34.173
139.5	50	 38.684
139.5	75	 44.486
139.5	90	 51.328
139.5	95	 56.469
139.5	97	 60.367
140.5	 3	 28.450
140.5	 5	 29.469
140.5	10	 31.182
140.5	25	 34.503
140.5	50	 39.074
140.5	75	 44.945
140.5	90	 51.853
140.5	95	 57.034
140.5	97	 60.955
141.5	 3	 28.699
141.5	 5	 29.734
141.5	10	 31.470
141.5	25	 34.838
141.5	50	 39.468
141.5	75	 45.407
141.5	90	 52.381
141.5	95	 57.600
141.5	97	 61.544
142.5	 3	 28.953
142.5	 5	 30.002
142.5	10	 31.763
142.5	25	 35.177
142.5	50	 39.866
142.5	75	 45.872
142.5	90	 52.911
142.5	95	 58.167
142.5	97	 62.132
143.5	 3	 29.211
143.5	 5	 30.275
143.5	10	 32.061
143.5	25	 35.521
143.5	50	 40.268
143.5	75	 46.341
143.5	90	 53.443
143.5	95	 58.735
143.5	97	 62.721
144.5	 3	 29.473
144.5	 5	 30.552
144.5	10	 32.362
144.5	25	 35.868
144.5	50	 40.674
144.5	75	 46.813
144.5	90	 53.977
144.5	95	 59.304
144.5	97	 63.309
145.5	 3	 29.739
145.5	 5	 30.833
145.5	10	 32.668
145.5	25	 36.220
145.5	50	 41.084
145.5	75	 47.287
145.5	90	 54.512
145.5	95	 59.872
145.5	97	 63.896
146.5	 3	 30.010
146.5	 5	 31.119
146.5	10	 32.979
146.5	25	 36.577
146.5	50	 41.498
146.5	75	 47.765
146.5	90	 55.048
146.5	95	 60.441
146.5	97	 64.482
147.5	 3	 30.285
147.5	 5	 31.409
147.5	10	 33.294
147.5	25	 36.937
147.5	50	 41.916
147.5	75	 48.245
147.5	90	 55.586
147.5	95	 61.010
147.5	97	 65.068
148.5	 3	 30.565
148.5	 5	 31.704
148.5	10	 33.613
148.5	25	 37.301
148.5	50	 42.336
148.5	75	 48.727
148.5	90	 56.125
148.5	95	 61.579
148.5	97	 65.652
149.5	 3	 30.850
149.5	 5	 32.003
149.5	10	 33.937
149.5	25	 37.670
149.5	50	 42.761
149.5	75	 49.212
149.5	90	 56.664
149.5	95	 62.147
149.5	97	 66.236
150.5	 3	 31.139
150.5	 5	 32.307
150.5	10	 34.265
150.5	25	 38.042
150.5	50	 43.188
150.5	75	 49.699
150.5	90	 57.204
150.5	95	 62.715
150.5	97	 66.818
151.5	 3	 31.432
151.5	 5	 32.616
151.5	10	 34.597
151.5	25	 38.419
151.5	50	 43.619
151.5	75	 50.188
151.5	90	 57.745
151.5	95	 63.282
151.5	97	 67.399
152.5	 3	 31.730
152.5	 5	 32.928
152.5	10	 34.934
152.5	25	 38.799
152.5	50	 44.053
152.5	75	 50.679
152.5	90	 58.286
152.5	95	 63.849
152.5	97	 67.978
153.5	 3	 32.033
153.5	 5	 33.246
153.5	10	 35.275
153.5	25	 39.183
153.5	50	 44.489
153.5	75	 51.171
153.5	90	 58.827
153.5	95	 64.414
153.5	97	 68.555
154.5	 3	 32.341
154.5	 5	 33.567
154.5	10	 35.620
154.5	25	 39.570
154.5	50	 44.928
154.5	75	 51.665
154.5	90	 59.368
154.5	95	 64.979
154.5	97	 69.131
155.5	 3	 32.652
155.5	 5	 33.893
155.5	10	 35.969
155.5	25	 39.961
155.5	50	 45.370
155.5	75	 52.160
155.5	90	 59.908
155.5	95	 65.542
155.5	97	 69.705
156.5	 3	 32.969
156.5	 5	 34.224
156.5	10	 36.322
156.5	25	 40.355
156.5	50	 45.813
156.5	75	 52.656
156.5	90	 60.448
156.5	95	 66.104
156.5	97	 70.277
157.5	 3	 33.289
157.5	 5	 34.558
157.5	10	 36.679
157.5	25	 40.752
157.5	50	 46.259
157.5	75	 53.152
157.5	90	 60.987
157.5	95	 66.664
157.5	97	 70.847
158.5	 3	 33.614
158.5	 5	 34.896
158.5	10	 37.039
158.5	25	 41.152
158.5	50	 46.707
158.5	75	 53.649
158.5	90	 61.526
158.5	95	 67.222
158.5	97	 71.415
159.5	 3	 33.943
159.5	 5	 35.239
159.5	10	 37.403
159.5	25	 41.555
159.5	50	 47.156
159.5	75	 54.146
159.5	90	 62.063
159.5	95	 67.779
159.5	97	 71.981
160.5	 3	 34.276
160.5	 5	 35.585
160.5	10	 37.771
160.5	25	 41.961
160.5	50	 47.607
160.5	75	 54.643
160.5	90	 62.599
160.5	95	 68.334
160.5	97	 72.545
161.5	 3	 34.614
161.5	 5	 35.935
161.5	10	 38.141
161.5	25	 42.368
161.5	50	 48.058
161.5	75	 55.140
161.5	90	 63.134
161.5	95	 68.887
161.5	97	 73.106
162.5	 3	 34.955
162.5	 5	 36.289
162.5	10	 38.515
162.5	25	 42.778
162.5	50	 48.511
162.5	75	 55.637
162.5	90	 63.666
162.5	95	 69.437
162.5	97	 73.665
163.5	 3	 35.300
163.5	 5	 36.646
163.5	10	 38.892
163.5	25	 43.190
163.5	50	 48.964
163.5	75	 56.132
163.5	90	 64.198
163.5	95	 69.985
163.5	97	 74.221
164.5	 3	 35.648
164.5	 5	 37.006
164.5	10	 39.271
164.5	25	 43.603
164.5	50	 49.418
164.5	75	 56.627
164.5	90	 64.726
164.5	95	 70.531
164.5	97	 74.775
165.5	 3	 36.000
165.5	 5	 37.370
165.5	10	 39.653
165.5	25	 44.018
165.5	50	 49.872
165.5	75	 57.120
165.5	90	 65.253
165.5	95	 71.074
165.5	97	 75.326
166.5	 3	 36.355
166.5	 5	 37.736
166.5	10	 40.037
166.5	25	 44.434
166.5	50	 50.325
166.5	75	 57.612
166.5	90	 65.777
166.5	95	 71.615
166.5	97	 75.875
167.5	 3	 36.713
167.5	 5	 38.105
167.5	10	 40.423
167.5	25	 44.851
167.5	50	 50.779
167.5	75	 58.103
167.5	90	 66.299
167.5	95	 72.152
167.5	97	 76.421
168.5	 3	 37.073
168.5	 5	 38.476
168.5	10	 40.811
168.5	25	 45.268
168.5	50	 51.231
168.5	75	 58.591
168.5	90	 66.818
168.5	95	 72.687
168.5	97	 76.964
169.5	 3	 37.437
169.5	 5	 38.849
169.5	10	 41.201
169.5	25	 45.686
169.5	50	 51.682
169.5	75	 59.077
169.5	90	 67.334
169.5	95	 73.218
169.5	97	 77.504
170.5	 3	 37.802
170.5	 5	 39.224
170.5	10	 41.591
170.5	25	 46.104
170.5	50	 52.132
170.5	75	 59.560
170.5	90	 67.846
170.5	95	 73.747
170.5	97	 78.041
171.5	 3	 38.170
171.5	 5	 39.601
171.5	10	 41.983
171.5	25	 46.522
171.5	50	 52.581
171.5	75	 60.040
171.5	90	 68.355
171.5	95	 74.272
171.5	97	 78.576
172.5	 3	 38.539
172.5	 5	 39.979
172.5	10	 42.375
172.5	25	 46.938
172.5	50	 53.027
172.5	75	 60.518
172.5	90	 68.861
172.5	95	 74.793
172.5	97	 79.107
173.5	 3	 38.910
173.5	 5	 40.358
173.5	10	 42.767
173.5	25	 47.354
173.5	50	 53.471
173.5	75	 60.992
173.5	90	 69.362
173.5	95	 75.311
173.5	97	 79.635
174.5	 3	 39.282
174.5	 5	 40.738
174.5	10	 43.160
174.5	25	 47.769
174.5	50	 53.913
174.5	75	 61.462
174.5	90	 69.860
174.5	95	 75.826
174.5	97	 80.161
175.5	 3	 39.655
175.5	 5	 41.119
175.5	10	 43.552
175.5	25	 48.182
175.5	50	 54.351
175.5	75	 61.929
175.5	90	 70.353
175.5	95	 76.336
175.5	97	 80.682
176.5	 3	 40.029
176.5	 5	 41.499
176.5	10	 43.943
176.5	25	 48.594
176.5	50	 54.787
176.5	75	 62.391
176.5	90	 70.843
176.5	95	 76.843
176.5	97	 81.201
177.5	 3	 40.402
177.5	 5	 41.879
177.5	10	 44.334
177.5	25	 49.003
177.5	50	 55.219
177.5	75	 62.849
177.5	90	 71.327
177.5	95	 77.345
177.5	97	 81.716
178.5	 3	 40.776
178.5	 5	 42.259
178.5	10	 44.723
178.5	25	 49.409
178.5	50	 55.647
178.5	75	 63.302
178.5	90	 71.807
178.5	95	 77.843
178.5	97	 82.228
179.5	 3	 41.149
179.5	 5	 42.638
179.5	10	 45.111
179.5	25	 49.813
179.5	50	 56.071
179.5	75	 63.750
179.5	90	 72.282
179.5	95	 78.337
179.5	97	 82.736
180.5	 3	 41.522
180.5	 5	 43.015
180.5	10	 45.496
180.5	25	 50.214
180.5	50	 56.491
180.5	75	 64.193
180.5	90	 72.751
180.5	95	 78.827
180.5	97	 83.240
181.5	 3	 41.893
181.5	 5	 43.391
181.5	10	 45.880
181.5	25	 50.611
181.5	50	 56.906
181.5	75	 64.631
181.5	90	 73.215
181.5	95	 79.311
181.5	97	 83.741
182.5	 3	 42.263
182.5	 5	 43.765
182.5	10	 46.260
182.5	25	 51.004
182.5	50	 57.316
182.5	75	 65.063
182.5	90	 73.674
182.5	95	 79.791
182.5	97	 84.237
183.5	 3	 42.631
183.5	 5	 44.136
183.5	10	 46.638
183.5	25	 51.393
183.5	50	 57.721
183.5	75	 65.489
183.5	90	 74.127
183.5	95	 80.266
183.5	97	 84.730
184.5	 3	 42.996
184.5	 5	 44.505
184.5	10	 47.012
184.5	25	 51.778
184.5	50	 58.121
184.5	75	 65.909
184.5	90	 74.575
184.5	95	 80.736
184.5	97	 85.218
185.5	 3	 43.359
185.5	 5	 44.871
185.5	10	 47.383
185.5	25	 52.158
185.5	50	 58.515
185.5	75	 66.323
185.5	90	 75.016
185.5	95	 81.201
185.5	97	 85.702
186.5	 3	 43.719
186.5	 5	 45.233
186.5	10	 47.750
186.5	25	 52.534
186.5	50	 58.903
186.5	75	 66.731
186.5	90	 75.451
186.5	95	 81.660
186.5	97	 86.182
187.5	 3	 44.075
187.5	 5	 45.592
187.5	10	 48.112
187.5	25	 52.903
187.5	50	 59.285
187.5	75	 67.131
187.5	90	 75.880
187.5	95	 82.114
187.5	97	 86.657
188.5	 3	 44.428
188.5	 5	 45.946
188.5	10	 48.470
188.5	25	 53.268
188.5	50	 59.660
188.5	75	 67.525
188.5	90	 76.302
188.5	95	 82.562
188.5	97	 87.127
189.5	 3	 44.776
189.5	 5	 46.296
189.5	10	 48.822
189.5	25	 53.626
189.5	50	 60.029
189.5	75	 67.912
189.5	90	 76.717
189.5	95	 83.004
189.5	97	 87.591
190.5	 3	 45.120
190.5	 5	 46.641
190.5	10	 49.170
190.5	25	 53.979
190.5	50	 60.392
190.5	75	 68.292
190.5	90	 77.126
190.5	95	 83.440
190.5	97	 88.051
191.5	 3	 45.459
191.5	 5	 46.981
191.5	10	 49.511
191.5	25	 54.325
191.5	50	 60.747
191.5	75	 68.665
191.5	90	 77.528
191.5	95	 83.869
191.5	97	 88.505
192.5	 3	 45.793
192.5	 5	 47.316
192.5	10	 49.847
192.5	25	 54.665
192.5	50	 61.095
192.5	75	 69.030
192.5	90	 77.922
192.5	95	 84.292
192.5	97	 88.953
193.5	 3	 46.121
193.5	 5	 47.645
193.5	10	 50.177
193.5	25	 54.998
193.5	50	 61.437
193.5	75	 69.388
193.5	90	 78.310
193.5	95	 84.709
193.5	97	 89.395
194.5	 3	 46.444
194.5	 5	 47.967
194.5	10	 50.501
194.5	25	 55.325
194.5	50	 61.771
194.5	75	 69.739
194.5	90	 78.690
194.5	95	 85.118
194.5	97	 89.831
195.5	 3	 46.760
195.5	 5	 48.284
195.5	10	 50.817
195.5	25	 55.644
195.5	50	 62.097
195.5	75	 70.082
195.5	90	 79.063
195.5	95	 85.521
195.5	97	 90.260
196.5	 3	 47.069
196.5	 5	 48.593
196.5	10	 51.128
196.5	25	 55.956
196.5	50	 62.416
196.5	75	 70.417
196.5	90	 79.428
196.5	95	 85.916
196.5	97	 90.683
197.5	 3	 47.372
197.5	 5	 48.896
197.5	10	 51.431
197.5	25	 56.262
197.5	50	 62.728
197.5	75	 70.744
197.5	90	 79.785
197.5	95	 86.304
197.5	97	 91.098
198.5	 3	 47.668
198.5	 5	 49.192
198.5	10	 51.727
198.5	25	 56.559
198.5	50	 63.032
198.5	75	 71.064
198.5	90	 80.135
198.5	95	 86.684
198.5	97	 91.506
199.5	 3	 47.957
199.5	 5	 49.480
199.5	10	 52.015
199.5	25	 56.850
199.5	50	 63.329
199.5	75	 71.377
199.5	90	 80.477
199.5	95	 87.057
199.5	97	 91.906
200.5	 3	 48.238
200.5	 5	 49.762
200.5	10	 52.296
200.5	25	 57.133
200.5	50	 63.618
200.5	75	 71.681
200.5	90	 80.811
200.5	95	 87.421
200.5	97	 92.298
201.5	 3	 48.512
201.5	 5	 50.035
201.5	10	 52.570
201.5	25	 57.408
201.5	50	 63.900
201.5	75	 71.978
201.5	90	 81.137
201.5	95	 87.777
201.5	97	 92.681
202.5	 3	 48.778
202.5	 5	 50.301
202.5	10	 52.836
202.5	25	 57.676
202.5	50	 64.174
202.5	75	 72.267
202.5	90	 81.455
202.5	95	 88.125
202.5	97	 93.056
203.5	 3	 49.036
203.5	 5	 50.559
203.5	10	 53.095
203.5	25	 57.936
203.5	50	 64.440
203.5	75	 72.549
203.5	90	 81.765
203.5	95	 88.465
203.5	97	 93.422
204.5	 3	 49.287
204.5	 5	 50.810
204.5	10	 53.345
204.5	25	 58.189
204.5	50	 64.700
204.5	75	 72.823
204.5	90	 82.067
204.5	95	 88.795
204.5	97	 93.779
205.5	 3	 49.529
205.5	 5	 51.052
205.5	10	 53.589
205.5	25	 58.435
205.5	50	 64.952
205.5	75	 73.090
205.5	90	 82.362
205.5	95	 89.117
205.5	97	 94.126
206.5	 3	 49.764
206.5	 5	 51.287
206.5	10	 53.824
206.5	25	 58.673
206.5	50	 65.197
206.5	75	 73.349
206.5	90	 82.648
206.5	95	 89.430
206.5	97	 94.464
207.5	 3	 49.990
207.5	 5	 51.514
207.5	10	 54.052
207.5	25	 58.904
207.5	50	 65.434
207.5	75	 73.602
207.5	90	 82.926
207.5	95	 89.734
207.5	97	 94.791
208.5	 3	 50.209
208.5	 5	 51.733
208.5	10	 54.273
208.5	25	 59.128
208.5	50	 65.665
208.5	75	 73.847
208.5	90	 83.196
208.5	95	 90.029
208.5	97	 95.108
209.5	 3	 50.420
209.5	 5	 51.945
209.5	10	 54.486
209.5	25	 59.345
209.5	50	 65.890
209.5	75	 74.085
209.5	90	 83.458
209.5	95	 90.314
209.5	97	 95.414
210.5	 3	 50.623
210.5	 5	 52.149
210.5	10	 54.692
210.5	25	 59.555
210.5	50	 66.107
210.5	75	 74.317
210.5	90	 83.712
210.5	95	 90.590
210.5	97	 95.709
211.5	 3	 50.819
211.5	 5	 52.346
211.5	10	 54.891
211.5	25	 59.758
211.5	50	 66.319
211.5	75	 74.542
211.5	90	 83.958
211.5	95	 90.856
211.5	97	 95.993
212.5	 3	 51.007
212.5	 5	 52.536
212.5	10	 55.083
212.5	25	 59.955
212.5	50	 66.524
212.5	75	 74.760
212.5	90	 84.197
212.5	95	 91.114
212.5	97	 96.267
213.5	 3	 51.188
213.5	 5	 52.718
213.5	10	 55.268
213.5	25	 60.146
213.5	50	 66.724
213.5	75	 74.973
213.5	90	 84.428
213.5	95	 91.361
213.5	97	 96.528
214.5	 3	 51.362
214.5	 5	 52.895
214.5	10	 55.447
214.5	25	 60.332
214.5	50	 66.918
214.5	75	 75.179
214.5	90	 84.651
214.5	95	 91.599
214.5	97	 96.779
215.5	 3	 51.530
215.5	 5	 53.064
215.5	10	 55.620
215.5	25	 60.511
215.5	50	 67.106
215.5	75	 75.380
215.5	90	 84.867
215.5	95	 91.828
215.5	97	 97.018
216.5	 3	 51.691
216.5	 5	 53.227
216.5	10	 55.787
216.5	25	 60.685
216.5	50	 67.290
216.5	75	 75.575
216.5	90	 85.076
216.5	95	 92.048
216.5	97	 97.246
217.5	 3	 51.846
217.5	 5	 53.385
217.5	10	 55.949
217.5	25	 60.854
217.5	50	 67.469
217.5	75	 75.765
217.5	90	 85.278
217.5	95	 92.258
217.5	97	 97.462
218.5	 3	 51.995
218.5	 5	 53.537
218.5	10	 56.105
218.5	25	 61.019
218.5	50	 67.643
218.5	75	 75.950
218.5	90	 85.474
218.5	95	 92.459
218.5	97	 97.667
219.5	 3	 52.138
219.5	 5	 53.683
219.5	10	 56.256
219.5	25	 61.178
219.5	50	 67.813
219.5	75	 76.130
219.5	90	 85.662
219.5	95	 92.652
219.5	97	 97.861
220.5	 3	 52.276
220.5	 5	 53.824
220.5	10	 56.403
220.5	25	 61.334
220.5	50	 67.979
220.5	75	 76.306
220.5	90	 85.845
220.5	95	 92.836
220.5	97	 98.044
221.5	 3	 52.409
221.5	 5	 53.961
221.5	10	 56.545
221.5	25	 61.486
221.5	50	 68.141
221.5	75	 76.478
221.5	90	 86.021
221.5	95	 93.011
221.5	97	 98.217
222.5	 3	 52.537
222.5	 5	 54.093
222.5	10	 56.683
222.5	25	 61.634
222.5	50	 68.300
222.5	75	 76.645
222.5	90	 86.192
222.5	95	 93.179
222.5	97	 98.380
223.5	 3	 52.661
223.5	 5	 54.220
223.5	10	 56.817
223.5	25	 61.779
223.5	50	 68.456
223.5	75	 76.809
223.5	90	 86.357
223.5	95	 93.340
223.5	97	 98.534
224.5	 3	 52.780
224.5	 5	 54.344
224.5	10	 56.947
224.5	25	 61.920
224.5	50	 68.609
224.5	75	 76.970
224.5	90	 86.518
224.5	95	 93.494
224.5	97	 98.678
225.5	 3	 52.896
225.5	 5	 54.464
225.5	10	 57.074
225.5	25	 62.058
225.5	50	 68.759
225.5	75	 77.128
225.5	90	 86.674
225.5	95	 93.641
225.5	97	 98.815
226.5	 3	 53.007
226.5	 5	 54.580
226.5	10	 57.197
226.5	25	 62.194
226.5	50	 68.907
226.5	75	 77.283
226.5	90	 86.826
226.5	95	 93.783
226.5	97	 98.945
227.5	 3	 53.114
227.5	 5	 54.692
227.5	10	 57.317
227.5	25	 62.327
227.5	50	 69.052
227.5	75	 77.436
227.5	90	 86.975
227.5	95	 93.920
227.5	97	 99.068
228.5	 3	 53.217
228.5	 5	 54.801
228.5	10	 57.434
228.5	25	 62.457
228.5	50	 69.195
228.5	75	 77.586
228.5	90	 87.120
228.5	95	 94.053
228.5	97	 99.186
229.5	 3	 53.317
229.5	 5	 54.906
229.5	10	 57.547
229.5	25	 62.584
229.5	50	 69.335
229.5	75	 77.734
229.5	90	 87.263
229.5	95	 94.183
229.5	97	 99.301
230.5	 3	 53.412
230.5	 5	 55.006
230.5	10	 57.657
230.5	25	 62.708
230.5	50	 69.474
230.5	75	 77.880
230.5	90	 87.405
230.5	95	 94.310
230.5	97	 99.413
231.5	 3	 53.503
231.5	 5	 55.103
231.5	10	 57.763
231.5	25	 62.829
231.5	50	 69.609
231.5	75	 78.025
231.5	90	 87.545
231.5	95	 94.438
231.5	97	 99.525
232.5	 3	 53.589
232.5	 5	 55.196
232.5	10	 57.865
232.5	25	 62.947
232.5	50	 69.742
232.5	75	 78.167
232.5	90	 87.685
232.5	95	 94.565
232.5	97	 99.638
233.5	 3	 53.670
233.5	 5	 55.283
233.5	10	 57.962
233.5	25	 63.060
233.5	50	 69.872
233.5	75	 78.309
233.5	90	 87.825
233.5	95	 94.695
233.5	97	 99.755
234.5	 3	 53.745
234.5	 5	 55.364
234.5	10	 58.053
234.5	25	 63.169
234.5	50	 69.999
234.5	75	 78.448
234.5	90	 87.966
234.5	95	 94.829
234.5	97	 99.877
235.5	 3	 53.813
235.5	 5	 55.439
235.5	10	 58.139
235.5	25	 63.272
235.5	50	 70.121
235.5	75	 78.586
235.5	90	 88.110
235.5	95	 94.967
235.5	97	100.008
236.5	 3	 53.874
236.5	 5	 55.506
236.5	10	 58.217
236.5	25	 63.368
236.5	50	 70.239
236.5	75	 78.722
236.5	90	 88.256
236.5	95	 95.113
236.5	97	100.149
237.5	 3	 53.925
237.5	 5	 55.564
237.5	10	 58.286
237.5	25	 63.457
237.5	50	 70.350
237.5	75	 78.856
237.5	90	 88.406
237.5	95	 95.269
237.5	97	100.305
238.5	 3	 53.966
238.5	 5	 55.612
238.5	10	 58.345
238.5	25	 63.537
238.5	50	 70.455
238.5	75	 78.988
238.5	90	 88.562
238.5	95	 95.436
238.5	97	100.478
239.5	 3	 53.995
239.5	 5	 55.648
239.5	10	 58.392
239.5	25	 63.606
239.5	50	 70.553
239.5	75	 79.118
239.5	90	 88.723
239.5	95	 95.617
239.5	97	100.672
240.0	 3	 54.004
240.0	 5	 55.661
240.0	10	 58.411
240.0	25	 63.636
240.0	50	 70.598
240.0	75	 79.181
240.0	90	 88.806
240.0	95	 95.714
240.0	97	100.778
