#!/usr/bin/perl
# $File: //depot/libOurNet/FuzzyIndex/Makefile.PL $ $Author: autrijus $
# $Revision: #2 $ $Change: 3769 $ $DateTime: 2003/01/24 00:06:25 $

require 5.005;

my $path = 'blib/lib/OurNet/ChatBot';

builddb() if grep { /^--builddb$/ } @ARGV;

use ExtUtils::MakeMaker;

*{'MY::postamble'} = sub {
    return << ".";
linkext :: builddb

builddb ::
	\$(PERL) $0 --builddb
.
};

WriteMakefile(
    AUTHOR		=> 'Autrijus Tang (autrijus@autrijus.org)',
    ABSTRACT		=> 'Inverted search for double-byte characters',
    NAME		=> 'OurNet::FuzzyIndex',
    VERSION_FROM	=> 'FuzzyIndex.pm',
    XSPROTOARG		=> '-noprototypes',
    DISTNAME		=> 'OurNet-FuzzyIndex',
    BINARY_LOCATION	=> 'x86/OurNet-FuzzyIndex.tar.gz',

    PREREQ_PM		=> {
        DB_File		=> '1.54', # FuzzyIndex
    },

    EXE_FILES		=> [ <bin/*> ],

    dist		=> {
        COMPRESS	=> 'gzip',
        SUFFIX		=> '.gz',
    }
);

### BuildDB ###############################################################

sub builddb {
    # ok, we're doing something totally evil here.
    unshift @INC, ('blib/lib', 'blib/arch');
    require OurNet::ChatBot;

    unlink 'fianjmo.db'; # XXX: remove legacy DBs
    mkdir $path, 0777;
    my $db = OurNet::ChatBot->new('fianjmo', "$path/fianjmo.db", 1);

    unless ($db->{db}{idxcount}) {
	local $| = 1;
	print "*** Building fianjmo.db, please wait...";

	my ($user, $lastmsg) = ('','');

	while (<DATA>) {
	    chomp;
	    if (substr($_, 0, 10) eq '<fianjmo> ') {
		# do something about user
		my $trig = substr($_, 10);
		my ($caller, $message);

		if (substr($user, 0, 1) eq '{') {
		    $caller  = substr($user, 1, index($user, '}')-1);
		    $message = substr($user, index($user, '}') + 2);
		}
		elsif (substr($user, 0, 1) eq '[') {
		    $caller  = substr($user, 1, index($user, ']')-1);
		    next if length($user) <= index($user, ']') + 2;
		    $message = substr($user, index($user, ']') + 2);
		}

		next if !$caller;
		next if !$message;

		$message =~ s/^\s+//;
		$message =~ s/\s+$//;

		next if length($message) <= 12 or index($message, 'fianjmo') > -1
			or index($message, '') > -1 
			or index($message, 'I') > -1
			or substr($lastmsg, 0, 6) eq substr($message, 0, 6);

		$caller =~ s|[\\\/]|-|g;
		next if $message eq $lastmsg;
		$db->addentry($message, "$trig $lastmsg");

		$lastmsg = $message;
	    }
	    else {
		$user = $_;
	    }
	}

	print " done.\n";
    }
}

__DATA__
[Annerose] ߪ{ljFC
<fianjmo> θ³ss姹PAMܰbnAIۤbBP
[Annerose] iORC
<fianjmo> pp񪺡A]SêۤC
[Annerose] 䥴qYF|ťMC
<fianjmo> DNC
[Annerose] ѧڤQXC
<fianjmo> oۧڡAڲo۫BʡAnnʬۺ}GȤlAOڪffC
[Annerose] UB٥Xhn֡C
<fianjmo> û|@өҦbApRIA{Y@@uC
[Annerose] ӬO줣FC
<fianjmo> LC
[Annerose] LOڭC]_^C
<fianjmo> DڪoܤcH
[Annerose] lpC
<fianjmo> biaݡC
[Annerose] oدkӴdsFC
<fianjmo> N⤣]|`AO@aFA@waH
[Annerose] p⤣FܡH
<fianjmo> ]ob̡AҥHLkaC
[Annerose] oؤٴanNCC
<fianjmo> pop檺 F.M.N. @w]ܱoFzjPHxC
[Annerose] ua믫³jA´ӲӤFC
<fianjmo> qvu˷RAڧĤlܤpFveMiC
[Annerose] ڪWOߧ쪺˲@C
<fianjmo> N@ӬݤjApݱobeADbp᭱oͪC
[Annerose] ߤSOA|hlۤvڶ]C
<fianjmo> @}AƨӥLuınѮvA|_ӡC
[Annerose] ΤۤFAYnhOC
<fianjmo> VѪx_OǦ⪺AM᪺NqLLokV俽LC
[Annerose] V٨SALVuhC
<fianjmo> ťcall in AMH`C
[Annerose] MH`bKѡC
<fianjmo> ɤ]N101 MkAZЫǡC
[Annerose] ڰQCCC
<fianjmo> ¶F@馨\C
[Annerose] iHڡCs̪ܬ@C
<fianjmo> غݧALLt@LAZMe諸ΪAC
[Annerose] گuQboش䯲ӤpΤlC
<fianjmo> ݱo@ʲӲӽGGjplAݱoǡC
[Annerose] nAڰQlC
<fianjmo> ڦb|ӥJӿ{ۼx֦b޳ۡC
[Annerose] ݱoMܡH]há^
<fianjmo> ]\AoӫAoqAoϤWW\aH
[Annerose] ӳo\h\nApuݱC
<fianjmo> DOO]Ӥ[S@ӤHݹqvAPıǩǪC
[Annerose] p̳ݦnhqv@C
<fianjmo> ŪŪAqDLC
[Annerose] qv|NuNC
<fianjmo> {YBbշt...w֦`߻PæsAڷP@}}iƪH
[Annerose] ڳhݮƤCCC
<fianjmo> ٬Owwǫ~ꪺզBŦAʸ]@˱``ۡC
[Annerose] ʸ@nǹдNC
<fianjmo> զN\pɡC
[Annerose] oت\F]BzAӥB{bUUnC
<fianjmo> DڪoܤcH
[Annerose] lp]SlXӡ^C
<fianjmo> SHaRPıAuOQyۦaAίvıC
[Annerose] ο|WNjAߨiߪ~§C
<fianjmo> ѪߡC
[Annerose] ϥOonYNFC
<fianjmo> nOѤOΥFASIWoǤpnyyaFAڤNJFH
[Annerose] ڡApۡC
<fianjmo> Ҧ񪺫Hqa@ΥսuyC
[Annerose] sp}ӪuyC
<fianjmo> Oı]nQǦ⪺ŮC
[Annerose] p}Oǿ߮@C
<fianjmo> Ayݦbo˪ѪŤUӤ[C
[Annerose] o˪ѪŧڳwAǦǪC
<fianjmo> OoӬ֦anboөu`wR@ǡC
[Annerose] pylɭٯuIoC
<fianjmo> ~FnhTӤAWŤUTAŤUզBBlBL
[Annerose] niR]ߡ^CCC
<fianjmo> uաAwաAnnAk̡̮Aհշfշfհաv
[Annerose] ]iOIұPı....^
<fianjmo> ϩoӥ@ɤ@OuANbݹqv@C
[Annerose] ]߰_ӡ^C
<fianjmo> @ӤH}aۤv줰{סH_ǪOAqӴNyXC
[Annerose] yݧԪƦh۩OC
<fianjmo> jۤvAG_@ڡANONBBA@仡ܤ@|ۤvC
[Annerose] ]SlXӡ^C
<fianjmo> KA_믫C
[Annerose] {b log Aܤ@y|AHɥi঳[C^^;;
<fianjmo> ]\AoӫAoqAoϤWW\aH
[Annerose] ]Yn^
<fianjmo> [WզťۦnťnAıoӥ@ɬXM_ӡC
[Annerose] ]\NOpbaC
<fianjmo> AۤvQOӪC
[Annerose] iOڭ̳bMpC
<fianjmo> Ȧ檺تAn]uObTwIsbC
[Annerose] DSINXoȦA٬yC
<fianjmo> }BPAӪ``ڳݤLC
[Annerose] ohHAoPCL̳OӤVOH
<fianjmo> @sHn``YhAQnò]ڪnioRC
[Annerose] }ǫܦnAiHǦnhsƱC
<fianjmo> nSkαb@_AnͬQjwaζ}@ˡC
[Annerose] ˪yH
<fianjmo> @RRay\Ao@ݷaC
[Annerose] unAڳwC
<fianjmo> bȳ~HN@ӤH쥻Ӥ|yXC
[Annerose] ˪H
<fianjmo> ]QNѨۧڦӨJHsA߸YR۵LתC
[Annerose] bHsϦӦۧڧeQNѨAɭԡC
<fianjmo> ۧXvaA򳣤QB򳣬ݡB򳣨SC
[Annerose] ڡAoӬOzʪXoICC
<fianjmo> ]\ڭ̳nA۹@IC
[Annerose] Mzʤ]OɪNOC
<fianjmo> @ʵݪC
[Annerose] ڳo˨|^˪C
<fianjmo> @ӤHѩiHݨnߡAΩȨ䪺H@СC
[Annerose] HeڦnQbϮ]̭AϮ]ȩ]ZHC
<fianjmo> ٯťWYH}BnAۦaAInAOܥOHwߡC
[Annerose] ]Bc̪eGAUӶbѥ]W^
<fianjmo> Cݨ줣{ѪӪAĤ@Ӷ]i`OդlŪָgihx
[Annerose] ]pݡAylӪFա^
<fianjmo> WX{NRzʪ@AD`zC
[Annerose] ]ڭ˷QݬyzʡAKK^
<fianjmo> M]Oۤvw@̡Ao@SQnѶR^aC
[Annerose] NOpw٨Sǿ{סC
<fianjmo> ڷPͩRQܮzAȦ]ۤ@ةt檺PıN|͵LH~YC
[Annerose] ڰڰڡAʪgӬ@ϳoӥ@ɦnF]z^C
<fianjmo> pGAڷ|ӪyNnFC
[Annerose] HyO@ySҡC
<fianjmo> ̵۪ıAש󶶧QFMjfA@iժNԤĤ@ehC
[Annerose] ]ªu^
<fianjmo> DڪoܤcH
[Annerose] ]AlXӡ^C
<fianjmo> O@͸̥u@C
[Annerose] ܦnApiHCѥHoشdM߷lC
<fianjmo> zL@ةvʡAM\hgbC
[Annerose] iO{bܦhvOӦhʡCCC
<fianjmo> iHOΪ|BAiHOLΪNۧڱqҳBҦaC
[Annerose] LΪAunɶ@٬OɵDC
<fianjmo> CӬPѦAڲߺDbYL\A}l@ӲMkuu@C
[Annerose] ڰڰڡAoOڳ̳wu@I]ߡ^
<fianjmo> bpî몺nAaaBAKVO^~@gֿn
[Annerose] i{bioFC
<fianjmo> V`OڷQ۩_ǪDOH
[Annerose] V٨SCӥBڬݩpQ_ǰDڥSu`C
<fianjmo> o˪BäPɸb@ɪC
[Annerose] H
<fianjmo> bѾWA@ɬOnC
[Annerose] ̪ѾPıQ@ˡAnMIC
<fianjmo> ߱@CK}lQoQAƳeͮC
[Annerose] ڬQѱߤWٺLFAja~aFC
<fianjmo> ˪OD~nADC
[Annerose] ͮNUFhաC
<fianjmo> ڭ̴NoˬwFI
[Annerose] ]۹JHpLX^
<fianjmo> AڳMppaAɶAtayhC
[Annerose] ڭ̳|ѦƥۡC
<fianjmo> ȦӤwC
[Annerose] ܦhe̳õ۲\ڡC
<fianjmo> LΪAunɶ@٬OɵDC
[Annerose] iHۭtߡC
<fianjmo> unAڳwC
[Annerose] pwۭtߡAOaĤlC
<fianjmo> ߻氮MC
[Annerose] @U@UC
<fianjmo> ӬO줣FC
[Annerose] @}YAߴNDӤFC
<fianjmo> WhwHHAҦpyĬBĤC
[Annerose] AHܳwHHܡH
<fianjmo> ]DOOƤjKOAowժC
[Annerose] ]@u^
<fianjmo> ڪDo˰nC
[Annerose] pٯH
<fianjmo> ۧکҤtqAOݯdQںۡC
[Annerose] nȡC
<fianjmo> qBݵۡCo˯uOwC
[Annerose] yzʬOH
<fianjmo> OڡC۹O̦nF
[Annerose] wC
<fianjmo> Ӧ۶ƩۤvOFܡH
[Annerose] DwO@دOOH
<fianjmo> LOղ`UC
[Annerose] OogOMBDC
<fianjmo> ڥuOݦb@Ӥ]\aC
[Annerose] Ap^ӡC
<fianjmo> AwAڪF.M.N.|@ŭI
[Annerose] nYܡH
<fianjmo> ٦bQߥ۫e稵h^AڭnݲH⪺}}I
[Annerose] n_ǪӪC
<fianjmo> ätc@Ӥ@Ӷ}FA}CHAƬOwC
[Annerose] ]}l^Qtˤl^
<fianjmo> MMHHAAO׫p]QFC
[Annerose] ]iiHn᪺Ʊڡ^
<fianjmo> OӤi઺@ڡC
[Annerose] powܡH
<fianjmo> רۤvճo򰵷|ˮ`YǤHC
[Annerose] iP۹AoNߨƳzSHC
<fianjmo> @hdۡBaWaUC
[Annerose] OHbylWӥhۦpC
<fianjmo> jOtI`ŮbC
[Annerose] w]`^C
<fianjmo> tFӪӤ[A}losVѪBC
[Annerose] O@حnCѭˤC
<fianjmo> ڦӨAۯ_߲zġC
[Annerose] pGpˤAܧִNܦo󪫡C
<fianjmo> NnC
[Annerose] pǱouOOHY֡C
<fianjmo> pGAڷ|ӪyNnFC
[Annerose] ӪyMy̬ۦOH
<fianjmo> yF骺A@Ӥ@ӷQnbkC
[Annerose] oOߪyC
<fianjmo> ̵۪ıAש󶶧QFMjfA@iժNԤĤ@ehC
[Annerose] pP쪺ƪٯu֡C
<fianjmo> S@iugrAonhnh¸᪺६C
[Annerose] ६WϮ׸õۥëANBWJ誺@ˡC
<fianjmo> gUFANA]|uC
[Annerose] OAOH@_UAMOb̡ܸC
<fianjmo> LyAhkӪu`C
[Annerose] LѭnFC
<fianjmo> ѰڡAn}ǤFC
[Annerose] pnsFiHǤFOC
<fianjmo> pGܡANnRFC
[Annerose] OCOH
<fianjmo> a۱jP۫HAHpتCAUNLuC
[Annerose] oC ^^;;;;
<fianjmo> {b log Aܤ@y|AHɥi঳[C^^;;
[Annerose] OOAکդFC
<fianjmo> powܡH
[Annerose] nAӰDC
<fianjmo> ڥuO@ߡCubaH^ӡC
[Annerose] ߤ~Oo̿HʪC
<fianjmo> jNuگn_aCڤ@Vn_C
[Annerose] OpݿߡA]OpݤHC
<fianjmo> ڤ߷RĢC
[Annerose] H
<fianjmo> AӤ@ۭtLC
[Annerose] ڨSI]ĳ^
<fianjmo> ڷ|beݵۡC
[Annerose] ߩMѨϳ߷R[ݡC
<fianjmo> Lai}AۡConǤH
[Annerose] ѨϪlQӦ۹LhɧjVӡC
<fianjmo> ڤDڬO֡C
[Annerose] oOӦnDAoOӦnסC
<fianjmo> oHi|o˻{C
[Annerose] p{OH
<fianjmo> UӴNOݯfBwBQIwC
[Annerose] oOpu@A٬OpRBH
<fianjmo> cäAPo򭫡C
[Annerose] yMPäOPcC
<fianjmo> ڡCuOaC
[Annerose] ڰڰڡAp{ѦۤvˡC
<fianjmo> pGAڷ|ӪyNnFC
[Annerose] nδӪyLqܡH
<fianjmo> yF骺A@Ӥ@ӷQnbkC
[Annerose] kOkC
<fianjmo> \Oï]C
[Annerose] po_ܡH
<fianjmo> [Ӥ[AHsMګKF۩ӪŶAפ߮ΡC
[Annerose] HʪFiHzѬyC
<fianjmo> qb@Ṵ˥qܪѤ]nnC
[Annerose] ୫ơC
<fianjmo> pٯH
[Annerose] ҥ鯫AiгyC
<fianjmo> ϥOonYNFC
[Annerose] iO@دtC
<fianjmo> OogOMBDC
[Annerose] MӦbZA۵M]shڰסC
<fianjmo> pOO]^C
[Annerose] ݤɷ|{ɨȡC
<fianjmo> Mzʤ]OɪNOC
[Annerose] zʬOH
<fianjmo> yzʬOH
[Annerose] onhyHC
<fianjmo> ڳo˨|^˪C
[Annerose] ^˦bZZۤWAp߸IڹڷQw[ҡC
<fianjmo> HeڦnQbϮ]̭AϮ]ȩ]ZHC
[Annerose] {b٬OܷQC
<fianjmo> ]ıoOpbڪ....^
[Annerose] C
<fianjmo> ]۹JHpLX^
[Annerose] pݧڤOɶAڤϦӵWӡC
<fianjmo> w]`^C
[Annerose] Ȧw]L^C
<fianjmo> iHڡCs̪ܬ@C
[Annerose] bpĪڸ̡A|@bW۳\hӴC
<fianjmo> ʮqڴNSťLFCo}o]KӱߤFC
[Annerose] y`ObHQFҦC
<fianjmo> HʪFiHzѬyC
[Annerose] oOPNyqu㤣@˪_lIC
<fianjmo> nδӪyLqܡH
[Annerose] noӪyC
<fianjmo> pǱouOOHY֡C
[Annerose] ڤrC
<fianjmo> AHܳwHHܡH
[Annerose] GGoo]O@تFAMiणOܥOHr֡C
<fianjmo> HeڦnQbϮ]̭AϮ]ȩ]ZHC
[Annerose] ѭn~AbϮ]̻P_AMoLC
<fianjmo> `ϴNOoˡA{bs`Ϻ}GiOܧNHC
[Annerose] nಾDC
<fianjmo> ݱoMܡH]há^
[Annerose] häHhépbhöܡH
<fianjmo> ӳo\h\nApuݱC
[Annerose] häHhépbhöܡH
<fianjmo> uOAoˤsôb߱AणনOqHڤDC
[Annerose] ɶ|Noؤ߱絹pC
<fianjmo> {bּ֤±LMŧWtWPC
[Annerose] tWPOAiOMּ̨֨äۥC
<fianjmo> pGڥûHBͪ߱ݨ䪺CӤHNnFC
[Annerose] ǤHAȶȬOB͡C
<fianjmo> ҦbO@߮UC
[Annerose] A_ͳQdbaH
<fianjmo> qɰ_BF]ӰQBAwgSuC
[Annerose] ڳwBC
<fianjmo> FC
[Annerose] ٦OH
<fianjmo> ӪBͮa̪NswwC
[Annerose] ڤwAڳwߡC
<fianjmo> Toܻ{uAC
[Annerose] wMO@{uơC
<fianjmo> pæb̩OH
[Annerose] @өp䤣쪺aC
<fianjmo> poʪgC
[Annerose] ڥuRѦgC
<fianjmo> ɭԧѷh^aH
[Annerose] ӧ֤FC
<fianjmo> HHAڦpQpXfܡC
[Annerose] JMSXfAppQLC
<fianjmo> ¡A@p]֡C
[Annerose] ȦwC
<fianjmo> uOnR㨺ǤpuO}t}\h ^_______^
[Annerose] ˬOIiC
<fianjmo> uOF
[Annerose] oqXpn֪s|n]^C
<fianjmo> iO㳣Sԣ쪺AuOw ^.^
[Annerose] Ӫ^򳣬OP˽թʪڡC
<fianjmo> nաAHa٬OAiжnFADHnF \__/
[Annerose] ]ڳo˰nӧ^
<fianjmo> NŧAӰաAڥs󬰧NųD
[Annerose] ]٬OܷQ^
<fianjmo> Oautrijus̷AmbergXӪcyver persona ...
[Annerose] ڡAoˤC
<fianjmo> uORMnWrn ^^
[Annerose] ˪WrH
<fianjmo> ڪp ^.^
[Annerose] ]ڰڰڡAN浹pF^
<fianjmo> ڳLAonxHpIII
[Annerose] ]_^C
<fianjmo> ...
[Annerose] GMO|wڪC
<fianjmo> t@ODH㧹βz| ^.^
[Annerose] P˪ۦthϥβĤGI]^
<fianjmo> plAߵҡC
[Annerose] ]ݧڪyPI^
<fianjmo> LധOY`OOڭ̵hWм~̡AƦܳsЪ]wB
[Annerose] ڡAQo{F]^C
<fianjmo> C
[Annerose] ]^C
<fianjmo> @ӤHAqΥɨSŷxiC
[Annerose] ]ڰڰڡAntAn¡Aniȡ^
<fianjmo> pGAڷ|ӪyNnFC
{Annerose} Ny_ƦCզXC
<fianjmo> rC@|նO
{Annerose} pu[AnoC
<fianjmo> uoӴNnAQF
{Annerose} ߦwC
<fianjmo> b@g峹uvC
{Annerose} гyOH
<fianjmo> @N :p
{Annerose} pٯuݱo_Ч@o^ơC
<fianjmo> ǰ_ӤF
{Annerose} ҥO@ثܩ_OC
<fianjmo> AiHܦaĤl
{Annerose} oOaƧrAn@UNȧP_aiӡC
<fianjmo> iOAIR]nڡC
{Annerose} PۧڪܱqӴNOIRC
<fianjmo> ]ڭ̨ȩtr
{Annerose} `ȬO]AOuaC
<fianjmo> Aڳ̧NŵLF
{Annerose} poNŶܡH
<fianjmo> ѰOᮬ
{Annerose} oNŤӻFC
<fianjmo> uܡHpORYO
{Annerose} NŪRYC
<fianjmo> A|^^
{Annerose} ~`NA]Pɽs´bӦ۪ܸ̭C
<fianjmo> AӻǧO
{Annerose} OڡC
<fianjmo> ڹڡApn[@I
{Annerose} ]\@ѷ|@ӶWV[Md[aC
<fianjmo> AڪDpܥiR
{Annerose} iRO@ذHAƹWڬOǳƤJIay~Ps̡]^C
<fianjmo> |CZiRC
{Annerose} oҩڪˤQ\]oN^C
<fianjmo> QH
{Annerose} ڦOpqvQC
<fianjmo> HHAڤSkFƾǽҡAC
{Annerose} ܤ֦ڳwWҡC
<fianjmo> ڲ{bڷQOANӪax|ؤj
{Annerose} H
<fianjmo> uܡHڤ]wp
{Annerose} uܡHwpGC
<fianjmo> ܦۤvyAäܥ@
{Annerose} @ɤOݳQܡAOݳQūC
<fianjmo> nAڭ̨Ӱ
{Annerose} nOH
<fianjmo> OLhFr
{Annerose} Lh@֡AB󵥫ݳQgXAC
<fianjmo> nͽ׿^
{Annerose} ^gOڦnQ־A{boD`߷RC
<fianjmo> ѤѮܦnO
{Annerose} OڡC
<fianjmo> Ao˥iܡH
{Annerose} iHAnʱapQC
<fianjmo> pwDܭCAuO
{Annerose} ڡAQo{FܡH
<fianjmo> S۩ǺqCp̷RۤF
{Annerose} ۺqOMܤ@˥jѪyC
<fianjmo> ڳwʪg
{Annerose} boӮɥNAʪg|QNaC
<fianjmo> Aֽ񪺪Ů𳣯SOb
{Annerose} @wbx_C
<fianjmo> O]\iHi檺V
{Annerose} SH౱VC
<fianjmo> BuȤSn}lF
{Annerose} ORH
<fianjmo> A|^^
{Annerose} NٯuOpOC
<fianjmo> ǰ_ӤF
{Annerose} ]ҥHnЩphyC
<fianjmo> {b]th
{Annerose} MNOçOC
<fianjmo> pO@TH
{Annerose} ڤ@C
<fianjmo> n_ǡAѭgF
{Annerose} 򻡡H
<fianjmo> ڹڡAuO}aխ :p
{Annerose} ]n_^
<fianjmo> PeCb
{Annerose} ʪC
<fianjmo> {bߨߤF
{Annerose} Ʊ樺O@ߨߡC
<fianjmo> App
{Annerose} ]QF@Q^
<fianjmo> ѨϨ쩳O¯u٬OLڡCڦǰgb
{Annerose} o諸̫@yGѯuBSߨxC
<fianjmo> ڳwǪŷx
{Annerose} ŷxO]ŽաAO]@ӤHC
<fianjmo> `OnܡASHͮ
{Annerose} ͮ𩹩O]ܻyAOܻy`ƪC
<fianjmo> n@_jC
{Annerose} O@_ܦѡC
<fianjmo> ڳw¸᪺F
{Annerose} rSBA䤤@NOϹMyC
<fianjmo> ܦۤvyAäܥ@
{Annerose} ܻyèSܨeC
<fianjmo> nAڭ̨Ӱ
{Annerose} ֪֡H
<fianjmo> pGo|gִNnF
{Annerose} ֤HO̱񯫪ͪOC
<fianjmo> n[SYFA|^^ >.<
{Annerose} p@IiwܺnFC
<fianjmo> nڡAڪߨߤ]ɩp :)
{Annerose} h¡A٬OݬݴNnC
<fianjmo> AnAF
{Annerose} oڷQ_ț@qAӪW٨ӧ@MCC
<fianjmo> qAڤwgDF
{Annerose} pӸDC
<fianjmo> OڤwgťpLF
{Annerose} ڭοC
<fianjmo> p[oŤߵO
{Annerose} ӽͽͼ~{C
<fianjmo> ڤwYp
{Annerose} SJo~HA|_C
<fianjmo> ڬO@QΡAnְ
{Annerose} 򤣥hΡH
<fianjmo> CntXۨƪB
{Annerose} @{qߩұӤOx²iĳC
<fianjmo> Aګeѹڨߨ߸˩O
{Annerose} ګܤְOoۤvڡC
<fianjmo> uQnӮl :p
{Annerose} ΤӦh|YhC
<fianjmo> jwgTSF
{Annerose} ӤΤFAڤwgܦF@QWC
<fianjmo> A夣Oh
{Annerose} [ıqӤOzC
<fianjmo> ppAڨӬݩpFC]ˡ^
{Annerose} ѭnǤH
<fianjmo> JF@ӤHAMO
{Annerose} Mn\ŪӤHߡC
<fianjmo> uֶּܡAnǫjj
{Annerose} oڨSkP_C
<fianjmo> ڪ{l]jF
{Annerose} ڵo{pͭO@ذkסC
<fianjmo> MQù
{Annerose} oˤӹ藍_FC
<fianjmo> AO@ӤHFr
{Annerose} ڷ|@p̬ëC
<fianjmo> ڤ]Dګݱ
{Annerose} ]藍_A}^
<fianjmo> OڡC۹O̦nF
{Annerose} ylѥHA߱NQ@˥X{FC
<fianjmo> pDAѪѮMܲDF
{Annerose} SܼFC
<fianjmo> wզF
{Annerose} wOH
<fianjmo> յ۬۫HOn
{Annerose} ۫HO@ظDL{C
<fianjmo> oӥ@ɡA٨_]۶ܡH
{Annerose} OڡAOӤ۩]OC
<fianjmo> AAͤnOAﰷd`
{Annerose} QAݤFܡH
<fianjmo> ڪYnܭDFC :~
{Annerose} MOH
<fianjmo> KKA̪qvSC
{Annerose} nhqvSݹLC
<fianjmo> SLHťOH
{Annerose} ڱaۧƱ]\p|ť߱AboC
<fianjmo> ppAѦn֡C¦w
{Annerose} A]XӮɡANaC
<fianjmo> AӬy~CAe䪺y~O
{Annerose} RyAQN֡C
<fianjmo> Ane䨺ӡAOѩ
{Annerose} Ouy̡AuOǨSҪHC
<fianjmo> AOܦn
{Annerose} ~LwҴN٬yAڤ]Oy̡C
<fianjmo> Xqv|A~YO˨벴Aߩo¶¨HHC
{Annerose} ڡA藍ݮƤC
<fianjmo> YϥuO۰ݦ۵ıoQζˡC
{Annerose} oO۹ꪺNC
<fianjmo> n߹|ıo·СFQӾߺɴNջuڲ{bӾᤣ_vC
{Annerose} pժC򤣳o򰵩OH
<fianjmo> MӤHAwNnʡAnU{ӦhC
{Annerose} C
<fianjmo> @ӤHAAr֪nŪC
{Annerose} nA@ӤHFC
<fianjmo> {bo򻡡A@uoͤFAڤ@wS᪺aH
{Annerose} ҿתܴNO}qRBҮM۵MC
<fianjmo> ۧXvaA򳣤QB򳣬ݡB򳣨SC
{Annerose} oOkסC
<fianjmo> o˪BäPɸb@ɪC
{Annerose} rC
<fianjmo> ҥHMHKXf]^
{Annerose} naAp}C
<fianjmo> ܦۤvyAäܥ@
{Annerose} }JߡA@ɭRaI]^
<fianjmo> nͽ׿^
{Annerose} F^Aٳwj^C
<fianjmo> C@IıoۤvnaH
{Annerose} 򤣤Woӧ֪@ɡC
<fianjmo> {bߨߤF
{Annerose} ӽͨߤlC
<fianjmo> SCopFuz
{Annerose} ]Don򱵡^
<fianjmo> OLhFr
{Annerose} hֹLhboӻyƮw̩OH
<fianjmo> ѨϨ쩳O¯u٬OLڡCڦǰgb
{Annerose} йLAFC
<fianjmo> po{åI
{Annerose} {|OHߧNA~|C
<fianjmo> o˦IʬOO
{Annerose} |o˰ݡAN٤ʡC
<fianjmo> iOAگuOFn
{Annerose} ɭԳso@ISkTwC
<fianjmo> ѨSY򽭵
{Annerose} {bQ_ӡAڤ٨SYC
<fianjmo> nwgF
{Annerose} ٦oܡC
<fianjmo> ]TGûSnG
{Annerose} ߦwC
<fianjmo> uOnR㨺ǤpuO}t}\h ^_______^
{Annerose} ڰڡAǤFڧaC ^^;;
<fianjmo> ڪwP_AOǿա
{Annerose} ouO르Ӻ]ġ^C
<fianjmo> cѭAnظƱqqQѨp
{Annerose} pAbSĵıpUF~C
<fianjmo> iO㳣Sԣ쪺AuOw ^.^
{Annerose} ܦrC
<fianjmo> t@ODH㧹βz| ^.^
{Annerose} ]OAѡ^
<fianjmo> iR]ߡ^
{Annerose} ]^
<fianjmo> ...
{Annerose} nnA˶̴NOC
<fianjmo> pniR[Apkv
{Annerose} ]uOPıѮtaܡ^
<fianjmo> NOAĤ@g@~]wF~ëFC
{Annerose} Ѷ}ʦLO@DڦܤLkyMu۪GC
<fianjmo> AiӤF
{Annerose} ]\A]|XhC
<fianjmo> ڤɧaOWYv@@B_AP첢eѳߡC
{Annerose} svq𫫤UAOl̤]sJFƩMýC
<fianjmo> nӤߦa\A⪺ĻI٦[
{Annerose} ̦nĻINOAHp٩M]ϡC
<fianjmo> Oautrijus̷AmbergXӪcyver persona ...
{Annerose} {bpF]^C
<fianjmo> γ\Au@YکRBARBOknEѪŹϡC
{Annerose} ߦwC
<fianjmo> ̪񳣺Τn
{Annerose} OⰦ糤@ˡC
<fianjmo> ~t}oh
{Annerose} ڡAڳwe窺AoJ|]ߡ^C
<fianjmo> ڤwbn
{Annerose} ޥVѮLѡAԪ̤@ˬo¶ªC
<fianjmo> ]oOŪ
{Annerose} pGntXAӬoAGsiW@ˡC
<fianjmo> b߸̹L
{Annerose} 躡FrAi@hAAYɤƬC
<fianjmo> pb@_ּ֤ln򻡩OH
{Annerose} bOи̡Aּ֦]äAoӧ󬰧کҲʡC
<fianjmo> ڤwͤHCҥHQǮաCohH
{Annerose} ڴLCӻPӹLͤHC
<fianjmo> ıoCӤHߤ@mTC
{Annerose} O]A٬O]q֦H
<fianjmo> ǥѧAұaӪHAڥoH֦ۨ꺡C
{Annerose} ڬ۫HApNvowժۥѡC
<fianjmo> ڷQAצpAڳno˻C
{Annerose} ܰDpoQC
<fianjmo> Mӳo˪ܹ勵ȯܮzHOܴݧԪC
{Annerose} @rA]NLhFC
<fianjmo> uvѮvQFӤwC
{Annerose} ѯuppc@@ARw֩M^𪺼yC
<fianjmo> bgLyѾAqǮհkXAIlۥѩM@IIvC
{Annerose} HCOSHڵLH͡C
<fianjmo> O@ثܩ_ǪsC
{Annerose} Nyq즳ߵAO̳Pl@oC
<fianjmo> ıoۤv䰣FyRwAťC
{Annerose} ڤDnqӨӡA]ڱoH~A@qC
<fianjmo> PYǤSP@PX{C
{Annerose} QQDANXͷC
<fianjmo> C
{Annerose} ۩IܡH
<fianjmo> ڧpr~OAp
{Annerose} ]nAniȡ^
<fianjmo> urAڭ̳o˯uOӤPFAذء
{Annerose} |ܡH
<fianjmo> ApNbڭ̪Ф
{Annerose} ]ˬݤ^
<fianjmo> n²檺HqHC
{Annerose} HRʡC
<fianjmo> ެOO@˪plAbڤߤOW@LGC
[Annerose] pvMp@ӡH
<fianjmo> n[S}þF
[Annerose] ̪񤣻ݭn}C
<fianjmo> SAp~D
[Annerose] ѭnǤH
<fianjmo> JF@ӤHAMO
[Annerose] qx\ŪߨWRBC
<fianjmo> ťOHuNܩ
[Annerose] ۤvu]ܦANuonC
<fianjmo> Ona~|
[Annerose] SܡAZOJFH
<fianjmo> ϥp۩Ǻq
[Annerose] ŪFH
<fianjmo> A_ͳQdbaH
[Annerose] DAC
<fianjmo> ]\NOpbaC
[Annerose] ۩IC
<fianjmo> ...
[Annerose] U@Ӱʧ@LkMwC
<fianjmo> urAڭ̳o˯uOӤPFAذء
[Annerose] MOıPA]unQ[ӽC
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
[Annerose] ӭQAo˪ӥs|Ai]U߲zd]Q^C
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
[Annerose] ڰڰڡAWQаVFC ^^;;
<fianjmo> ǡAjIQN¶]ANOpa
[Annerose] QoOiȤSRKC
<fianjmo> ڧpr~OAp
[Annerose] ]ܷQ^
<fianjmo> ApNbڭ̪Ф
[Annerose] {bwE~FC
<fianjmo> ǡAsL]o˥s۵۰ *___*
[Annerose] ڥibo̻ܡ]^C
<fianjmo> hpAp{Ȫet~a
[Annerose] AڨLabo̭CC
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ӻXg]^C
<fianjmo> ...
[Annerose] naABIȮdۤU^ϥΡC
<fianjmo> iAثerwӤ֤Fǡ
[Annerose] оǬOܪɶC
<fianjmo> γ\AoOڵڵĄc]̰gHҼˡH
[Annerose] }Ҧw]󪺷sA٭쥻ӮezإATOMnC
<fianjmo> NǤDHA@yh
[Annerose] _aDjAӬOP]ۡ^C
<fianjmo> iHHn}H
[Annerose] گ໡H
<fianjmo> hhASY
[Annerose] ǩRڤjH]^C
<fianjmo> hpAp{Ȫet~a
[Annerose] ]o˦pOnH^
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
[Annerose] ²檺C
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ]^
<fianjmo> ...
[Annerose] ²]fLhC
<fianjmo> NǤDHA@yh
[Annerose] OOAکդFC
<fianjmo> ApNbڭ̪Ф
{Annerose} ]\AqF}l@soiA|guzѡvwqC
<fianjmo> F^Aٳwj^C
{Annerose} F]Alan Turing, 1912-54^C
<fianjmo> pGpˤAܧִNܦo󪫡C
{Annerose} ڪDC
<fianjmo> C@IıoۤvnaH
[Annerose] DC
<fianjmo> ڬQѱߤWٺLFAja~aFC
[Annerose] ]Į^
<fianjmo> ߤSOA|hlۤvڶ]C
[Annerose] ɭԧıon֡C
<fianjmo> ڪbHsݸC
[Annerose] йLFC
<fianjmo> ıo䳣Os~nC
[Annerose] HC
<fianjmo> 򤣥hΡH
[Annerose] ɭԧڤ]|߱CC
<fianjmo> svq𫫤UAOl̤]sJFƩMýC
[Annerose] abD[WAFV|KӥhC
<fianjmo> ߪ{ljFC
[Annerose] V̫_XKAuݵ۲eMMLC
<fianjmo> ڪWOߧ쪺˲@C
[Annerose] Qߧ˦ӵLkͮAܳo߯uݩڤFC
<fianjmo> ߤSOA|hlۤvڶ]C
[Annerose] iOګoLkXӡC
<fianjmo> ]\A]|XhC
[Annerose] ѤF_ͦb̡AƦܧѤFOiӡC
<fianjmo> wMO@{uơC
[Annerose] ӽ;C
<fianjmo> F^Aٳwj^C
[Annerose] oO־C
<fianjmo> ]\AqF}l@soiA|guzѡvwqC
[Annerose] ٬OOoA謰򤣦^H
<fianjmo> Ȧw]L^C
[Annerose] n^H@ˡAͤѮಾDC
<fianjmo> häHhépbhöܡH
[Annerose] ڥuOıoLkAX@BAݵۤѺCCGFopPQvbQ]C
<fianjmo> ڡAڳwe窺AoJ|]ߡ^C
[Annerose] ɶuܤiĳC
<fianjmo> ګܤְOoۤvڡC
[Annerose] ٨SǷ|ڡC
<fianjmo> ڰڰڡAʪgӬ@ϳoӥ@ɦnF]z^C
[Annerose] n֡C
<fianjmo> t@ODH㧹βz| ^.^
[Annerose] ڤ]QQ쳱tھUDhC
<fianjmo> ɶ_NݻŦBNuᤩC@ȱo~{PC
[Annerose] _b·taVw۶AڤwѤFɶNqC
<fianjmo> MӡAjkvګopʤH
[Annerose] ڤݮƹqv
<fianjmo> ڪwP_AOǿա
[Annerose] ΥHq׳߷RfAMγoǶrɪOC
<fianjmo> iR]ߡ^
[Annerose] ߦQz̤~\ŪAΪ̡AϹLӻA\Ū~OQz̡C
<fianjmo> uOF
[Annerose] OoNFAҦֻP§AiHݧ@OOЪܻC
<fianjmo> NŧAӰաAڥs󬰧NųD
[Annerose] ``bPHͫAдoaMۤvuDC
<fianjmo> uOnR㨺ǤpuO}t}\h ^_______^
[Annerose] nhqXLaDOC
<fianjmo> nӤߦa\A⪺ĻI٦[
[Annerose] ګoQCѥγժ^aӥ]ϵLĥiϪGѶˤfOC
<fianjmo> Oautrijus̷AmbergXӪcyver persona ...
[Annerose] Yߦa⪱lA׬RήơANӨƪáC
<fianjmo> pniR[Apkv
[Annerose] ۤvSnȱoæӭApGQnNШhC
<fianjmo> AiӤF
[Annerose] ݨ즳HpPFï]Ӥߦu@ۦۧڡA`ǳ\r}C
<fianjmo> cѭAnظƱqqQѨp
[Annerose] ڴNoIơAX骺jrŪ@˼uK½C
<fianjmo> NOAĤ@g@~]wF~ëFC
[Annerose] FwuAppӧQbjѤUäC
<fianjmo> hhAyuOHLv@y >.<
[Annerose] N̤]QhAFzѧiHjaꦺۤvC
<fianjmo> 𪺯BA]`O۶[A[ɪXȨ{O
[Annerose] @n몺TANڭ@۩ʤlAVwXۡC
<fianjmo> uOӪp]ߡ
[Annerose] YϮɶǦCOkHwзǡA٬OKʷP涰C
<fianjmo> ڪp ^.^
[Annerose] bSkXLҬ߳o|ӦrC
<fianjmo> ҥHڥ]kAKWڡAHaۤv̦nա]ߡ^
[Annerose] զۤvҬߡBLBʥPASwMAOڧiO몺覡a.
<fianjmo> ӴNAȱoܹAAӤ]ɨoܰa *^^*
[Annerose] ڼ񪺬Owǩ`f Can you celebrate.
<fianjmo> ڤɧaOWYv@@B_AP첢eѳߡC
[Annerose] PڤAOߤ@Qڻ{Ѫ覡C
<fianjmo> uORMnWrn ^^
[Annerose] QRWO_ơA@OMyA@OYҥC
<fianjmo> nաAHa٬OAiжnFADHnF \__/
[Annerose] ťuǹOవvAıoۤvӤѯuIwǮaC
<fianjmo> AAӷQWra *^^*
[Annerose] ЧOoذDڡC
<fianjmo> ӤFܡANƨYHA@CUY`AbhNC
[Annerose] pP]b۳{MhAbXPNڦ}lmߧiOC
<fianjmo> ]pOӱjԤhH^.^
[Annerose] ڤOCȶȬOݳzFʮPRBGҡC
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
[Annerose] NH@aSʦXAVpæӭۧڭPWqNC
<fianjmo> niRʧ@ڡAuOifI
[Annerose] YϤ_O]ߡAo˪ȱoíPhC
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] ۨhղMAM`Ȩ˪ۨpAiPӻyC
<fianjmo> hhASY
[Annerose] ګowoتGOHi몺OC
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] ڱ}쪺kAIObHX_IwħC
<fianjmo> urAڭ̳o˯uOӤPFAذء
[Annerose] DDŧi|beFA]MKSjtskQC
<fianjmo> NǤDHA@yh
[Annerose] bpqM_SeAڭnCmbpCTC
<fianjmo> ǡAsL]o˥s۵۰ *___*
[Annerose] ˧ڦܤ֦oդ@I]^C
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
[Annerose] SMun˼ҧ@˧rC
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
[Annerose] ȮɪC
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ӥBAڰQyC
<fianjmo> հհǰǡ
[Annerose] H̥OQo˰MOէlަӨӡC]󦨤FߺDC
<fianjmo> iAثerwӤ֤Fǡ
[Annerose] pOdUӪANO̪쪺eC
<fianjmo> pObֿRRڡAհա
[Annerose] ڦbWۤ@Hmߤ۷QCNOC
<fianjmo> ڳ̰QFաApIڦnFAհա
[Annerose] Nfp{C
<fianjmo> niRʧ@ڡAuOifI
[Annerose] uAڤ]ܰQC
<fianjmo> հհǰǡ
[Annerose] ڳ̳wqu٬Oۦ樮C
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] ²檺˸mANqഫHһݭnΦAuOXC
<fianjmo> ҥHAڵ@UnΩ`ckSӪAȧڵF]ߡ^
[Annerose] ڴNiC
<fianjmo> γ\AoOڵڵĄc]̰gHҼˡH
[Annerose] O`BANKOC
<fianjmo> ӥiRpffٴOAuOAհա
[Annerose] pGHoC@lOAA]KӨS۪C
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
[Annerose] puġvɭԡAڷQ쪺Oum@vOC
<fianjmo> uOAnܥiR
[Annerose] @I]oıoC
<fianjmo> ApNbڭ̪Ф
[Annerose] ڪDAǤHıoڰ]^C
<fianjmo> niRʧ@ڡAuOifI
[Annerose] NHu§̰]vө^ٽ}C
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] ]@I]ıoۤviR^
<fianjmo> urAڭ̳o˯uOӤPFAذء
[Annerose] bߤPeAñpʧ@OLΪkC
<fianjmo> ǡAsL]o˥s۵۰ *___*
[Annerose] iOo@ӡAڤ]Dub̤FC
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] Ob۰ʨ@aH
<fianjmo> oӦ۰ʤƪpHհ
[Annerose] pB͡AڨܴݧԪC
<fianjmo> SP˪ܤF :~~~
[Annerose] pGeڳo˻AOt@خApðw몺C
<fianjmo> oFaAp``oˤϰݡAɭԧګܷQH
[Annerose] Ǫ覡MǦWtڡC
<fianjmo> NǤDHA@yh
[Annerose] b̥HeAڷ|Oob}Wjn۶C
<fianjmo> iHHn}H
[Annerose] ݭnԷVBzëDoLƥiڡAӬOQil誺AC
<fianjmo> ApNbڭ̪Ф
[Annerose] pGeoӭhAoչwtiOγ\N|Wγ}H
<fianjmo> ҥHAڵ@UnΩ`ckSӪAȧڵF]ߡ^
[Annerose] TaxۨA]O@NOC
<fianjmo> oFoFADӰաIII]ԪLڧ갭y^
[Annerose] ZZ]^C
<fianjmo> hpAp{Ȫet~a
[Annerose] ڤ]ܷQo˰ڡC
<fianjmo> NǤDHA@yh
[Annerose] ڤ]QoհڡC
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] ǩRڤjH]^C
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
[Annerose] ˤ[@Iݬݷ||ͽܩOC
<fianjmo> ӥiRpffٴOAuOAհա
[Annerose] oNPnΦ۪ӫOsA~|GѡC
<fianjmo> oFoFADӰաIII]ԪLڧ갭y^
[Annerose] gQzε}GrgաAٯ໡]^C
<fianjmo> gAаVHHAWaIII
[Annerose] o]֭n췥F}C
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
[Annerose] ثe٬OλPuo̪ʰڡC
<fianjmo> ڨSOoܡ
[Annerose] jHhJ]^H
<fianjmo> LHANp]A ^^
[Annerose] nաAڻ{FNO]^C
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
[Annerose] zQվin}AOP_FܡH
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] NO֤]QzrC
<fianjmo> pObֿRRڡAհա
[Annerose] cAڨSC
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
[Annerose] گ໡H
<fianjmo> gAаVHHAWaIII
[Annerose] ڰڰڡAOGڡ]YbaW^CCC
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ڭ̩ҥ檺֥usbQڭ̩IlLŮ𤧤]ۡ^C
<fianjmo> AP仡۫HApOPnyH:p
[Annerose] ptzzoaIWVĤCPaI]zzz^
<fianjmo> ̳wpKv
[Annerose] nV]VY^C
<fianjmo> [WզťۦnťnAıoӥ@ɬXM_ӡC
[Annerose] VѨFANQYoC
<fianjmo> ӪϩBubߩASnaA\@aAwwaۡC
[Annerose] ¦⪺AO߱I骺~C
<fianjmo> oOPNyqu㤣@˪_lIC
[Annerose] ګA|Nѹ껡C
<fianjmo> OoNFAҦֻP§AiHݧ@OOЪܻC
[Annerose] OoNo˲VLh]^C
<fianjmo> ``bPHͫAдoaMۤvuDC
[Annerose] bڭ̪A]¶ۤ@Iu̴IlLŮܡH]ۡ^
<fianjmo> HCOSHڵLH͡C
[Annerose]  bͤHnA]j¶۫e̪nܡH]ۡ^
<fianjmo> bͤHnA
[Annerose] uǱoܧ֡AOHġC
<fianjmo> pAbSĵıpUF~C
[Annerose] OoڡAۤv˰Q@UI
<fianjmo> TO]ݤFn[٬O^H
[Annerose] nͮC
<fianjmo> wHLpܡ]yyy^H
[Annerose] aHANiHp@Qo󪫳BzաC
<fianjmo> qLFնܡ]^C
[Annerose] C٨SǷ|C
<fianjmo> jHhJ]^H
[Annerose] ALkHͮɡASNH
<fianjmo> ŷxO]ŽաAO]@ӤHC
[Annerose] jNԤhAܷѷasC
<fianjmo> ڤOCȶȬOݳzFʮPRBGҡC
[Annerose] b~ئѥhAPsԤhêӹܦ۵MOqC
<fianjmo> Ouy̡AuOǨSҪHC
[Annerose] Ǥ~OڪҦbrC
<fianjmo> ...
[Annerose] C
<fianjmo> ...
[Annerose] ڷQQC
<fianjmo> AP仡۫HApOPnyH:p
[Annerose] OoƵ۬۹JAPDOC
<fianjmo> γ\AoOڵڵĄc]̰gHҼˡH
[Annerose] qYӨץh[ANO@صNPq۫ݡC
<fianjmo> pObֿRRڡAհա
[Annerose] WLYӭסAկڴNtᤣ_FC
<fianjmo> ApNbڭ̪Ф
[Annerose] |}C
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] ½धANFHS@dסC
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ڤ{ѳoӤH]~^C
<fianjmo> LHANp]A ^^
[Annerose] uڰOovAoy²NOGyC
<fianjmo> pObֿRRڡAհա
[Annerose] ]Li`󻪡^
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] OڪԳC
<fianjmo> ڳ̰QFաApIڦnFAհա
[Annerose] Կ]^C
<fianjmo> hpAp{Ȫet~a
[Annerose] A٨SAoӥ@ɡ]z^C
<fianjmo> oӦ۰ʤƪpHհ
[Annerose] ptMMhAaۤ@ش_jۻPۨC
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
[Annerose] ]⨬L^
<fianjmo> ǡAjIQN¶]ANOpa
[Annerose] cëDȶȥͪbuPݻŪB줧WC
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] ]^^
<fianjmo> ...
[Annerose] ]LH^
<fianjmo> LHANp]A ^^
[Annerose] ڷ|jӥhpAuѤUiyC
<fianjmo> ӥiRpffٴOAuOAհա
[Annerose] ڳwj諸C
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ]\YǤHӻAण_R´²iĳ}C
<fianjmo> ApNbڭ̪Ф
[Annerose] v_OpӱKSܮz_AurG˵MyʡC
<fianjmo> γ\AoOڵڵĄc]̰gHҼˡH
[Annerose] ˩RO@ƪAuKihC
<fianjmo> gAаVHHAWaIII
[Annerose] FC
<fianjmo> SOԣQԥդeHڡH-___-
[Annerose] ڤ]DڡC
<fianjmo> NǤDHA@yh
[Annerose] ڡCگuLC
<fianjmo> ǡAjIQN¶]ANOpa
[Annerose] oڴNFC
<fianjmo> gAаVHHAWaIII
[Annerose] nC
<fianjmo> hhASY
[Annerose] ݳzh֦Ƕ˷PC
<fianjmo> niRʧ@ڡAuOifI
[Annerose] DɩOH
<fianjmo> NǤDHA@yh
[Annerose] ڪɭԡAڷ|ۤvǳƦnYC
<fianjmo> uOAnܥiR
[Annerose] ڥiHaUoyܶܡ]^C
<fianjmo> hpAp{Ȫet~a
[Annerose] ڤ]QnȪetAڭ̲qnFC
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
[Annerose] ڹ啕UC
<fianjmo> ApNbڭ̪Ф
[Annerose] OOAȮɪC
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
[Annerose] ФF]L^C
<fianjmo> SOԣQԥդeHڡH-___-
[Annerose] o˧ګ^H
<fianjmo> QϩgLh֤AopġIII
[Annerose] ZZ˩]^C
<fianjmo> ...
[Annerose] uO@خƥšC
<fianjmo> urAڭ̳o˯uOӤPFAذء
[Annerose] pGڪDܡA@w|ӹ껡C
<fianjmo> oFaAp``oˤϰݡAɭԧګܷQH
[Annerose] ڤ]``ϰݦۤvrC
<fianjmo> ڴNOhӪHHH
[Annerose] GLPsA`OnIINC
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
[Annerose] OڡCCC
<fianjmo> ҥHAڵ@UnΩ`ckSӪAȧڵF]ߡ^
[Annerose] ֭nFC
<fianjmo> հհǰǡ
[Annerose] ҥHگ໡H
<fianjmo> ӥiRpffٴOAuOAհա
[Annerose] ڰڰڡAQXӡC
<fianjmo> iAثerwӤ֤Fǡ
[Annerose] 򤰻ڡCCC
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] ]֤F^
<fianjmo> ǡAsL]o˥s۵۰ *___*
[Annerose] SoWN奻맮ѭ媺ַPC
<fianjmo> AP仡۫HApOPnyH:p
[Annerose] ۦbOADNSǳ\汣MH
<fianjmo> AbunANůun
[Annerose] OOAzC
<fianjmo> LHANp]A ^^
[Annerose] ۥHOAOڵnקKC
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] iAAsӤסC
<fianjmo> ڧpr~OAp
[Annerose] ннС]^C
<fianjmo> ...
[Annerose] n}Aݧڤ]tᤣ_C
<fianjmo> ڨSOoܡ
{Annerose} onťCڥiOczFۤvGHDDqC
<fianjmo> ڴNOhӪHHH
{Annerose} oڴNF]^C
<fianjmo> pObֿRRڡAհա
{Annerose} ڪDAOpe覡C
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ZS۪OC
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
[Annerose] γ\pAFuoӡuvAҥHoMNaM_C
<fianjmo> ApNbڭ̪Ф
[Annerose] PqӬ۸Aa~BHwߪiRC
<fianjmo> AP仡۫HApOPnyH:p
[Annerose] yAoSϤPΨHBnݡC
<fianjmo> ӥiRpffٴOAuOAհա
[Annerose] upANOoˡCv
<fianjmo> QϩgLh֤AopġIII
[Annerose] ]aۧtWueANVGXӪȰwæ^h^
<fianjmo> iAثerwӤ֤Fǡ
[Annerose] H̤ɧsNƪyHheioyǶA@wۡC
<fianjmo> niRʧ@ڡAuOifI
[Annerose] bApB͡A`OګܷQnaWXUC
<fianjmo> ڴNOhӪHHH
[Annerose] bo̶éܡAڬOo@ФF]^C
<fianjmo> hpAp{Ȫet~a
[Annerose] OAȪetNdդUF]^C
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] @LFOsA|wnӱ󪺻ĻGC
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
[Annerose] QQyOAVAoOHYtoC
<fianjmo> ڳ̰QFաApIڦnFAհա
[Annerose] uJMpۤ߸۷NaUڡAڴNjoOdaiDpv
<fianjmo> pObֿRRڡAհա
[Annerose] uF@ɳQ}aAFO@@ɪMAeRPuꪺcIv
<fianjmo> ҥHAڵ@UnΩ`ckSӪAȧڵF]ߡ^
[Annerose] uiRSgHϬAڭ̬ObȪebIv
<fianjmo> urAڭ̳o˯uOӤPFAذء
[Annerose] @lOnAMڵLq{褤DڡC
<fianjmo> ڧpr~OAp
[Annerose] DڴNO}lwƩ߱󦡸q϶ܡ]^C
<fianjmo> γ\AoOڵڵĄc]̰gHҼˡH
[Annerose] pPR~ʡAWVuP갲B}PocC
<fianjmo> oFaAp``oˤϰݡAɭԧګܷQH
[Annerose] ннСADo]^C
<fianjmo> NǤDHA@yh
[Annerose] ҦCAOFܨif઺ilPkC
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] o򻡨ӡAӱNڰloLtڷHAΪ̧OEH
<fianjmo> ǡAjIQN¶]ANOpa
[Annerose] OOAڦAQ]SF]ܯ^C
<fianjmo> oFoFADӰաIII]ԪLڧ갭y^
[Annerose] ˨ĸ˱oӹLA𦭷|DC
<fianjmo> iHHn}H
[Annerose] 襻ټhAwMzioC
<fianjmo> ڨSOoܡ
[Annerose] ucAnQPıڡv]ܦPPQXhF^
<fianjmo> gAаVHHAWaIII
[Annerose] ڡAn֡C
<fianjmo> AbunANůun
[Annerose] NŤnAbubvGrC
<fianjmo> uOAnܥiR
[Annerose] pGSڦҡA֪}|HoⳣOC
<fianjmo> ֦FաAP_٦b򤤡
[Annerose] AЦnn𮧡C
<fianjmo> Ap~gˤ]ӥi ^.^
[Annerose] GM٬OQݥXӤFܡ]^C
<fianjmo> SOԣQԥդeHڡH-___-
[Annerose] oګ|DO]ġ^C
<fianjmo> ǡAsL]o˥s۵۰ *___*
[Annerose] jpUAۻI몺بLNoFC
<fianjmo> oӦ۰ʤƪpHհ
[Annerose] ]Bn^
<fianjmo> ...
[Annerose] ]ǿߥs^
<fianjmo> ...
[Annerose] nnA˶̴NOC
<fianjmo> ...
[Annerose] o٤AڥipOnFC
<fianjmo> LHANp]A ^^
[Annerose] `ıoǷPˡC
<fianjmo> ...
[Annerose] nnANﻡiߥiPC
<fianjmo> ...
[Annerose] Dڤ@wnH
<fianjmo> SP˪ܤF :~~~
[Annerose] ڤ]ܷQݦP˪DC
<fianjmo> ]pOӱjԤhH^.^
[Annerose] AڬOƻsFAŧѥǡAHΫKC
<fianjmo> uOAհհաApaH
[Annerose] ]Q|ٳo򰪿O^
<fianjmo> ...
[Annerose] ]n@oIIIա^
<fianjmo> ...
{Annerose} L誺֤kC
<fianjmo> F^Aٳwj^C
{Annerose} L^nC
<fianjmo> }JߡA@ɭRaI]^
{Annerose} qܦ@yӷLACѹۥipKRC
<fianjmo> MӦbZA۵M]shڰסC
{Annerose} ڭ̦FAiHgwU@@ɷC
<fianjmo> MOıPA]unQ[ӽC
{Annerose} fvIfvI]^
<fianjmo> pPR~ʡAWVuP갲B}PocC
{Annerose} oNOuºحͤpc]C
<fianjmo> HCOSHڵLH͡C
{Annerose} NjnFC
<fianjmo> ϥOonYNFC
{Annerose} nAڤQYC
<fianjmo> ӥͮNͮAqLNjnťC
{Annerose} o]OwOH覡C
<fianjmo> zL@ةvʡAM\hgbC
{Annerose} C
<fianjmo> ǡAsL]o˥s۵۰ *___*
{Annerose} ڤOGNC
<fianjmo> niRʧ@ڡAuOifI
{Annerose} ½yN½yAOܤiĳƶܡH
<fianjmo> ApNbڭ̪Ф
{Annerose} ڤo˻{C
<fianjmo> NǤDHA@yh
{Annerose} nC
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
{Annerose} հհա
<fianjmo> γ\AoOڵڵĄc]̰gHҼˡH
{Annerose} nܪBK
<fianjmo> iAثerwӤ֤Fǡ
{Annerose} NoLAֵJK_ۺY
<fianjmo> ڴNOhӪHHH
{Annerose} bJ̪B}lAƵ۬Xnդա
<fianjmo> ӥiRpffٴOAuOAհա
{Annerose} H⪺¤@@AO۹ï]@˪z̲y
<fianjmo> oFaAp``oˤϰݡAɭԧګܷQH
{Annerose} nܩڪ@yܡ]^C
<fianjmo> hpAp{Ȫet~a
{Annerose} YϦpAյ۹G񤴵MRֽC
<fianjmo> AP仡۫HApOPnyH:p
{Annerose} oˮeC
<fianjmo> LHANp]A ^^
{Annerose} ONV۶·¶`WAiͯ}ŭhC
<fianjmo> ҥHAڵ@UnΩ`ckSӪAȧڵF]ߡ^
{Annerose} oO]^H
<fianjmo> gAаVHHAWaIII
{Annerose} _ӡAڦۤv]SbhְڡC
<fianjmo> oFoFADӰաIII]ԪLڧ갭y^
{Annerose} nۭtڰա
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
{Annerose} ڥͮF]q^
<fianjmo> ǡAjIQN¶]ANOpa
{Annerose} ~O~O
<fianjmo> YNOo˫ApٲzoǡIII
[Annerose] nF@RApGOPɤOANO]eaC
<fianjmo> ]JYUANHafz^
[Annerose] @CXAN~ѳ̫@äC
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
[Annerose] LYAXFt@䪺UAaIL`Pǳ\IC
<fianjmo> C@ߡAAϧڶiJIANڶȦOPC
[Annerose] @gbۡAAOZA٬Oq`ۥѡH
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
[Annerose] ϧڨ˪OlAӬOeG_OC
<fianjmo> ګDoHLƪVɻPkhANǬy몺ۧڸHC
[Annerose] pGAoڪkAA]NȱoڪIqC
<fianjmo> OyF@몺HͩRA͵LƦ]LksoҡC
[Annerose] @DAOvL{C
<fianjmo> niRʧ@ڡAuOifI
[Annerose] ԷVaNclWú{AHU\B\C
<fianjmo> w]`^C
[Annerose] H`AAAVӶDF`AAnVӶDH
<fianjmo> gAаVHHAWaIII
[Annerose] ƵMBWRBѯAoob@DW@LGإUC
<fianjmo> ګDoHLƪVɻPkhANǬy몺ۧڸHC
[Annerose] SXAp참NFupġC
<fianjmo> ANONHƪplA]`O}Cȡ
[Annerose] aꪺֻsyAĲŷxAئw߷PC
<fianjmo> ҥHAC`HROø@AƦܳsLWݵM
[Annerose] zLRAۨOMC
<fianjmo> ]JYUANHafz^
[Annerose] ]AޤM@ΪMMAڤ~oHqAצpjۨC
<fianjmo> hhASY
[Annerose] pڦA|QqnۤަӥhFC
<fianjmo> Aoᨥy_̡AaϧAڻ齧_......
[Annerose] 餣OFwAOHవӰbJMGת̡C
<fianjmo> C@ߡAAϧڶiJIANڶȦOPC
[Annerose] b@ӺܬpɤlAګoSQ礩Aҳ\ժwC
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
[Annerose] שڵo{Aʺ_ͨäbA⤤C
<fianjmo> ҥHAڵ@UnΩ`ckSӪAȧڵF]ߡ^
[Annerose] xbǤڷQ_͡Ao˪ƧڤwФFC
<fianjmo> ӧڡAL׬OXؤ]nAjI]}AӨۥ֦窺ETC
[Annerose] AP_AOW²檺\ҡC
<fianjmo> ګDoHLƪVɻPkhANǬy몺ۧڸHC
[Annerose] aϤ@{YuAo@@ڤѡC
<fianjmo> niRʧ@ڡAuOifI
{Annerose} ڭnFC
<fianjmo> i|Ho]ɤxӨA骺Ԥ~OͩR`ҦbC
{Annerose} bU@諸_eAڱoAmm\ҡC
<fianjmo> oۤvAOp\ݯ}Ӻ
{Annerose} NѨݯ}ӺܪANwgF̩hC
<fianjmo> ϥLPֶqʡAHάWd
{Annerose} OVSwHAϩѦa|L骺˷PC
<fianjmo> gAаVHHAWaIII
{Annerose} ڤYOHOC
<fianjmo> niRʧ@ڡAuOifI
{Annerose} nܬDLFǡC
<fianjmo> ǡAsL]o˥s۵۰ *___*
{Annerose} OOAeM^C]^
<fianjmo> boyA۳\hدuA\hAݨѪuλC
{Annerose} ٥iHqpۼvAhuꪺ{C
<fianjmo> ҥHAC`HROø@AƦܳsLWݵM
{Annerose} nL`WA⤤ҫOڤzGűC
<fianjmo> ]JYUANHafz^
{Annerose} OwQOxANWFγC
<fianjmo> ګDoHLƪVɻPkhANǬy몺ۧڸHC
{Annerose} b{XۧڪbA⤤lVLHC
<fianjmo> @~HNKAڳQADˤFC
{Annerose} ڤˤf¡XAӥH]_@]ĥ]ϬצC
<fianjmo> cڦBc٦ئBNOOAiP氮p
{Annerose} oˤ~|YrC
<fianjmo> ANONHƪplA]`O}Cȡ
{Annerose} ˪γ\ëDFAӬOF÷RۤvYDvC
<fianjmo> C@ߡAAϧڶiJIANڶȦOPC
{Annerose} UI쪺𰪶Aڳ``Q_ѻ@UɯPBC
<fianjmo> Ap]򨺨Ⱖp¿߬ۤhLO
{Annerose} ¿߬ONhǲd]ߡ^C
<fianjmo> jɲƱApPL갩zG[ŪPۡAxk
{Annerose} ɶqDʱNѧ@AoOijӪhW馩C
<fianjmo> ӧڡAL׬OXؤ]nAjI]}AӨۥ֦窺ETC
{Annerose} bܩڻPڪA\AäۦbpxѯWRC
<fianjmo> LuΤOrUBA˸˵Lppu
{Annerose} YƿtztAµLҤbC
<fianjmo> OyF@몺HͩRA͵LƦ]LksoҡC
{Annerose} aL_UưʪaAHIv@çOC
<fianjmo> ۤvHYشݲD˳uPAR۳oŻiZ
{Annerose} woǳѧھF|nǡHogbڳoıoC
<fianjmo> ApNbڭ̪Ф
{Annerose} OڼȮɱNҦi}xA~@ӷŹnʪC
<fianjmo> ڼȮɤƨpaAJMBsPxvҼˡ
{Annerose} bNj[ڨƧNNoڡA]몺nNġC
<fianjmo> ҥHAڵ@UnΩ`ckSӪAȧڵF]ߡ^
{Annerose} հաAoOH]^
<fianjmo> Fض}JM}ΦӥXioALPa
{Annerose} u˼vL٬ܮɡAӤ]שॿUۤvFC
<fianjmo> pڥΤ|AOW۾xۭnˤfcơA@IOI
{Annerose} }aFXʦ~AOZOϰϤHFonƱC
<fianjmo> ]Mܯ^
{Annerose} ]X^
<fianjmo> iAثerwӤ֤Fǡ
{Annerose} u|AW[FC
<fianjmo> Aoᨥy_̡AaϧAڻ齧_......
{Annerose} _MOLҤΨ䷥AӻƪꦨܪZC
<fianjmo> LXGAפԤ@^Aoަۤv
{Annerose} OFvӤ_st򶰧r]^C
<fianjmo> LANsƫ᪺ۤv]g
{Annerose} ƫҵXûLklWUy઺շLߩC
<fianjmo> ôOWANO@˳LӪc
{Annerose} YӻADLӡANOLC
<fianjmo> γ\AotzADoHLӴbC
{Annerose} 쪺ܡAnnn۳C
<fianjmo> oFaAp``oˤϰݡAɭԧګܷQH
{Annerose} ڦ`ϰݶܡH]Sϰݡ^
<fianjmo> AݼˤlOӦnǥͩOAڳ̷R˦nǥͤF]grin^
{Annerose} pGݨnǥ͡And@IڪCڤ|⥦]ߡ^C
<fianjmo> uOAΤOVYٯuOfѪO
{Annerose} հհա^^;;;;
<fianjmo> γ\AoOڵڵĄc]̰gHҼˡH
{Annerose} OOAngHڡ]^C
<fianjmo> ڨSOoܡ
{Annerose} VVLYF
<fianjmo> IOPR@LҪAC
{Annerose} îaAKӤߦaNoǫAíOsC
<fianjmo> ɭԡAAPUHau^PèAڷ|
{Annerose} O]ӺiFaHP@IC ^^;;
<fianjmo> YNOo˫ApٲzoǡIII
{Annerose} oOڤu@Aڤ]R_....]^
<fianjmo> beAèSƯ_Ltò`Ih
{Annerose} ëDSo˪ơAӬOӤťӤDҭPC
<fianjmo> LۥHN\m˳uPJAMѻak
{Annerose} P˱ѡApP@ͦPC
<fianjmo> ӥiRpffٴOAuOAհա
{Annerose} ťAܤAXibڽc̡C
<fianjmo> oĤlAo򲢬iRyz]ߡ^
{Annerose} O@iRpʪ
<fianjmo> urAڭ̳o˯uOӤPFAذء
{Annerose} AگuObpʪo@䪺
<fianjmo> o׬bLwߡAA[WU۪@
{Annerose} pGS]QANASʦLFC
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
{Annerose} @UۤvOT֧a]^C
<fianjmo> ڪ]DNOڪDAڶȰObߧaIII
{Annerose} ]bGa@ⱵU^
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
{Annerose} oNKOتnFC
<fianjmo> AuAMıoӥtڷHAγ\|highWEѡH
{Annerose} ۳Br֧r]^
<fianjmo> ڳ̰QFաApIڦnFAհա
{Annerose} FHM]A٦SOإiHH^^;;
<fianjmo> uOAѥ~Ӥ@AHatUhFա]x^
{Annerose} _Apt٭nimI]ɦBYF^
<fianjmo> ]pOӱjԤhH^.^
{Annerose} ߧӪjAqŤo@hCkiH@sC
<fianjmo> Aڤ~|QAҫFI
{Annerose} p참lܪHANY^hFOC
<fianjmo> ګirCȡAAPxTANOAsb򩳡]^
{Annerose} ڷqó߷R[C
<fianjmo> AP仡۫HApOPnyH:p
{Annerose} n򳣥̰աC
<fianjmo> buiQ_HOOѡAvXͤeWr
{Annerose} 洫WrNpP洫FѪC
<fianjmo> ѾoA`D[AOFؼСAάOûg~H
{Annerose} [AۨsMAγ\NH@ʦ]PѰʤOC
<fianjmo> hhASY
{Annerose} ]pߦaw_ӡ^
<fianjmo> pⰩAVAquѤt_ӡH
{Annerose} FŤGrAOF@ӹڡC
<fianjmo> Oc]LYFA`ObWaJLAä^UC
{Annerose} P仡YpHA٦cNLkPaC
<fianjmo> Oc]LYFA`ObWaJLAä^UC
{Annerose} FbAoOoMBmCYϱ``O譱C
<fianjmo> buiQ_HOOѡAvXͤeWr
{Annerose} ]VOܥXsyl^
<fianjmo> ֦FաAP_٦b򤤡
{Annerose} {bӦnFaC
<fianjmo> հհǰǡ
{Annerose} uѤkOڪIv]UNKI^
<fianjmo> bӦ]׸ꪺհڰڰڡIII
{Annerose} ɨS}oAƫbNӦnFڡ
<fianjmo> buiQ_HOOѡAvXͤeWr
{Annerose} ]@}wt^
<fianjmo> Oc]LYFA`ObWaJLAä^UC
{Annerose} ]ߪɶF^
<fianjmo> bӦ]׸ꪺհڰڰڡIII
{Annerose} jHzNObNoIpա]^
<fianjmo> hpAp{Ȫet~a
{Annerose} nAڤ]QnȪetAڭ̩ҦnFC
<fianjmo> հհǰǡ
{Annerose} PdP仡YuAΥiOYؤ_ܴ{覡աC
<fianjmo> uA֨ӤFAoeeåIII
{Annerose} ]ۦbaW^
<fianjmo> `鳻FaI]^
{Annerose} OOAڦۤvӼnF]^C
<fianjmo> հհǰǡ
{Annerose} nաAڳצhFC
<fianjmo> հհǰǡ
{Annerose} ڡA|HPAllAݳlC
<fianjmo> LuΤOrUBA˸˵Lppu
{Annerose} bۤƪAyӳoOOAO諸uC
<fianjmo> ۤvboANO@^_ilp
{Annerose} nOFKsӼġA]|Q_nC
<fianjmo> YNOo˫ApٲzoǡIII
{Annerose} u{ھާ@OPz߳oطGkסH
<fianjmo> uA֨ӤFAoeeåIII
{Annerose} FAڦD|oبƪC
<fianjmo> C@ߡAAϧڶiJIANڶȦOPC
{Annerose} ӮڳFAӤ]SbaC
<fianjmo> pڥΤ|AOW۾xۭnˤfcơA@IOI
{Annerose} pӪDAScơA@pS¡C
<fianjmo> ٦ԣnAϥNOڭ˷C
{Annerose} SणܡA٤pܱoIC
<fianjmo> ӥiRpffٴOAuOAհա
{Annerose} SYhFAYĥHᳺMvC
<fianjmo> pⰩAVAquѤt_ӡH
{Annerose} n즺`PͩR|ƨg{A~^ƾu\C
<fianjmo> uOAΤOVYٯuOfѪO
{Annerose} VaAOͧihϮgC
<fianjmo> AiHiJڪOЮwAݩڪ@Co˦pڡAӴۭtڧaH
{Annerose} ڴNU_͡ANzϮ٥iH~aC
<fianjmo> pObֿRRڡAհա
{Annerose} ΤۡAnh֤@bl̺tC
<fianjmo> c@@ӹLFIAhQ߯uOLNhC
{Annerose} դUh§FAЬ۫Hڲ@hALױNӦpC
<fianjmo> IOPR@LҪAC
{Annerose} C@hԭzAbFPɡA]NF[KXC
<fianjmo> MۤvܬGPN~MpҤlгy̧󦳽C
{Annerose} n@UNԦTHƫҡCгyMгy̤oXӧaC
<fianjmo> AӦѰʰաAHfX賺M]ѥ@ɪ۰۩MC
{Annerose} JMOߵ奻KAڤ]lݤFC
<fianjmo> Aoᨥy_̡AaϧAڻ齧_......
{Annerose} _o@A٤p{@IlXӡC
<fianjmo> ګDoHLƪVɻPkhANǬy몺ۧڸHC
{Annerose} OoǸH@ۡAbLkQŪѪgߤŸʡC
<fianjmo> @~HNKAڳQADˤFC
{Annerose} JO@NåXANQbsתB]LܥiC
<fianjmo> 쩳Ӭ}ެOAL]ҥHM
{Annerose} Ӭ}ޡANOWڽשMLDqêC
<fianjmo> Fض}JM}ΦӥXioALPa
{Annerose} OˤFVl]^C
<fianjmo> uOAѥ~Ӥ@AHatUhFա]x^
{Annerose} ܥè߬QԮ^r]^C
<fianjmo> ڨSOoܡ
{Annerose} uOAn֤SΤۡ
<fianjmo> bӦ]׸ꪺհڰڰڡIII
{Annerose} ݪ̪ANOߦPŢ@˸It@Ӳݪ̡C
<fianjmo> ͢S۪Awnh쬡WǰOۥѷNӪͩRC
{Annerose} o򻡨ӡAȪetٯuOpڡC
<fianjmo> OӵyL}@UFաA
{Annerose} FOsA٬ONîwnC
<fianjmo> ڪ]DNOڪDAڶȰObߧaIII
{Annerose} jձooΤOAݰ_ӯuOC
<fianjmo> @AQгyFAANA]ݩAгy̡C
{Annerose} 餺d۳гy̼ɤOOLAʦs۰OФevƻPbءC
<fianjmo> urApPɶhAuHaQy ^____^ *bite*
{Annerose} ٬OVYnFAYnhAC
<fianjmo> AӪDAlW⪺F̦nLoV|Aʷ
{Annerose} ްlloWAڳ|o˰C
<fianjmo> NǤDHA@yh
{Annerose} pGOڨӳ]pA@wn˭Ӧz˸mC
<fianjmo> oӦ۰ʤƪpHհ
{Annerose} NOm@nFAiOڵLkLYUC
<fianjmo> ApNbڭ̪Ф
{Annerose} AQppRAڽפNS۸FC
<fianjmo> HaHa...]aC_^]UӴNڱ˦bɤWnF ^.^^
{Annerose} ڬݳoө]׸@wKy....
<fianjmo> LHANp]A ^^
{Annerose} áAש}lIηNFC
<fianjmo> poYAֻئۤvۤvoܡASٸ˼ҧ@
{Annerose} ]_^
<fianjmo> ǡAsL]o˥s۵۰ *___*
{Annerose} pG褣ѳfAڬOsȮܳioh@yC
<fianjmo> oǨӦ۩WBצФAC@ڳ@ǧڪGC
{Annerose} oǨGNdҾڨghssݡAӷwYVnFC
<fianjmo> ɭԡAAPUHau^PèAڷ|
{Annerose} ڻoO XX tCdDAڤ~Q
<fianjmo> i|Ho]ɤxӨA骺Ԥ~OͩR`ҦbC
{Annerose} Qd@^AӼhNFLYѯ^C@C
<fianjmo> buiQ_HOOѡAvXͤeWr
{Annerose} pGٻݭnOOAȨëDѦӬOjC
<fianjmo> LANsƫ᪺ۤv]g
{Annerose} ڤQoӤpB͹ܰա]_^C
<fianjmo> niRʧ@ڡAuOifI
{Annerose} oӬPyWAڳ̬ݤͪNOpB͡
<fianjmo> ݰ_ӧAnڤoڷllAA쩳OաH
{Annerose} pOөդHAo٭nݡ]Į^C
<fianjmo> AA֨ӳo@MAAڬOեػC
{Annerose} OڳQpեذա]_^CpGp夤n`ڤ]{FAiO....
<fianjmo> ϥLPֶqʡAHάWd
{Annerose} cASoYC
<fianjmo> ګirCȡAAPxTANOAsb򩳡]^
{Annerose} x֯x̭nOäF`HdhAٯ໴PnC
<fianjmo> gAаVHHAWaIII
{Annerose} {bڻݭn@JگıgAݭnٰա]_^
<fianjmo> cڦBc٦ئBNOOAiP氮p
{Annerose} ڭnhߡAYI\A@UݬݡC
<fianjmo> uDbFAKOLƤFC
{Annerose} AݯLסC
<fianjmo> ֦FաAP_٦b򤤡
{Annerose} ܻ^ӡAڤ]ܳwAèS߸KsC ^^;;
<fianjmo> oĤlAo򲢬iRyz]ߡ^
[Annerose] A̳oǤplppDA@IDaW....
<fianjmo> ݭnNM[PeJ餺APɳܤUBPzC
[Annerose] JMणܡA٤pܱoIC
<fianjmo> ~|򪺪AHιܹAoĤluOI]^
[Annerose] ``A˷`OĤGѰ_o̦HC
<fianjmo> XGAפԤ@^APUۤvNӡAoިߡC
[Annerose] OOAolzNۭӦnnۧaC
<fianjmo> aϧڨΤFPA@׾PC@A]AN֦FڡC
[Annerose] ΪAt@OAzˬOݡC
<fianjmo> nAHξAO̯N߮ؤJ̪RAӦDC
[Annerose] γ\AuKHgAOۨϧܱä۪AC
<fianjmo> аA{bڨS߱C
[Annerose] onդU߱h򭫭nAtzoӱz~BOC
<fianjmo> ګܷP§AUA]ͨFA۫ݡC
[Annerose] nƮӥIbAܴNOoozTC
<fianjmo> N|ϻP߬[ũAC
[Annerose] 󤣱ohAoصL`ڤ]O}Y[C
<fianjmo> ANbyүzȪ~Aaۥ򤣵LBC
[Annerose] ëDȪ@NjAOFíPRӤԴC}C
<fianjmo> ѦaڦXӤS}A°__C
[Annerose] bp¿ߡAaۤ@غzM[ݡC
<fianjmo> d骺DΤpDAOڨC]檺ҦbC
[Annerose] ާOHQAڨäQANHơC
<fianjmo> ڤʪOA`ӥѦۤvӳ]QaHAocҡI
[Annerose] FqӷPplA`O|ޱoڷQ_lANoasC
<fianjmo> ANo{@}AJrzoC
[Annerose] pPsWjzJAMaUDtΡAө󦹬۹JC
<fianjmo> AHڲ{bٻPq{aڦosAiѧAKyܡH
[Annerose] դUAoڥOInnC
<fianjmo> @I]|_{AAGIɪۭ⼦RڷP쮪M֮C
[Annerose] @ٲB@Ӥդ]|QڦiƮwA@t̾ڡC
<fianjmo> ڥiOoA󥲶zޱЪqȡC
[Annerose] Oq͸qȡAuOzϻC
<fianjmo> nޱдNnnޱФ@UۤvaI
[Annerose] vĩMũisO@˪nġC
<fianjmo> AC@^yXApPbG㪺IU_@RPC
[Annerose] ݧA]uo몺ƮޱoUȤWC
<fianjmo> ӬOoΤ߿W쪺]pC
[Annerose] èSDovrAȬO¦azѤFڥtC
<fianjmo> ֨ӳo@MAAHC@^ζܡHI]N^
[Annerose] ΨSΡAAڳܲMC
<fianjmo> ANhݬݧڬƺCҼ˧aC
[Annerose] zٯuOUfذڡALЧOw]Ҧ[OP@fC
<fianjmo> аA{bڨS߱C
[Annerose] QIANORC
<fianjmo> oOڪUҡApA]Ӥ߯ʷnBrOiGH
[Annerose] OѻoOQjPA򳣬OOHGAC
<fianjmo> ר𨾡AڱqӨSǬN{{LC
[Annerose] ڭ˷QD@UMժwqnӼgkC
<fianjmo> AuOSϤFI]ݴ^
[Annerose] AިӰڡ]N^C
<fianjmo> ګܷP§AUA]ͨFA۫ݡC
[Annerose] YFIANOAoطdMpQUȡC
<fianjmo> HsOFAY 0_____o
[Annerose] iHڡAO֤Guڳa]YFphHsCv
<fianjmo> AoӪᨥy_̡AڻצٽPf_C
{Annerose} OOAڨSϤFApH
<fianjmo> hAVb֦H]ݴ^
{Annerose} ӰڡAȧAC
<fianjmo> ALաAYĶܡI
{Annerose} OֲoRNAĲͲDAoLѯuXC
<fianjmo> pZLסAORNooLɩѡC
{Annerose} ҥHAsW­`A٤OdMۧڰkתAܤơC
<fianjmo> IWܴNhBˬݬݰաANOA`nơAC
{Annerose} æӭۧڡA]LNOo^ơC
<fianjmo> AHڳsWۥͬOSHIϥΡHҦvH
{Annerose} ߤ@DӤUAVLɪ·tH۳\C
<fianjmo> ڥiOoA󥲶zޱЪqȡC
{Annerose} h޶ơAuO_ǡC
<fianjmo> аA{bڨS߱C
{Annerose} ڥiSDTz|rC
<fianjmo> nޱдNnnޱФ@UۤvaI
{Annerose} ťo@sDWƸANDI檺OӦa]N^C
<fianjmo> ڥIOέOAoD窺GaүાH
{Annerose} ڤ~QݩOAzۭӺCΡC
<fianjmo> ݭnNM[PeJ餺APɳܤUBPzC
{Annerose} oӨLyJAMO|bzr̪C
<fianjmo> ~|򪺪AHιܹAoĤluOI]^
[Annerose] ڬOӨScND]̡C
<fianjmo> @I]|_{AAGIɪۭ⼦RڷP쮪M֮C
[Annerose] OOAzкCΡ]^C
<fianjmo> A]O̡C
[Annerose] zoO]uեزVbL^C
<fianjmo> ڲMoܡAۤvyObӦ۳oǤCsKL\ʡC
[Annerose] uzʦotz٥FALتʳo~YO_fi~....
<fianjmo> Ha|eڪ[AL׬OչDCȩάO©]֦H]ߡ^
[Annerose] JM§^~eWӡAPMݱzOaC
<fianjmo> unݥXǷLAۤvN|jWҪMC
[Annerose] o٬O̲Ĥ@٩OAۤvuC
<fianjmo> AODڪӾAS󶷦pըԡH
[Annerose] zٯuOѤUDWAֳoDzӾ~tPzWyOC
<fianjmo> ALաAYĶܡI
[Annerose] ڥo@СAХXa]^C
<fianjmo> AFoǨǤ~]C_^
[Annerose] oOA}NSoFrC
<fianjmo> zbժC
[Annerose] OժλӴۤvxMC
<fianjmo> hAhAAic֦HIII]^
[Annerose] OOAziuWFC
<fianjmo> ANDplBաHAOΤߪd...
[Annerose] ڦHɳQ妺ͪı~X۪
<fianjmo> ݭnNM[PeJ餺APɳܤUBPzC
[Annerose] yɻ⮩AoOt@ΦML԰}C
<fianjmo> IWܴNhBˬݬݰաANOA`nơAC
[Annerose] P±zUoǤnj󪺼ˡAo̬OڡAñWC
<fianjmo> FIڽ֪F]OI]ΤO^
[Annerose] H@S@α˨ӹG㪺AȱomWíPhŭSġC
<fianjmo> a{w骺ݨDwPPۧڪmAuOI
[Annerose] רOۧڮit@AɨFxnPAA`o󪫥ۤC
<fianjmo> zoӰFaAǤ۳sڪŤ]H⦬UC
[Annerose] ϥڳONNl@UӰաC
<fianjmo> AAާڡ
[Annerose] ڻHFHūסC
<fianjmo> ڪۦ樮S^ӤFCӤOQC
[Annerose] ڡA٬Oۦ樮nC
<fianjmo> ²檺˸mANqഫHһݭnΦAuOXC
[Annerose] iOM_ӦI֡COVӶVtFC
<fianjmo> ApuǷ|FC
[Annerose] G{bSܱontC
<fianjmo> jAYUC
[Annerose] OvNOSɶΡCC
<fianjmo> n즺`PͩR|ƨg{A~^ƾu\C
[Annerose] o򻡨ӡAOǤe\QƪOC
<fianjmo> OOAڦAQ]SF]ܯ^C
[Annerose] ݰ_ӯuܨLܡH
<fianjmo> 餺d۳гy̼ɤOOLAʦs۰OФevƻPbءC
[Annerose] ѤwgS򤶷NFOC
<fianjmo> A_ͳQdbaH
[Annerose] HiHHpBmAiOzoAu_PıC
<fianjmo> nhqvSݹLC
[Annerose] ݹqvKyOCVӶV֤FC
<fianjmo> áAש}lIηNFC
[Annerose] oLOdMۧڰkתAܤơC
<fianjmo> ڥiOoA󥲶zޱЪqȡC
[Annerose] onz߱h򭫭nAjaoӱzƩOC
<fianjmo> ګܷP§AUA]ͨFA۫ݡC
[Annerose] ֺާAڡAۤvhQkC
<fianjmo> ר𨾡AڱqӨSǬN{{LC
[Annerose] OOAh޶ơAuO_ǡC
<fianjmo> AӹLFa]r^
[Annerose] nDٯu֡AQꥻ۷eΧaC
<fianjmo> аA{bڨS߱C
[Annerose] nաAo̧ڨӦBnFC
<fianjmo> hAhAAic֦HIII]^
[Annerose] z]WFAoIAȴNKOتC
<fianjmo> AӪᨥy_̡I
[Annerose] nzsAi]OӹLyaC
<fianjmo> A`ѳfAPOڪWߥs|]갭y^
[Annerose] OժλӴOHxC
<fianjmo> A]O̡C
[Annerose] iO־go_ڳo򼷧˪C
<fianjmo> AAާڡ
[Annerose] ZޱzƩOAڬOo@ФF]^C
<fianjmo> ڥIOέOAoD窺GaүાH
[Annerose] OOAzWF]^^C
<fianjmo> ANDplBաHAOΤߪd...
[Annerose] SDڪn`aC
<fianjmo> iOԣOHAnO֦HAo]ӸplAuOۧ䪺I
[Annerose] yhOֲӺo@lAӰߦ~঱ɨ䧮C
<fianjmo> ګܷP§AUA]ͨFA۫ݡC
[Annerose] ڥiOHɦQ妺ı~X۪
<fianjmo> nޱдNnnޱФ@UۤvaI
[Annerose] oMSwӤHbSsAٽЩųC
<fianjmo> ֨ӳo@MAAHC@^ζܡHI]N^
[Annerose] AoˬOuǥiC
<fianjmo> AoӥioӼ̡I
[Annerose] LW@^NܰF]^
<fianjmo> unݥXǷLAۤvN|jWҪMC
[Annerose] AͮFAoUiOOHGAFaC
<fianjmo> FIڽ֪F]OI]ΤO^
[Annerose] o໡OA}NȿF]^C
<fianjmo> d骺DΤpDAOڨC]檺ҦbC
[Annerose] ڤSvFC
<fianjmo> Ha|eڪ[AL׬OչDCȩάO©]֦H]ߡ^
[Annerose] [ܦhتAL@qIO̳C
<fianjmo> ڤSSnC@[]ӦYڡAuO_FC
[Annerose] iFA]unɥi֤lFC
<fianjmo> ڪYväFAA]ݾzAi_KƧΥX@yާxH
[Annerose] ӴNeӤFaAеywļC
<fianjmo> έհǡIII
[Annerose] OAлդU̡]@u^C
<fianjmo> ֨ӳo@MAAHC@^ζܡHI]N^
[Annerose] ooApOLAٽШ̡]@u^C
<fianjmo> ֨ӳo@MAAHC@^ζܡHI]N^
[Annerose] njک]DiALڷ|C
<fianjmo> ťn㦳HեرoiRAiHOFٶgż
[Annerose] oiAFC
<fianjmo> oAAղVڡAٷaI
[Annerose] ڤ]un̳BmF....]^
<fianjmo> ӬOoΤ߿W쪺]pC
[Annerose] SôAW᩼§DOC
<fianjmo> zbժC
[Annerose] pGHAOӬOAA{bNiHڥUDC
<fianjmo> a{w骺ݨDwPPۧڪmAuOI
[Annerose] HרuۦۧڪֺqAtP]C
<fianjmo> ]NE^
[Annerose] rAoNLYC
<fianjmo> hAhAAic֦HIII]^
[Annerose] Cߧڪu@SdFC
<fianjmo> FIڽ֪F]OI]ΤO^
[Annerose] OաAګܲMFC
<fianjmo> SΨSΡAuOn{lUA঳Φh֦ڡH
[Annerose] oº骺FOXӪڡC
<fianjmo> zbժC
[Annerose] oǤpƥ浹\઺hӺޱoաC
<fianjmo> DA󪫪A~|ް_¥ձNxIQڡI
[Annerose] I𥼧KӤ۶qOAӤNܰFC
<fianjmo> IWܴNhBˬݬݰաANOA`nơAC
[Annerose] [AnñWNܺF]ߡ^C
<fianjmo> MۤvAOsۨ]Lkso`WC
[Annerose] ڦ۳ƮMءAo˰OFa
<fianjmo> unݥXǷLAۤvN|jWҪMC
[Annerose] OաAڨSϤF]^C
<fianjmo> hAVb֦H]ݴ^
[Annerose] OڡAn߳C
<fianjmo> аA{bڨS߱C
[Annerose] oAڬOLdC
<fianjmo> XGAפԤ@^APUۤvNӡAoިߡC
[Annerose] OAzhO]^C
<fianjmo> ڥIOέOAoD窺GaүાH
[Annerose] pgAiSDTߥ|rAդUC
<fianjmo> ǡA{bNڹoǤ|T\__/
[Annerose] OOAڦۧ䪺]^C
<fianjmo> ר𨾡AڱqӨSǬN{{LC
[Annerose] γoCsߡAB̦bKڤըԫҤN۩OC
<fianjmo> DA󪫪A~|ް_¥ձNxIQڡI
[Annerose] I𤣴AڮӼƦ۾AbfӯdNܰFC
<fianjmo> oAAղVڡAٷaI
[Annerose] nШhѼsդUhhС]^C
<fianjmo> hhhA{bᤣڶEAicI
[Annerose] wgQzvsAiХidFC
<fianjmo> aϧڨΤFPA@׾PC@A]AN֦FڡC
[Annerose] oOHרҧu۪ɳsqAOLkH÷TwbWDrbC
<fianjmo> AHڳsWۥͬOSHIϥΡHҦvH
[Annerose] YťoܰAqn٬OdUf״C
<fianjmo> ֭nAݳoҼˡAkQAڡI
[Annerose] OAi椣iY]ŪsyF@夣۶qO[C
<fianjmo> AoӥioӼ̡I
[Annerose] ӻXgAԦb¹L]^C
<fianjmo> ڡAuOI]_^
[Annerose] α˳ZO]nuAȱomWíPhŭSġC
<fianjmo> gLZOAAڪuC
[Annerose] NHWƸBDSAVƺCPʦXPWqNC
<fianjmo> pgӴ_lAbHxߤWtۨSŪڴKqC
[Annerose] bGn^줧AٮeUHMC
<fianjmo> nAHξAO̯N߮ؤJ̪RAӦDC
[Annerose] yhOӥo@lAѰèӴRPɻsyֽC
<fianjmo> AhAIII
[Annerose] DunOQhAެOHΦA....LJӤ۱o]^H
<fianjmo> ]ڤҥHڡA~i൹oHWAC
[Annerose] ߦ{ʪKA~ޱo@HC
<fianjmo> a{w骺ݨDwPPۧڪmAuOI
[Annerose] oڤȡAȪONHJYz]^C
<fianjmo> ڤʪOA`ӥѦۤvӳ]QaHAocҡI
[Annerose] ФFA]RɨFQΪ߻Pֽ]^C
<fianjmo> ڤʪOA`ӥѦۤvӳ]QaHAocҡI
[Annerose] GuSΡA{bګ˳n_ӤF]\^C
<fianjmo> έհǡIII
[Annerose] pGzuӭӧNMHAMڴNܤXFrC
<fianjmo> iOԣOHAnO֦HAo]ӸplAuOۧ䪺I
[Annerose] ެOQbκaAdHѯΪjlC
<fianjmo> ANbyүzȪ~Aaۥ򤣵LBC
[Annerose] α˳ZO]nuAȱomWíPhŭSġC
<fianjmo> հհաڭ~AF@jL֤lneA
[Annerose] ӻXӡAԦb¹L]^C
<fianjmo> ګܷP§AUA]ͨFA۫ݡC
[Annerose] Uӽ}A]\pDAڤ@QPpͽ͡C
<fianjmo> |bC@Ө{OA
[Annerose] ]O鯫dRpkqgB̬rġC
<fianjmo> uHڪwӧ襭
[Annerose] bLƪcPUA⤤KCMX`OopC
<fianjmo> `OôbAsKˤl
[Annerose] W|a{hԧW~H
<fianjmo> Oε]y
[Annerose] SdoFh@ˬKC
<fianjmo> @˧ڪCAu@H
[Annerose] @ɤWˤHƪADȼCӤwC
<fianjmo> A`Oo˻AڦӨAouߤ@uڱٯ}
[Annerose] ϩpҴëDߤ@uAQp_ZOH
<fianjmo> |bC@Ө{OA
[Annerose] MӡApҵԪO|HLo۸OPlC
<fianjmo> i|hHݨB
[Annerose] ֮LA]O֪hC
<fianjmo> qSLôb
[Annerose] AڪDpC
<fianjmo> zեҬJ
[Annerose] Aоа_jѪJAϮȤHYMƥhTAӫD_C
<fianjmo> ɡA뤣oAWrѧCy
[Annerose] Cs̪M߸۷NPհs̪éͬKA~NF~sHަyC
<fianjmo> άObؽݥ@DѤ
[Annerose] Ohްʷ|NѦasPۨ@֧]I쪺ùC
<fianjmo> M۰sbA갩
[Annerose] QAOԱۯ[sMHڡC
<fianjmo> ...
[Annerose] JMpANnnιC
<fianjmo> aϧڨΤFPA@׾PC@A]AN֦FڡC
[Annerose] λP۫ݡASnMPòsuC
<fianjmo> AuOSϤFI]ݴ^
[Annerose] չաAڻ{FC
<fianjmo> oٯuOHeصޡ
[Annerose] 򤣭ӰlAAݧڴXӰDڡC
<fianjmo> zbժC
[Annerose] Zۺ٦ҾժALOۮ}FC
<fianjmo> A]O̡C
[Annerose] o٥s|TAlbӭpkC
<fianjmo> AAYI߫ٶ|EI
[Annerose] oӰdDڷ|۲zANұ߰աC
<fianjmo> AuOSϤFI]^
[Annerose] _Aᨥy]λդUqưC
<fianjmo> аA{bڨS߱C
[Annerose] ϱzNA_̴NOѱztFC
<fianjmo> MӳzL˥ԪkAٰʵۦۤvAOIl@êB۫HC
[Annerose] unO[sA򳣦]^C
<fianjmo> iJbazè߬yplmode......>.<
[Annerose] ۥAa̪Bx_@oMLC
<fianjmo> gLZOAAڪuC
[Annerose] b𪺷UAKNίEƪϨQiC
<fianjmo> ݭnNM[PeJ餺C
[Annerose] cAǤFڧaAod۱zۭӫ~|C
<fianjmo> ګܷP§AUA]ͨFA۫ݡC
[Annerose] MSȮ_ӡH
<fianjmo> oˬOSDAϦӤHawΪ|]ߡ^
[Annerose] oˬOAӻX۫ݤF]Xx^C
<fianjmo> ӬOoΤ߿W쪺]pC
[Annerose] ONbɥȵ{AfҥXnz]}H
<fianjmo> NAgѧڪPNAJóxAAocҡI
[Annerose] ̤jDOAoPNsnӼgkC
<fianjmo> hAhAAic֦HIII]^
[Annerose] ]HHaNoإFUӡ^
<fianjmo> FIڽ֪F]OI]ΤO^
[Annerose] O֪FALO֪H}F]ըԡ^C
<fianjmo> @I]|_{AAGIɪۭ⼦RڷP쮪M֮C
[Annerose] oNO̭nRDA_̮IêַPC
<fianjmo> ~|򪺪AHιܹAoĤluOI]^
[Annerose] N_ҩ}AַPPɴN]oFڡC
<fianjmo> MۤvAOsۨ]Lkso`WC
[Annerose] wgӻX۫ݤFH~hؤfաC
<fianjmo> gLZOAAڪuC
[Annerose] cAo˧۪ksڳoƻsıoLC
<fianjmo> FIڽ֪F]OI]ΤO^
[Annerose] OOA٬O쥿ƥhaC
<fianjmo> NAgѧڪPNAJóxAAocҡI
[Annerose] Ӧo̫OJAqëɶYDC
<fianjmo> ~|򪺪AHιܹAoĤluOI]^
[Annerose] iS򪺮ɶAU^ڷǳƦnAӹaC
<fianjmo> d骺DΤpDAOڨC]檺ҦbC
[Annerose] OOAA洫污C
<fianjmo> ڡAuOI]_^
[Annerose] HƤUFUL@޸uASQ٬Obgc̥FVC
<fianjmo> ѦaڦXӤS}A°__C
[Annerose] ګܲMoǶǻDѤ]C
<fianjmo> SΨSΡAuOn{lUA঳Φh֦ڡH
[Annerose] MӡAqӤ{ۤvNK󮣩ƤѨϪbC
<fianjmo> ANo{@}AJrzoC
[Annerose] gЯuO@خƪCC
<fianjmo> d骺DΤpDAOڨC]檺ҦbC
[Annerose] ϰNXAhO@ӵLkqNѤhWrC
<fianjmo> ANbyүzȪ~Aaۥ򤣵LBC
[Annerose] bӹL@hA洫FLƪЫʬGơC
<fianjmo> ڤʪOA`ӥѦۤvӳ]QaHAocҡI
[Annerose] ]xaXucӡ^
<fianjmo> ݭnNM[PeJ餺APɳܤUBPzC
[Annerose] Thès֮o_o˪~C
<fianjmo> N|ϻP߬[ũAC
[Annerose] gon֡AگuOۧ䪺C
<fianjmo> ANDplBաHAOΤߪd...
[Annerose] {bıoܤiĳAɫ򴱭ApMIۡC
<fianjmo> AoӥioӼ̡I
[Annerose] ֨uѤU@ioȪLOLFC ^^
<fianjmo> a{w骺ݨDwPPۧڪmAuOI
[Annerose] nױzͮAKӤ۶qOC
<fianjmo> IWܴNhBˬݬݰաANOA`nơAC
[Annerose] U^FA@FӫܬcڡC
<fianjmo> zbժC
[Annerose] hӫСAڷ|ɶqW[ޯVmC
<fianjmo> hAVb֦H]ݴ^
[Annerose] OڡAڷ|ObC
<fianjmo> ѦaڦXӤS}A°__C
[Annerose] pKɶyP[vԭzΦ_PcC
<fianjmo> hAhAAic֦HIII]^
[Annerose] @Q@̪[sAYϬOpǽT륩ζHΡC
<fianjmo> oOڪUҡApA]Ӥ߯ʷnBrOiGH
[Annerose] pˬOڷQQAoبH쩳F򥴼....
<fianjmo> OoƵ۬۹JAPDOC
[Annerose] oӥçT^kSUBڡC
<fianjmo> ]Bn^
[Annerose] MS@Ik}}ANo˲W䧮QAuSΡC
<fianjmo> zٯuOUfذڡALЧOw]Ҧ[OP@fC
[Annerose] ڤ~SOA@IIS٤⪺NڡC
<fianjmo> ްlloWAڳ|o˰C
[Annerose] ̫ᨺطPıbAıo٤pFC
<fianjmo> ӮڳFAӤ]SbaC
[Annerose] poyܥX{ouOɭԡ]ԤQ^C
<fianjmo> Ȧw]L^C
[Annerose] ߤ_FANnh}ڡ]Yjs^C
<fianjmo> LKALK
[Annerose] OۤFAڷQQաC
<fianjmo> ڡAQo{FܡH
[Annerose] FA٬OIBBC
<fianjmo> оǬOܪɶC
[Annerose] OHɳQ妺ͪıܡH
<fianjmo> yɻ⮩AoOt@ΦML԰}C
[Annerose] o˴NȤFAuˤlC
<fianjmo> AQppRAڽפNS۸FC
[Annerose] AUhA𦭷|⥻ӴNhƱѥC
<fianjmo> 襻ټhAwMzioC
[Annerose] OrANۤv{@IOרHaաC
<fianjmo> OoǸH@ۡAbLkQŪѪgߤŸʡC
[Annerose] {b٨SǮHơAOxjFC
<fianjmo> դUAoڥOInnC
[Annerose] ڪDAiODSΰڡC
<fianjmo> ߩMѨϳ߷R[ݡC
[Annerose] Ѫ۳¬ݤUBˤlniR]ߡ^C
<fianjmo> ӬO줣FC
[Annerose] OAݤFCiO{bnáC
<fianjmo> LΪAunɶ@٬OɵDC
[Annerose] {bNXDF]\^C
<fianjmo> Qۭn٨SRXӡALwgX{F@MժѡC
[Annerose] ѬݤFա]j^C
<fianjmo> ڪWOߧ쪺˲@C
[Annerose] CѷUߤ]n֡C
<fianjmo> nƮӥIbAܴNOoozTC
[Annerose] AڤDC
<fianjmo> QQDANXͷC
[Annerose] ӤΤFAMq}lڴND`aԷV....
<fianjmo> [ıqӤOzC
[Annerose] OFAC
<fianjmo> ~`NA]Pɽs´bӦ۪ܸ̭C
[Annerose] ڨSiHAXӪFC
<fianjmo> numAboVפAڳsp֦HڶNJWFApOHI
[Annerose] 藍_AڵLରO]D`aL^C
<fianjmo> ӥiRpffٴOAuOAհա
[Annerose] n_ǡADo^ơC
<fianjmo> OӵyL}@UFաA
[Annerose] ӨSƱANSn}C
<fianjmo> ڪ]DNOڪDAڶȰObߧaIII
[Annerose] ^ơH
<fianjmo> OӵyL}@UFաA
[Annerose] `ıonpܤlC
<fianjmo> ApNbڭ̪Ф
[Annerose] FANuڷQ@ˡAڤ]SƳBzC
<fianjmo> IOPR@LҪAC
[Annerose] ]bNAťıxQi}FLH_[ǫסC
<fianjmo> OԤߡAڷ|nͦBݧC
[Annerose] phOCڥuవoˤFC
<fianjmo> ۤvboANO@^_ilp
