################################################################################
#
#  PPPort_xs.PL -- generate PPPort.xs
#
################################################################################
#
#  $Revision: 9 $
#  $Author: mhx $
#  $Date: 2006/01/14 18:07:55 +0100 $
#
################################################################################
#
#  Version 3.x, Copyright (C) 2004-2006, Marcus Holland-Moritz.
#  Version 2.x, Copyright (C) 2001, Paul Marquess.
#  Version 1.x, Copyright (C) 1999, Kenneth Albanowski.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.
#
################################################################################

use strict;
$^W = 1;
require "parts/ppptools.pl";

my %SECTION = (
  xshead => { code => '', header => "/* ---- from __FILE__ ---- */" },
  xsinit => { code => '', header => "/* ---- from __FILE__ ---- */" },
  xsmisc => { code => '', header => "/* ---- from __FILE__ ---- */" },
  xsboot => { code => '', header => "/* ---- from __FILE__ ---- */", indent => "\t" },
  xsubs  => { code => '', header => "##".('-' x 70)."\n##  XSUBs from __FILE__\n##".('-' x 70)."\n" },
);

if (exists $ENV{PERL_NO_GET_CONTEXT} && $ENV{PERL_NO_GET_CONTEXT}) {
$SECTION{xshead}{code} .= <<END;
#define PERL_NO_GET_CONTEXT
END
}

my $file;
my $sec;

for $file (glob 'parts/inc/*') {
  my $spec = parse_partspec($file);

  my $msg = 0;
  for $sec (keys %SECTION) {
    if (exists $spec->{$sec}) {
      $msg++ or print "adding XS code from $file\n";
      if (exists $SECTION{$sec}{header}) {
        my $header = $SECTION{$sec}{header};
        $header =~ s/__FILE__/$file/g;
        $SECTION{$sec}{code} .= $header . "\n";
      }
      $SECTION{$sec}{code} .= $spec->{$sec} . "\n";
    }
  }
}

my $data = do { local $/; <DATA> };

for $sec (keys %SECTION) {
  my $code = $SECTION{$sec}{code};
  if (exists $SECTION{$sec}{indent}) {
    $code =~ s/^/$SECTION{$sec}{indent}/gm;
  }
  $code =~ s/[\r\n]+$//;
  $data =~ s/^__\U$sec\E__$/$code/m;
}

open FH, ">PPPort.xs" or die "PPPort.xs: $!\n";
print FH $data;
close FH;

exit 0;

__DATA__
/*******************************************************************************
*
*  !!!!! Do NOT edit this file directly! -- Edit PPPort_xs.PL instead. !!!!!
*
********************************************************************************
*
*  Perl/Pollution/Portability
*
********************************************************************************
*
*  $Revision: 9 $
*  $Author: mhx $
*  $Date: 2006/01/14 18:07:55 +0100 $
*
********************************************************************************
*
*  Version 3.x, Copyright (C) 2004-2006, Marcus Holland-Moritz.
*  Version 2.x, Copyright (C) 2001, Paul Marquess.
*  Version 1.x, Copyright (C) 1999, Kenneth Albanowski.
*
*  This program is free software; you can redistribute it and/or
*  modify it under the same terms as Perl itself.
*
*******************************************************************************/

/* ========== BEGIN XSHEAD ================================================== */

__XSHEAD__

/* =========== END XSHEAD =================================================== */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* ========== BEGIN XSINIT ================================================== */

__XSINIT__

/* =========== END XSINIT =================================================== */

#include "ppport.h"

/* ========== BEGIN XSMISC ================================================== */

__XSMISC__

/* =========== END XSMISC =================================================== */

MODULE = Devel::PPPort		PACKAGE = Devel::PPPort

BOOT:
__XSBOOT__

__XSUBS__
