#!/usr/bin/env perl

use 5.010;
use strict;
use warnings;

package Medical::Growth::NHANES_2000::BMI_for_Age::Child::Female;

our ($VERSION) = '1.00';

use Moo::Lax;    # Vanilla Moo considered harmful

extends 'Medical::Growth::NHANES_2000::Base';

__PACKAGE__->_declare_params_LMS;

# Inlined rather than in a base class - too small to merit reading
# another file
sub bmi {
    my ( $self, $wt_kg, $ht_cm ) = @_;
    return unless $ht_cm and $wt_kg;
    return 10000 * $wt_kg / $ht_cm**2;
}

1;

# bmiagerev, sex = 2

__DATA__

24	-0.98660853	16.42339664	0.085451785
24.5	-1.024496827	16.38804056	0.085025838
25.5	-1.102698353	16.3189719	0.084214052
26.5	-1.18396635	16.25207985	0.083455124
27.5	-1.268071036	16.18734669	0.082748284
28.5	-1.354751525	16.12475448	0.082092737
29.5	-1.443689692	16.06428762	0.081487717
30.5	-1.53454192	16.00593001	0.080932448
31.5	-1.626928093	15.94966631	0.080426175
32.5	-1.720434829	15.89548197	0.079968176
33.5	-1.814635262	15.84336179	0.079557735
34.5	-1.909076262	15.79329146	0.079194187
35.5	-2.003296102	15.7452564	0.078876895
36.5	-2.096828937	15.69924188	0.078605255
37.5	-2.189211877	15.65523282	0.078378696
38.5	-2.279991982	15.61321371	0.078196674
39.5	-2.368732949	15.57316843	0.078058667
40.5	-2.455021314	15.53508019	0.077964169
41.5	-2.538471972	15.49893145	0.077912684
42.5	-2.618732901	15.46470384	0.077903716
43.5	-2.695488973	15.43237817	0.077936763
44.5	-2.768464816	15.40193436	0.078011309
45.5	-2.837426693	15.37335154	0.078126817
46.5	-2.902178205	15.34660842	0.078282739
47.5	-2.962580386	15.32168181	0.078478449
48.5	-3.018521987	15.29854897	0.078713325
49.5	-3.069936555	15.27718618	0.078986694
50.5	-3.116795864	15.2575692	0.079297841
51.5	-3.159107331	15.23967338	0.079646006
52.5	-3.196911083	15.22347371	0.080030389
53.5	-3.230276759	15.20894491	0.080450145
54.5	-3.259300182	15.19606152	0.080904391
55.5	-3.284099963	15.18479799	0.081392203
56.5	-3.30481415	15.17512871	0.081912623
57.5	-3.321596954	15.16702811	0.082464661
58.5	-3.334615646	15.16047068	0.083047295
59.5	-3.344047622	15.15543107	0.083659478
60.5	-3.35007771	15.15188405	0.084300139
61.5	-3.352893805	15.14980479	0.0849682
62.5	-3.352691376	15.14916825	0.085662539
63.5	-3.34966438	15.14994984	0.086382035
64.5	-3.343998803	15.15212585	0.087125591
65.5	-3.335889574	15.15567186	0.087892047
66.5	-3.325522491	15.16056419	0.088680264
67.5	-3.31307846	15.16677947	0.089489106
68.5	-3.298732648	15.17429464	0.090317434
69.5	-3.282653831	15.18308694	0.091164117
70.5	-3.265003896	15.1931339	0.092028028
71.5	-3.245937506	15.20441335	0.092908048
72.5	-3.225606516	15.21690296	0.093803033
73.5	-3.204146115	15.2305815	0.094711916
74.5	-3.181690237	15.24542745	0.095633595
75.5	-3.158363475	15.26141966	0.096566992
76.5	-3.134282833	15.27853728	0.097511046
77.5	-3.109557879	15.29675967	0.09846471
78.5	-3.084290931	15.31606644	0.099426955
79.5	-3.058577292	15.33643745	0.100396769
80.5	-3.032505499	15.35785274	0.101373159
81.5	-3.0061576	15.38029261	0.10235515
82.5	-2.979609448	15.40373754	0.103341788
83.5	-2.952930993	15.42816819	0.104332139
84.5	-2.926186592	15.45356545	0.105325289
85.5	-2.899435307	15.47991037	0.106320346
86.5	-2.872731211	15.50718419	0.10731644
87.5	-2.846123683	15.53536829	0.108312721
88.5	-2.819657704	15.56444426	0.109308364
89.5	-2.793374145	15.5943938	0.110302563
90.5	-2.767310047	15.6251988	0.111294537
91.5	-2.741498897	15.65684126	0.112283526
92.5	-2.715970894	15.68930333	0.113268793
93.5	-2.690753197	15.7225673	0.114249622
94.5	-2.665870146	15.75661555	0.115225321
95.5	-2.641343436	15.79143062	0.116195218
96.5	-2.617192204	15.82699517	0.117158667
97.5	-2.593430614	15.86329241	0.118115073
98.5	-2.570076037	15.90030484	0.119063807
99.5	-2.547141473	15.93801545	0.12000429
100.5	-2.524635245	15.97640787	0.120935994
101.5	-2.502569666	16.01546483	0.121858355
102.5	-2.48095189	16.05516984	0.12277087
103.5	-2.459785573	16.09550688	0.123673085
104.5	-2.439080117	16.13645881	0.124564484
105.5	-2.418838304	16.17800955	0.125444639
106.5	-2.399063683	16.22014281	0.126313121
107.5	-2.379756861	16.26284277	0.127169545
108.5	-2.360920527	16.30609316	0.128013515
109.5	-2.342557728	16.34987759	0.128844639
110.5	-2.324663326	16.39418118	0.129662637
111.5	-2.307240716	16.43898741	0.130467138
112.5	-2.290287663	16.48428082	0.131257852
113.5	-2.273803847	16.53004554	0.132034479
114.5	-2.257782149	16.57626713	0.132796819
115.5	-2.242227723	16.62292864	0.133544525
116.5	-2.227132805	16.67001572	0.134277436
117.5	-2.212495585	16.71751288	0.134995324
118.5	-2.19831275	16.76540496	0.135697996
119.5	-2.184580762	16.81367689	0.136385276
120.5	-2.171295888	16.86231366	0.137057004
121.5	-2.158454232	16.91130036	0.137713039
122.5	-2.146051754	16.96062216	0.138353254
123.5	-2.134084303	17.0102643	0.138977537
124.5	-2.122547629	17.06021213	0.139585795
125.5	-2.111437411	17.11045106	0.140177947
126.5	-2.100749266	17.16096656	0.140753927
127.5	-2.090478774	17.21174424	0.141313686
128.5	-2.080621484	17.26276973	0.141857186
129.5	-2.071172932	17.31402878	0.142384404
130.5	-2.062128649	17.3655072	0.142895332
131.5	-2.053484173	17.4171909	0.143389972
132.5	-2.045235058	17.46906585	0.143868341
133.5	-2.03737688	17.52111811	0.144330469
134.5	-2.029906684	17.57333347	0.144776372
135.5	-2.022817914	17.62569869	0.145206138
136.5	-2.016107084	17.67819987	0.145619819
137.5	-2.009769905	17.7308234	0.146017491
138.5	-2.003802134	17.78355575	0.146399239
139.5	-1.998199572	17.83638347	0.146765161
140.5	-1.992958064	17.88929321	0.147115364
141.5	-1.988073505	17.94227168	0.147449967
142.5	-1.983541835	17.9953057	0.147769097
143.5	-1.979359041	18.04838216	0.148072891
144.5	-1.975521156	18.10148804	0.148361495
145.5	-1.972024258	18.15461039	0.148635067
146.5	-1.968864465	18.20773639	0.148893769
147.5	-1.966037938	18.26085325	0.149137776
148.5	-1.963540872	18.31394832	0.14936727
149.5	-1.961369499	18.36700902	0.149582439
150.5	-1.959520079	18.42002284	0.149783482
151.5	-1.9579889	18.47297739	0.149970604
152.5	-1.956772271	18.52586035	0.15014402
153.5	-1.95586652	18.57865951	0.15030395
154.5	-1.955267984	18.63136275	0.150450621
155.5	-1.954973011	18.68395801	0.15058427
156.5	-1.954977947	18.73643338	0.150705138
157.5	-1.955279136	18.788777	0.150813475
158.5	-1.955872909	18.84097713	0.150909535
159.5	-1.956755579	18.89302212	0.150993582
160.5	-1.957923436	18.94490041	0.151065883
161.5	-1.959372737	18.99660055	0.151126714
162.5	-1.9610997	19.04811118	0.151176355
163.5	-1.963100496	19.09942105	0.151215094
164.5	-1.96537124	19.15051899	0.151243223
165.5	-1.967907983	19.20139397	0.151261042
166.5	-1.970706706	19.25203503	0.151268855
167.5	-1.973763307	19.30243131	0.151266974
168.5	-1.977073595	19.35257209	0.151255713
169.5	-1.980633277	19.40244671	0.151235395
170.5	-1.984437954	19.45204465	0.151206347
171.5	-1.988483106	19.50135548	0.151168902
172.5	-1.992764085	19.55036888	0.151123398
173.5	-1.997276103	19.59907464	0.15107018
174.5	-2.002014224	19.64746266	0.151009595
175.5	-2.00697335	19.69552294	0.150942
176.5	-2.012148213	19.7432456	0.150867753
177.5	-2.017533363	19.79062086	0.150787221
178.5	-2.023123159	19.83763907	0.150700774
179.5	-2.028911755	19.88429066	0.150608788
180.5	-2.034893091	19.9305662	0.150511645
181.5	-2.041060881	19.97645636	0.150409731
182.5	-2.047408604	20.02195192	0.15030344
183.5	-2.05392949	20.06704377	0.150193169
184.5	-2.060616513	20.11172291	0.150079322
185.5	-2.067462375	20.15598047	0.149962308
186.5	-2.074459502	20.19980767	0.14984254
187.5	-2.081600029	20.24319586	0.149720441
188.5	-2.088875793	20.28613648	0.149596434
189.5	-2.096278323	20.32862109	0.149470953
190.5	-2.103798828	20.37064138	0.149344433
191.5	-2.111428194	20.41218911	0.149217319
192.5	-2.119156972	20.45325617	0.14909006
193.5	-2.126975375	20.49383457	0.14896311
194.5	-2.134873266	20.5339164	0.148836931
195.5	-2.142840157	20.57349387	0.148711989
196.5	-2.150865204	20.61255929	0.148588757
197.5	-2.158937201	20.65110506	0.148467715
198.5	-2.167044578	20.6891237	0.148349348
199.5	-2.175176987	20.72660728	0.14823412
200.5	-2.183317362	20.76355011	0.148122614
201.5	-2.191457792	20.79994337	0.148015249
202.5	-2.199583649	20.83578051	0.147912564
203.5	-2.207681525	20.87105449	0.147815078
204.5	-2.215737645	20.90575839	0.147723315
205.5	-2.223739902	20.93988477	0.147637768
206.5	-2.231667995	20.97342858	0.147559083
207.5	-2.239511942	21.00638171	0.147487716
208.5	-2.247257081	21.0387374	0.14742421
209.5	-2.254885145	21.07048996	0.147369174
210.5	-2.26238209	21.10163241	0.147323144
211.5	-2.269731517	21.13215845	0.147286698
212.5	-2.276917229	21.16206171	0.147260415
213.5	-2.283925442	21.1913351	0.147244828
214.5	-2.290731442	21.21997472	0.147240683
215.5	-2.29732427	21.24797262	0.147248467
216.5	-2.303687802	21.27532239	0.14726877
217.5	-2.309799971	21.30201933	0.147302299
218.5	-2.315651874	21.32805489	0.147349514
219.5	-2.32121731	21.35342563	0.147411215
220.5	-2.326481911	21.37812462	0.147487979
221.5	-2.331428139	21.40214589	0.147580453
222.5	-2.336038473	21.42548351	0.147689289
223.5	-2.34029545	21.44813156	0.14781515
224.5	-2.344181703	21.47008412	0.147958706
225.5	-2.34768	21.49133529	0.148120633
226.5	-2.350773286	21.51187918	0.148301619
227.5	-2.353444725	21.53170989	0.148502355
228.5	-2.355677743	21.55082155	0.148723546
229.5	-2.35745607	21.56920824	0.148965902
230.5	-2.358763788	21.58686406	0.149230142
231.5	-2.359585369	21.60378309	0.149516994
232.5	-2.359905726	21.61995939	0.149827195
233.5	-2.359710258	21.635387	0.150161492
234.5	-2.358980464	21.65006126	0.150520734
235.5	-2.357714508	21.6639727	0.150905439
236.5	-2.355892424	21.67711736	0.151316531
237.5	-2.353501353	21.68948935	0.151754808
238.5	-2.350528726	21.70108288	0.152221086
239.5	-2.346962247	21.71189225	0.152716206
240	-2.34495843	21.71699934	0.152974718
240.5	-2.342796948	21.72190973	0.153240872

__END__

=head1 NAME

Medical::Growth::NHANES_2000::BMI_for_Age::Child::Female

=head1 SYNOPSIS

  use Medical::Growth::NHANES_2000;
  Medical::Growth::NHANES_2000->find_measure_class(
    ages => 'Child', sex => 'Female',
    measure => 'BMI for Age')->pct_for_value($bmi,$age);

=head1 DESCRIPTION

This class provides the NHANES 2000 parameters for BMI-for-age
tables for girls ages 2-20 years.

BMI values are expressed in kg/m2, and ages in months.

For details of the methods provided to operate on observations, please see
L<Medical::Growth::NHANES_2000::Base>.  For overall information on use of
the NHANES 2000 system, please see L<Medical::Growth::NHANES_2000>.

This class provides one additional convenience method:

=over 4

=item B<bmi>(I<$wt_kg>, I<$ht_cm>)

Returns the BMI in kg/m2 computed from I<$wt_kg> and I<$ht_cm>.  If
either I<$wt_kg> or I<$ht_cm> is missing or zero, returns C<undef>.

=back

=head1 VERSION

version 1.00

=head1 AUTHOR

Charles Bailey <cbail@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2012-2014 Charles Bailey.

This software may be used under the terms of the Artistic License or
the GNU General Public License, as the user prefers.

=head1 ACKNOWLEDGMENT

The code incorporated into this package was originally written with
United States federal funding as part of research work done by the
author at the Children's Hospital of Philadelphia.

=cut
