package Acme::Insult::Evil 1.1 {    # https://www.freepublicapis.com/evil-insult-generator
    use v5.38;
    use HTTP::Tiny;
    use JSON::Tiny qw[decode_json];
    use URI;
    use parent 'Exporter';
    our %EXPORT_TAGS = ( all => [ our @EXPORT_OK = qw[insult] ] );
    #
    use overload '""' => sub ( $s, $u, $b ) { $s->{insult} // () };
    #
    sub _http (%params) {
        state $http
            //= HTTP::Tiny->new( default_headers => { Accept => 'application/json' }, agent => sprintf '%s/%.2f ', __PACKAGE__, our $VERSION );
        state $api //= URI->new('https://evilinsult.com/generate_insult.php');

        # API accepts languages as a param named 'lang' but returns the language in a field called 'language'... why?
        $api->query_form( type => 'json', ( defined $params{language} ? ( lang => delete $params{language} ) : () ), %params );
        my $res = $http->get($api);    # {success} is true even when advice is not found but we'll at least know when we have valid JSON
        $res->{success} ? decode_json( $res->{content} ) : ();
    }
    #
    sub insult (%args) { my $ref = _http(%args); $ref ? bless $ref, __PACKAGE__ : $ref }
}
1;
__END__

=encoding utf-8

=head1 NAME

Acme::Insult::Evil - Programmatically Generate Evil Insults

=head1 SYNOPSIS

    use Acme::Insult::Evil qw[insult];
    say insult( ); # stringify

=head1 DESCRIPTION

Acme::Insult::Evil provides 'evil' 'insulting' statements generated by the RESTful Evil Insult Generator API.

=head1 METHODS

These functions may be imported by name or with the C<:all> tag.

=head2 C<insult( [...] )>

Tear someone down.

    my $shade = insult( ); # Random insult
    print insult( language => 'fr' ); # stringify

You may request specific insults by passing parameters.

Expected parameters include:

=over

=item C<language>

Insult's language. The default is C<en>. Supported languages include: C<en>, C<fr>, C<cn>, C<ja>, C<es>, etc.

=back

On success, an insult is returned as a blessed hash reference containing the following data:

=over

=item C<active>

Boolean value. If true, the insult is part of the public API.

=item C<comment>

This often provides contextual information about the insult's source of the insult itself.

=item C<created>

ISO 8601 date.

=item C<createdby>

=item C<insult>

=item C<language>

The language of the insult.

=item C<number>

The numeric id of the insult.

=item C<shown>

A running tally indicating how many times this insult has been seen.

=back

=head1 LICENSE & LEGAL

Copyright (C) Sanko Robinson.

This library is free software; you can redistribute it and/or modify it under the terms found in the Artistic License
2. Other copyrights, terms, and conditions may apply to data transmitted through this module.

Insults are generated by the L<Evil Insult Generator|https://evilinsult.com/>.

=head1 AUTHOR

Sanko Robinson E<lt>sanko@cpan.orgE<gt>

=head2 ...but why?

I'm inflicting this upon the world because L<oodler577|https://github.com/oodler577/> invited me to help expand Perl's
coverage of smaller open APIs. Blame them or L<join us|https://github.com/oodler577/FreePublicPerlAPIs> in the effort.

=begin stopwords

RESTful

=end stopwords

=cut
