## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::ExLex::CDB.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: DTA exception lexicon

##==============================================================================
## Package
##==============================================================================
package DTA::CAB::Analyzer::ExLex::CDB;
use DTA::CAB::Analyzer ':child';
use DTA::CAB::Analyzer::Dict::JsonCDB;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Dict::JsonCDB);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Automaton::Gfsm, DTA::CAB::Analyzer::Automaton
sub new {
  my $that = shift;
  return $that->SUPER::new(
			   ##-- overrides
			   label => 'exlex',
			   typeKeys => [qw(exlex pnd errid)],

			   analyzeCode =>join("\n",
					      (
					       'return if (!defined($val=$dhash->{'
					       #._am_xlit('$_')
					       .'$_->{text}'
					       .'}));'
					      ),
					      '$val=$jxs->decode($val);',
					      '@$_{keys %$val}=values %$val;',
					     ),

			   ##-- user args
			   @_
			  );
}

## $prefix = $dict->analyzePre()
sub analyzePre {
  my $dic = shift;
  return $dic->DTA::CAB::Analyzer::Dict::JsonCDB::analyzePre(@_).' my $tied=tied($dhash);';
}


1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl, edited
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::ExLex - DTA exception lexicon using DTA::CAB::Analyzer::Dict::JsonDB

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::ExLex::CDB;
 
 $exlex = DTA::CAB::Analyzer::ExLex::CDB->new(%args);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::ExLex::CDB
is a just a wrapper for
L<DTA::CAB::Analyzer::Dict::JsonCDB|DTA::CAB::Analyzer::Dict::JsonCDB>
which sets the following default options:

 label => 'exlex',                   ##-- analysis label
 typeKeys => [qw(exlex pnd errid)]   ##-- type-wise analysis keys

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut


=cut
