use strict;
use warnings;
use Test::More;
use UUID ();


my $so_char  = UUID::debug_sizeof_char();
my $so_schar = UUID::debug_sizeof_signed_char();
my $so_uchar = UUID::debug_sizeof_unsigned_char();
my $so_suuid = UUID::debug_sizeof_struct_uuid();
my $so_uuidt = UUID::debug_sizeof_uuid_t();

note 'size of char          : ', $so_char;
note 'size of signed char   : ', $so_schar;
note 'size of unsigned char : ', $so_uchar;
note 'size of struct uuid   : ', $so_suuid;
note 'size of uuid_t        : ', $so_uuidt;

is $so_schar, $so_char, 'char vs signed char';
is $so_uchar, $so_char, 'char vs unsigned char';

is $so_uuidt, $so_suuid,  'uuid_t vs struct uuid';

is $so_suuid, 16*$so_char, 'struct uuid vs 16*char';

done_testing;
